/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.CommonUtils;

public class OracleView
extends OracleTableBase
implements OracleSourceObject,
DBSView {
    private static final Log log = Log.getLog(OracleView.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();
    private String viewText;
    private String viewSourceText;
    private OracleDDLFormat currentDDLFormat;

    public OracleView(OracleSchema schema, String name) {
        super(schema, name, false);
    }

    public OracleView(OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public boolean isView() {
        return true;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.VIEW;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.viewText == null) {
            this.currentDDLFormat = OracleDDLFormat.getCurrentFormat((OracleDataSource)this.getDataSource());
        }
        OracleDDLFormat newFormat = OracleDDLFormat.FULL;
        boolean isFormatInOptions = options.containsKey("oracle.ddl.format");
        if (isFormatInOptions) {
            newFormat = (OracleDDLFormat)((Object)options.get("oracle.ddl.format"));
        }
        if (this.viewText == null || this.currentDDLFormat != newFormat && this.isPersisted()) {
            try {
                if (this.viewText == null || !isFormatInOptions) {
                    this.viewText = OracleUtils.getDDL(monitor, this.getTableTypeName(), this, this.currentDDLFormat, options);
                } else {
                    this.viewText = OracleUtils.getDDL(monitor, this.getTableTypeName(), this, newFormat, options);
                    this.currentDDLFormat = newFormat;
                }
            }
            catch (DBException e) {
                log.warn((Object)"Error getting view definition from system package", (Throwable)e);
            }
        }
        if (CommonUtils.isEmpty((String)this.viewText)) {
            this.loadAdditionalInfo(monitor);
            if (CommonUtils.isEmpty((String)this.viewSourceText)) {
                return "-- Oracle view definition is not available";
            }
            return this.viewSourceText;
        }
        return this.viewText;
    }

    public void setObjectDefinitionText(String source) {
        this.viewText = source;
    }

    @Override
    public AdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    protected String getTableTypeName() {
        return "VIEW";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=OracleTableBase.AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.valid = OracleUtils.getObjectStatus(monitor, this, OracleObjectType.VIEW);
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewText(String viewText) {
        this.viewText = viewText;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        String viewDefinitionText = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            boolean isOracle9 = ((OracleDataSource)this.getDataSource()).isAtLeastV9();
            try {
                Object object = null;
                Object var8_14 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TEXT,TYPE_TEXT,OID_TEXT,VIEW_TYPE_OWNER,VIEW_TYPE" + (isOracle9 ? ",SUPERVIEW_NAME" : "") + "\n" + "FROM " + OracleUtils.getAdminAllViewPrefix(monitor, (OracleDataSource)this.getDataSource(), "VIEWS") + " WHERE OWNER=? AND VIEW_NAME=?");){
                    dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable2 = null;
                    Object var11_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            String superViewName;
                            viewDefinitionText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TEXT");
                            this.additionalInfo.setTypeText(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TYPE_TEXT"));
                            this.additionalInfo.setOidText(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OID_TEXT"));
                            this.additionalInfo.typeOwner = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"VIEW_TYPE_OWNER");
                            this.additionalInfo.typeName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"VIEW_TYPE");
                            if (isOracle9 && !CommonUtils.isEmpty((String)(superViewName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUPERVIEW_NAME")))) {
                                this.additionalInfo.setSuperView(((OracleSchema)this.getContainer()).getView(monitor, superViewName));
                            }
                        } else {
                            log.warn((Object)("Cannot find view '" + this.getFullyQualifiedName(DBPEvaluationContext.UI) + "' metadata"));
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (object == null) {
                        object = throwable4;
                    } else if (object != throwable4) {
                        ((Throwable)object).addSuppressed(throwable4);
                    }
                    throw object;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        if (viewDefinitionText != null) {
            StringBuilder paramsList = new StringBuilder();
            List<OracleTableColumn> attributes = this.getAttributes(monitor);
            if (attributes != null) {
                paramsList.append("\n(");
                boolean first = true;
                for (OracleTableColumn column : attributes) {
                    if (!first) {
                        paramsList.append(",");
                    }
                    paramsList.append(DBUtils.getQuotedIdentifier((DBSObject)column));
                    first = false;
                }
                paramsList.append(")");
            }
            this.viewSourceText = "CREATE OR REPLACE VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + paramsList + "\nAS\n" + viewDefinitionText;
        }
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.additionalInfo.loaded = false;
        this.viewText = null;
        this.viewSourceText = null;
        return super.refreshObject(monitor);
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.VIEW, "Compile view", "ALTER VIEW " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    public class AdditionalInfo
    extends OracleTableBase.TableAdditionalInfo {
        private String typeText;
        private String oidText;
        private String typeOwner;
        private String typeName;
        private OracleView superView;

        @Property(viewable=false, order=10)
        public Object getType(DBRProgressMonitor monitor) throws DBException {
            if (this.typeOwner == null) {
                return null;
            }
            OracleSchema owner = ((OracleDataSource)OracleView.this.getDataSource()).getSchema(monitor, this.typeOwner);
            return owner == null ? null : owner.getDataType(monitor, this.typeName);
        }

        @Property(viewable=false, order=11)
        public String getTypeText() {
            return this.typeText;
        }

        public void setTypeText(String typeText) {
            this.typeText = typeText;
        }

        @Property(viewable=false, order=12)
        public String getOidText() {
            return this.oidText;
        }

        public void setOidText(String oidText) {
            this.oidText = oidText;
        }

        @Property(viewable=false, editable=true, order=5)
        public OracleView getSuperView() {
            return this.superView;
        }

        public void setSuperView(OracleView superView) {
            this.superView = superView;
        }
    }
}

