/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.translate.SQLTranslateContext;

public final class SQLQueryTranslator {
    public static String translateScript(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull DBPPreferenceStore preferenceStore, @NotNull String script) throws DBException {
        SQLTranslateContext context = new SQLTranslateContext(sourceDialect, targetDialect, preferenceStore);
        List<SQLScriptElement> sqlScriptElements = SQLScriptParser.parseScript(sourceDialect, preferenceStore, script);
        ArrayList<? extends SQLScriptElement> result = new ArrayList<SQLScriptElement>();
        for (SQLScriptElement element : sqlScriptElements) {
            result.addAll(context.translateCommand(element));
        }
        String scriptDelimiter = targetDialect.getScriptDelimiters()[0];
        StringBuilder sql = new StringBuilder();
        for (SQLScriptElement sQLScriptElement : result) {
            sql.append(sQLScriptElement.getText());
            sql.append(scriptDelimiter).append("\n");
        }
        return sql.toString();
    }
}

