/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.Method;
import java.text.Format;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.registry.NavigatorExtensionsRegistry;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.ui.navigator.INavigatorNodeActionHandler;
import org.jkiss.dbeaver.ui.navigator.database.DefaultNavigatorNodeRenderer;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class StatisticsNavigatorNodeRenderer
extends DefaultNavigatorNodeRenderer {
    private static final Log log = Log.getLog(StatisticsNavigatorNodeRenderer.class);
    private static final int PERCENT_FILL_WIDTH = 50;
    private static final RGB HOST_NAME_FG_DARK = new RGB(140, 140, 140);
    private static final RGB HOST_NAME_FG_LIGHT = new RGB(105, 105, 105);
    private static final boolean PAINT_ACTION_HOVER = false;
    private final INavigatorModelView view;
    private static final ByteNumberFormat numberFormat = new ByteNumberFormat();
    private final Map<String, Format> classFormatMap = new HashMap<String, Format>();
    private static final Map<DBSObject, StatReadJob> statReaders = new IdentityHashMap<DBSObject, StatReadJob>();
    private Font fontItalic;

    public StatisticsNavigatorNodeRenderer(INavigatorModelView view) {
        this.view = view;
    }

    public INavigatorModelView getView() {
        return this.view;
    }

    public Font getFontItalic(Tree tree) {
        if (this.fontItalic == null) {
            this.fontItalic = UIUtils.modifyFont((Font)tree.getFont(), (int)2);
            tree.addDisposeListener(e -> UIUtils.dispose((Resource)this.fontItalic));
        }
        return this.fontItalic;
    }

    @Override
    public void paintNodeDetails(DBNNode node, Tree tree, GC gc, Event event) {
        super.paintNodeDetails(node, tree, gc, event);
        boolean scrollEnabled = StatisticsNavigatorNodeRenderer.isHorizontalScrollbarEnabled(tree);
        Object element = event.item.getData();
        if (element instanceof DBNDatabaseNode) {
            DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            if (element instanceof DBNDataSource) {
                int widthOccupied = 0;
                if (!scrollEnabled && preferenceStore.getBoolean("navigator.show.node.actions")) {
                    widthOccupied += this.renderDataSourceNodeActions((DBNDatabaseNode)element, tree, gc, event);
                }
                if (preferenceStore.getBoolean("navigator.show.connection.host")) {
                    this.renderDataSourceHostName((DBNDataSource)element, tree, gc, event, widthOccupied);
                }
            } else if (element instanceof DBNDatabaseItem && preferenceStore.getBoolean("navigator.show.objects.description")) {
                this.renderObjectDescription((DBNDatabaseItem)element, tree, gc, event);
            }
            if (!scrollEnabled && preferenceStore.getBoolean("navigator.show.statistics.info")) {
                this.renderObjectStatistics((DBNDatabaseNode)element, tree, gc, event);
            }
        }
    }

    @Override
    public void showDetailsToolTip(DBNNode node, Tree tree, Event event) {
        String detailsTip = this.getDetailsTipText(node, tree, event);
        if (detailsTip != null) {
            tree.setToolTipText(detailsTip);
        } else {
            tree.setToolTipText(null);
        }
    }

    @Override
    public void performAction(DBNNode node, Tree tree, Event event, boolean defaultAction) {
        INavigatorNodeActionHandler overActionButton;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.node.actions") && (overActionButton = this.getActionButtonFor(node, tree, event)) != null) {
            overActionButton.handleNodeAction(this.view, node, event, defaultAction);
        }
    }

    @Override
    public void handleHover(DBNNode node, Tree tree, TreeItem item, Event event) {
        super.handleHover(node, tree, item, event);
        boolean scrollEnabled = StatisticsNavigatorNodeRenderer.isHorizontalScrollbarEnabled(tree);
        Object element = item.getData();
        if (element instanceof DBNDatabaseNode && element instanceof DBNDataSource && !scrollEnabled && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.node.actions") && this.isOverActionButton((DBNDatabaseNode)element, tree, item, event.gc, event)) {
            tree.setCursor(tree.getDisplay().getSystemCursor(21));
            return;
        }
        tree.setCursor(null);
    }

    private String getDetailsTipText(DBNNode element, Tree tree, Event event) {
        if (element instanceof DBNDatabaseNode) {
            long statObjectSize;
            DBSObject object;
            if (element instanceof DBNDataSource) {
                INavigatorNodeActionHandler overActionButton;
                if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.node.actions") && (overActionButton = this.getActionButtonFor(element, tree, event)) != null) {
                    return overActionButton.getNodeActionToolTip(this.view, element);
                }
                if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.connection.host")) {
                    return DataSourceUtils.getDataSourceAddressText((DBPDataSourceContainer)((DBNDataSource)element).getDataSourceContainer());
                }
                return null;
            }
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.statistics.info") && event.x > this.getTreeWidth(tree) - 50 && (object = ((DBNDatabaseNode)element).getObject()) instanceof DBPObjectStatistics && ((DBPObjectStatistics)object).hasStatistics() && (statObjectSize = ((DBPObjectStatistics)object).getStatObjectSize()) > 0L) {
                String formattedSize;
                try {
                    DBDDataFormatter formatter = object.getDataSource().getContainer().getDataFormatterProfile().createFormatter("number", null);
                    formattedSize = formatter.formatValue((Object)statObjectSize);
                }
                catch (Exception exception) {
                    formattedSize = String.valueOf(statObjectSize);
                }
                return "Object size on disk: " + formattedSize + " bytes";
            }
        }
        return null;
    }

    private INavigatorNodeActionHandler getActionButtonFor(DBNNode element, Tree tree, Event event) {
        List<INavigatorNodeActionHandler> nodeActions = NavigatorExtensionsRegistry.getInstance().getNodeActions(this.getView(), element);
        if (StatisticsNavigatorNodeRenderer.isHorizontalScrollbarEnabled(tree)) {
            return null;
        }
        int widthOccupied = 0;
        for (INavigatorNodeActionHandler nah : nodeActions) {
            if (!nah.isSticky(this.view, element)) {
                boolean isSelected = (event.stateMask & 2) != 0;
                boolean isHover = false;
                if (!isSelected && !isHover) {
                    return null;
                }
            }
            widthOccupied += 2;
            DBPImage icon = nah.getNodeActionIcon(this.getView(), element);
            if (icon == null) continue;
            Image image = DBeaverIcons.getImage((DBPImage)icon);
            Rectangle imageBounds = image.getBounds();
            int imageSize = imageBounds.height;
            if (event.x <= tree.getClientArea().width - (widthOccupied += imageSize)) continue;
            return nah;
        }
        return null;
    }

    private void renderObjectDescription(@NotNull DBNDatabaseItem element, @NotNull Tree tree, @NotNull GC gc, @NotNull Event event) {
        String description;
        DBSObject object = element.getObject();
        if (object != null && !CommonUtils.isEmptyTrimmed((String)(description = object.getDescription()))) {
            this.drawText(description, null, tree, gc, event, 0);
        }
    }

    private void renderDataSourceHostName(DBNDataSource element, Tree tree, GC gc, Event event, int widthOccupied) {
        DBPDataSourceContainer container = element.getDataSourceContainer();
        String text = DataSourceUtils.getDataSourceAddressText((DBPDataSourceContainer)container);
        Color background = UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
        this.drawText(text, background, tree, gc, event, widthOccupied);
    }

    private void drawText(@Nullable String text, @Nullable Color bgColor, Tree tree, GC gc, Event event, int widthOccupied) {
        if (!CommonUtils.isEmpty((String)text)) {
            boolean scrollEnabled;
            Font oldFont = gc.getFont();
            Color hostNameColor = UIUtils.getSharedColor((RGB)((bgColor == null ? UIStyles.isDarkTheme() : UIUtils.isDark((RGB)bgColor.getRGB())) ? HOST_NAME_FG_DARK : HOST_NAME_FG_LIGHT));
            gc.setForeground(hostNameColor);
            Font hostNameFont = this.getFontItalic(tree);
            gc.setFont(hostNameFont);
            Point hostTextSize = gc.stringExtent(text);
            int xOffset = RuntimeUtils.isLinux() ? 16 : 2;
            ScrollBar hSB = tree.getHorizontalBar();
            boolean bl = scrollEnabled = hSB != null && hSB.isVisible();
            if (!scrollEnabled) {
                int treeWidth = tree.getClientArea().width;
                gc.setClipping(event.x + event.width + xOffset, event.y + (event.height - hostTextSize.y) / 2, treeWidth - (event.x + event.width + xOffset + widthOccupied), event.height);
            }
            gc.drawText(" - " + text, event.x + event.width + xOffset, event.y + (event.height - hostTextSize.y) / 2, true);
            if (!scrollEnabled) {
                gc.setClipping(null);
            }
            gc.setFont(oldFont);
        }
    }

    private int renderDataSourceNodeActions(DBNDatabaseNode element, Tree tree, GC gc, Event event) {
        int xWidth;
        List<INavigatorNodeActionHandler> nodeActions = NavigatorExtensionsRegistry.getInstance().getNodeActions(this.getView(), (DBNNode)element);
        int xPos = xWidth = this.getTreeWidth(tree);
        int widthOccupied = 0;
        for (INavigatorNodeActionHandler nah : nodeActions) {
            if (!nah.isSticky(this.view, (DBNNode)element)) {
                boolean isSelected = (event.stateMask & 2) != 0;
                boolean isHover = false;
                if (!isSelected && !isHover) {
                    return widthOccupied;
                }
            }
            widthOccupied += 2;
            DBPImage icon = nah.getNodeActionIcon(this.getView(), (DBNNode)element);
            if (icon == null) continue;
            Image image = DBeaverIcons.getImage((DBPImage)icon);
            Rectangle imageBounds = image.getBounds();
            int imageSize = imageBounds.height;
            widthOccupied += imageSize;
            Point mousePos = tree.getDisplay().getCursorLocation();
            Point itemPos = tree.toDisplay(xPos -= imageSize, event.y + (event.height - imageSize) / 2);
            gc.drawImage(image, xPos, event.y + (event.height - imageSize) / 2);
        }
        return widthOccupied;
    }

    private boolean isOverActionButton(DBNDatabaseNode element, Tree tree, TreeItem item, GC gc, Event event) {
        List<INavigatorNodeActionHandler> nodeActions = NavigatorExtensionsRegistry.getInstance().getNodeActions(this.getView(), (DBNNode)element);
        int xPos = this.getTreeWidth(tree);
        for (INavigatorNodeActionHandler nah : nodeActions) {
            DBPImage icon;
            if (!nah.isSticky(this.view, (DBNNode)element) || (icon = nah.getNodeActionIcon(this.getView(), (DBNNode)element)) == null) continue;
            Image image = DBeaverIcons.getImage((DBPImage)icon);
            Rectangle imageBounds = image.getBounds();
            int imageSize = imageBounds.width;
            if (event.x < (xPos -= imageSize) || event.x >= xPos + imageSize) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderObjectStatistics(DBNDatabaseNode element, Tree tree, GC gc, Event event) {
        DBSObject object = element.getObject();
        if (object instanceof DBPObjectStatistics) {
            String sizeText;
            int percentFull;
            long maxObjectSize;
            boolean statsWasRead = false;
            DBNNode parentNode = this.getParentItem(element);
            DBSObject parentObject = parentNode instanceof DBNDatabaseNode ? DBUtils.getPublicObject((DBSObject)((DBNDatabaseNode)parentNode).getObject()) : null;
            statsWasRead = parentObject instanceof DBPObjectStatisticsCollector ? ((DBPObjectStatisticsCollector)parentObject).isStatisticsCollected() : true;
            long l = maxObjectSize = statsWasRead ? this.getMaxObjectSize((TreeItem)event.item) : -1L;
            if (statsWasRead && maxObjectSize >= 0L) {
                Format format;
                long statObjectSize = ((DBPObjectStatistics)object).getStatObjectSize();
                if (statObjectSize <= 0L) {
                    return;
                }
                int n = percentFull = maxObjectSize == 0L ? 0 : (int)(statObjectSize * 100L / maxObjectSize);
                if (percentFull < 0 || percentFull > 100) {
                    log.debug((Object)"Object stat > 100%!");
                    percentFull = 100;
                }
                Map<String, Format> map = this.classFormatMap;
                synchronized (map) {
                    format = this.classFormatMap.get(object.getClass().getName());
                    if (format == null) {
                        try {
                            Class formatterClass;
                            Method getStatObjectSizeMethod = object.getClass().getMethod("getStatObjectSize", new Class[0]);
                            Property propAnnotation = getStatObjectSizeMethod.getAnnotation(Property.class);
                            if (propAnnotation != null && (formatterClass = propAnnotation.formatter()) != Format.class) {
                                format = (Format)formatterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            log.debug((Object)e);
                        }
                        if (format == null) {
                            format = numberFormat;
                        }
                        this.classFormatMap.put(object.getClass().getName(), format);
                    }
                }
                sizeText = format.format(statObjectSize);
            } else {
                sizeText = "...";
                percentFull = 0;
                if (parentNode instanceof DBNDatabaseNode) {
                    DBSObject realParentObject = DBUtils.getPublicObject((DBSObject)((DBNDatabaseNode)parentNode).getObject());
                    if (!this.readObjectStatistics(element.getParentNode(), realParentObject, ((TreeItem)event.item).getParentItem())) {
                        return;
                    }
                }
            }
            Point textSize = gc.stringExtent(sizeText);
            textSize.x += 4;
            int occupiedWidth = event.x + event.width + 4;
            int xWidth = this.getTreeWidth(tree);
            if (xWidth - occupiedWidth > Math.max(50, textSize.x)) {
                CTabFolder tabFolder = (CTabFolder)UIUtils.getParentOfType((Control)tree, CTabFolder.class);
                Color fillColor = tabFolder == null ? UIStyles.getDefaultWidgetBackground() : tabFolder.getBackground();
                gc.setBackground(fillColor);
                int fillWidth = 50 * percentFull / 100 + 1;
                int x = xWidth - fillWidth - 2;
                gc.fillRectangle(x, event.y + 2, fillWidth, event.height - 4);
                gc.setForeground(tree.getForeground());
                int x2 = xWidth - textSize.x - 2;
                Font oldFont = gc.getFont();
                gc.setFont(tree.getFont());
                gc.drawText(sizeText, x2 + 2, event.y + (event.height - textSize.y) / 2, true);
                gc.setFont(oldFont);
            }
        }
    }

    private DBNNode getParentItem(DBNDatabaseNode element) {
        DBNNode parentNode = element.getParentNode();
        while (parentNode instanceof DBNDatabaseFolder) {
            parentNode = parentNode.getParentNode();
        }
        return parentNode;
    }

    private long getMaxObjectSize(TreeItem item) {
        Object maxSize;
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null && (maxSize = parentItem.getData("nav.stat.maxSize")) instanceof Number) {
            return ((Number)maxSize).longValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readObjectStatistics(DBNNode parentNode, DBSObject parentObject, TreeItem parentItem) {
        Map<DBSObject, StatReadJob> map = statReaders;
        synchronized (map) {
            StatReadJob statReadJob = statReaders.get(parentObject);
            if (statReadJob == null) {
                statReadJob = new StatReadJob(parentNode, parentObject, parentItem);
                statReaders.put(parentObject, statReadJob);
                statReadJob.schedule();
            }
        }
        return true;
    }

    private int getTreeWidth(Tree tree) {
        int xShift;
        int treeWidth;
        ScrollBar hSB = tree.getHorizontalBar();
        if (hSB == null || !hSB.isVisible()) {
            treeWidth = tree.getClientArea().width;
            xShift = 0;
        } else {
            treeWidth = hSB.getMaximum();
            xShift = hSB.getSelection();
        }
        return treeWidth - xShift;
    }

    private static boolean isHorizontalScrollbarEnabled(Tree tree) {
        ScrollBar horizontalBar = tree.getHorizontalBar();
        if (horizontalBar == null) {
            return false;
        }
        if (RuntimeUtils.isLinux()) {
            return tree.getClientArea().width != horizontalBar.getMaximum();
        }
        return horizontalBar.isVisible();
    }

    private static class StatReadJob
    extends AbstractJob {
        private final DBNNode parentNode;
        private final DBSObject collector;
        private final TreeItem treeItem;

        StatReadJob(DBNNode parentNode, DBSObject collector, TreeItem treeItem) {
            super("Read statistics for " + DBUtils.getObjectFullName((DBPNamedObject)collector, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.parentNode = parentNode;
            this.collector = collector;
            this.treeItem = treeItem;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                try {
                    DBNDatabaseNode[] children;
                    monitor.beginTask("Collect database statistics", 1);
                    if (this.collector instanceof DBPObjectStatisticsCollector) {
                        ((DBPObjectStatisticsCollector)this.collector).collectObjectStatistics(monitor, false, false);
                    }
                    long maxStatSize = 0L;
                    if (this.parentNode instanceof DBNDatabaseNode && (children = ((DBNDatabaseNode)this.parentNode).getChildren(monitor)) != null) {
                        DBNDatabaseNode[] dBNDatabaseNodeArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                            DBSObject child = childNode.getObject();
                            if (child instanceof DBPObjectStatistics) {
                                long statObjectSize = ((DBPObjectStatistics)child).getStatObjectSize();
                                maxStatSize = Math.max(maxStatSize, statObjectSize);
                            }
                            ++n2;
                        }
                    }
                    long finalMaxStatSize = maxStatSize;
                    UIUtils.asyncExec(() -> {
                        try {
                            if (this.treeItem != null && !this.treeItem.isDisposed()) {
                                this.treeItem.getData("nav.stat.maxSize");
                                this.treeItem.setData("nav.stat.maxSize", (Object)finalMaxStatSize);
                                this.treeItem.getParent().redraw();
                            }
                        }
                        catch (Throwable throwable) {
                            Map<DBSObject, StatReadJob> map = statReaders;
                            synchronized (map) {
                                statReaders.remove(this.collector);
                            }
                            throw throwable;
                        }
                        Map<DBSObject, StatReadJob> map = statReaders;
                        synchronized (map) {
                            statReaders.remove(this.collector);
                        }
                    });
                }
                catch (DBException e) {
                    log.error((Object)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

