/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class ClickhouseSQLDialect
extends GenericSQLDialect {
    private static final String[] CLICKHOUSE_FUNCTIONS = new String[]{"quantile", "quantileExact", "uniq", "concat", "replaceOne", "replaceAll", "toStartOfFifteenMinutes", "toStartOfFiveMinute", "toStartOfInterval", "toTimezone", "formatDateTime", "now", "multiIf", "geoToS2", "s2ToGeo", "greatCircleDistance", "greatCircleAngle", "plus", "minus", "multiply", "divide", "arrayConcat", "hasAll", "hasAny", "indexOf", "mapKeys", "mapValues", "UUIDNumToString", "UUIDStringToNum", "visitParamHas", "IPv4StringToNum", "randConstant", "javaHash", "bitmapBuild", "bitCount", "splitByChar", "splitByWhitespace", "toLowCardinality", "formatRow"};
    private static final String[] CLICKHOUSE_NONKEYWORDS = new String[]{"DEFAULT", "SYSTEM"};

    public ClickhouseSQLDialect() {
        super("Clickhouse SQL", "clickhouse");
    }

    public boolean supportsOrderByIndex() {
        return false;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        String[] stringArray = CLICKHOUSE_NONKEYWORDS;
        int n = CLICKHOUSE_NONKEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            this.removeSQLKeyword(word);
            ++n2;
        }
        this.addFunctions(Arrays.asList(CLICKHOUSE_FUNCTIONS));
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (typeName.equals("String")) {
            return null;
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public boolean supportsNestedComments() {
        return true;
    }

    public boolean mustBeQuoted(@NotNull String str, boolean forceCaseSensitive) {
        String[] stringArray = CLICKHOUSE_NONKEYWORDS;
        int n = CLICKHOUSE_NONKEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.equalsIgnoreCase(str)) {
                return true;
            }
            ++n2;
        }
        return super.mustBeQuoted(str, forceCaseSensitive);
    }
}

