/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(DatabaseConsumerSettings.class);
    private String containerNodePath;
    private DBNDatabaseNode containerNode;
    private final Map<DBSDataContainer, DatabaseMappingContainer> dataMappings = new LinkedHashMap<DBSDataContainer, DatabaseMappingContainer>();
    private boolean openNewConnections = true;
    private boolean useTransactions = true;
    private int commitAfterRows = 10000;
    private boolean transferAutoGeneratedColumns = true;
    private boolean truncateBeforeLoad = false;
    private boolean openTableOnFinish = true;
    private boolean useMultiRowInsert;
    private int multiRowInsertBatch = 500;
    private boolean skipBindValues;
    private boolean disableUsingBatches = false;
    private boolean useBulkLoad = false;
    private String onDuplicateKeyInsertMethodId;
    private boolean disableReferentialIntegrity;
    private transient Map<String, Object> dialogSettings;

    @Nullable
    public DBSObjectContainer getContainer() {
        if (this.containerNode == null) {
            return null;
        }
        return (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)this.containerNode.getObject());
    }

    public DBNDatabaseNode getContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(DBNDatabaseNode containerNode) {
        this.containerNode = containerNode;
    }

    public Map<DBSDataContainer, DatabaseMappingContainer> getDataMappings() {
        return this.dataMappings;
    }

    public DatabaseMappingContainer getDataMapping(DBSDataContainer dataContainer) {
        return this.dataMappings.get(dataContainer);
    }

    public boolean isCompleted(Collection<DataTransferPipe> pipes) {
        for (DataTransferPipe pipe : pipes) {
            DBSDataContainer sourceObject;
            DatabaseMappingContainer containerMapping;
            if (pipe.getProducer() == null || (containerMapping = this.dataMappings.get(sourceObject = (DBSDataContainer)pipe.getProducer().getDatabaseObject())) != null && containerMapping.getMappingType() != DatabaseMappingType.unspecified && containerMapping.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isTransferAutoGeneratedColumns() {
        return this.transferAutoGeneratedColumns;
    }

    public void setTransferAutoGeneratedColumns(boolean transferAutoGeneratedColumns) {
        this.transferAutoGeneratedColumns = transferAutoGeneratedColumns;
    }

    public boolean isTruncateBeforeLoad() {
        return this.truncateBeforeLoad;
    }

    public void setTruncateBeforeLoad(boolean truncateBeforeLoad) {
        this.truncateBeforeLoad = truncateBeforeLoad;
    }

    public boolean isOpenTableOnFinish() {
        return this.openTableOnFinish;
    }

    public void setOpenTableOnFinish(boolean openTableOnFinish) {
        this.openTableOnFinish = openTableOnFinish;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public boolean isUseMultiRowInsert() {
        return this.useMultiRowInsert;
    }

    public void setUseMultiRowInsert(boolean useMultiRowInsert) {
        this.useMultiRowInsert = useMultiRowInsert;
    }

    public int getMultiRowInsertBatch() {
        return this.multiRowInsertBatch;
    }

    public void setMultiRowInsertBatch(int multiRowInsertBatch) {
        this.multiRowInsertBatch = multiRowInsertBatch;
    }

    public boolean isSkipBindValues() {
        return this.skipBindValues;
    }

    public void setSkipBindValues(boolean skipBindValues) {
        this.skipBindValues = skipBindValues;
    }

    public boolean isDisableUsingBatches() {
        return this.disableUsingBatches;
    }

    public void setDisableUsingBatches(boolean disableUsingBatches) {
        this.disableUsingBatches = disableUsingBatches;
    }

    public String getOnDuplicateKeyInsertMethodId() {
        return this.onDuplicateKeyInsertMethodId;
    }

    public void setOnDuplicateKeyInsertMethodId(String onDuplicateKeyInsertMethodId) {
        this.onDuplicateKeyInsertMethodId = onDuplicateKeyInsertMethodId;
    }

    public int getCommitAfterRows() {
        return this.commitAfterRows;
    }

    public void setCommitAfterRows(int commitAfterRows) {
        this.commitAfterRows = commitAfterRows;
    }

    public boolean isUseBulkLoad() {
        return this.useBulkLoad;
    }

    public void setUseBulkLoad(boolean useBulkLoad) {
        this.useBulkLoad = useBulkLoad;
    }

    @Nullable
    public DBPDataSource getTargetDataSource(DatabaseMappingObject attrMapping) {
        DBSObjectContainer container = this.getContainer();
        if (container != null) {
            return container.getDataSource();
        }
        if (attrMapping.getTarget() != null) {
            return attrMapping.getTarget().getDataSource();
        }
        return null;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        block3: {
            Map mappings;
            List<DataTransferPipe> dataPipes;
            block4: {
                DBSDataManipulator targetObject;
                IDataTransferConsumer<?, ?> consumer;
                this.dialogSettings = settings;
                this.containerNodePath = CommonUtils.toString((Object)settings.get("container"), (String)this.containerNodePath);
                this.openNewConnections = CommonUtils.getBoolean((Object)settings.get("openNewConnections"), (boolean)this.openNewConnections);
                this.useTransactions = CommonUtils.getBoolean((Object)settings.get("useTransactions"), (boolean)this.useTransactions);
                this.onDuplicateKeyInsertMethodId = CommonUtils.toString((Object)settings.get("onDuplicateKeyMethod"), (String)this.onDuplicateKeyInsertMethodId);
                this.commitAfterRows = CommonUtils.toInt((Object)settings.get("commitAfterRows"), (int)this.commitAfterRows);
                this.useMultiRowInsert = CommonUtils.getBoolean((Object)settings.get("useMultiRowInsert"), (boolean)this.useMultiRowInsert);
                this.multiRowInsertBatch = CommonUtils.toInt((Object)settings.get("multiRowInsertBatch"), (int)this.multiRowInsertBatch);
                this.skipBindValues = CommonUtils.getBoolean((Object)settings.get("skipBindValues"), (boolean)this.skipBindValues);
                this.disableUsingBatches = CommonUtils.getBoolean((Object)settings.get("disableUsingBatches"), (boolean)this.disableUsingBatches);
                this.transferAutoGeneratedColumns = CommonUtils.getBoolean((Object)settings.get("transferAutoGeneratedColumns"), (boolean)this.transferAutoGeneratedColumns);
                this.disableReferentialIntegrity = CommonUtils.getBoolean((Object)settings.get("disableReferentialIntegrity"), (boolean)this.disableReferentialIntegrity);
                this.useBulkLoad = CommonUtils.getBoolean((Object)settings.get("useBulkLoad"), (boolean)this.useBulkLoad);
                this.truncateBeforeLoad = CommonUtils.getBoolean((Object)settings.get("truncateBeforeLoad"), (boolean)this.truncateBeforeLoad);
                this.openTableOnFinish = CommonUtils.getBoolean((Object)settings.get("openTableOnFinish"), (boolean)this.openTableOnFinish);
                dataPipes = dataTransferSettings.getDataPipes();
                if (!dataPipes.isEmpty() && (consumer = dataPipes.get(0).getConsumer()) instanceof DatabaseTransferConsumer && (targetObject = ((DatabaseTransferConsumer)consumer).getTargetObject()) != null) {
                    this.containerNode = DBWorkbench.getPlatform().getNavigatorModel().findNode(targetObject.getParentObject());
                }
                this.checkContainerConnection(runnableContext);
                this.loadNode(runnableContext, dataTransferSettings, null);
                mappings = (Map)settings.get("mappings");
                if (mappings == null) break block3;
                if (this.dataMappings.isEmpty()) break block4;
                for (DatabaseMappingContainer dmc : this.dataMappings.values()) {
                    Map dmcSettings;
                    DBSDataContainer sourceDatacontainer = dmc.getSource();
                    if (sourceDatacontainer == null || (dmcSettings = (Map)mappings.get(DBUtils.getObjectFullId((DBSObject)sourceDatacontainer))) == null) continue;
                    dmc.loadSettings(runnableContext, dmcSettings);
                }
                break block3;
            }
            if (dataPipes.isEmpty()) break block3;
            for (DataTransferPipe pipe : dataPipes) {
                DBSObject dbObject;
                IDataTransferProducer<?> producer = pipe.getProducer();
                if (producer == null || !((dbObject = producer.getDatabaseObject()) instanceof DBSDataContainer)) continue;
                DBSDataContainer sourceDC = (DBSDataContainer)dbObject;
                Map dmcSettings = (Map)mappings.get(DBUtils.getObjectFullId((DBSObject)dbObject));
                if (dmcSettings == null) continue;
                DatabaseMappingContainer dmc = new DatabaseMappingContainer(this, sourceDC);
                dmc.loadSettings(runnableContext, dmcSettings);
                this.dataMappings.put(sourceDC, dmc);
            }
        }
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        if (this.containerNode != null) {
            settings.put("container", this.containerNode.getNodeItemPath());
        }
        settings.put("openNewConnections", this.openNewConnections);
        settings.put("useTransactions", this.useTransactions);
        settings.put("commitAfterRows", this.commitAfterRows);
        settings.put("useMultiRowInsert", this.useMultiRowInsert);
        settings.put("multiRowInsertBatch", this.multiRowInsertBatch);
        settings.put("skipBindValues", this.skipBindValues);
        settings.put("disableUsingBatches", this.disableUsingBatches);
        settings.put("onDuplicateKeyMethod", this.onDuplicateKeyInsertMethodId);
        settings.put("transferAutoGeneratedColumns", this.transferAutoGeneratedColumns);
        settings.put("disableReferentialIntegrity", this.disableReferentialIntegrity);
        settings.put("useBulkLoad", this.useBulkLoad);
        settings.put("truncateBeforeLoad", this.truncateBeforeLoad);
        settings.put("openTableOnFinish", this.openTableOnFinish);
        LinkedHashMap<String, LinkedHashMap<String, Object>> mappings = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        settings.put("mappings", mappings);
        for (DatabaseMappingContainer dmc : this.dataMappings.values()) {
            DBSDataContainer sourceDatacontainer = dmc.getSource();
            if (sourceDatacontainer == null) continue;
            LinkedHashMap<String, Object> dmcSettings = new LinkedHashMap<String, Object>();
            mappings.put(DBUtils.getObjectFullId((DBSObject)sourceDatacontainer), dmcSettings);
            dmc.saveSettings(dmcSettings);
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_new_connection, this.openNewConnections);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_use_transactions, this.useTransactions);
        if (this.useTransactions) {
            DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_commit_after, this.commitAfterRows);
        }
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_use_multi_insert, this.useMultiRowInsert);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_multi_insert_batch, this.multiRowInsertBatch);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_skip_bind_values, this.skipBindValues);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_disable_batches, this.disableUsingBatches);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_on_duplicate_key_method_label, this.onDuplicateKeyInsertMethodId);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_transfer_auto_generated_columns, this.transferAutoGeneratedColumns);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_disable_referential_integrity, this.disableReferentialIntegrity);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_use_bulk_load, this.useBulkLoad);
        DTUtils.addSummary(summary, DTMessages.database_consumer_settings_option_truncate_before_load, this.truncateBeforeLoad);
        return summary.toString();
    }

    private void checkContainerConnection(DBRRunnableContext runnableContext) {
        if (this.containerNode instanceof DBNDataSource && this.containerNode.getDataSource() == null) {
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        this.containerNode.initializeNode(monitor, null);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError(DTMessages.database_consumer_settings_title_init_connection, DTMessages.database_consumer_settings_message_error_connecting, e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void loadNode(DBRRunnableContext runnableContext, DataTransferSettings settings, @Nullable DBSObjectContainer producerContainer) {
        if (!(this.containerNode != null || CommonUtils.isEmpty((String)this.containerNodePath) && producerContainer == null || CommonUtils.isEmpty((String)this.containerNodePath) && producerContainer == null)) {
            try {
                runnableContext.run(true, true, monitor -> {
                    try {
                        Object node = !CommonUtils.isEmpty((String)this.containerNodePath) ? DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath(monitor, this.containerNodePath) : DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)producerContainer);
                        if (node instanceof DBNDatabaseNode) {
                            this.containerNode = node;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                this.checkContainerConnection(runnableContext);
            }
            catch (InvocationTargetException e) {
                settings.getState().addError(e.getTargetException());
                log.error((Object)"Error getting container node", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addDataMappings(DBRRunnableContext context, DBSDataContainer dataContainer, DatabaseMappingContainer mappingContainer) {
        Map dmcSettings;
        Map mappings;
        this.dataMappings.put(dataContainer, mappingContainer);
        if (mappingContainer.getTarget() == null && this.dialogSettings != null && (mappings = (Map)this.dialogSettings.get("mappings")) != null && (dmcSettings = (Map)mappings.get(DBUtils.getObjectFullId((DBSObject)dataContainer))) != null) {
            mappingContainer.loadSettings(context, dmcSettings);
        }
    }

    public boolean isDisableReferentialIntegrity() {
        return this.disableReferentialIntegrity;
    }

    public void setDisableReferentialIntegrity(boolean disableReferentialIntegrity) {
        this.disableReferentialIntegrity = disableReferentialIntegrity;
    }
}

