/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;

public class QMMStatementInfo
extends QMMObject {
    private final QMMConnectionInfo session;
    private final DBCExecutionPurpose purpose;
    private final QMMStatementInfo previous;
    private transient DBCStatement reference;

    public QMMStatementInfo(QMMConnectionInfo session, DBCStatement reference, QMMStatementInfo previous) {
        this.session = session;
        this.reference = reference;
        this.purpose = reference.getSession().getPurpose();
        this.previous = previous;
    }

    public QMMStatementInfo(long openTime, long closeTime, QMMConnectionInfo session, DBCExecutionPurpose purpose) {
        super(openTime, closeTime);
        this.session = session;
        this.purpose = purpose;
        this.previous = null;
    }

    @Override
    public void close() {
        super.close();
        this.reference = null;
    }

    @Override
    public String getText() {
        return this.session.getText();
    }

    DBCStatement getReference() {
        return this.reference;
    }

    public QMMConnectionInfo getSession() {
        return this.session;
    }

    public DBCExecutionPurpose getPurpose() {
        return this.purpose;
    }

    public QMMStatementInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return "STATEMENT";
    }
}

