/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import java.sql.SQLException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class QMMStatementExecuteInfo
extends QMMObject {
    private QMMStatementInfo statement;
    private QMMTransactionSavepointInfo savepoint;
    private String queryString;
    private long fetchRowCount;
    private long updateRowCount = -1L;
    private int errorCode;
    private String errorMessage;
    private long fetchBeginTime;
    private long fetchEndTime;
    private boolean transactional;
    private QMMStatementExecuteInfo previous;

    QMMStatementExecuteInfo(QMMStatementInfo statement, QMMTransactionSavepointInfo savepoint, String queryString, QMMStatementExecuteInfo previous) {
        SQLDialect sqlDialect;
        this.statement = statement;
        this.previous = previous;
        this.savepoint = savepoint;
        this.queryString = queryString;
        if (savepoint != null) {
            savepoint.setLastExecute(this);
        }
        this.transactional = (sqlDialect = statement.getSession().getSQLDialect()) != null && queryString != null ? statement.getPurpose() != DBCExecutionPurpose.META && sqlDialect.isTransactionModifyingQuery(queryString) : false;
    }

    public QMMStatementExecuteInfo(long openTime, long closeTime, QMMStatementInfo stmt, String queryString, long rowCount, int errorCode, String errorMessage, long fetchBeginTime, long fetchEndTime, boolean transactional) {
        super(openTime, closeTime);
        this.statement = stmt;
        this.queryString = queryString;
        this.fetchRowCount = rowCount;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.fetchBeginTime = fetchBeginTime;
        this.fetchEndTime = fetchEndTime;
        this.transactional = transactional;
    }

    void close(long rowCount, Throwable error) {
        if (error != null) {
            if (error instanceof SQLException) {
                this.errorCode = ((SQLException)error).getErrorCode();
            }
            this.errorMessage = error.getMessage();
            this.transactional = true;
        }
        this.updateRowCount = rowCount;
        if (!this.transactional) {
            this.transactional = this.updateRowCount >= 0L;
        }
        super.close();
    }

    void beginFetch() {
        this.fetchBeginTime = QMMStatementExecuteInfo.getTimeStamp();
    }

    void endFetch(long rowCount) {
        this.fetchEndTime = QMMStatementExecuteInfo.getTimeStamp();
        this.fetchRowCount = rowCount;
    }

    public QMMStatementInfo getStatement() {
        return this.statement;
    }

    public QMMTransactionSavepointInfo getSavepoint() {
        return this.savepoint;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public long getUpdateRowCount() {
        return this.updateRowCount;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        return this.errorCode != 0 || this.errorMessage != null;
    }

    public long getFetchBeginTime() {
        return this.fetchBeginTime;
    }

    public long getFetchEndTime() {
        return this.fetchEndTime;
    }

    public boolean isFetching() {
        return this.fetchBeginTime > 0L && this.fetchEndTime == 0L;
    }

    public boolean isTransactional() {
        return this.transactional || this.updateRowCount > 0L;
    }

    public QMMStatementExecuteInfo getPrevious() {
        return this.previous;
    }

    public String toString() {
        return String.valueOf('\"') + this.queryString + '\"';
    }

    @Override
    public String getText() {
        return this.queryString;
    }

    @Override
    public long getDuration() {
        if (!this.isClosed()) {
            return -1L;
        }
        long execTime = this.getCloseTime() - this.getOpenTime();
        long fetchTime = this.isFetching() ? 0L : this.getFetchEndTime() - this.getFetchBeginTime();
        return execTime + fetchTime;
    }
}

