/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.jkiss.dbeaver.model.fs.nio.NIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public final class NIOFile
extends NIOResource
implements IFile {
    public NIOFile(NIOFileSystemRoot root, Path backendFile) {
        super(root, backendFile);
    }

    public int getType() {
        return 1;
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public String getCharset() throws CoreException {
        return "UTF-8";
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return this.getCharset();
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return this.getCharset();
    }

    public IContentDescription getContentDescription() throws CoreException {
        return null;
    }

    public InputStream getContents() throws CoreException {
        try {
            return Files.newInputStream(this.getNioPath(), new OpenOption[0]);
        }
        catch (Exception ex) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(ex));
        }
    }

    public InputStream getContents(boolean force) throws CoreException {
        return this.getContents();
    }

    @Deprecated
    public int getEncoding() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return new IFileState[0];
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    @Deprecated
    public void setCharset(String newCharset) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream os = Files.newOutputStream(this.getNioPath(), new OpenOption[0]);){
                ContentUtils.copyStreams(source, -1L, os, (DBRProgressMonitor)new DefaultProgressMonitor(monitor));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }
}

