/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.internal.core.Messages;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.core.patch.PatchReader;
import org.eclipse.compare.internal.patch.FilePatch;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.internal.patch.WorkspaceFileDiffResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.IHunkFilter;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.TextUtilities;

public class Patcher
implements IHunkFilter {
    protected static final String REJECT_FILE_EXTENSION = ".rej";
    protected static final String MARKER_TYPE = "org.eclipse.compare.rejectedPatchMarker";
    public static final String PROP_PATCHER = "org.eclipse.compare.patcher";
    private FilePatch2[] fDiffs;
    private IResource fTarget;
    private Set<Object> disabledElements = new HashSet<Object>();
    private Map<FilePatch2, FileDiffResult> diffResults = new HashMap<FilePatch2, FileDiffResult>();
    private final Map<FilePatch2, byte[]> contentCache = new HashMap<FilePatch2, byte[]>();
    private Set<Hunk> mergedHunks = new HashSet<Hunk>();
    private final PatchConfiguration configuration = new PatchConfiguration();
    private boolean fGenerateRejectFile = false;

    public Patcher() {
        this.configuration.setProperty(PROP_PATCHER, (Object)this);
        this.configuration.addHunkFilter((IHunkFilter)this);
    }

    public FilePatch2[] getDiffs() {
        if (this.fDiffs == null) {
            return new FilePatch2[0];
        }
        return this.fDiffs;
    }

    public IPath getPath(FilePatch2 diff) {
        return diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
    }

    public boolean setStripPrefixSegments(int strip) {
        if (strip != this.getConfiguration().getPrefixSegmentStripCount()) {
            this.getConfiguration().setPrefixSegmentStripCount(strip);
            return true;
        }
        return false;
    }

    int getStripPrefixSegments() {
        return this.getConfiguration().getPrefixSegmentStripCount();
    }

    public boolean setFuzz(int fuzz) {
        if (fuzz != this.getConfiguration().getFuzz()) {
            this.getConfiguration().setFuzz(fuzz);
            return true;
        }
        return false;
    }

    public int getFuzz() {
        return this.getConfiguration().getFuzz();
    }

    public boolean setIgnoreWhitespace(boolean ignoreWhitespace) {
        if (ignoreWhitespace != this.getConfiguration().isIgnoreWhitespace()) {
            this.getConfiguration().setIgnoreWhitespace(ignoreWhitespace);
            return true;
        }
        return false;
    }

    public boolean isIgnoreWhitespace() {
        return this.getConfiguration().isIgnoreWhitespace();
    }

    public boolean isGenerateRejectFile() {
        return this.fGenerateRejectFile;
    }

    public void setGenerateRejectFile(boolean generateRejectFile) {
        this.fGenerateRejectFile = generateRejectFile;
    }

    public void parse(IStorage storage) throws IOException, CoreException {
        BufferedReader reader = Utilities.createReader(storage);
        try {
            this.parse(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    public void parse(BufferedReader reader) throws IOException {
        PatchReader patchReader = new PatchReader(){

            protected FilePatch2 createFileDiff(IPath oldPath, long oldDate, IPath newPath, long newDate) {
                return new FilePatch(oldPath, oldDate, newPath, newDate);
            }
        };
        patchReader.parse(reader);
        this.patchParsed(patchReader);
    }

    protected void patchParsed(PatchReader patchReader) {
        this.fDiffs = patchReader.getDiffs();
    }

    public void countLines() {
        FilePatch2[] fileDiffs;
        FilePatch2[] filePatch2Array = fileDiffs = this.getDiffs();
        int n = fileDiffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 fileDiff = filePatch2Array[n2];
            int addedLines = 0;
            int removedLines = 0;
            int j = 0;
            while (j < fileDiff.getHunkCount()) {
                String[] lines;
                IHunk hunk = fileDiff.getHunks()[j];
                String[] stringArray = lines = ((Hunk)hunk).getLines();
                int n3 = lines.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray[n4];
                    char c = line.charAt(0);
                    switch (c) {
                        case '+': {
                            ++addedLines;
                            break;
                        }
                        case '-': {
                            ++removedLines;
                        }
                    }
                    ++n4;
                }
                ++j;
            }
            fileDiff.setAddedLines(addedLines);
            fileDiff.setRemovedLines(removedLines);
            ++n2;
        }
    }

    public void applyAll(IProgressMonitor pm, IFileValidator validator) throws CoreException {
        int i;
        IFile singleFile = null;
        IContainer container = null;
        if (this.fTarget instanceof IContainer) {
            container = (IContainer)this.fTarget;
        } else if (this.fTarget instanceof IFile) {
            singleFile = (IFile)this.fTarget;
            container = singleFile.getParent();
        } else {
            Assert.isTrue((boolean)false);
        }
        ArrayList<IFile> list = new ArrayList<IFile>();
        if (singleFile != null) {
            list.add(singleFile);
        } else {
            i = 0;
            while (i < this.fDiffs.length) {
                FilePatch2 diff = this.fDiffs[i];
                if (this.isEnabled(diff)) {
                    switch (diff.getDiffType(this.isReversed())) {
                        case 3: {
                            list.add(this.createPath(container, this.getPath(diff)));
                        }
                    }
                }
                ++i;
            }
        }
        if (!validator.validateResources(list.toArray(new IFile[list.size()]))) {
            return;
        }
        if (pm != null) {
            String message = Messages.Patcher_0;
            pm.beginTask(message, this.fDiffs.length * 10);
        }
        i = 0;
        while (i < this.fDiffs.length) {
            int workTicks = 10;
            FilePatch2 diff = this.fDiffs[i];
            if (this.isEnabled(diff)) {
                IPath pp;
                IPath path = this.getPath(diff);
                if (pm != null) {
                    pm.subTask(path.toString());
                }
                IFile file = singleFile != null ? singleFile : this.createPath(container, path);
                ArrayList<Hunk> failed = new ArrayList<Hunk>();
                int type = diff.getDiffType(this.isReversed());
                switch (type) {
                    case 1: {
                        List<String> result = this.apply(diff, file, true, failed);
                        if (result != null) {
                            this.store(LineReader.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                        }
                        workTicks -= 10;
                        break;
                    }
                    case 2: {
                        file.delete(true, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                        workTicks -= 10;
                        break;
                    }
                    case 3: {
                        List<String> result = this.apply(diff, file, false, failed);
                        if (result != null) {
                            this.store(LineReader.createString(this.isPreserveLineDelimeters(), result), file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)workTicks));
                        }
                        workTicks -= 10;
                    }
                }
                if (this.isGenerateRejectFile() && failed.size() > 0 && (file = this.createPath(container, pp = this.getRejectFilePath(path))) != null) {
                    this.store(Patcher.getRejected(failed), file, pm);
                    try {
                        IMarker marker = file.createMarker(MARKER_TYPE);
                        marker.setAttribute("message", (Object)Messages.Patcher_1);
                        marker.setAttribute("priority", 2);
                    }
                    catch (CoreException coreException) {}
                }
            }
            if (pm != null) {
                if (pm.isCanceled()) break;
                if (workTicks > 0) {
                    pm.worked(workTicks);
                }
            }
            ++i;
        }
    }

    private IPath getRejectFilePath(IPath path) {
        IPath pp = null;
        if (path.segmentCount() > 1) {
            pp = path.removeLastSegments(1);
            pp = pp.append(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
        } else {
            pp = new Path(String.valueOf(path.lastSegment()) + REJECT_FILE_EXTENSION);
        }
        return pp;
    }

    List<String> apply(FilePatch2 diff, IFile file, boolean create, List<Hunk> failedHunks) {
        FileDiffResult result = this.getDiffResult(diff);
        List<String> lines = LineReader.load((IStorage)file, create);
        result.patch(lines, null);
        failedHunks.addAll(result.getFailedHunks());
        if (this.hasCachedContents(diff)) {
            return this.getCachedLines(diff);
        }
        if (!result.hasMatches()) {
            return null;
        }
        return result.getLines();
    }

    protected void store(String contents, IFile file, IProgressMonitor pm) throws CoreException {
        byte[] bytes;
        String patchLD;
        String expectedLD;
        if (!file.exists() && FileBuffers.getTextFileBufferManager().isTextFileLocation(file.getFullPath(), true) && (expectedLD = Patcher.getLineDelimiterPreference(file)) != null && !expectedLD.equals(patchLD = TextUtilities.determineLineDelimiter((String)contents, (String)expectedLD))) {
            contents = contents.replaceAll(patchLD, expectedLD);
        }
        try {
            bytes = contents.getBytes(Utilities.getCharset(file));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = contents.getBytes();
        }
        this.store(bytes, file, pm);
    }

    private static String getLineDelimiterPreference(IFile file) {
        IScopeContext[] scopeContext;
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    protected void store(byte[] bytes, IFile file, IProgressMonitor pm) throws CoreException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            if (file.exists()) {
                file.setContents((InputStream)is, false, true, pm);
            } else {
                file.create((InputStream)is, false, pm);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isPreserveLineDelimeters() {
        return true;
    }

    public static String getRejected(List<Hunk> failedHunks) {
        if (failedHunks.size() <= 0) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Hunk hunk : failedHunks) {
            sb.append(hunk.getRejectedDescription());
            sb.append(lineSeparator);
            sb.append(hunk.getContent());
        }
        return sb.toString();
    }

    protected IFile createPath(IContainer container, IPath path) throws CoreException {
        if (path.segmentCount() > 1) {
            IFolder childContainer;
            if (container instanceof IWorkspaceRoot) {
                IProject project = ((IWorkspaceRoot)container).getProject(path.segment(0));
                if (!project.exists()) {
                    project.create(null);
                }
                if (!project.isOpen()) {
                    project.open(null);
                }
                childContainer = project;
            } else {
                IFolder f = container.getFolder(path.uptoSegment(1));
                if (!f.exists()) {
                    f.create(false, true, null);
                }
                childContainer = f;
            }
            return this.createPath((IContainer)childContainer, path.removeFirstSegments(1));
        }
        return container.getFile(path);
    }

    public IResource getTarget() {
        return this.fTarget;
    }

    public void setTarget(IResource target) {
        this.fTarget = target;
    }

    public IFile getTargetFile(FilePatch2 diff) {
        IPath path = diff.getStrippedPath(this.getStripPrefixSegments(), this.isReversed());
        return this.existsInTarget(path);
    }

    public IFile existsInTarget(IPath path) {
        IContainer c;
        if (this.fTarget instanceof IFile) {
            IFile file = (IFile)this.fTarget;
            if (this.matches(file.getFullPath(), path)) {
                return file;
            }
        } else if (this.fTarget instanceof IContainer && (c = (IContainer)this.fTarget).exists(path)) {
            return c.getFile(path);
        }
        return null;
    }

    private boolean matches(IPath fullpath, IPath path) {
        IPath p = fullpath;
        while (path.segmentCount() <= p.segmentCount()) {
            if (p.equals((Object)path)) {
                return true;
            }
            p = p.removeFirstSegments(1);
        }
        return false;
    }

    public int calculatePrefixSegmentCount() {
        int length = 99;
        if (this.fDiffs != null) {
            FilePatch2[] filePatch2Array = this.fDiffs;
            int n = this.fDiffs.length;
            int n2 = 0;
            while (n2 < n) {
                FilePatch2 diff = filePatch2Array[n2];
                length = Math.min(length, diff.segmentCount());
                ++n2;
            }
            if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)this.fTarget)) {
                --length;
            }
        }
        return length;
    }

    public void addDiff(FilePatch2 newDiff) {
        FilePatch2[] temp = new FilePatch2[this.fDiffs.length + 1];
        System.arraycopy(this.fDiffs, 0, temp, 0, this.fDiffs.length);
        temp[this.fDiffs.length] = newDiff;
        this.fDiffs = temp;
    }

    public void removeDiff(FilePatch2 diffToRemove) {
        FilePatch2[] temp = new FilePatch2[this.fDiffs.length - 1];
        int counter = 0;
        FilePatch2[] filePatch2Array = this.fDiffs;
        int n = this.fDiffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diff = filePatch2Array[n2];
            if (diff != diffToRemove) {
                temp[counter++] = diff;
            }
            ++n2;
        }
        this.fDiffs = temp;
    }

    public void setEnabled(Object element, boolean enabled) {
        if (element instanceof DiffProject) {
            this.setEnabledProject((DiffProject)element, enabled);
        }
        if (element instanceof FilePatch2) {
            this.setEnabledFile((FilePatch2)element, enabled);
        }
        if (element instanceof Hunk) {
            this.setEnabledHunk((Hunk)element, enabled);
        }
    }

    private void setEnabledProject(DiffProject projectDiff, boolean enabled) {
        FilePatch2[] diffFiles;
        FilePatch2[] filePatch2Array = diffFiles = projectDiff.getFileDiffs();
        int n = diffFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diffFile = filePatch2Array[n2];
            this.setEnabledFile(diffFile, enabled);
            ++n2;
        }
    }

    private void setEnabledFile(FilePatch2 fileDiff, boolean enabled) {
        IHunk[] hunks;
        IHunk[] iHunkArray = hunks = fileDiff.getHunks();
        int n = hunks.length;
        int n2 = 0;
        while (n2 < n) {
            IHunk hunk = iHunkArray[n2];
            this.setEnabledHunk((Hunk)hunk, enabled);
            ++n2;
        }
    }

    private void setEnabledHunk(Hunk hunk, boolean enabled) {
        if (enabled) {
            this.disabledElements.remove(hunk);
            FilePatch2 file = hunk.getParent();
            this.disabledElements.remove(file);
            DiffProject project = file.getProject();
            if (project != null) {
                this.disabledElements.remove(project);
            }
        } else {
            this.disabledElements.add(hunk);
            FilePatch2 file = hunk.getParent();
            if (this.disabledElements.containsAll(Arrays.asList(file.getHunks()))) {
                this.disabledElements.add(file);
                DiffProject project = file.getProject();
                if (project != null && this.disabledElements.containsAll(Arrays.asList(project.getFileDiffs()))) {
                    this.disabledElements.add(project);
                }
            }
        }
    }

    public boolean isEnabled(Object element) {
        if (this.disabledElements.contains(element)) {
            return false;
        }
        Object parent = this.getElementParent(element);
        if (parent == null) {
            return true;
        }
        return this.isEnabled(parent);
    }

    protected Object getElementParent(Object element) {
        if (element instanceof Hunk) {
            Hunk hunk = (Hunk)element;
            return hunk.getParent();
        }
        return null;
    }

    public int guessFuzzFactor(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.Patcher_2, -1);
            FilePatch2[] diffs = this.getDiffs();
            if (diffs == null || diffs.length <= 0) {
                return -1;
            }
            int fuzz = -1;
            FilePatch2[] filePatch2Array = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                FilePatch2 d = filePatch2Array[n2];
                IFile file = this.getTargetFile(d);
                if (file != null && file.exists()) {
                    List<String> lines = LineReader.load((IStorage)file, false);
                    FileDiffResult result = this.getDiffResult(d);
                    int f = result.calculateFuzz(lines, monitor);
                    if (f > fuzz) {
                        fuzz = f;
                    }
                }
                ++n2;
            }
            int n3 = fuzz;
            return n3;
        }
        finally {
            monitor.done();
        }
    }

    public void refresh() {
        this.diffResults.clear();
        this.refresh(this.getDiffs());
    }

    public void refresh(FilePatch2[] diffs) {
        FilePatch2[] filePatch2Array = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diff = filePatch2Array[n2];
            FileDiffResult result = this.getDiffResult(diff);
            ((WorkspaceFileDiffResult)result).refresh();
            ++n2;
        }
    }

    public FileDiffResult getDiffResult(FilePatch2 diff) {
        FileDiffResult result = this.diffResults.get(diff);
        if (result == null) {
            result = new WorkspaceFileDiffResult(diff, this.getConfiguration());
            this.diffResults.put(diff, result);
        }
        return result;
    }

    public PatchConfiguration getConfiguration() {
        return this.configuration;
    }

    public DiffProject getProject(FilePatch2 diff) {
        return diff.getProject();
    }

    public boolean setReversed(boolean reverse) {
        if (this.getConfiguration().isReversed() != reverse) {
            this.getConfiguration().setReversed(reverse);
            this.refresh();
            return true;
        }
        return false;
    }

    public boolean isReversed() {
        return this.getConfiguration().isReversed();
    }

    public void cacheContents(FilePatch2 diff, byte[] contents) {
        this.contentCache.put(diff, contents);
    }

    public boolean hasCachedContents(FilePatch2 diff) {
        return this.contentCache.containsKey(diff);
    }

    public List<String> getCachedLines(FilePatch2 diff) {
        byte[] contents = this.contentCache.get(diff);
        if (contents != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(contents)));
            return LineReader.readLines(reader);
        }
        return null;
    }

    public byte[] getCachedContents(FilePatch2 diff) {
        return this.contentCache.get(diff);
    }

    public boolean hasCachedContents() {
        return !this.contentCache.isEmpty();
    }

    public void clearCachedContents() {
        this.contentCache.clear();
        this.mergedHunks.clear();
    }

    public void setProperty(String key, Object value) {
        this.getConfiguration().setProperty(key, value);
    }

    public Object getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    public boolean isManuallyMerged(Hunk hunk) {
        return this.mergedHunks.contains(hunk);
    }

    public void setManuallyMerged(Hunk hunk, boolean merged) {
        if (merged) {
            this.mergedHunks.add(hunk);
        } else {
            this.mergedHunks.remove(hunk);
        }
    }

    public IProject getTargetProject(FilePatch2 diff) {
        DiffProject dp = this.getProject(diff);
        if (dp != null) {
            return Utilities.getProject(dp);
        }
        IResource tr = this.getTarget();
        if (tr instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)tr;
            return root.getProject(diff.getPath(this.isReversed()).segment(0));
        }
        return tr.getProject();
    }

    public static Patcher getPatcher(PatchConfiguration configuration) {
        return (Patcher)configuration.getProperty(PROP_PATCHER);
    }

    public boolean hasRejects() {
        for (FileDiffResult result : this.diffResults.values()) {
            if (!result.hasRejects()) continue;
            return true;
        }
        return false;
    }

    public boolean select(IHunk hunk) {
        return this.isEnabled(hunk);
    }

    public static interface IFileValidator {
        public boolean validateResources(IFile[] var1);
    }
}

