/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.views;

import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class MySQLConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static final boolean MANAGE_SERVER_TIME_ZONE = true;
    private Text hostText;
    private Text portText;
    private Text dbText;
    private ClientHomesSelector homesSelector;
    private boolean activated = false;
    private Combo serverTimezoneCombo;
    private final Image LOGO_MYSQL = this.createImage("icons/mysql_logo.png");
    private final Image LOGO_MARIADB = this.createImage("icons/mariadb_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.LOGO_MYSQL);
        UIUtils.dispose((Resource)this.LOGO_MARIADB);
    }

    public Image getImage() {
        if (this.getSite().getDriver().getId().equalsIgnoreCase("mariaDB")) {
            return this.LOGO_MARIADB;
        }
        return this.LOGO_MYSQL;
    }

    public void createControl(Composite composite) {
        String[] tzList;
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.site.updateButtons();
            }
        };
        int fontHeight = UIUtils.getFontHeight((Control)composite);
        Composite addrGroup = new Composite(composite, 0);
        addrGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Group serverGroup = UIUtils.createControlGroup((Composite)addrGroup, (String)"Server", (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)serverGroup, (String)MySQLUIMessages.dialog_connection_host);
        Composite hostComposite = UIUtils.createComposite((Composite)serverGroup, (int)3);
        hostComposite.setLayoutData((Object)new GridData(768));
        this.hostText = new Text(hostComposite, 2048);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.hostText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)hostComposite, (String)MySQLUIMessages.dialog_connection_port, null, (int)2048, (Object)new GridData(32));
        ((GridData)this.portText.getLayoutData()).widthHint = fontHeight * 10;
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        this.dbText = UIUtils.createLabelText((Composite)serverGroup, (String)MySQLUIMessages.dialog_connection_database, null, (int)2048, (Object)new GridData(768));
        this.dbText.addModifyListener(textListener);
        this.createAuthPanel(addrGroup, 1);
        Group advancedGroup = UIUtils.createControlGroup((Composite)addrGroup, (String)"Advanced", (int)2, (int)32, (int)0);
        this.serverTimezoneCombo = UIUtils.createLabelCombo((Composite)advancedGroup, (String)MySQLUIMessages.dialog_connection_server_timezone, (int)4);
        this.serverTimezoneCombo.add(MySQLUIMessages.dialog_connection_auto_detect);
        String[] stringArray = tzList = TimeZone.getAvailableIDs();
        int n = tzList.length;
        int n2 = 0;
        while (n2 < n) {
            String tzID = stringArray[n2];
            this.serverTimezoneCombo.add(tzID);
            ++n2;
        }
        this.serverTimezoneCombo.setLayoutData((Object)new GridData(32));
        this.homesSelector = new ClientHomesSelector((Composite)advancedGroup, MySQLUIMessages.dialog_connection_local_client, false);
        gd = new GridData(800);
        this.homesSelector.getPanel().setLayoutData((Object)gd);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return super.isComplete() && this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.getSite().getDriver();
        super.loadSettings();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText("localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(connectionInfo.getHostPort());
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            this.dbText.setText(CommonUtils.toString((Object)connectionInfo.getDatabaseName(), (String)CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase())));
        }
        if (this.serverTimezoneCombo != null) {
            String tzProp = connectionInfo.getProviderProperty("@dbeaver-serverTimezone@");
            if (CommonUtils.isEmpty((String)tzProp)) {
                this.serverTimezoneCombo.select(0);
            } else {
                this.serverTimezoneCombo.setText(tzProp);
            }
        }
        this.homesSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId(), this.site.isNew());
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.serverTimezoneCombo != null) {
            String serverTimeZone = this.serverTimezoneCombo.getText();
            if (CommonUtils.isEmpty((String)serverTimeZone) || serverTimeZone.equals(MySQLUIMessages.dialog_connection_auto_detect)) {
                connectionInfo.removeProviderProperty("@dbeaver-serverTimezone@");
            } else {
                connectionInfo.setProviderProperty("@dbeaver-serverTimezone@", serverTimeZone);
            }
        }
        if (this.homesSelector != null) {
            connectionInfo.setClientHomeId(this.homesSelector.getSelectedHome());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

