/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.security.auth.module.NTSystem;
import com.sun.security.auth.module.UnixSystem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.access.DBASessionPrincipal;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class BasicWorkspaceSession
implements DBASession,
DBASessionPrincipal {
    private final BaseWorkspaceImpl baseWorkspace;
    private String userName;
    private String domainName;

    public BasicWorkspaceSession(BaseWorkspaceImpl baseWorkspace) {
        this.baseWorkspace = baseWorkspace;
        try {
            if (RuntimeUtils.isWindows()) {
                NTSystem ntSystem = new NTSystem();
                this.userName = ntSystem.getName();
                this.domainName = ntSystem.getDomain();
            } else {
                UnixSystem unixSystem = new UnixSystem();
                this.userName = unixSystem.getUsername();
            }
        }
        catch (Exception exception) {}
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = System.getProperty("user.name");
        }
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = "unknown";
        }
        if (CommonUtils.isEmpty((String)this.domainName)) {
            if (RuntimeUtils.isWindows()) {
                this.domainName = System.getenv("USERDOMAIN");
            }
            if (CommonUtils.isEmpty((String)this.domainName)) {
                this.domainName = "local";
            }
        }
    }

    @NotNull
    public DBAAuthSpace getSessionSpace() {
        return this.baseWorkspace;
    }

    public DBASessionPrincipal getSessionPrincipal() {
        return this;
    }

    @NotNull
    public String getSessionId() {
        return this.baseWorkspace.getWorkspaceId();
    }

    public boolean isApplicationSession() {
        return true;
    }

    @Nullable
    public DBPProject getSingletonProject() {
        return null;
    }

    public String getUserDomain() {
        return this.domainName;
    }

    public String getUserName() {
        return this.userName;
    }
}

