/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedValueObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectViewerRenderer {
    private boolean isTree;
    private transient Item selectedItem;
    private transient Item lastClickItem;
    private transient int selectedColumn = -1;
    private ColumnViewer itemsViewer;
    private final TextLayout linkLayout;
    private final Cursor linkCursor;
    private final Cursor arrowCursor;
    private final Color selectionBackgroundColor;
    private BooleanStyleSet booleanStyles;
    private transient int booleanValueWith;

    public ObjectViewerRenderer(ColumnViewer viewer) {
        this(viewer, true);
    }

    protected ObjectViewerRenderer(ColumnViewer viewer, boolean trackInput) {
        this.itemsViewer = viewer;
        this.isTree = this.itemsViewer instanceof AbstractTreeViewer;
        Display display = this.itemsViewer.getControl().getDisplay();
        this.linkLayout = new TextLayout((Device)display);
        this.selectionBackgroundColor = display.getSystemColor(26);
        this.linkCursor = display.getSystemCursor(21);
        this.arrowCursor = display.getSystemCursor(0);
        this.itemsViewer.getControl().setCursor(this.arrowCursor);
        if (trackInput) {
            CellTrackListener actionsListener = new CellTrackListener();
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ObjectViewerRenderer.this.selectedItem = ObjectViewerRenderer.this.lastClickItem = (Item)e.item;
                }
            };
            if (this.isTree) {
                this.getTree().addSelectionListener((SelectionListener)selectionAdapter);
            } else {
                this.getTable().addSelectionListener((SelectionListener)selectionAdapter);
            }
            this.itemsViewer.getControl().addMouseListener((org.eclipse.swt.events.MouseListener)new MouseListener());
            this.itemsViewer.getControl().addMouseTrackListener((MouseTrackListener)actionsListener);
            this.itemsViewer.getControl().addMouseMoveListener((MouseMoveListener)actionsListener);
            this.itemsViewer.getControl().addKeyListener((KeyListener)actionsListener);
        }
        IPropertyChangeListener styleChangeListener = event -> {
            this.booleanStyles = BooleanStyleSet.getDefaultStyles(DBWorkbench.getPlatform().getPreferenceStore());
        };
        BooleanStyleSet.installStyleChangeListener(viewer.getControl(), styleChangeListener);
        styleChangeListener.propertyChange(null);
    }

    public boolean isTree() {
        return this.isTree;
    }

    private TableItem detectTableItem(int x, int y) {
        this.selectedItem = null;
        this.selectedColumn = -1;
        Point pt = new Point(x, y);
        this.selectedItem = this.getTable().getItem(pt);
        if (this.selectedItem == null) {
            return null;
        }
        this.selectedColumn = UIUtils.getColumnAtPos((TableItem)this.selectedItem, x, y);
        return (TableItem)this.selectedItem;
    }

    private TreeItem detectTreeItem(int x, int y) {
        this.selectedItem = null;
        this.selectedColumn = -1;
        Point pt = new Point(x, y);
        this.selectedItem = this.getTree().getItem(pt);
        if (this.selectedItem == null) {
            return null;
        }
        this.selectedColumn = UIUtils.getColumnAtPos((TreeItem)this.selectedItem, x, y);
        return (TreeItem)this.selectedItem;
    }

    public String getSelectedText() {
        if (this.lastClickItem == null || this.selectedColumn == -1) {
            return null;
        }
        Object cellValue = this.getCellValue(this.lastClickItem.getData(), this.selectedColumn);
        return ObjectViewerRenderer.getCellString(cellValue, false);
    }

    protected ColumnViewer getItemsViewer() {
        return this.itemsViewer;
    }

    public Composite getControl() {
        return (Composite)this.itemsViewer.getControl();
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.linkLayout);
    }

    private Tree getTree() {
        return ((TreeViewer)this.itemsViewer).getTree();
    }

    private Table getTable() {
        return ((TableViewer)this.itemsViewer).getTable();
    }

    private Rectangle getCellLinkBounds(Item item, int column, Object cellValue) {
        this.prepareLinkStyle(cellValue, null);
        if (cellValue instanceof Boolean && this.booleanValueWith > 0) {
            Rectangle itemBounds = this.isTree ? ((TreeItem)item).getBounds(column) : ((TableItem)item).getBounds(column);
            switch (this.getBooleanAlignment((Boolean)cellValue)) {
                case LEFT: {
                    itemBounds.x += 4;
                    break;
                }
                case CENTER: {
                    itemBounds.x += (itemBounds.width - this.booleanValueWith) / 2;
                    break;
                }
                case RIGHT: {
                    itemBounds.x += itemBounds.width - this.booleanValueWith - 4;
                }
            }
            itemBounds.width = this.booleanValueWith;
            return itemBounds;
        }
        Rectangle itemBounds = this.isTree ? ((TreeItem)item).getTextBounds(column) : ((TableItem)item).getTextBounds(column);
        Rectangle linkBounds = this.linkLayout.getBounds();
        linkBounds.x += itemBounds.x;
        linkBounds.y += itemBounds.y + 1;
        linkBounds.height -= 2;
        return linkBounds;
    }

    public void paintCell(Event event, Object element, Object cellValue, Widget item, Class<?> propDataType, int columnIndex, boolean editable, boolean selected) {
        GC gc = event.gc;
        if (Boolean.class == propDataType || Boolean.TYPE == propDataType) {
            this.booleanValueWith = -1;
            Boolean value = cellValue == null ? null : (cellValue instanceof Boolean ? (Boolean)cellValue : Boolean.valueOf(CommonUtils.toBoolean((Object)cellValue)));
            BooleanStyle booleanStyle = this.booleanStyles.getStyle(value);
            if (this.booleanStyles.getMode() == BooleanMode.TEXT) {
                String cellText;
                String string = cellText = item instanceof TreeItem ? ((TreeItem)item).getText(columnIndex) : "";
                if (cellText.isEmpty()) {
                    String strValue = booleanStyle.getText();
                    Point textExtent = gc.textExtent(strValue);
                    this.booleanValueWith = textExtent.x;
                    Rectangle columnBounds = this.isTree ? ((TreeItem)item).getBounds(columnIndex) : ((TableItem)item).getBounds(columnIndex);
                    gc.setForeground(UIUtils.getSharedColor(booleanStyle.getColor()));
                    switch (this.getBooleanAlignment(value)) {
                        case LEFT: {
                            gc.drawString(strValue, event.x + 4, event.y + (columnBounds.height - textExtent.y) / 2, true);
                            break;
                        }
                        case CENTER: {
                            gc.drawString(strValue, event.x + (columnBounds.width - textExtent.x) / 2, event.y + (columnBounds.height - textExtent.y) / 2, true);
                            break;
                        }
                        case RIGHT: {
                            gc.drawString(strValue, event.x + columnBounds.width - textExtent.x - 4, event.y + (columnBounds.height - textExtent.y) / 2, true);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                Image image = DBeaverIcons.getImage((DBPImage)booleanStyle.getIcon());
                Rectangle imageBounds = image.getBounds();
                this.booleanValueWith = imageBounds.width;
                Rectangle columnBounds = this.isTree ? ((TreeItem)item).getBounds(columnIndex) : ((TableItem)item).getBounds(columnIndex);
                gc.setBackground(this.getControl().getBackground());
                switch (this.getBooleanAlignment(value)) {
                    case LEFT: {
                        gc.drawImage(image, event.x + 4, event.y + (columnBounds.height - imageBounds.height) / 2);
                        break;
                    }
                    case CENTER: {
                        gc.drawImage(image, event.x + (columnBounds.width - imageBounds.width) / 2, event.y);
                        break;
                    }
                    case RIGHT: {
                        gc.drawImage(image, event.x + columnBounds.width - imageBounds.width - 4, event.y + (columnBounds.height - imageBounds.height) / 2);
                    }
                }
            }
            event.doit = false;
        } else if (cellValue != null && this.isHyperlink(cellValue)) {
            this.prepareLinkStyle(cellValue, selected ? gc.getForeground() : JFaceColors.getHyperlinkText((Display)event.item.getDisplay()));
            Rectangle textBounds = event.item instanceof TreeItem ? ((TreeItem)event.item).getTextBounds(event.index) : ((TableItem)event.item).getTextBounds(event.index);
            this.linkLayout.draw(gc, textBounds.x, textBounds.y);
        }
    }

    @NotNull
    public BooleanStyleSet getBooleanStyles() {
        return this.booleanStyles;
    }

    @NotNull
    protected UIElementAlignment getBooleanAlignment(@Nullable Boolean value) {
        return this.booleanStyles.getStyle(value).getAlignment();
    }

    private void prepareLinkStyle(Object cellValue, Color foreground) {
        TextStyle linkStyle = new TextStyle(this.getControl().getFont(), foreground, null);
        linkStyle.underline = true;
        linkStyle.underlineStyle = 4;
        String text = ObjectViewerRenderer.getCellString(cellValue, false);
        this.linkLayout.setText(text);
        this.linkLayout.setIndent(0);
        this.linkLayout.setStyle(linkStyle, 0, text.length());
    }

    public static String getCellString(@Nullable Object value, boolean nameColumn) {
        if (value == null) {
            return "";
        }
        if (!nameColumn && value instanceof DBPNamedValueObject) {
            value = ((DBPNamedValueObject)value).getObjectValue();
        } else if (value instanceof DBPNamedObject) {
            value = ((DBPNamedObject)value).getName();
        }
        String displayString = GeneralUtils.makeDisplayString((Object)value).toString();
        if (RuntimeUtils.isLinux()) {
            displayString = CommonUtils.getSingleLineString((String)displayString);
        }
        return displayString;
    }

    public boolean isHyperlink(@Nullable Object cellValue) {
        return false;
    }

    public void navigateHyperlink(Object cellValue) {
    }

    @Nullable
    public abstract Object getCellValue(Object var1, int var2);

    class CellTrackListener
    implements MouseTrackListener,
    MouseMoveListener,
    KeyListener {
        CellTrackListener() {
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            this.resetCursor();
        }

        public void mouseHover(MouseEvent e) {
        }

        private void resetCursor() {
            ObjectViewerRenderer.this.getItemsViewer().getControl().setCursor(ObjectViewerRenderer.this.arrowCursor);
        }

        public void mouseMove(MouseEvent e) {
            this.updateCursor(e.x, e.y, e.stateMask);
        }

        private void updateCursor(int x, int y, int stateMask) {
            Object hoverItem = ObjectViewerRenderer.this.isTree ? ObjectViewerRenderer.this.detectTreeItem(x, y) : ObjectViewerRenderer.this.detectTableItem(x, y);
            if (hoverItem == null || ObjectViewerRenderer.this.selectedColumn < 0) {
                this.resetCursor();
            } else {
                int checkColumn;
                Object element = hoverItem.getData();
                Object cellValue = ObjectViewerRenderer.this.getCellValue(element, checkColumn = ObjectViewerRenderer.this.selectedColumn);
                if (cellValue == null) {
                    this.resetCursor();
                } else {
                    boolean isHyperlink;
                    boolean ctrlPressed = (stateMask & 0x40000) != 0 || (stateMask & 0x10000) != 0;
                    boolean bl = isHyperlink = cellValue instanceof Boolean || ctrlPressed && ObjectViewerRenderer.this.isHyperlink(cellValue);
                    if (isHyperlink && ObjectViewerRenderer.this.getCellLinkBounds((Item)hoverItem, checkColumn, cellValue).contains(x, y)) {
                        ObjectViewerRenderer.this.getItemsViewer().getControl().setCursor(ObjectViewerRenderer.this.linkCursor);
                    } else {
                        this.resetCursor();
                    }
                }
            }
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 262144 || e.keyCode == 65536) {
                Point mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().getCursorLocation();
                mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().map(null, ObjectViewerRenderer.this.itemsViewer.getControl(), mousePoint);
                this.updateCursor(mousePoint.x, mousePoint.y, e.keyCode);
            } else {
                ObjectViewerRenderer.this.selectedColumn = 0;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144 || e.keyCode == 65536) {
                Point mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().getCursorLocation();
                mousePoint = ObjectViewerRenderer.this.itemsViewer.getControl().getDisplay().map(null, ObjectViewerRenderer.this.itemsViewer.getControl(), mousePoint);
                this.updateCursor(mousePoint.x, mousePoint.y, 0);
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            int checkColumn;
            Object element;
            Object cellValue;
            Object hoverItem = ObjectViewerRenderer.this.isTree ? ObjectViewerRenderer.this.detectTreeItem(e.x, e.y) : ObjectViewerRenderer.this.detectTableItem(e.x, e.y);
            ObjectViewerRenderer.this.lastClickItem = hoverItem;
            if ((e.stateMask & 0x40000) == 0 && (e.stateMask & 0x10000) == 0) {
                return;
            }
            if (hoverItem != null && ObjectViewerRenderer.this.selectedColumn >= 0 && e.button == 1 && ObjectViewerRenderer.this.isHyperlink(cellValue = ObjectViewerRenderer.this.getCellValue(element = hoverItem.getData(), checkColumn = ObjectViewerRenderer.this.selectedColumn)) && ObjectViewerRenderer.this.getCellLinkBounds((Item)hoverItem, checkColumn, cellValue).contains(e.x, e.y)) {
                ObjectViewerRenderer.this.navigateHyperlink(cellValue);
            }
        }
    }
}

