/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.Iterator;
import org.eclipse.draw2dl.ActionEvent;
import org.eclipse.draw2dl.ActionListener;
import org.eclipse.draw2dl.ButtonBorder;
import org.eclipse.draw2dl.ButtonModel;
import org.eclipse.draw2dl.ChangeEvent;
import org.eclipse.draw2dl.ChangeListener;
import org.eclipse.draw2dl.ClickableEventHandler;
import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.StackLayout;
import org.eclipse.draw2dl.ToggleModel;
import org.eclipse.draw2dl.geometry.Rectangle;

public class Clickable
extends Figure {
    private static final int ROLLOVER_ENABLED_FLAG = Figure.MAX_FLAG << 1;
    private static final int STYLE_BUTTON_FLAG = Figure.MAX_FLAG << 2;
    private static final int STYLE_TOGGLE_FLAG;
    protected static int MAX_FLAG;
    public static final int STYLE_BUTTON;
    public static final int STYLE_TOGGLE;
    public static final int DEFAULT_FIRING = 0;
    public static final int REPEAT_FIRING = 1;
    private ClickableEventHandler eventHandler;
    private ButtonModel model;
    private ModelObserver modelObserver;

    static {
        MAX_FLAG = STYLE_TOGGLE_FLAG = Figure.MAX_FLAG << 3;
        STYLE_BUTTON = STYLE_BUTTON_FLAG;
        STYLE_TOGGLE = STYLE_TOGGLE_FLAG;
    }

    public Clickable() {
        this.init();
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
    }

    public Clickable(IFigure contents) {
        this(contents, 0);
    }

    public Clickable(IFigure contents, int style) {
        this.init();
        this.setRequestFocusEnabled(true);
        this.setFocusTraversable(true);
        this.setContents(contents);
        this.setStyle(style);
    }

    public void addActionListener(ActionListener listener) {
        this.addListener(ActionListener.class, listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.addListener(ChangeListener.class, listener);
    }

    protected ButtonModel createDefaultModel() {
        if (this.isStyle(STYLE_TOGGLE)) {
            return new ToggleModel();
        }
        return new ButtonModel();
    }

    protected ClickableEventHandler createEventHandler() {
        return new ClickableEventHandler();
    }

    protected ModelObserver createModelObserver() {
        return new ModelObserver(){

            @Override
            public void actionPerformed(ActionEvent action) {
                Clickable.this.fireActionPerformed();
            }

            @Override
            public void handleStateChanged(ChangeEvent change) {
                Clickable.this.fireStateChanged(change);
            }
        };
    }

    public void doClick() {
        this.fireActionPerformed();
    }

    protected void fireActionPerformed() {
        ActionEvent action = new ActionEvent(this);
        Iterator listeners = this.getListeners(ActionListener.class);
        while (listeners.hasNext()) {
            ((ActionListener)listeners.next()).actionPerformed(action);
        }
    }

    protected void fireStateChanged(ChangeEvent modelChange) {
        ChangeEvent change = new ChangeEvent(this, modelChange.getPropertyName());
        Iterator listeners = this.getListeners(ChangeListener.class);
        while (listeners.hasNext()) {
            ((ChangeListener)listeners.next()).handleStateChanged(change);
        }
    }

    public ButtonModel getModel() {
        return this.model;
    }

    protected void hookEventHandler(ClickableEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.addChangeListener(handler);
        this.addKeyListener(handler);
        this.addFocusListener(handler);
    }

    protected void init() {
        this.setModel(this.createDefaultModel());
        this.setEventHandler(this.createEventHandler());
    }

    public boolean isRolloverEnabled() {
        return (this.flags & ROLLOVER_ENABLED_FLAG) != 0;
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public boolean isStyle(int style) {
        return (style & this.flags) == style;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.hasFocus()) {
            graphics.setForegroundColor(ColorConstants.black);
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle area = this.getClientArea();
            if (this.isStyle(STYLE_BUTTON)) {
                graphics.drawFocus(area.x, area.y, area.width, area.height);
            } else {
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        if (this.isStyle(STYLE_BUTTON) && (this.getModel().isArmed() || this.getModel().isSelected())) {
            graphics.translate(1, 1);
            graphics.pushState();
            super.paintClientArea(graphics);
            graphics.popState();
            graphics.translate(-1, -1);
        } else {
            super.paintClientArea(graphics);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.removeListener(ActionListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.removeListener(ChangeListener.class, listener);
    }

    protected void setContents(IFigure contents) {
        this.setLayoutManager(new StackLayout());
        if (this.getChildren().size() > 0) {
            this.remove(this.getChildren().get(0));
        }
        this.add(contents);
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this.getModel().setEnabled(value);
        this.setChildrenEnabled(value);
    }

    public void setEventHandler(ClickableEventHandler h) {
        if (this.eventHandler != null) {
            this.unhookEventHandler(this.eventHandler);
        }
        this.eventHandler = h;
        if (this.eventHandler != null) {
            this.hookEventHandler(this.eventHandler);
        }
    }

    public void setFiringMethod(int type) {
        this.getModel().setFiringBehavior(type);
    }

    public void setModel(ButtonModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelObserver);
            this.model.removeActionListener(this.modelObserver);
            this.modelObserver = null;
        }
        this.model = model;
        if (model != null) {
            this.modelObserver = this.createModelObserver();
            model.addActionListener(this.modelObserver);
            model.addChangeListener(this.modelObserver);
        }
    }

    public void setRolloverEnabled(boolean value) {
        if (this.isRolloverEnabled() == value) {
            return;
        }
        this.setFlag(ROLLOVER_ENABLED_FLAG, value);
        this.repaint();
    }

    public void setSelected(boolean value) {
        this.getModel().setSelected(value);
    }

    public void setStyle(int style) {
        if ((style & STYLE_BUTTON) != 0) {
            this.setFlag(STYLE_BUTTON_FLAG, true);
            if (!(this.getBorder() instanceof ButtonBorder)) {
                this.setBorder(new ButtonBorder());
            }
            this.setOpaque(true);
        } else {
            this.setFlag(STYLE_BUTTON_FLAG, false);
            this.setOpaque(false);
        }
        if ((style & STYLE_TOGGLE) != 0) {
            this.setFlag(STYLE_TOGGLE_FLAG, true);
            this.setModel(this.createDefaultModel());
        }
    }

    protected void unhookEventHandler(ClickableEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.removeMouseListener(handler);
        this.removeMouseMotionListener(handler);
        this.removeChangeListener(handler);
    }

    static interface ModelObserver
    extends ActionListener,
    ChangeListener {
    }
}

