/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.rpc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.app.standalone.rpc.InstanceClient;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBeaverInstanceServer
implements IInstanceController {
    private static final Log log = Log.getLog(DBeaverInstanceServer.class);
    private DBPDataSourceContainer dataSourceContainer = null;
    private static final String VAR_RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static int portNumber;
    private static Registry registry;
    private static FileChannel configFileChannel;
    private static final List<File> filesToConnect;
    private static final RMIClientSocketFactory CSF_DEFAULT;
    private static final RMIServerSocketFactory SSF_LOCAL;
    private static boolean localRMI;

    static {
        filesToConnect = new ArrayList<File>();
        CSF_DEFAULT = RMISocketFactory.getDefaultSocketFactory();
        SSF_LOCAL = port -> new ServerSocket(port, 0, InetAddress.getLoopbackAddress());
        localRMI = false;
    }

    @Override
    public String getVersion() {
        return GeneralUtils.getProductVersion().toString();
    }

    @Override
    public void openExternalFiles(String[] fileNames) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(fileNames) + "]"));
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        UIUtils.syncExec(() -> {
            String[] stringArray2 = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String filePath = stringArray2[n2];
                File file = new File(filePath);
                if (file.exists()) {
                    filesToConnect.add(file);
                    if (this.dataSourceContainer != null) {
                        EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)this.dataSourceContainer));
                    }
                    EditorUtils.openExternalFileEditor((File)file, (IWorkbenchWindow)window);
                } else {
                    DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + file.getAbsolutePath() + "': file doesn't exist");
                }
                ++n2;
            }
            shell.setMinimized(false);
            shell.forceActive();
        });
    }

    @Override
    public void openDatabaseConnection(String connectionSpec) throws RemoteException {
        InstanceConnectionParameters instanceConParameters = new InstanceConnectionParameters();
        DBPDataSourceContainer dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)DBWorkbench.getPlatform().getWorkspace().getActiveProject(), (String)connectionSpec, (GeneralUtils.IParameterHandler)instanceConParameters, (boolean)false, (boolean)instanceConParameters.createNewConnection);
        if (dataSource == null) {
            return;
        }
        if (this.dataSourceContainer == null) {
            this.dataSourceContainer = dataSource;
            for (File file : filesToConnect) {
                EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)this.dataSourceContainer));
            }
        }
        if (instanceConParameters.openConsole) {
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            UIUtils.syncExec(() -> {
                SQLEditorHandlerOpenEditor.openSQLConsole((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)new SQLNavigatorContext((DBSObject)dataSource), (String)dataSource.getName(), (String)"");
                workbenchWindow.getShell().forceActive();
            });
        } else if (instanceConParameters.makeConnect) {
            DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)dataSource, null);
        }
    }

    @Override
    public String getThreadDump() {
        log.info((Object)"Making thread dump");
        StringBuilder td = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> tde : Thread.getAllStackTraces().entrySet()) {
            td.append(tde.getKey().getId()).append(" ").append(tde.getKey().getName()).append(":\n");
            StackTraceElement[] stackTraceElementArray = tde.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                td.append("\t").append(ste.toString()).append("\n");
                ++n2;
            }
        }
        return td.toString();
    }

    @Override
    public void quit() {
        log.info((Object)"Program termination requested");
        new Job("Terminate application"){

            protected IStatus run(IProgressMonitor monitor) {
                System.exit(-1);
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    @Override
    public void closeAllEditors() {
        log.debug((Object)"Close all open editor tabs");
        UIUtils.syncExec(() -> {
            IWorkbenchPage page;
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                page.closeAllEditors(false);
            }
        });
    }

    @Override
    public void executeWorkbenchCommand(String commandId) throws RemoteException {
        log.debug((Object)("Execute workbench command " + commandId));
        try {
            ActionUtils.runCommand((String)commandId, (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
        }
        catch (Exception e) {
            throw new RemoteException("Can't execute command '" + commandId + "'", e);
        }
    }

    @Override
    public void fireGlobalEvent(String eventId, Map<String, Object> properties) throws RemoteException {
        DBWorkbench.getPlatform().getGlobalEventManager().fireGlobalEvent(eventId, properties);
    }

    @Override
    public void bringToFront() {
        UIUtils.syncExec(() -> {
            Shell shell = UIUtils.getActiveShell();
            if (shell != null) {
                if (!shell.getMinimized()) {
                    shell.setMinimized(true);
                }
                shell.setMinimized(false);
                shell.setActive();
            }
        });
    }

    public static IInstanceController startInstanceServer(CommandLine commandLine, IInstanceController server) {
        block13: {
            try {
                IInstanceController client;
                DBeaverInstanceServer.openRmiRegistry();
                IInstanceController stub = localRMI ? (IInstanceController)UnicastRemoteObject.exportObject(server, 0, null, SSF_LOCAL) : (IInstanceController)UnicastRemoteObject.exportObject((Remote)server, 0);
                registry.bind("DBeaver.InstanceController", stub);
                if (commandLine != null) {
                    DBeaverCommandLine.getRemoteParameterHandlers(commandLine);
                }
                if ((client = InstanceClient.createClient(GeneralUtils.getMetadataFolder().getParent().toAbsolutePath().toString(), true)) == null) break block13;
                log.debug((Object)"Can't start RMI server because other instance is already running");
                return null;
            }
            catch (Exception e) {
                log.error((Object)"Can't start RMI server", (Throwable)e);
                return null;
            }
        }
        configFileChannel = FileChannel.open(GeneralUtils.getMetadataFolder().resolve("dbeaver-instance.properties"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        Throwable throwable = null;
        Object var4_6 = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Properties props = new Properties();
            props.setProperty("port", String.valueOf(portNumber));
            props.store(os, "DBeaver instance server properties");
            configFileChannel.write(ByteBuffer.wrap(os.toByteArray()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return server;
    }

    private static void openRmiRegistry() throws RemoteException {
        portNumber = IOUtils.findFreePort((int)20000, (int)65000);
        log.debug((Object)("Starting RMI server at " + portNumber));
        if (System.getProperty(VAR_RMI_SERVER_HOSTNAME) == null) {
            System.setProperty(VAR_RMI_SERVER_HOSTNAME, "127.0.0.1");
            localRMI = true;
            registry = LocateRegistry.createRegistry(portNumber, CSF_DEFAULT, SSF_LOCAL);
        } else {
            registry = LocateRegistry.createRegistry(portNumber);
        }
    }

    public static void stopInstanceServer() {
        try {
            log.debug((Object)"Stop RMI server");
            registry.unbind("DBeaver.InstanceController");
            if (configFileChannel != null) {
                configFileChannel.close();
                Files.delete(GeneralUtils.getMetadataFolder().resolve("dbeaver-instance.properties"));
            }
            log.debug((Object)"RMI controller has been stopped");
        }
        catch (Exception e) {
            log.error((Object)"Can't stop RMI server", (Throwable)e);
        }
    }

    private static class InstanceConnectionParameters
    implements GeneralUtils.IParameterHandler {
        boolean makeConnect = true;
        boolean openConsole = false;
        boolean createNewConnection = true;

        private InstanceConnectionParameters() {
        }

        public boolean setParameter(String name, String value) {
            switch (name) {
                case "connect": {
                    this.makeConnect = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "openConsole": {
                    this.openConsole = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "create": {
                    this.createNewConnection = CommonUtils.toBoolean((Object)value);
                    return true;
                }
            }
            return false;
        }
    }
}

