/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNFileSystem
extends DBNNode {
    private static final Log log = Log.getLog(DBNFileSystem.class);
    private DBFVirtualFileSystem fileSystem;
    private DBNPath[] children;

    public DBNFileSystem(DBNNode parentNode, DBFVirtualFileSystem fileSystem) {
        super(parentNode);
        this.fileSystem = fileSystem;
    }

    @Override
    public boolean isDisposed() {
        return this.fileSystem == null || super.isDisposed();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        this.fileSystem = null;
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        return "FileSystem";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeName() {
        return this.fileSystem.getFileSystemDisplayName();
    }

    @Override
    public String getNodeDescription() {
        return this.fileSystem.getDescription();
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public DBNPath[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNPath[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBNPath> result = new ArrayList<DBNPath>();
        for (Path rootPath : this.fileSystem.getFileSystem(monitor).getRootDirectories()) {
            result.add(new DBNPath(this, rootPath));
        }
        if (result.isEmpty()) {
            return new DBNPath[0];
        }
        DBNNode[] childNodes = result.toArray(new DBNPath[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.children = null;
        return this;
    }

    @Override
    public String getNodeItemPath() {
        return String.valueOf(this.getParentNode().getNodeItemPath()) + this.fileSystem.getId();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> o1.getNodeName().compareToIgnoreCase(o2.getNodeName()));
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (this.fileSystem != null && adapter.isAssignableFrom(this.fileSystem.getClass())) {
            return adapter.cast(this.fileSystem);
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.fileSystem.getFileSystemDisplayName();
    }
}

