/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;

public class DataSourceVariableResolver
extends SystemVariablesResolver {
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBPConnectionConfiguration configuration;

    public DataSourceVariableResolver(@Nullable DBPDataSourceContainer dataSourceContainer, @NotNull DBPConnectionConfiguration configuration) {
        this.dataSourceContainer = dataSourceContainer;
        this.configuration = configuration;
    }

    @Override
    public String get(String name) {
        switch (name) {
            case "host": {
                return this.configuration.getHostName();
            }
            case "port": {
                return this.configuration.getHostPort();
            }
            case "server": {
                return this.configuration.getServerName();
            }
            case "database": {
                return this.configuration.getDatabaseName();
            }
            case "user": {
                return this.configuration.getUserName();
            }
            case "password": {
                return this.configuration.getUserPassword();
            }
            case "url": {
                return this.configuration.getUrl();
            }
            case "connectionType": {
                return this.configuration.getConnectionType().getId();
            }
            case "datasource": {
                return this.dataSourceContainer == null ? null : this.dataSourceContainer.getName();
            }
            case "project.path": {
                return this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject().getAbsolutePath().getAbsolutePath();
            }
            case "project.name": {
                return this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject().getName();
            }
            case "date": {
                return RuntimeUtils.getCurrentDate();
            }
        }
        return super.get(name);
    }
}

