/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.generic;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgreExecutionPlan;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;

public class PostgreGenericQueryPlaner
implements DBCQueryPlanner {
    private final GenericDataSource dataSource;

    public PostgreGenericQueryPlaner(GenericDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public GenericDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        PostgreExecutionPlan plan = new PostgreExecutionPlan(this.getPlanStyle() == DBCPlanStyle.QUERY, true, query, configuration);
        plan.explain(session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return this.dataSource.isServerVersionAtLeast(9, 0) ? DBCPlanStyle.PLAN : DBCPlanStyle.QUERY;
    }
}

