/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.data.PostgreBinaryFormatter;
import org.jkiss.dbeaver.ext.postgresql.sql.PostgreEscapeStringRule;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLDollarQuoteRule;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreDialect
extends JDBCSQLDialect
implements TPRuleProvider,
SQLDataTypeConverter {
    public static final String[] POSTGRE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"SHOW", "SET"});
    private static final String[][] PG_STRING_QUOTES = new String[][]{{"'", "'"}};
    public static final String[][] BLOCK_BOUND_KEYWORDS = new String[0][];
    private static final String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private static final String[] OTHER_TYPES_FUNCTION = new String[]{"CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_ROLE", "CURRENT_USER"};
    public static String[] POSTGRE_EXTRA_KEYWORDS = new String[]{"ABSENT", "ACCORDING", "ADA", "ADMIN", "BASE64", "BEGIN_FRAME", "BEGIN_PARTITION", "BERNOULLI", "BIT_LENGTH", "BLOCKED", "BOM", "CONTROL", "DLNEWCOPY", "DLPREVIOUSCOPY", "DLURLCOMPLETE", "DLURLCOMPLETEONLY", "DLURLCOMPLETEWRITE", "DLURLPATH", "DLURLPATHONLY", "DLURLPATHWRITE", "DLURLSCHEME", "DLURLSERVER", "DLVALUE", "DYNAMIC_FUNCTION", "DYNAMIC_FUNCTION_CODE", "EMPTY", "END_FRAME", "END_PARTITION", "ENFORCED", "EXIT", "EXPRESSION", "FIRST_VALUE", "FRAME_ROW", "FS", "GROUPS", "IGNORE", "IMMEDIATELY", "INCLUDE", "INDENT", "INTEGRITY", "KEY_MEMBER", "LAG", "LAST_VALUE", "LEAD", "LIBRARY", "LIKE_REGEX", "NAMESPACE", "NIL", "NTH_VALUE", "NTILE", "NULLABLE", "OCCURRENCES_REGEX", "PASSTHROUGH", "PERCENT", "PERIOD", "PERMISSION", "POSITION_REGEX", "PRECEDES", "PROCEDURES", "RECOVERY", "REQUIRING", "RESPECT", "RESTORE", "RULE", "SIMPLE", "SQLCODE", "SQLERROR", "SUCCEEDS", "TOKEN", "UNLINK", "UNTYPED", "VERSIONING", "XMLAGG", "XMLBINARY", "XMLCAST", "XMLCOMMENT", "XMLDECLARATION", "XMLDOCUMENT", "XMLITERATE", "XMLQUERY", "XMLSCHEMA", "XMLTEXT", "XMLVALIDATE", "SQLERRM", "WHILE"};
    public static String[] POSTGRE_ONE_CHAR_KEYWORDS = new String[]{"C", "G", "K", "M", "T", "P"};
    public static String[] POSTGRE_FUNCTIONS_AGGREGATE = new String[]{"ARRAY_AGG", "BIT_AND", "BIT_OR", "BOOL_AND", "BOOL_OR", "EVERY", "JSON_AGG", "JSONB_AGG", "JSON_OBJECT_AGG", "JSONB_OBJECT_AGG", "MODE", "STRING_AGG", "XMLAGG", "CORR", "COVAR_POP", "COVAR_SAMP", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "VARIANCE", "VAR_POP", "VAR_SAMP"};
    public static String[] POSTGRE_FUNCTIONS_WINDOW = new String[]{"ROW_NUMBER", "RANK", "DENSE_RANK", "CUME_DIST", "NTILE", "LAG", "LEAD", "FIRST_VALUE", "LAST_VALUE", "NTH_VALUE"};
    public static String[] POSTGRE_FUNCTIONS_MATH = new String[]{"ACOSD", "ASIND", "ATAN2D", "ATAND", "CBRT", "CEIL", "CEILING", "COSD", "COTD", "DIV", "EXP", "LN", "MOD", "RANDOM", "SCALE", "SETSEED", "SIND", "TAND", "TRUNC", "WIDTH_BUCKET"};
    public static String[] POSTGRE_FUNCTIONS_STRING = new String[]{"BIT_LENGTH", "BTRIM", "CHR", "CONCAT_WS", "CONVERT", "CONVERT_FROM", "CONVERT_TO", "DECODE", "ENCODE", "INITCAP", "LEFT", "LENGTH", "LPAD", "MD5", "OVERLAY", "PARSE_IDENT", "PG_CLIENT_ENCODING", "POSITION", "QUOTE_IDENT", "QUOTE_LITERAL", "QUOTE_NULLABLE", "REGEXP_MATCH", "REGEXP_MATCHES", "REGEXP_REPLACE", "REGEXP_SPLIT_TO_ARRAY", "REGEXP_SPLIT_TO_TABLE", "REPLACE", "REVERSE", "RIGHT", "RPAD", "SPLIT_PART", "STRPOS", "SUBSTRING", "TO_ASCII", "TO_HEX", "TRANSLATE", "TREAT"};
    public static String[] POSTGRE_FUNCTIONS_DATETIME = new String[]{"AGE", "CLOCK_TIMESTAMP", "DATE_PART", "DATE_TRUNC", "ISFINITE", "JUSTIFY_DAYS", "JUSTIFY_HOURS", "JUSTIFY_INTERVAL", "MAKE_DATE", "MAKE_INTERVAL", "MAKE_TIME", "MAKE_TIMESTAMP", "MAKE_TIMESTAMPTZ", "STATEMENT_TIMESTAMP", "TIMEOFDAY", "TRANSACTION_TIMESTAMP"};
    public static String[] POSTGRE_FUNCTIONS_GEOMETRY = new String[]{"AREA", "CENTER", "DIAMETER", "HEIGHT", "ISCLOSED", "ISOPEN", "NPOINTS", "PCLOSE", "POPEN", "RADIUS", "WIDTH", "BOX", "BOUND_BOX", "CIRCLE", "LINE", "LSEG", "PATH", "POLYGON"};
    public static String[] POSTGRE_FUNCTIONS_NETWROK = new String[]{"ABBREV", "BROADCAST", "HOST", "HOSTMASK", "MASKLEN", "NETMASK", "NETWORK", "SET_MASKLEN", "TEXT", "INET_SAME_FAMILY", "INET_MERGE", "MACADDR8_SET7BIT"};
    public static String[] POSTGRE_FUNCTIONS_LO = new String[]{"LO_FROM_BYTEA", "LO_PUT", "LO_GET", "LO_CREAT", "LO_CREATE", "LO_UNLINK", "LO_IMPORT", "LO_EXPORT", "LOREAD", "LOWRITE", "GROUPING", "CAST"};
    public static String[] POSTGRE_FUNCTIONS_ADMIN = new String[]{"CURRENT_SETTING", "SET_CONFIG", "BRIN_SUMMARIZE_NEW_VALUES", "BRIN_SUMMARIZE_RANGE", "BRIN_DESUMMARIZE_RANGE", "GIN_CLEAN_PENDING_LIST"};
    public static String[] POSTGRE_FUNCTIONS_RANGE = new String[]{"ISEMPTY", "LOWER_INC", "UPPER_INC", "LOWER_INF", "UPPER_INF", "RANGE_MERGE"};
    public static String[] POSTGRE_FUNCTIONS_TEXT_SEARCH = new String[]{"ARRAY_TO_TSVECTOR", "GET_CURRENT_TS_CONFIG", "NUMNODE", "PLAINTO_TSQUERY", "PHRASETO_TSQUERY", "WEBSEARCH_TO_TSQUERY", "QUERYTREE", "SETWEIGHT", "STRIP", "TO_TSQUERY", "TO_TSVECTOR", "JSON_TO_TSVECTOR", "JSONB_TO_TSVECTOR", "TS_DELETE", "TS_FILTER", "TS_HEADLINE", "TS_RANK", "TS_RANK_CD", "TS_REWRITE", "TSQUERY_PHRASE", "TSVECTOR_TO_ARRAY", "TSVECTOR_UPDATE_TRIGGER", "TSVECTOR_UPDATE_TRIGGER_COLUMN"};
    public static String[] POSTGRE_FUNCTIONS_XML = new String[]{"XMLCOMMENT", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", "XMLPI", "XMLROOT", "XMLEXISTS", "XML_IS_WELL_FORMED", "XML_IS_WELL_FORMED_DOCUMENT", "XML_IS_WELL_FORMED_CONTENT", "XPATH", "XPATH_EXISTS", "XMLTABLE", "XMLNAMESPACES", "TABLE_TO_XML", "TABLE_TO_XMLSCHEMA", "TABLE_TO_XML_AND_XMLSCHEMA", "QUERY_TO_XML", "QUERY_TO_XMLSCHEMA", "QUERY_TO_XML_AND_XMLSCHEMA", "CURSOR_TO_XML", "CURSOR_TO_XMLSCHEMA", "SCHEMA_TO_XML", "SCHEMA_TO_XMLSCHEMA", "SCHEMA_TO_XML_AND_XMLSCHEMA", "DATABASE_TO_XML", "DATABASE_TO_XMLSCHEMA", "DATABASE_TO_XML_AND_XMLSCHEMA", "XMLATTRIBUTES"};
    public static String[] POSTGRE_FUNCTIONS_JSON = new String[]{"TO_JSON", "TO_JSONB", "ARRAY_TO_JSON", "ROW_TO_JSON", "JSON_BUILD_ARRAY", "JSONB_BUILD_ARRAY", "JSON_BUILD_OBJECT", "JSONB_BUILD_OBJECT", "JSON_OBJECT", "JSONB_OBJECT", "JSON_ARRAY_LENGTH", "JSONB_ARRAY_LENGTH", "JSON_EACH", "JSONB_EACH", "JSON_EACH_TEXT", "JSONB_EACH_TEXT", "JSON_EXTRACT_PATH", "JSONB_EXTRACT_PATH", "JSON_OBJECT_KEYS", "JSONB_OBJECT_KEYS", "JSON_POPULATE_RECORD", "JSONB_POPULATE_RECORD", "JSON_POPULATE_RECORDSET", "JSONB_POPULATE_RECORDSET", "JSON_ARRAY_ELEMENTS", "JSONB_ARRAY_ELEMENTS", "JSON_ARRAY_ELEMENTS_TEXT", "JSONB_ARRAY_ELEMENTS_TEXT", "JSON_TYPEOF", "JSONB_TYPEOF", "JSON_TO_RECORD", "JSONB_TO_RECORD", "JSON_TO_RECORDSET", "JSONB_TO_RECORDSET", "JSON_STRIP_NULLS", "JSONB_STRIP_NULLS", "JSONB_SET", "JSONB_INSERT", "JSONB_PRETTY"};
    public static String[] POSTGRE_FUNCTIONS_ARRAY = new String[]{"ARRAY_APPEND", "ARRAY_CAT", "ARRAY_NDIMS", "ARRAY_DIMS", "ARRAY_FILL", "ARRAY_LENGTH", "ARRAY_LOWER", "ARRAY_POSITION", "ARRAY_POSITIONS", "ARRAY_PREPEND", "ARRAY_REMOVE", "ARRAY_REPLACE", "ARRAY_TO_STRING", "ARRAY_UPPER", "CARDINALITY", "STRING_TO_ARRAY", "UNNEST"};
    public static String[] POSTGRE_FUNCTIONS_INFO = new String[]{"CURRENT_DATABASE", "CURRENT_QUERY", "CURRENT_SCHEMA", "CURRENT_SCHEMAS", "INET_CLIENT_ADDR", "INET_CLIENT_PORT", "INET_SERVER_ADDR", "INET_SERVER_PORT", "ROW_SECURITY_ACTIVE", "FORMAT_TYPE", "TO_REGCLASS", "TO_REGPROC", "TO_REGPROCEDURE", "TO_REGOPER", "TO_REGOPERATOR", "TO_REGTYPE", "TO_REGNAMESPACE", "TO_REGROLE", "COL_DESCRIPTION", "OBJ_DESCRIPTION", "SHOBJ_DESCRIPTION", "TXID_CURRENT", "TXID_CURRENT_IF_ASSIGNED", "TXID_CURRENT_SNAPSHOT", "TXID_SNAPSHOT_XIP", "TXID_SNAPSHOT_XMAX", "TXID_SNAPSHOT_XMIN", "TXID_VISIBLE_IN_SNAPSHOT", "TXID_STATUS"};
    public static String[] POSTGRE_FUNCTIONS_COMPRASION = new String[]{"NUM_NONNULLS", "NUM_NULLS"};
    public static String[] POSTGRE_FUNCTIONS_FORMATTING = new String[]{"TO_CHAR", "TO_DATE", "TO_NUMBER", "TO_TIMESTAMP"};
    public static String[] POSTGRE_FUNCTIONS_ENUM = new String[]{"ENUM_FIRST", "ENUM_LAST", "ENUM_RANGE"};
    public static String[] POSTGRE_FUNCTIONS_SEQUENCE = new String[]{"CURRVAL", "LASTVAL", "NEXTVAL", "SETVAL"};
    public static String[] POSTGRE_FUNCTIONS_BINARY_STRING = new String[]{"GET_BIT", "GET_BYTE", "SET_BIT", "SET_BYTE"};
    public static String[] POSTGRE_FUNCTIONS_CONDITIONAL = new String[]{"COALESCE", "NULLIF", "GREATEST", "LEAST"};
    public static String[] POSTGRE_FUNCTIONS_TRIGGER = new String[]{"SUPPRESS_REDUNDANT_UPDATES_TRIGGER"};
    public static String[] POSTGRE_FUNCTIONS_SRF = new String[]{"GENERATE_SERIES", "GENERATE_SUBSCRIPTS"};
    private PostgreServerExtension serverExtension;

    public PostgreDialect() {
        super("PostgreSQL", "postgresql");
    }

    public void addExtraKeywords(String ... keywords) {
        super.addSQLKeywords(Arrays.asList(keywords));
    }

    public void addExtraFunctions(String ... functions) {
        super.addFunctions(Arrays.asList(functions));
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addExtraKeywords("SHOW", "TYPE", "USER", "COMMENT", "MATERIALIZED", "ILIKE", "ELSIF", "ELSEIF", "ANALYSE", "ANALYZE", "CONCURRENTLY", "FREEZE", "LANGUAGE", "MODULE", "OFFSET", "RETURNING", "VARIADIC", "PERFORM", "FOREACH", "LOOP", "PERFORM", "RAISE", "NOTICE", "CONFLICT", "EXTENSION", "DATATYPE", "TABLESPACE", "REFRESH");
        this.addExtraKeywords(POSTGRE_EXTRA_KEYWORDS);
        this.addKeywords(Arrays.asList(OTHER_TYPES_FUNCTION), DBPKeywordType.OTHER);
        this.addExtraFunctions(PostgreConstants.POSTGIS_FUNCTIONS);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ADMIN);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_AGGREGATE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ARRAY);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_BINARY_STRING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_COMPRASION);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_CONDITIONAL);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_DATETIME);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_ENUM);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_FORMATTING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_GEOMETRY);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_INFO);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_JSON);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_LO);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_MATH);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_NETWROK);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_RANGE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_SEQUENCE);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_SRF);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_STRING);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_TEXT_SEARCH);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_TRIGGER);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_WINDOW);
        this.addExtraFunctions(POSTGRE_FUNCTIONS_XML);
        this.removeSQLKeyword("LENGTH");
        if (dataSource instanceof PostgreDataSource) {
            this.serverExtension = ((PostgreDataSource)dataSource).getServerType();
            this.serverExtension.configureDialect(this);
        }
        this.setUnquotedIdentCase(DBPIdentifierCase.LOWER);
    }

    public void addKeywords(Collection<String> set, DBPKeywordType type) {
        super.addKeywords(set, type);
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public char getStringEscapeCharacter() {
        if (this.serverExtension != null && this.serverExtension.supportsBackslashStringEscape()) {
            return '\\';
        }
        return super.getStringEscapeCharacter();
    }

    public int getCatalogUsage() {
        return 1;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public String[] getParametersPrefixes() {
        return new String[]{"$"};
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public String[][] getBlockBoundStrings() {
        return BLOCK_BOUND_KEYWORDS;
    }

    @NotNull
    public String getTypeCastClause(DBSTypedObject attribute, String expression) {
        String typeName = attribute.getTypeName();
        if (ArrayUtils.contains((Object[])PostgreDataType.getOidTypes(), (Object)typeName) || attribute.getTypeID() == 1111) {
            DBSObject parentObject;
            DBSDataType dataType;
            if (attribute instanceof DBDAttributeBinding && (dataType = ((DBDAttributeBinding)attribute).getDataType()) != null && (parentObject = dataType.getParentObject()) instanceof PostgreSchema && dataType instanceof PostgreDataType) {
                typeName = ((PostgreDataType)dataType).getFullyQualifiedName(DBPEvaluationContext.DDL);
            }
            return String.valueOf(expression) + "::" + typeName;
        }
        return expression;
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (PostgreUtils.isPGObject(value) || "bit".equals(attribute.getTypeName()) || "interval".equals(attribute.getTypeName()) || attribute.getTypeID() == 1111) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        if (CommonUtils.isNaN((Object)value) || CommonUtils.isInfinite((Object)value)) {
            return String.valueOf('\'') + String.valueOf(value) + '\'';
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    @NotNull
    public String[][] getStringQuoteStrings() {
        return PG_STRING_QUOTES;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    public boolean supportsNestedComments() {
        return true;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> String.valueOf(left) + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return PostgreBinaryFormatter.INSTANCE;
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        super.loadDataTypesFromDatabase(dataSource);
        this.addDataTypes(PostgreConstants.DATA_TYPE_ALIASES.keySet());
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return POSTGRE_NON_TRANSACTIONAL_KEYWORDS;
    }

    protected boolean isStoredProcedureCallIncludesOutParameters() {
        return false;
    }

    public void extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull List<TPRule> rules, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.INITIAL || position == TPRuleProvider.RulePosition.PARTITION) {
            boolean ddTagDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.tag.string");
            boolean ddTagIsString = dataSource == null ? ddTagDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.tag.string"), (boolean)ddTagDefault);
            boolean ddPlainDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.plain.string");
            boolean ddPlainIsString = dataSource == null ? ddPlainDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.plain.string"), (boolean)ddPlainDefault);
            rules.add((TPRule)new SQLDollarQuoteRule(position == TPRuleProvider.RulePosition.PARTITION, true, ddTagIsString, ddPlainIsString));
            rules.add((TPRule)new PostgreEscapeStringRule());
        }
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }

    public String convertExternalDataType(@NotNull SQLDialect sourceDialect, @NotNull DBSTypedObject sourceTypedObject, @Nullable DBPDataTypeProvider targetTypeProvider) {
        String externalTypeName = sourceTypedObject.getTypeName().toLowerCase(Locale.ENGLISH);
        String localDataType = null;
        String dataTypeModifies = null;
        switch (externalTypeName) {
            case "xmltype": 
            case "xml": 
            case "sys.xmltype": {
                localDataType = "xml";
                break;
            }
            case "nvarchar": 
            case "varchar2": 
            case "nchar": {
                localDataType = "varchar";
                dataTypeModifies = String.valueOf(sourceTypedObject.getMaxLength());
                break;
            }
            case "json": 
            case "jsonb": {
                localDataType = "jsonb";
                break;
            }
            case "sdo_geometry": 
            case "mdsys.sdo_geometry": 
            case "geometry": {
                localDataType = "geometry";
                break;
            }
            case "number": {
                localDataType = "numeric";
                if (sourceTypedObject.getPrecision() == null) break;
                dataTypeModifies = sourceTypedObject.getPrecision().toString();
                if (sourceTypedObject.getScale() == null) break;
                dataTypeModifies = String.valueOf(dataTypeModifies) + "," + sourceTypedObject.getScale();
            }
        }
        if (localDataType == null) {
            return null;
        }
        if (targetTypeProvider == null) {
            return localDataType;
        }
        DBSDataType dataType = targetTypeProvider.getLocalDataType(localDataType);
        if (dataType == null) {
            return null;
        }
        String targetTypeName = DBUtils.getObjectFullName((DBPNamedObject)dataType, (DBPEvaluationContext)DBPEvaluationContext.DDL);
        if (dataTypeModifies != null) {
            targetTypeName = String.valueOf(targetTypeName) + "(" + dataTypeModifies + ")";
        }
        return targetTypeName;
    }
}

