/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class SQLNavigatorContext
implements DatabaseEditorContext {
    private DBPDataSourceContainer dataSourceContainer;
    private DBSObject selectedObject;
    private DBCExecutionContext executionContext;
    private SQLScriptContext scriptContext;

    SQLNavigatorContext(ExecutionEvent event) {
        this.selectedObject = AbstractDataSourceHandler.getActiveObject((ExecutionEvent)event);
        if (this.selectedObject != null) {
            this.dataSourceContainer = this.selectedObject instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)this.selectedObject : this.selectedObject.getDataSource().getContainer();
            this.executionContext = null;
        } else {
            this.executionContext = AbstractDataSourceHandler.getActiveExecutionContext((ExecutionEvent)event, (boolean)false);
            this.dataSourceContainer = this.executionContext != null ? this.executionContext.getDataSource().getContainer() : AbstractDataSourceHandler.getActiveDataSourceContainer((ExecutionEvent)event, (boolean)false);
        }
    }

    public SQLNavigatorContext() {
        this.dataSourceContainer = null;
        this.selectedObject = null;
        this.executionContext = null;
    }

    public SQLNavigatorContext(DBSObject selectedObject) {
        this.selectedObject = selectedObject;
        this.dataSourceContainer = selectedObject == null ? null : (selectedObject instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)selectedObject : selectedObject.getDataSource().getContainer());
        this.executionContext = null;
    }

    public SQLNavigatorContext(DBPDataSourceContainer dataSourceContainer, DBCExecutionContext executionContext) {
        this.dataSourceContainer = dataSourceContainer;
        this.executionContext = executionContext;
        this.selectedObject = null;
    }

    public SQLNavigatorContext(DBCExecutionContext executionContext) {
        this.selectedObject = null;
        this.dataSourceContainer = executionContext == null ? null : executionContext.getDataSource().getContainer();
        this.executionContext = executionContext;
    }

    public SQLNavigatorContext(SQLScriptContext scriptContext) {
        this.selectedObject = null;
        this.scriptContext = scriptContext;
    }

    @Nullable
    public SQLScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        if (this.dataSourceContainer != null) {
            return this.dataSourceContainer;
        }
        if (this.scriptContext != null) {
            return this.scriptContext.getExecutionContext().getDataSource().getContainer();
        }
        return null;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    public DBSObject getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(DBSObject selectedObject) {
        this.selectedObject = selectedObject;
    }

    public DBCExecutionContext getExecutionContext() {
        if (this.executionContext != null) {
            return this.executionContext;
        }
        if (this.scriptContext != null) {
            return this.scriptContext.getExecutionContext();
        }
        return null;
    }

    DBPProject getProject() {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        return ds != null ? ds.getProject() : NavigatorUtils.getSelectedProject();
    }
}

