/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import java.text.NumberFormat;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDLabelValuePairExt;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.GenericFilterValueEdit;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class FilterValueEditPopup
extends AbstractPopupPanel {
    private static final String DIALOG_ID = "DBeaver.FilterValueEditMenu";
    private static final String PROP_SHOW_ROW_COUNT = "showRowCount";
    private static final String PROP_QUERY_DATABASE = "queryDatabase";
    private static final String PROP_CASE_INSENSITIVE_SEARCH = "caseInsensitiveSearch";
    private Object value;
    private GenericFilterValueEdit filter;
    private Point location;
    private Button showRowCountCheck;

    public FilterValueEditPopup(Shell parentShell, @NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows) {
        super(parentShell, NLS.bind((String)ResultSetMessages.dialog_filter_value_edit_title, (Object)attr.getFullyQualifiedName(DBPEvaluationContext.UI)));
        this.setShellStyle(1264);
        this.filter = new GenericFilterValueEdit(viewer, attr, rows, DBCLogicalOperator.IN);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createDialogArea(final Composite parent) {
        final DBSEntityReferrer descReferrer = ResultSetUtils.getEnumerableConstraint(this.filter.getAttribute());
        Composite group = (Composite)super.createDialogArea(parent);
        Composite labelComposite = UIUtils.createComposite((Composite)group, (int)2);
        labelComposite.setLayoutData((Object)new GridData(768));
        Label controlLabel = UIUtils.createControlLabel((Composite)labelComposite, (String)ResultSetMessages.dialog_filter_value_edit_label_choose_values);
        controlLabel.setLayoutData((Object)new GridData(768));
        if (descReferrer instanceof DBSEntityAssociation) {
            Link hintLabel = UIUtils.createLink((Composite)labelComposite, (String)ResultSetMessages.dialog_filter_value_edit_label_define_description, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(((DBSEntityAssociation)descReferrer).getAssociatedEntity());
                    if (editDictionaryPage.edit(parent.getShell())) {
                        FilterValueEditPopup.this.reloadFilterValues();
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(128));
        } else {
            UIUtils.createEmptyLabel((Composite)labelComposite, (int)1, (int)1);
        }
        Text filterTextbox = this.filter.addFilterText(group);
        filterTextbox.setFocus();
        filterTextbox.addTraverseListener(e -> {
            Table table = this.filter.getTableViewer().getTable();
            if (e.detail == 32 || e.detail == 64) {
                if (table.getSelectionIndex() < 0 && table.getItemCount() > 0) {
                    table.setSelection(0);
                }
                table.setFocus();
            } else if (e.detail == 4) {
                this.applyFilterValue();
            }
        });
        UIUtils.addEmptyTextHint((Control)filterTextbox, text -> ResultSetMessages.dialog_filter_value_edit_text_hint);
        Composite tableComposite = UIUtils.createComposite((Composite)group, (int)1);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        tableComposite.setLayoutData((Object)gd);
        this.filter.setupTable(tableComposite, 0x10B04 | (this.filter.getOperator() == DBCLogicalOperator.IN ? 32 : 0), true, true, new GridData(1808));
        Table table = this.filter.getTableViewer().getTable();
        ViewerColumnController columnController = new ViewerColumnController("sqlFilterValueEditPopup", (ColumnViewer)this.filter.getTableViewer());
        columnController.addColumn(ResultSetMessages.dialog_filter_value_edit_table_value_label, ResultSetMessages.dialog_filter_value_edit_table_value_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return FilterValueEditPopup.this.filter.getAttribute().getValueHandler().getValueDisplayString((DBSTypedObject)FilterValueEditPopup.this.filter.getAttribute(), ((DBDLabelValuePair)element).getValue(), DBDDisplayFormat.UI);
            }
        });
        if (descReferrer != null) {
            columnController.addColumn(ResultSetMessages.dialog_filter_value_edit_table_description_label, ResultSetMessages.dialog_filter_value_edit_table_description_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((DBDLabelValuePair)element).getLabel();
                }
            });
        }
        if (descReferrer == null) {
            columnController.addColumn(ResultSetMessages.dialog_filter_value_edit_table_count_label, ResultSetMessages.dialog_filter_value_edit_table_count_description, 16384, true, true, true, null, (CellLabelProvider)new ColumnLabelProvider(){
                private final NumberFormat numberFormat = NumberFormat.getInstance();

                public String getText(Object element) {
                    if (element instanceof DBDLabelValuePairExt) {
                        return this.numberFormat.format(((DBDLabelValuePairExt)element).getCount());
                    }
                    return CommonUtils.notEmpty((String)((DBDLabelValuePair)element).getLabel());
                }
            }, null);
        }
        columnController.createColumns(true);
        this.filter.getTableViewer().addDoubleClickListener(event -> {
            this.value = this.filter.getSelectedFilterValue();
            this.close();
        });
        Group optionsGroup = UIUtils.createControlGroup((Composite)tableComposite, (String)ResultSetMessages.dialog_filter_value_edit_table_group_options, (int)0, (int)768, (int)0);
        optionsGroup.moveAbove((Control)this.filter.getButtonsPanel());
        if (this.isAttributeSupportsLike()) {
            final Button caseInsensitiveSearchCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_case_insensitive_label, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_case_insensitive_description, (boolean)this.isCaseInsensitiveSearchEnabled(), (int)1);
            caseInsensitiveSearchCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterValueEditPopup.this.getDialogBoundsSettings().put(FilterValueEditPopup.PROP_CASE_INSENSITIVE_SEARCH, caseInsensitiveSearchCheck.getSelection());
                    FilterValueEditPopup.this.reloadFilterValues();
                }
            });
            caseInsensitiveSearchCheck.setEnabled(this.isQueryDatabaseEnabled());
            ++((GridLayout)optionsGroup.getLayout()).numColumns;
        }
        final Button queryDatabaseCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_read_from_server_label, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_read_from_server_description, (boolean)this.isQueryDatabaseEnabled(), (int)1);
        ++((GridLayout)optionsGroup.getLayout()).numColumns;
        queryDatabaseCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isEnabled = queryDatabaseCheck.getSelection();
                FilterValueEditPopup.this.getDialogBoundsSettings().put(FilterValueEditPopup.PROP_QUERY_DATABASE, isEnabled);
                if (FilterValueEditPopup.this.showRowCountCheck != null) {
                    FilterValueEditPopup.this.showRowCountCheck.setEnabled(isEnabled);
                }
                FilterValueEditPopup.this.reloadFilterValues();
            }
        });
        this.closeOnFocusLost(new Control[]{queryDatabaseCheck});
        if (!this.filter.isDictionarySelector()) {
            this.showRowCountCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_show_row_count_label, (String)ResultSetMessages.dialog_filter_value_edit_table_options_checkbox_show_row_count_description, (boolean)this.isRowCountEnabled(), (int)1);
            ++((GridLayout)optionsGroup.getLayout()).numColumns;
            this.showRowCountCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterValueEditPopup.this.getDialogBoundsSettings().put(FilterValueEditPopup.PROP_SHOW_ROW_COUNT, FilterValueEditPopup.this.showRowCountCheck.getSelection());
                    FilterValueEditPopup.this.reloadFilterValues();
                }
            });
            this.showRowCountCheck.setEnabled(this.isQueryDatabaseEnabled());
            this.closeOnFocusLost(new Control[]{this.showRowCountCheck});
        }
        this.filter.createFilterButton(ResultSetMessages.sql_editor_resultset_filter_panel_btn_apply, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterValueEditPopup.this.applyFilterValue();
            }
        });
        this.closeOnFocusLost(new Control[]{filterTextbox, table});
        this.filter.setFilterPattern(null);
        this.reloadFilterValues();
        return tableComposite;
    }

    private boolean isRowCountEnabled() {
        return this.getDialogBoundsSettings().getBoolean(PROP_SHOW_ROW_COUNT);
    }

    private boolean isQueryDatabaseEnabled() {
        return CommonUtils.getBoolean((String)this.getDialogBoundsSettings().get(PROP_QUERY_DATABASE), (boolean)true);
    }

    private boolean isCaseInsensitiveSearchEnabled() {
        return CommonUtils.getBoolean((Object)this.getDialogBoundsSettings().getBoolean(PROP_CASE_INSENSITIVE_SEARCH), (boolean)true);
    }

    private boolean isAttributeSupportsLike() {
        DBDAttributeBinding attribute = this.filter.getAttribute();
        return ArrayUtils.contains((Object[])DBUtils.getAttributeOperators((DBSTypedObject)attribute), (Object)DBCLogicalOperator.LIKE) && SQLUtils.getDialectFromObject((DBPObject)attribute).getCaseInsensitiveExpressionFormatter(DBCLogicalOperator.LIKE) != null;
    }

    private void reloadFilterValues() {
        this.filter.setQueryDatabase(this.isQueryDatabaseEnabled());
        this.filter.setShowRowCount(this.isRowCountEnabled());
        this.filter.setCaseInsensitiveSearch(this.isCaseInsensitiveSearchEnabled());
        this.filter.loadValues(() -> UIUtils.asyncExec(() -> {
            Table table = this.filter.getTableViewer().getTable();
            if (table != null && !table.isDisposed()) {
                UIUtils.packColumns((Table)table, (boolean)false);
            }
        }));
    }

    private void applyFilterValue() {
        this.value = this.filter.getFilterValue();
        this.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        return UIUtils.createPlaceholder((Composite)parent, (int)1);
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Object getValue() {
        return this.value;
    }
}

