/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import org.eclipse.draw2dl.graph.DirectedGraph;
import org.eclipse.draw2dl.graph.Edge;
import org.eclipse.draw2dl.graph.EdgeList;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.NodeList;
import org.eclipse.draw2dl.graph.SpanningTreeVisitor;

class TightSpanningTreeSolver
extends SpanningTreeVisitor {
    protected DirectedGraph graph;
    protected CandidateList candidates = new CandidateList();
    protected NodeList members = new NodeList();

    TightSpanningTreeSolver() {
    }

    @Override
    public void visit(DirectedGraph graph) {
        this.graph = graph;
        this.init();
        this.solve();
    }

    Node addEdge(Edge edge) {
        Node node;
        int delta = edge.getSlack();
        edge.tree = true;
        if (edge.target.flag) {
            delta = -delta;
            node = edge.source;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.target).add(edge);
        } else {
            node = edge.target;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.source).add(edge);
        }
        this.members.adjustRank(delta);
        this.addNode(node);
        return node;
    }

    private boolean isNodeReachable(Node node) {
        return node.flag;
    }

    private void setNodeReachable(Node node) {
        node.flag = true;
    }

    private boolean isCandidate(Edge e) {
        return e.flag;
    }

    private void setCandidate(Edge e) {
        e.flag = true;
    }

    void addNode(Node node) {
        Edge e;
        this.setNodeReachable(node);
        EdgeList list = node.incoming;
        int i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!this.isNodeReachable(e.source)) {
                if (!this.isCandidate(e)) {
                    this.setCandidate(e);
                    this.candidates.add(e);
                }
            } else {
                this.candidates.remove(e);
            }
            ++i;
        }
        list = node.outgoing;
        i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!this.isNodeReachable(e.target)) {
                if (!this.isCandidate(e)) {
                    this.setCandidate(e);
                    this.candidates.add(e);
                }
            } else {
                this.candidates.remove(e);
            }
            ++i;
        }
        this.members.add(node);
    }

    void init() {
        this.graph.edges.resetFlags(true);
        this.graph.nodes.resetFlags();
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node node = (Node)this.graph.nodes.get(i);
            node.workingData[0] = new EdgeList();
            ++i;
        }
    }

    protected void solve() {
        Node root = this.graph.nodes.getNode(0);
        this.setParentEdge(root, null);
        this.addNode(root);
        while (this.members.size() < this.graph.nodes.size()) {
            if (this.candidates.size() == 0) {
                throw new RuntimeException("graph is not fully connected");
            }
            int minSlack = Integer.MAX_VALUE;
            Edge minEdge = null;
            int i = 0;
            while (i < this.candidates.size() && minSlack > 0) {
                Edge edge = this.candidates.getEdge(i);
                int slack = edge.getSlack();
                if (slack < minSlack) {
                    minSlack = slack;
                    minEdge = edge;
                }
                ++i;
            }
            this.addEdge(minEdge);
        }
        this.graph.nodes.normalizeRanks();
    }

    static final class CandidateList {
        private Edge[] edges = new Edge[10];
        private int size;

        CandidateList() {
        }

        public void add(Edge edge) {
            if (this.size == this.edges.length - 1) {
                Edge[] newEdges = new Edge[this.edges.length * 2];
                System.arraycopy(this.edges, 0, newEdges, 0, this.edges.length);
                this.edges = newEdges;
            }
            this.edges[this.size++] = edge;
        }

        public Edge getEdge(int index) {
            return this.edges[index];
        }

        public void remove(Edge edge) {
            int i = 0;
            while (i < this.size) {
                if (this.edges[i] == edge) {
                    this.edges[i] = this.edges[this.size - 1];
                    --this.size;
                    return;
                }
                ++i;
            }
            throw new RuntimeException("Remove called on invalid Edge");
        }

        public int size() {
            return this.size;
        }
    }
}

