/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.figures;

import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.CompoundBorder;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LineBorder;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.text.FlowPage;
import org.eclipse.draw2dl.text.TextFlow;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.ui.UIUtils;

public class NoteFigure
extends FlowPage {
    private TextFlow textFlow;

    public NoteFigure(ERDNote note) {
        this.textFlow = new TextFlow((String)note.getObject());
        this.add((IFigure)this.textFlow);
        this.setBackgroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.notes.background"));
        this.setForegroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.notes.foreground"));
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"), 1), (Border)new MarginBorder(5)));
    }

    public TextFlow getTextFlow() {
        return this.textFlow;
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setText(String text) {
        this.textFlow.setText(text);
    }

    public Dimension getPreferredSize(int width, int h) {
        Dimension currentSize = this.getSize();
        Dimension textPrefSize = this.textFlow.getPreferredSize(width, h);
        if (currentSize.width >= textPrefSize.width && currentSize.height >= textPrefSize.height) {
            return currentSize;
        }
        return textPrefSize;
    }

    public void setPreferredSize(Dimension size) {
        this.textFlow.setSize(size);
        this.textFlow.setPreferredSize(size);
        super.setPreferredSize(size);
    }
}

