/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ICustomActionsProvider;
import org.jkiss.dbeaver.ui.INestedEditorSite;
import org.jkiss.dbeaver.ui.IProgressControlProvider;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class ProgressPageControl
extends Composite
implements ISearchContextProvider,
ICustomActionsProvider {
    private static final Log log = Log.getLog(ProgressPageControl.class);
    private static final int PROGRESS_MIN = 0;
    private static final int PROGRESS_MAX = 20;
    private boolean showDivider;
    private Label listInfoLabel;
    private ProgressBar progressBar;
    private Text searchText;
    private int loadCount = 0;
    private ProgressPageControl ownerPageControl = null;
    private ProgressPageControl childPageControl = null;
    private Composite searchControlsComposite;
    private String curInfo;
    private String curSearchText;
    private volatile Job curSearchJob;
    private Color searchNotFoundColor;
    private ToolBarManager defaultToolbarManager;
    private ToolBarManager searchToolbarManager;
    private ToolBarManager customToolbarManager;
    private Composite customControlsComposite;

    public ProgressPageControl(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        if ((style & 0x10000000) != 0) {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
        }
        this.setLayout((Layout)layout);
        this.addDisposeListener(e -> this.disposeControl());
        this.searchNotFoundColor = new Color((Device)this.getDisplay(), 255, 128, 128);
    }

    public GridLayout getLayout() {
        return (GridLayout)super.getLayout();
    }

    public void setShowDivider(boolean showDivider) {
        this.showDivider = showDivider;
    }

    public void setInfo(String info) {
        if (!CommonUtils.isEmpty((String)info)) {
            this.curInfo = info;
        }
        if (this.ownerPageControl != null) {
            this.ownerPageControl.setInfo(info);
        } else if (this.listInfoLabel != null && !this.listInfoLabel.isDisposed()) {
            this.listInfoLabel.setText(info);
        }
    }

    public final Composite createProgressPanel() {
        return this.createProgressPanel(this);
    }

    public final void substituteProgressPanel(ProgressPageControl externalPageControl) {
        this.ownerPageControl = externalPageControl;
        if (this.ownerPageControl != null) {
            this.ownerPageControl.setChildControl(this);
        }
    }

    public void createOrSubstituteProgressPanel(IWorkbenchPartSite site) {
        ProgressPageControl progressControl = this.findOwnerPageControl(site);
        if (progressControl != null) {
            this.substituteProgressPanel(progressControl);
        } else {
            this.createProgressPanel();
        }
    }

    private ProgressPageControl findOwnerPageControl(IWorkbenchPartSite site) {
        if (site instanceof INestedEditorSite && ((INestedEditorSite)site).getFolderEditor() instanceof IProgressControlProvider) {
            return ((IProgressControlProvider)((INestedEditorSite)site).getFolderEditor()).getProgressControl();
        }
        if (site instanceof MultiPageEditorSite && ((MultiPageEditorSite)site).getMultiPageEditor() instanceof IProgressControlProvider) {
            return ((IProgressControlProvider)((MultiPageEditorSite)site).getMultiPageEditor()).getProgressControl();
        }
        return null;
    }

    private void setChildControl(ProgressPageControl progressPageControl) {
        if (progressPageControl == this.childPageControl) {
            return;
        }
        this.childPageControl = progressPageControl;
        if (this.getProgressControl().progressBar == null) {
            this.hideControls(true);
        }
    }

    private ProgressPageControl getProgressControl() {
        return this.ownerPageControl != null ? this.ownerPageControl : this;
    }

    public Text getSearchTextControl() {
        return this.searchText;
    }

    public Composite createContentContainer() {
        Composite container = new Composite((Composite)this, (this.getStyle() & 0x10000000) == 0x10000000 ? 0 : 2048);
        container.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        container.setLayoutData((Object)gd);
        return container;
    }

    public Composite createProgressPanel(Composite container) {
        if (this.ownerPageControl != null) {
            throw new IllegalStateException("Can't create page control while substitution control already set");
        }
        if (this.showDivider) {
            Label separator = new Label(container, 258);
            separator.setLayoutData((Object)new GridData(768));
        }
        Composite infoGroup = new Composite(container, 0);
        GridData gd = new GridData(768);
        infoGroup.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        infoGroup.setLayout((Layout)gl);
        this.listInfoLabel = new Label(infoGroup, 0);
        gd = new GridData(768);
        gd.horizontalIndent = 5;
        gd.minimumWidth = 100;
        this.listInfoLabel.setLayoutData((Object)gd);
        Composite controlsComposite = UIUtils.createPlaceholder(infoGroup, 2, 5);
        controlsComposite.setLayoutData((Object)new GridData(768));
        this.searchControlsComposite = UIUtils.createPlaceholder(controlsComposite, 1);
        this.searchControlsComposite.setLayoutData((Object)new GridData(768));
        new ToolBar(this.searchControlsComposite, 0);
        this.customControlsComposite = new Composite(controlsComposite, 0);
        gd = new GridData(128);
        this.customControlsComposite.setLayoutData((Object)gd);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.customControlsComposite.setLayout((Layout)gl);
        this.defaultToolbarManager = new ToolBarManager(8519936);
        this.customToolbarManager = new ToolBarManager(8519936);
        this.hideControls(true);
        return infoGroup;
    }

    @Override
    public void fillCustomActions(IContributionManager contributionManager) {
        if (this.childPageControl != null) {
            this.childPageControl.fillCustomActions(contributionManager);
        }
    }

    protected void populateCustomActions(ContributionManager contributionManager) {
    }

    public void updateActions() {
        UIUtils.updateContributionItems((IContributionManager)this.defaultToolbarManager);
        UIUtils.updateContributionItems((IContributionManager)this.customToolbarManager);
    }

    private void hideControls(boolean showDefaultControls) {
        if (this.searchControlsComposite == null || this.searchControlsComposite.isDisposed()) {
            return;
        }
        this.setRedraw(false);
        try {
            UIUtils.disposeChildControls(this.searchControlsComposite);
            this.progressBar = null;
            this.searchText = null;
            if (showDefaultControls) {
                ((GridLayout)this.searchControlsComposite.getLayout()).numColumns = 2;
                ((GridLayout)this.searchControlsComposite.getLayout()).marginTop = 2;
                this.defaultToolbarManager.removeAll();
                if (this.isSearchPossible() && this.isSearchEnabled()) {
                    this.addSearchAction((IContributionManager)this.defaultToolbarManager);
                }
                Label phLabel = new Label(this.searchControlsComposite, 0);
                phLabel.setText("");
                phLabel.setLayoutData((Object)new GridData(768));
                ToolBar defaultToolbar = this.defaultToolbarManager.createControl(this.searchControlsComposite);
                defaultToolbar.setLayoutData((Object)new GridData(896));
                UIUtils.disposeChildControls(this.customControlsComposite);
                this.customToolbarManager.removeAll();
                this.fillCustomActions((IContributionManager)this.customToolbarManager);
                if (!this.customToolbarManager.isEmpty()) {
                    ToolBar toolbar = this.customToolbarManager.createControl(this.customControlsComposite);
                    toolbar.setLayoutData((Object)new GridData(896));
                    this.populateCustomActions((ContributionManager)this.customToolbarManager);
                }
            }
            this.searchControlsComposite.getParent().layout();
        }
        finally {
            this.setRedraw(true);
        }
    }

    protected void addSearchAction(IContributionManager contributionManager) {
        contributionManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.ui.edit.findReplace", UIMessages.controls_progress_page_toolbar_title, (DBPImage)UIIcon.SEARCH));
    }

    private void createProgressControls() {
        if (this.progressBar != null || this.customControlsComposite == null) {
            return;
        }
        this.hideControls(false);
        ((GridLayout)this.searchControlsComposite.getLayout()).numColumns = 2;
        this.progressBar = new ProgressBar(this.searchControlsComposite, 65792);
        this.progressBar.setSize(300, 16);
        this.progressBar.setState(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(20);
        this.progressBar.setToolTipText(UIMessages.controls_progress_page_progress_bar_loading_tooltip);
        this.progressBar.setLayoutData((Object)new GridData(768));
        ToolBar progressTools = new ToolBar(this.searchControlsComposite, 256);
        final ToolItem stopButton = new ToolItem(progressTools, 8);
        stopButton.setImage(UIUtils.getShardImage("IMG_ELCL_STOP"));
        stopButton.setToolTipText(UIMessages.controls_progress_page_progress_bar_cancel_tooltip);
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProgressPageControl.this.cancelProgress() && !stopButton.isDisposed()) {
                    stopButton.setEnabled(false);
                    stopButton.setImage(UIUtils.getShardImage("IMG_ELCL_STOP_DISABLED"));
                }
            }
        });
        this.searchControlsComposite.getParent().layout();
    }

    protected void createSearchControls() {
        if (this.searchText != null) {
            return;
        }
        this.hideControls(false);
        ((GridLayout)this.searchControlsComposite.getLayout()).numColumns = 2;
        this.searchControlsComposite.getParent().setRedraw(false);
        try {
            this.searchText = new Text(this.searchControlsComposite, 2048);
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (Control)this.searchText);
            if (this.curSearchText != null) {
                this.searchText.setText(this.curSearchText);
                this.searchText.setSelection(this.curSearchText.length());
            }
            this.searchText.setLayoutData((Object)new GridData(768));
            this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 27: {
                            ProgressPageControl.this.cancelSearch(true);
                            break;
                        }
                        case 13: 
                        case 0x1000001: 
                        case 0x1000002: {
                            if (ProgressPageControl.this.childPageControl != null) {
                                ProgressPageControl.this.childPageControl.setFocus();
                            }
                            e.doit = false;
                        }
                    }
                }
            });
            this.searchText.addModifyListener(e -> {
                this.curSearchText = this.searchText.getText();
                if (this.curSearchJob == null) {
                    this.curSearchJob = new UIJob(UIMessages.controls_progress_page_job_search){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            ProgressPageControl.this.performSearch(ISearchContextProvider.SearchType.NEXT);
                            ProgressPageControl.this.curSearchJob = null;
                            return Status.OK_STATUS;
                        }
                    };
                    this.curSearchJob.schedule(200L);
                }
            });
            if (this.searchToolbarManager == null) {
                this.searchToolbarManager = new ToolBarManager(0x800100);
                this.searchToolbarManager.add((IAction)new Action(UIMessages.controls_progress_page_action_close, UIUtils.getShardImageDescriptor("IMG_ELCL_REMOVE")){

                    public void run() {
                        ProgressPageControl.this.cancelSearch(true);
                    }
                });
            }
            this.searchToolbarManager.createControl(this.searchControlsComposite);
            this.searchControlsComposite.getParent().layout();
        }
        finally {
            this.searchControlsComposite.getParent().setRedraw(true);
        }
    }

    public void disposeControl() {
        if (this.searchToolbarManager != null) {
            this.searchToolbarManager.dispose();
            this.searchToolbarManager = null;
        }
        if (this.defaultToolbarManager != null) {
            this.defaultToolbarManager.dispose();
            this.defaultToolbarManager = null;
        }
        if (this.customToolbarManager != null) {
            this.customToolbarManager.dispose();
            this.customToolbarManager = null;
        }
        UIUtils.dispose((Resource)this.searchNotFoundColor);
    }

    protected boolean cancelProgress() {
        return false;
    }

    protected ISearchExecutor getSearchRunner() {
        if (this.childPageControl != null) {
            return this.childPageControl.getSearchRunner();
        }
        return null;
    }

    @Override
    public boolean isSearchPossible() {
        return this.getSearchRunner() != null;
    }

    @Override
    public boolean isSearchEnabled() {
        return this.getProgressControl().progressBar == null;
    }

    @Override
    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        this.getProgressControl().createSearchControls();
        if (searchType == ISearchContextProvider.SearchType.NONE) {
            this.getProgressControl().searchText.setFocus();
        }
        if (!CommonUtils.isEmpty((String)this.getProgressControl().curSearchText)) {
            int options = 0;
            options = searchType == ISearchContextProvider.SearchType.PREVIOUS ? (options |= 4) : (options |= 2);
            boolean success = this.getSearchRunner().performSearch(this.getProgressControl().curSearchText, options);
            this.getProgressControl().searchText.setBackground(success ? null : this.searchNotFoundColor);
            return success;
        }
        this.cancelSearch(false);
        return true;
    }

    private void cancelSearch(boolean hide) {
        ISearchExecutor searchRunner;
        if (this.curSearchJob != null) {
            this.curSearchJob.cancel();
            this.curSearchJob = null;
        }
        if ((searchRunner = this.getSearchRunner()) != null) {
            searchRunner.cancelSearch();
        }
        if (hide) {
            this.hideControls(true);
        } else {
            this.getProgressControl().searchText.setBackground(null);
        }
    }

    public void refreshActions() {
        this.getProgressControl().hideControls(true);
    }

    public void activate(boolean active) {
        if (active) {
            if (this.curInfo != null) {
                this.setInfo(this.curInfo);
            } else {
                this.setInfo("");
            }
            if (this.ownerPageControl != null) {
                this.ownerPageControl.setChildControl(this);
            }
        }
    }

    public class ProgressVisualizer<RESULT>
    implements ILoadVisualizer<RESULT> {
        private boolean completed = false;
        private String curStatus;
        private final List<TaskInfo> tasksRunning = new ArrayList<TaskInfo>();

        public DBRProgressMonitor overwriteMonitor(DBRProgressMonitor monitor) {
            return new ProxyProgressMonitor(monitor){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void beginTask(String name, int totalWork) {
                    super.beginTask(name, totalWork);
                    ProgressVisualizer.this.curStatus = name;
                    List list = ProgressVisualizer.this.tasksRunning;
                    synchronized (list) {
                        ProgressVisualizer.this.tasksRunning.add(new TaskInfo(name, totalWork));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done() {
                    super.done();
                    ProgressVisualizer.this.curStatus = "";
                    List list = ProgressVisualizer.this.tasksRunning;
                    synchronized (list) {
                        if (ProgressVisualizer.this.tasksRunning.isEmpty()) {
                            log.warn((Object)"Task end when no tasks are running");
                        } else {
                            ProgressVisualizer.this.tasksRunning.remove(ProgressVisualizer.this.tasksRunning.size() - 1);
                        }
                    }
                }

                public void subTask(String name) {
                    super.subTask(name);
                    ProgressVisualizer.this.curStatus = name;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void worked(int work) {
                    super.worked(work);
                    List list = ProgressVisualizer.this.tasksRunning;
                    synchronized (list) {
                        if (!ProgressVisualizer.this.tasksRunning.isEmpty()) {
                            ((TaskInfo)((ProgressVisualizer)ProgressVisualizer.this).tasksRunning.get((int)(((ProgressVisualizer)ProgressVisualizer.this).tasksRunning.size() - 1))).progress += work;
                        }
                    }
                }
            };
        }

        private TaskInfo getCurTaskInfo() {
            int i = this.tasksRunning.size() - 1;
            while (i >= 0) {
                if (this.tasksRunning.get((int)i).totalWork > 1) {
                    return this.tasksRunning.get(i);
                }
                --i;
            }
            return null;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visualizeLoading() {
            if (!ProgressPageControl.this.getProgressControl().isDisposed()) {
                ProgressPageControl.this.getProgressControl().createProgressControls();
                List<TaskInfo> list = this.tasksRunning;
                synchronized (list) {
                    TaskInfo taskInfo = this.getCurTaskInfo();
                    ProgressBar progressBar = ProgressPageControl.this.getProgressControl().progressBar;
                    if (progressBar != null) {
                        if (taskInfo != null) {
                            progressBar.setMaximum(taskInfo.totalWork);
                            progressBar.setSelection(taskInfo.progress);
                        } else {
                            progressBar.setMaximum(20);
                            progressBar.setSelection(ProgressPageControl.this.loadCount);
                        }
                    }
                }
                if (this.curStatus != null) {
                    ProgressPageControl.this.setInfo(this.curStatus);
                }
                ProgressPageControl progressPageControl = ProgressPageControl.this;
                progressPageControl.loadCount = progressPageControl.loadCount + 1;
                if (ProgressPageControl.this.loadCount > 20) {
                    ProgressPageControl.this.loadCount = 0;
                }
            }
        }

        public void completeLoading(RESULT result) {
            this.completed = true;
            if (ProgressPageControl.this.isDisposed()) {
                return;
            }
            this.visualizeLoading();
            ProgressPageControl.this.loadCount = 0;
            ProgressBar progressBar = ProgressPageControl.this.getProgressControl().progressBar;
            if (progressBar != null && !progressBar.isDisposed()) {
                progressBar.setState(4);
                ProgressPageControl.this.getProgressControl().hideControls(true);
            }
        }
    }

    private static class TaskInfo {
        final String name;
        final int totalWork;
        int progress;

        private TaskInfo(String name, int totalWork) {
            this.name = name;
            this.totalWork = totalWork;
        }
    }
}

