/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceHandler;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.IDataSourceContainerProviderEx;
import org.jkiss.dbeaver.model.ISmartTransactionManager;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCScriptContextListener;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.DefaultServerOutputReader;
import org.jkiss.dbeaver.model.impl.sql.SQLQueryTransformerCount;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryTransformer;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.CompositeSelectionProvider;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DynamicFindReplaceTarget;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.TabFolderReorder;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.VerticalFolder;
import org.jkiss.dbeaver.ui.controls.resultset.IQueryExecuteController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainerExt;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetListener;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetValueReflector;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IActionContributor;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorFeatures;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputConsoleViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorParametersProvider;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentationPanel;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPropertyTester;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsView;
import org.jkiss.dbeaver.ui.editors.sql.SQLScriptBindingType;
import org.jkiss.dbeaver.ui.editors.sql.execute.SQLQueryJob;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.log.SQLLogPanel;
import org.jkiss.dbeaver.ui.editors.sql.plan.ExplainPlanViewer;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationPanelDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationRegistry;
import org.jkiss.dbeaver.ui.editors.sql.variables.AssignVariableAction;
import org.jkiss.dbeaver.ui.editors.sql.variables.SQLVariablesPanel;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditor
extends SQLEditorBase
implements IDataSourceContainerProviderEx,
DBPEventListener,
ISaveablePart2,
DBPDataSourceTask,
DBPDataSourceHandler,
ISmartTransactionManager {
    private static final long SCRIPT_UI_UPDATE_PERIOD = 100L;
    private static final int MAX_PARALLEL_QUERIES_NO_WARN = 1;
    private static final int SQL_EDITOR_CONTROL_INDEX = 1;
    private static final int EXTRA_CONTROL_INDEX = 0;
    private static final String PANEL_ITEM_PREFIX = "SQLPanelToggle:";
    private static final String EMBEDDED_BINDING_PREFIX = "-- CONNECTION: ";
    private static final Pattern EMBEDDED_BINDING_PREFIX_PATTERN = Pattern.compile("--\\s*CONNECTION:\\s*(.+)", 2);
    private static final Image IMG_DATA_GRID = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID);
    private static final Image IMG_DATA_GRID_LOCKED = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_DATA_GRID_LOCKED);
    private static final Image IMG_EXPLAIN_PLAN = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_EXPLAIN_PLAN);
    private static final Image IMG_LOG = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_LOG);
    private static final Image IMG_VARIABLES = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_VARIABLE);
    private static final Image IMG_OUTPUT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT);
    private static final Image IMG_OUTPUT_ALERT = DBeaverIcons.getImage((DBPImage)UIIcon.SQL_PAGE_OUTPUT_ALERT);
    public static final String VAR_CONNECTION_NAME = "connectionName";
    public static final String VAR_FILE_NAME = "fileName";
    public static final String VAR_FILE_EXT = "fileExt";
    public static final String VAR_DRIVER_NAME = "driverName";
    public static final String VAR_ACTIVE_DATABASE = "database";
    public static final String VAR_ACTIVE_SCHEMA = "schema";
    public static final String DEFAULT_TITLE_PATTERN = "<${connectionName}> ${fileName}";
    private ResultSetOrientation resultSetOrientation = ResultSetOrientation.HORIZONTAL;
    private CustomSashForm resultsSash;
    private Composite sqlEditorPanel;
    @Nullable
    private Composite presentationStack;
    private SashForm sqlExtraPanelSash;
    private CTabFolder sqlExtraPanelFolder;
    private ToolBarManager sqlExtraPanelToolbar;
    private CTabFolder resultTabs;
    private TabFolderReorder resultTabsReorder;
    private CTabItem activeResultsTab;
    private SQLLogPanel logViewer;
    private SQLEditorOutputConsoleViewer outputViewer;
    private SQLVariablesPanel variablesViewer;
    private volatile QueryProcessor curQueryProcessor;
    private final List<QueryProcessor> queryProcessors = new ArrayList<QueryProcessor>();
    private DBPDataSourceContainer dataSourceContainer;
    private DBPDataSource curDataSource;
    private volatile DBCExecutionContext executionContext;
    private volatile DBCExecutionContext lastExecutionContext;
    private SQLScriptContext globalScriptContext;
    private volatile boolean syntaxLoaded = false;
    private final FindReplaceTarget findReplaceTarget = new FindReplaceTarget();
    private final List<SQLQuery> runningQueries = new ArrayList<SQLQuery>();
    private QueryResultsContainer curResultsContainer;
    private Image editorImage;
    private VerticalFolder sideToolBar;
    private SQLPresentationDescriptor extraPresentationDescriptor;
    private SQLEditorPresentation extraPresentation;
    private Map<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel> extraPresentationPanels = new HashMap<SQLPresentationPanelDescriptor, SQLEditorPresentationPanel>();
    private SQLEditorPresentationPanel extraPresentationCurrentPanel;
    private VerticalFolder presentationSwitchFolder;
    private final List<SQLEditorListener> listeners = new ArrayList<SQLEditorListener>();
    private final List<ServerOutputInfo> serverOutputs = new ArrayList<ServerOutputInfo>();
    private ScriptAutoSaveJob scriptAutoSavejob;
    private DisposeListener resultTabDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            Object data = e.widget.getData();
            if (data instanceof QueryResultsContainer) {
                QueryProcessor processor = ((QueryResultsContainer)data).queryProcessor;
                List<QueryResultsContainer> containers = processor.getResultContainers();
                int index = containers.indexOf(data) + 1;
                while (index < containers.size()) {
                    QueryResultsContainer container = containers.get(index);
                    if (container.resultSetNumber == index) {
                        QueryResultsContainer queryResultsContainer = container;
                        queryResultsContainer.resultSetNumber = queryResultsContainer.resultSetNumber - 1;
                    }
                    ++index;
                }
            }
            if (SQLEditor.this.resultTabs.getItemCount() == 0 && SQLEditor.this.resultsSash.getMaximizedControl() == null) {
                SQLEditor.this.toggleResultPanel(false, true);
            }
        }
    };
    private VerticalButton switchPresentationSQLButton;
    private VerticalButton switchPresentationExtraButton;

    public SQLEditor() {
        this.extraPresentationDescriptor = SQLPresentationRegistry.getInstance().getPresentation(this);
    }

    @Override
    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script"};
    }

    @Override
    public DBPDataSource getDataSource() {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return container == null ? null : container.getDataSource();
    }

    public DBCExecutionContext getExecutionContext() {
        if (this.executionContext != null) {
            return this.executionContext;
        }
        if (this.dataSourceContainer != null && !SQLEditorUtils.isOpenSeparateConnection(this.dataSourceContainer)) {
            return DBUtils.getDefaultContext((DBSObject)this.getDataSource(), (boolean)false);
        }
        return null;
    }

    public SQLScriptContext getGlobalScriptContext() {
        return this.globalScriptContext;
    }

    @Nullable
    public DBPProject getProject() {
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        return file == null ? DBWorkbench.getPlatform().getWorkspace().getActiveProject() : DBWorkbench.getPlatform().getWorkspace().getProject(file.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public int[] getCurrentLines() {
        List<SQLQuery> list = this.runningQueries;
        synchronized (list) {
            ArrayList<Integer> lines;
            block11: {
                IDocument document;
                block10: {
                    document = this.getDocument();
                    if (document != null && !this.runningQueries.isEmpty()) break block10;
                    return null;
                }
                lines = new ArrayList<Integer>(this.runningQueries.size() * 2);
                for (SQLQuery statementInfo : this.runningQueries) {
                    try {
                        int firstLine = document.getLineOfOffset(statementInfo.getOffset());
                        int lastLine = document.getLineOfOffset(statementInfo.getOffset() + statementInfo.getLength());
                        int k = firstLine;
                        while (k <= lastLine) {
                            lines.add(k);
                            ++k;
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (!lines.isEmpty()) break block11;
                return null;
            }
            int[] results = new int[lines.size()];
            int i = 0;
            while (i < lines.size()) {
                results[i] = (Integer)lines.get(i);
                ++i;
            }
            return results;
        }
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public boolean setDataSourceContainer(@Nullable DBPDataSourceContainer container) {
        IEditorInput input;
        if (container == this.dataSourceContainer) {
            return true;
        }
        this.releaseContainer();
        this.closeAllJobs();
        this.dataSourceContainer = container;
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().addDataSourceListener((DBPEventListener)this);
        }
        if ((input = this.getEditorInput()) != null) {
            IFile file;
            DBPDataSourceContainer savedContainer = EditorUtils.getInputDataSource((IEditorInput)input);
            if (savedContainer != container) {
                EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(container, this.getExecutionContext()));
            }
            if ((file = EditorUtils.getFileFromInput((IEditorInput)input)) != null) {
                DBNUtils.refreshNavigatorResource((IResource)file, (Object)container);
            } else {
                IWorkbenchPage page = this.getSite().getPage();
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference er = iEditorReferenceArray[n2];
                    if (er.getEditor(false) == this) {
                        page.hideEditor(er);
                        page.showEditor(er);
                        break;
                    }
                    ++n2;
                }
            }
        }
        this.checkConnected(false, status -> UIUtils.asyncExec(() -> {
            if (!status.isOK()) {
                DBWorkbench.getPlatformUI().showError("Can't connect to database", "Error connecting to datasource", status);
            }
            this.setFocus();
        }));
        this.setPartName(this.getEditorName());
        this.fireDataSourceChange();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.acquire((DBPDataSourceTask)this);
        }
        if (SQLEditorBase.isWriteEmbeddedBinding()) {
            UIUtils.syncExec(this::embedDataSourceAssociation);
        }
        return true;
    }

    private void updateDataSourceContainer() {
        IWorkbenchPart activePart;
        DBPDataSourceContainer inputDataSource = null;
        if (SQLEditorBase.isReadEmbeddedBinding()) {
            inputDataSource = this.getDataSourceFromContent();
        }
        if (inputDataSource == null) {
            inputDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput());
        }
        if (inputDataSource == null && (activePart = this.getSite().getWorkbenchWindow().getActivePage().getActivePart()) != this && activePart instanceof IDataSourceContainerProvider) {
            inputDataSource = ((IDataSourceContainerProvider)activePart).getDataSourceContainer();
        }
        this.setDataSourceContainer(inputDataSource);
    }

    private void updateExecutionContext(Runnable onSuccess) {
        if (this.dataSourceContainer == null) {
            this.releaseExecutionContext();
        } else {
            DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
            if (dataSource == null) {
                this.releaseExecutionContext();
            } else if (this.curDataSource != dataSource) {
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                DBPDataSourceContainer container = dataSource.getContainer();
                if (SQLEditorUtils.isOpenSeparateConnection(container)) {
                    this.initSeparateConnection(dataSource, onSuccess);
                } else if (onSuccess != null) {
                    onSuccess.run();
                }
            }
        }
    }

    private void initSeparateConnection(@NotNull DBPDataSource dataSource, Runnable onSuccess) {
        DBSInstance selectedInstance;
        String[] contextDefaults;
        DBSInstance dsInstance = dataSource.getDefaultInstance();
        String[] stringArray = contextDefaults = this.isRestoreActiveSchemaFromScript() ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)dataSource.getContainer(), (IEditorInput)this.getEditorInput()) : null;
        if (!ArrayUtils.isEmpty(contextDefaults) && contextDefaults[0] != null && (selectedInstance = (DBSInstance)DBUtils.findObject((Collection)dataSource.getAvailableInstances(), (String)contextDefaults[0])) != null) {
            dsInstance = selectedInstance;
        }
        if (dsInstance != null) {
            OpenContextJob job = new OpenContextJob(dsInstance, onSuccess);
            job.schedule();
        }
    }

    private void releaseExecutionContext() {
        if (this.executionContext != null && this.executionContext.isConnected()) {
            new CloseContextJob(this.executionContext).schedule();
        }
        this.executionContext = null;
        this.curDataSource = null;
    }

    private void releaseContainer() {
        this.releaseExecutionContext();
        if (this.dataSourceContainer != null) {
            this.dataSourceContainer.getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
            this.dataSourceContainer.getRegistry().removeDataSourceListener((DBPEventListener)this);
            this.dataSourceContainer.release((DBPDataSourceTask)this);
            this.dataSourceContainer = null;
        }
    }

    private DBPDataSourceContainer getDataSourceFromContent() {
        DBPProject project = this.getProject();
        IDocument document = this.getDocument();
        if (project == null || document == null || document.getNumberOfLines() == 0) {
            return null;
        }
        try {
            DBPDataSourceContainer dataSource;
            String connSpec;
            IRegion region = document.getLineInformation(0);
            String line = document.get(region.getOffset(), region.getLength());
            Matcher matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line);
            if (matcher.matches() && !CommonUtils.isEmpty((String)(connSpec = matcher.group(1).trim())) && (dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)project, (String)connSpec, null, (boolean)true, (boolean)false)) != null) {
                return dataSource;
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        return null;
    }

    private void embedDataSourceAssociation() {
        if (this.getDataSourceFromContent() == this.dataSourceContainer) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            log.error((Object)"Document is null");
            return;
        }
        try {
            String line;
            Matcher matcher;
            int totalLines = document.getNumberOfLines();
            IRegion region = null;
            if (totalLines > 0 && !(matcher = EMBEDDED_BINDING_PREFIX_PATTERN.matcher(line = document.get((region = document.getLineInformation(0)).getOffset(), region.getLength()))).matches()) {
                region = null;
            }
            if (this.dataSourceContainer == null) {
                if (region == null) {
                    return;
                }
                document.replace(region.getOffset(), region.getLength(), "");
            } else {
                SQLScriptBindingType bindingType = SQLScriptBindingType.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.script.bind.commentType"));
                StringBuilder assocSpecLine = new StringBuilder(EMBEDDED_BINDING_PREFIX);
                bindingType.appendSpec(this.dataSourceContainer, assocSpecLine);
                assocSpecLine.append(GeneralUtils.getDefaultLineSeparator());
                if (region != null) {
                    document.replace(region.getOffset(), region.getLength(), assocSpecLine.toString());
                } else {
                    document.replace(0, 0, assocSpecLine.toString());
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error extracting datasource info from script's content", e);
        }
        UIUtils.asyncExec(() -> {
            TextViewer textViewer = this.getTextViewer();
            if (textViewer != null) {
                textViewer.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SQLEditorListener listener) {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public boolean isActiveTask() {
        return this.getTotalQueryRunning() > 0;
    }

    public boolean isSmartAutoCommit() {
        return this.getActivePreferenceStore().getBoolean("transaction.smart.commit");
    }

    public void setSmartAutoCommit(boolean smartAutoCommit) {
        this.getActivePreferenceStore().setValue("transaction.smart.commit", smartAutoCommit);
        try {
            this.getActivePreferenceStore().save();
        }
        catch (IOException e) {
            log.error((Object)"Error saving smart auto-commit option", (Throwable)e);
        }
    }

    public void refreshActions() {
        this.sideToolBar.redraw();
    }

    private boolean isRestoreActiveSchemaFromScript() {
        return this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveActiveSchema") && this.getActivePreferenceStore().getBoolean("database.editor.separate.connection");
    }

    public boolean isDirty() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            if (!queryProcessor.isDirty() && queryProcessor.curJobRunning.get() <= 0) continue;
            return true;
        }
        if (this.executionContext != null && QMUtils.isTransactionActive((DBCExecutionContext)this.executionContext)) {
            return true;
        }
        if (this.isNonPersistentEditor()) {
            return false;
        }
        if (this.extraPresentation instanceof ISaveablePart && ((ISaveablePart)this.extraPresentation).isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    @Override
    @Nullable
    public <T> T getAdapter(Class<T> required) {
        if (required == INavigatorModelView.class) {
            return null;
        }
        if (this.resultTabs != null && !this.resultTabs.isDisposed()) {
            if (required == IFindReplaceTarget.class) {
                return required.cast((Object)this.findReplaceTarget);
            }
            CTabItem activeResultsTab = this.getActiveResultsTab();
            if (activeResultsTab != null && UIUtils.isUIThread()) {
                Object adapter;
                Object tabControl = activeResultsTab.getData();
                if (tabControl instanceof QueryResultsContainer) {
                    tabControl = ((QueryResultsContainer)tabControl).viewer;
                }
                if (tabControl instanceof IAdaptable && (adapter = ((IAdaptable)tabControl).getAdapter(required)) != null) {
                    return (T)adapter;
                }
                if (tabControl instanceof ResultSetViewer && (required == IResultSetController.class || required == ResultSetViewer.class)) {
                    return required.cast(tabControl);
                }
            }
        }
        return super.getAdapter(required);
    }

    private boolean checkConnected(boolean forceConnect, DBRProgressListener onFinish) {
        UIServiceConnections serviceConnections;
        boolean doConnect;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        boolean bl = doConnect = dataSourceContainer != null && (forceConnect || dataSourceContainer.getPreferenceStore().getBoolean("database.editor.connect.on.activate"));
        if (doConnect && !dataSourceContainer.isConnected() && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
            serviceConnections.connectDataSource(dataSourceContainer, onFinish);
        }
        return dataSourceContainer != null && dataSourceContainer.isConnected();
    }

    @Override
    public void createPartControl(Composite parent) {
        StyledText textWidget;
        SashForm editorContainer;
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.resultsSash = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)(this.resultSetOrientation.getSashOrientation() | 0x10000));
        CSSUtils.setCSSClass((Widget)this.resultsSash, (String)"coloredByConnectionType");
        this.resultsSash.setSashWidth(5);
        UIUtils.setHelp((Control)this.resultsSash, (String)"sql-editor");
        this.sqlEditorPanel = UIUtils.createPlaceholder((Composite)this.resultsSash, (int)3, (int)0);
        this.createControlsBar(this.sqlEditorPanel);
        this.sqlExtraPanelSash = new SashForm(this.sqlEditorPanel, 256);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 5;
        this.sqlExtraPanelSash.setLayoutData((Object)gd);
        Composite pPlaceholder = null;
        StackLayout presentationStackLayout = null;
        if (this.extraPresentationDescriptor != null) {
            this.presentationStack = new Composite((Composite)this.sqlExtraPanelSash, 0);
            this.presentationStack.setLayoutData((Object)new GridData(1808));
            presentationStackLayout = new StackLayout();
            this.presentationStack.setLayout((Layout)presentationStackLayout);
            editorContainer = this.presentationStack;
            pPlaceholder = new Composite(this.presentationStack, 0);
            pPlaceholder.setLayout((Layout)new FillLayout());
        } else {
            editorContainer = this.sqlExtraPanelSash;
        }
        super.createPartControl((Composite)editorContainer);
        this.getEditorControlWrapper().setLayoutData(new GridData(1808));
        this.sqlExtraPanelFolder = new CTabFolder((Composite)this.sqlExtraPanelSash, 0x8000C0);
        this.sqlExtraPanelFolder.setSelection(0);
        this.sqlExtraPanelFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = SQLEditor.this.sqlExtraPanelFolder.getSelection();
                if (item != null) {
                    IActionContributor ac = (IActionContributor)item.getData("actionContributor");
                    SQLEditor.this.updateExtraViewToolbar(ac);
                }
            }
        });
        this.sqlExtraPanelToolbar = new ToolBarManager();
        this.sqlExtraPanelToolbar.createControl((Composite)this.sqlExtraPanelFolder);
        this.sqlExtraPanelFolder.setTopRight((Control)this.sqlExtraPanelToolbar.getControl());
        this.restoreSashRatio(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        this.addSashRatioSaveListener(this.sqlExtraPanelSash, "SQLEditor.extraPanels.ratio");
        this.createPresentationSwitchBar(this.sqlEditorPanel);
        if (pPlaceholder != null) {
            switch (this.extraPresentationDescriptor.getActivationType()) {
                case HIDDEN: {
                    presentationStackLayout.topControl = this.presentationStack.getChildren()[1];
                    break;
                }
                case VISIBLE: 
                case MAXIMIZED: {
                    this.extraPresentation.createPresentation(pPlaceholder, this);
                    if (this.extraPresentationDescriptor.getActivationType() != SQLEditorPresentation.ActivationType.MAXIMIZED || this.presentationStack.getChildren()[0] == null) break;
                    presentationStackLayout.topControl = pPlaceholder;
                }
            }
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
        DBPProject project = this.getProject();
        if (project != null && project.isRegistryLoaded()) {
            this.createResultTabs();
        } else {
            UIExecutionQueue.queueExec(this::createResultTabs);
        }
        this.setAction("ShowInformation", null);
        SourceViewer viewer = this.getViewer();
        if (viewer != null && (textWidget = viewer.getTextWidget()) != null) {
            textWidget.addModifyListener(this::onTextChange);
            textWidget.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    SQLEditor.this.refreshActions();
                }
            });
        }
        SQLEditorFeatures.SQL_EDITOR_OPEN.use();
        new ServerOutputReader().schedule();
        this.updateExecutionContext(null);
        UIExecutionQueue.queueExec(this::onDataSourceChange);
    }

    private void onTextChange(ModifyEvent e) {
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnChange")) {
            this.doScriptAutoSave();
        }
    }

    private void createControlsBar(Composite sqlEditorPanel) {
        this.sideToolBar = new VerticalFolder(sqlEditorPanel, 16384);
        this.sideToolBar.setCheckCommandEnablement(true);
        ((GridLayout)this.sideToolBar.getLayout()).marginTop = 3;
        ((GridLayout)this.sideToolBar.getLayout()).marginBottom = 10;
        ((GridLayout)this.sideToolBar.getLayout()).verticalSpacing = 3;
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16392, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.run.statement", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16392, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.run.statementNew", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16392, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.run.script", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16392, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.run.scriptNew", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16392, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.run.explain", (boolean)false);
        UIUtils.createEmptyLabel((Composite)this.sideToolBar, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16416, (IAction)new SQLEditorBase.ShowPreferencesAction(this), (boolean)false);
        new Label((Composite)this.sideToolBar, 0).setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SEPARATOR_H));
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16416, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.show.output", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16416, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.show.log", (boolean)false);
        VerticalButton.create((VerticalFolder)this.sideToolBar, (int)16416, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.show.variables", (boolean)false);
        this.sideToolBar.setLayoutData((Object)new GridData(1042));
    }

    private void createPresentationSwitchBar(Composite sqlEditorPanel) {
        if (this.extraPresentationDescriptor == null) {
            return;
        }
        this.presentationSwitchFolder = new VerticalFolder(sqlEditorPanel, 131072);
        this.presentationSwitchFolder.setLayoutData((Object)new GridData(1040));
        this.switchPresentationSQLButton = new VerticalButton(this.presentationSwitchFolder, 131104);
        this.switchPresentationSQLButton.setText(SQLEditorMessages.editors_sql_description);
        this.switchPresentationSQLButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT));
        this.switchPresentationExtraButton = new VerticalButton(this.presentationSwitchFolder, 131104);
        this.switchPresentationExtraButton.setData((Object)this.extraPresentationDescriptor);
        this.switchPresentationExtraButton.setText(this.extraPresentationDescriptor.getLabel());
        this.switchPresentationExtraButton.setImage(DBeaverIcons.getImage((DBPImage)this.extraPresentationDescriptor.getIcon()));
        String toolTip = ActionUtils.findCommandDescription((String)this.extraPresentationDescriptor.getToggleCommandId(), (IServiceLocator)this.getSite(), (boolean)false);
        if (CommonUtils.isEmpty((String)toolTip)) {
            toolTip = this.extraPresentationDescriptor.getDescription();
        }
        if (!CommonUtils.isEmpty((String)toolTip)) {
            this.switchPresentationExtraButton.setToolTipText(toolTip);
        }
        this.switchPresentationSQLButton.setChecked(true);
        SelectionAdapter switchListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((VerticalButton)e.item).isChecked() || SQLEditor.this.presentationSwitchFolder.getSelection() == e.item) {
                    return;
                }
                String toggleCommandId = SQLEditor.this.extraPresentationDescriptor.getToggleCommandId();
                ActionUtils.runCommand((String)toggleCommandId, (IServiceLocator)SQLEditor.this.getSite());
            }
        };
        this.switchPresentationSQLButton.addSelectionListener((SelectionListener)switchListener);
        this.switchPresentationExtraButton.addSelectionListener((SelectionListener)switchListener);
        UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
        this.createToggleLayoutButton();
    }

    public boolean validateEditorInputState() {
        StyledText textWidget;
        SourceViewer viewer;
        boolean res = super.validateEditorInputState();
        if (res && (viewer = this.getViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
            textWidget.setFocus();
        }
        return res;
    }

    private void createResultTabs() {
        this.resultTabs = new CTabFolder((Composite)this.resultsSash, 0x800080);
        CSSUtils.setCSSClass((Widget)this.resultTabs, (String)"coloredByConnectionType");
        this.resultTabsReorder = new TabFolderReorder(this.resultTabs);
        this.resultTabs.setLayoutData((Object)new GridData(1808));
        this.resultTabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLQuery planQuery;
                if (SQLEditor.this.extraPresentationCurrentPanel != null) {
                    SQLEditor.this.extraPresentationCurrentPanel.deactivatePanel();
                }
                SQLEditor.this.extraPresentationCurrentPanel = null;
                Object data = e.item.getData();
                if (data instanceof QueryResultsContainer) {
                    SQLEditor.this.setActiveResultsContainer((QueryResultsContainer)data);
                } else if (data instanceof SQLEditorPresentationPanel) {
                    SQLEditor.this.extraPresentationCurrentPanel = (SQLEditorPresentationPanel)data;
                    SQLEditor.this.extraPresentationCurrentPanel.activatePanel();
                } else if (data instanceof ExplainPlanViewer && (planQuery = ((ExplainPlanViewer)((Object)data)).getQuery()) != null) {
                    SQLEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(planQuery.getOffset(), 0));
                }
            }
        });
        this.addSashRatioSaveListener((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        this.resultTabs.addListener(1001, event -> {
            CTabItem item = (CTabItem)event.item;
            if (item.getData() instanceof QueryResultsContainer) {
                ((QueryResultsContainer)item.getData()).resultsTab = item;
            }
        });
        this.restoreSashRatio((SashForm)this.resultsSash, "SQLEditor.resultSet.ratio");
        this.getTextViewer().getTextWidget().addTraverseListener(e -> {
            ResultSetViewer viewer;
            if (e.detail == 16 && e.stateMask == SWT.MOD1 && (viewer = this.getActiveResultSetViewer()) != null && viewer.getActivePresentation().getControl().isVisible()) {
                viewer.getActivePresentation().getControl().setFocus();
                e.detail = 0;
            }
        });
        this.resultTabs.setSimple(true);
        this.resultTabs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CTabItem item;
                if (e.button == 2 && (item = SQLEditor.this.resultTabs.getItem(new Point(e.x, e.y))) != null && item.getShowClose()) {
                    item.dispose();
                }
            }
        });
        this.resultTabs.addListener(8, event -> {
            if (event.button != 1) {
                return;
            }
            CTabItem selectedItem = this.resultTabs.getItem(new Point(event.getBounds().x, event.getBounds().y));
            if (selectedItem != null && selectedItem == this.resultTabs.getSelection()) {
                this.toggleEditorMaximize();
            }
        });
        this.createExtraViewControls();
        this.createQueryProcessor(true, true);
        this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
        this.resultTabs.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SQLEditor.this.activeResultsTab = SQLEditor.this.resultTabs.getItem(new Point(e.x, e.y));
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.resultTabs);
        menuMgr.addMenuListener(manager -> {
            int pinnedTabsCount = 0;
            int resultTabsCount = 0;
            CTabItem[] cTabItemArray = this.resultTabs.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (item.getData() instanceof QueryResultsContainer) {
                    ++resultTabsCount;
                    if (((QueryResultsContainer)item.getData()).isPinned()) {
                        ++pinnedTabsCount;
                    }
                }
                ++n2;
            }
            final CTabItem activeTab = this.getActiveResultsTab();
            if (activeTab != null && activeTab.getData() instanceof QueryResultsContainer) {
                QueryResultsContainer rc;
                final QueryResultsContainer resultsContainer = (QueryResultsContainer)activeTab.getData();
                if (resultsContainer.getResultSetController().hasData()) {
                    final boolean isPinned = resultsContainer.isPinned();
                    manager.add((IAction)new Action(isPinned ? SQLEditorMessages.action_result_tabs_unpin_tab : SQLEditorMessages.action_result_tabs_pin_tab){

                        public void run() {
                            resultsContainer.setPinned(!isPinned);
                            CTabItem currTabItem = activeTab;
                            if (isPinned) {
                                int i = SQLEditor.this.resultTabs.indexOf(activeTab) + 1;
                                while (i < SQLEditor.this.resultTabs.getItemCount()) {
                                    CTabItem nextTabItem = SQLEditor.this.resultTabs.getItem(i);
                                    if (!nextTabItem.getShowClose()) {
                                        SQLEditor.this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                                        currTabItem = nextTabItem;
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                int i = SQLEditor.this.resultTabs.indexOf(activeTab) - 1;
                                while (i >= 0) {
                                    CTabItem nextTabItem = SQLEditor.this.resultTabs.getItem(i);
                                    if (nextTabItem.getShowClose()) {
                                        SQLEditor.this.resultTabsReorder.swapTabs(currTabItem, nextTabItem);
                                        currTabItem = nextTabItem;
                                        --i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                    });
                }
                manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_set_name){

                    public void run() {
                        EnterNameDialog dialog = new EnterNameDialog(SQLEditor.this.resultTabs.getShell(), SQLEditorMessages.action_result_tabs_set_name_title, activeTab.getText());
                        if (dialog.open() == 0 && activeTab.getData() instanceof QueryResultsContainer) {
                            QueryResultsContainer resultsContainer = (QueryResultsContainer)activeTab.getData();
                            resultsContainer.setTabName(dialog.getResult());
                        }
                    }
                });
                if (activeTab.getData() instanceof QueryResultsContainer && (rc = (QueryResultsContainer)activeTab.getData()).hasData()) {
                    AssignVariableAction action = new AssignVariableAction(this, rc.getQuery().getText());
                    action.setEditable(false);
                    manager.add((IAction)action);
                }
            }
            if (pinnedTabsCount > 1 || resultTabsCount > 1 || activeTab != null && activeTab.getShowClose()) {
                manager.add((IContributionItem)new Separator());
                if (pinnedTabsCount > 1 && activeTab != null && !activeTab.getShowClose()) {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_unpin_all_tabs){

                        public void run() {
                            CTabItem[] cTabItemArray = SQLEditor.this.resultTabs.getItems();
                            int n = cTabItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CTabItem item = cTabItemArray[n2];
                                if (item.getData() instanceof QueryResultsContainer && ((QueryResultsContainer)item.getData()).isPinned()) {
                                    ((QueryResultsContainer)item.getData()).setPinned(false);
                                }
                                ++n2;
                            }
                        }
                    });
                }
                if (resultTabsCount - pinnedTabsCount > 1 && activeTab != null && activeTab.getShowClose() && activeTab.getData() instanceof QueryResultsContainer) {
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_all_tabs){

                        public void run() {
                            SQLEditor.this.closeExtraResultTabs(null, false, false);
                        }
                    });
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_query_tabs){

                        public void run() {
                            QueryProcessor processor = ((QueryResultsContainer)activeTab.getData()).queryProcessor;
                            ArrayList<CTabItem> tabsToRemove = new ArrayList<CTabItem>();
                            for (QueryResultsContainer container : processor.getResultContainers()) {
                                CTabItem tab = container.getTabItem();
                                if (!tab.getShowClose() || container.queryProcessor != processor) continue;
                                tabsToRemove.add(tab);
                            }
                            for (CTabItem tab : tabsToRemove) {
                                tab.dispose();
                            }
                        }
                    });
                    manager.add((IAction)new Action(SQLEditorMessages.action_result_tabs_close_other_tabs){

                        public void run() {
                            ArrayList<CTabItem> tabsToRemove = new ArrayList<CTabItem>();
                            CTabItem[] cTabItemArray = SQLEditor.this.resultTabs.getItems();
                            int n = cTabItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CTabItem tab = cTabItemArray[n2];
                                if (tab.getShowClose() && tab != activeTab) {
                                    tabsToRemove.add(tab);
                                }
                                ++n2;
                            }
                            for (CTabItem tab : tabsToRemove) {
                                tab.dispose();
                            }
                            SQLEditor.this.setActiveResultsContainer((QueryResultsContainer)activeTab.getData());
                        }
                    });
                }
                if (activeTab != null && activeTab.getShowClose()) {
                    manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.close.tab"));
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.maximize.result.panel"));
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.resultTabs.setMenu(menu);
    }

    private void addSashRatioSaveListener(SashForm sash, String prefId) {
        Control control = sash.getChildren()[0];
        control.addListener(11, event -> {
            if (!control.isDisposed()) {
                int[] weights = sash.getWeights();
                IPreferenceStore prefs = this.getPreferenceStore();
                if (prefs != null && weights.length == 2) {
                    prefs.setValue(prefId, String.valueOf(weights[0]) + "-" + weights[1]);
                }
            }
        });
    }

    private void restoreSashRatio(SashForm sash, String prefId) {
        String[] weightsStr;
        String resultsPanelRatio = this.getPreferenceStore().getString(prefId);
        if (!CommonUtils.isEmpty((String)resultsPanelRatio) && (weightsStr = resultsPanelRatio.split("-")).length > 1) {
            int[] weights = new int[]{CommonUtils.toInt((Object)weightsStr[0]), CommonUtils.toInt((Object)weightsStr[1])};
            if (weights[1] < weights[0] / 15 || weights[0] < weights[1] / 15) {
                log.debug((Object)"Restore default sash weights");
            } else {
                sash.setWeights(weights);
            }
        }
    }

    private void setActiveResultsContainer(QueryResultsContainer data) {
        this.curResultsContainer = data;
        this.curQueryProcessor = this.curResultsContainer.queryProcessor;
    }

    public void toggleExtraPanelsLayout() {
        CTabItem outTab = this.getExtraViewTab(this.outputViewer.getControl());
        CTabItem logTab = this.getExtraViewTab((Control)this.logViewer);
        CTabItem varTab = this.getExtraViewTab((Control)this.variablesViewer);
        if (outTab != null) {
            outTab.dispose();
        }
        if (logTab != null) {
            logTab.dispose();
        }
        if (varTab != null) {
            varTab.dispose();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String epLocation = this.getExtraPanelsLocation();
        epLocation = "results".equals(epLocation) ? "right" : "results";
        preferenceStore.setValue("SQLEditor.extraPanels.location", epLocation);
        this.createExtraViewControls();
        if (outTab != null) {
            this.showOutputPanel();
        }
        if (logTab != null) {
            this.showExecutionLogPanel();
        }
        if (varTab != null) {
            this.showVariablesPanel();
        }
    }

    public String getExtraPanelsLocation() {
        return this.getPreferenceStore().getString("SQLEditor.extraPanels.location");
    }

    private void createExtraViewControls() {
        if (this.logViewer != null) {
            this.logViewer.dispose();
            this.logViewer = null;
        }
        if (this.variablesViewer != null) {
            this.variablesViewer.dispose();
            this.variablesViewer = null;
        }
        if (this.outputViewer != null) {
            this.outputViewer.dispose();
            this.outputViewer = null;
        }
        if (this.sqlExtraPanelFolder != null) {
            CTabItem[] cTabItemArray = this.sqlExtraPanelFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem ti = cTabItemArray[n2];
                ti.dispose();
                ++n2;
            }
        }
        CTabFolder folder = this.getFolderForExtraPanels();
        this.logViewer = new SQLLogPanel((Composite)folder, this);
        this.variablesViewer = new SQLVariablesPanel((Composite)folder, this);
        this.outputViewer = new SQLEditorOutputConsoleViewer(this.getSite(), folder, 0);
        if (this.getFolderForExtraPanels() != this.sqlExtraPanelFolder) {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
        }
    }

    private CTabFolder getFolderForExtraPanels() {
        CTabFolder folder = this.sqlExtraPanelFolder;
        String epLocation = this.getExtraPanelsLocation();
        if ("results".equals(epLocation)) {
            folder = this.resultTabs;
        }
        return folder;
    }

    private CTabItem getExtraViewTab(Control control) {
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == control) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void showExtraView(String commandId, String name, String toolTip, Image image, Control view, IActionContributor actionContributor) {
        boolean isTabsToTheRight;
        VerticalButton viewItem = this.getViewToolItem(commandId);
        if (viewItem == null) {
            log.warn((Object)("Tool item for command " + commandId + " not found"));
            return;
        }
        CTabFolder tabFolder = this.getFolderForExtraPanels();
        CTabItem curItem = this.getExtraViewTab(view);
        if (curItem != null) {
            viewItem.setChecked(false);
            viewItem.redraw();
            curItem.dispose();
            return;
        }
        boolean bl = isTabsToTheRight = tabFolder == this.sqlExtraPanelFolder;
        if (isTabsToTheRight) {
            if (this.sqlExtraPanelSash.getMaximizedControl() != null) {
                this.sqlExtraPanelSash.setMaximizedControl(null);
            }
        } else {
            this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            this.showResultsPanel(true);
        }
        if (view == this.outputViewer.getControl()) {
            this.updateOutputViewerIcon(false);
            this.outputViewer.resetNewOutput();
        }
        viewItem.setChecked(true);
        CTabItem item = new CTabItem(tabFolder, 64);
        item.setControl(view);
        item.setText(name);
        item.setToolTipText(toolTip);
        item.setImage(image);
        item.setData((Object)view);
        item.setData("actionContributor", (Object)actionContributor);
        item.addDisposeListener(e -> {
            if (!viewItem.isDisposed()) {
                viewItem.setChecked(false);
                viewItem.redraw();
            }
            if (tabFolder.getItemCount() == 0) {
                this.sqlExtraPanelSash.setMaximizedControl(this.sqlExtraPanelSash.getChildren()[0]);
            }
        });
        tabFolder.setSelection(item);
        viewItem.redraw();
        if (isTabsToTheRight) {
            this.updateExtraViewToolbar(actionContributor);
        }
    }

    private void updateExtraViewToolbar(IActionContributor actionContributor) {
        this.sqlExtraPanelToolbar.removeAll();
        if (actionContributor != null) {
            actionContributor.contributeActions((IContributionManager)this.sqlExtraPanelToolbar);
        }
        this.sqlExtraPanelToolbar.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggle.extraPanels", (int)32, (DBPImage)UIIcon.ARROW_DOWN));
        this.sqlExtraPanelToolbar.update(true);
    }

    private VerticalButton getViewToolItem(String commandId) {
        VerticalButton viewItem = null;
        VerticalButton[] verticalButtonArray = this.sideToolBar.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton item = verticalButtonArray[n2];
            if (commandId.equals(item.getCommandId())) {
                viewItem = item;
                break;
            }
            ++n2;
        }
        return viewItem;
    }

    private CTabItem getActiveResultsTab() {
        return this.activeResultsTab == null || this.activeResultsTab.isDisposed() ? (this.resultTabs == null ? null : this.resultTabs.getSelection()) : this.activeResultsTab;
    }

    public void closeActiveTab() {
        CTabItem tabItem = this.getActiveResultsTab();
        if (tabItem != null && tabItem.getShowClose()) {
            tabItem.dispose();
            this.activeResultsTab = null;
        }
    }

    public void showOutputPanel() {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.output", SQLEditorMessages.editors_sql_output, SQLEditorMessages.editors_sql_output_tip, IMG_OUTPUT, this.outputViewer.getControl(), manager -> manager.add((IAction)new OutputAutoShowToggleAction()));
    }

    public void showExecutionLogPanel() {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.log", SQLEditorMessages.editors_sql_execution_log, SQLEditorMessages.editors_sql_execution_log_tip, IMG_LOG, (Control)this.logViewer, null);
    }

    public void showVariablesPanel() {
        this.showExtraView("org.jkiss.dbeaver.ui.editors.sql.show.variables", SQLEditorMessages.editors_sql_variables, SQLEditorMessages.editors_sql_variables_tip, IMG_VARIABLES, (Control)this.variablesViewer, null);
        UIUtils.asyncExec(() -> this.variablesViewer.refreshVariables());
    }

    public <T> T getExtraPresentationPanel(Class<T> panelClass) {
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (tabItem.getData() instanceof SQLEditorPresentationPanel && tabItem.getData().getClass() == panelClass) {
                return panelClass.cast(tabItem.getData());
            }
            ++n2;
        }
        return null;
    }

    public boolean showPresentationPanel(SQLEditorPresentationPanel panel) {
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == panel) {
                this.resultTabs.setSelection(item);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public SQLEditorPresentationPanel showPresentationPanel(String panelID) {
        VerticalButton[] verticalButtonArray = this.sideToolBar.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton cItem = verticalButtonArray[n2];
            IAction action = cItem.getAction();
            if (action != null && action instanceof PresentationPanelToggleAction && ((PresentationPanelToggleAction)action).panel.getId().equals(panelID)) {
                action.run();
                return this.extraPresentationCurrentPanel;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasMaximizedControl() {
        return this.resultsSash.getMaximizedControl() != null;
    }

    public SQLEditorPresentation getExtraPresentation() {
        return this.extraPresentation;
    }

    public SQLEditorPresentation.ActivationType getExtraPresentationState() {
        if (this.extraPresentation == null || this.presentationStack == null) {
            return SQLEditorPresentation.ActivationType.HIDDEN;
        }
        Control maximizedControl = ((StackLayout)this.presentationStack.getLayout()).topControl;
        if (maximizedControl == this.getExtraPresentationControl()) {
            return SQLEditorPresentation.ActivationType.MAXIMIZED;
        }
        if (maximizedControl == this.getEditorControlWrapper()) {
            return SQLEditorPresentation.ActivationType.HIDDEN;
        }
        return SQLEditorPresentation.ActivationType.VISIBLE;
    }

    public void showExtraPresentation(boolean show, boolean maximize) {
        if (this.extraPresentationDescriptor == null || this.presentationStack == null) {
            return;
        }
        this.resultsSash.setRedraw(false);
        try {
            StackLayout stackLayout = (StackLayout)this.presentationStack.getLayout();
            if (!show) {
                stackLayout.topControl = this.presentationStack.getChildren()[1];
                this.getEditorControlWrapper().setFocus();
                this.getSite().setSelectionProvider((ISelectionProvider)new DynamicSelectionProvider());
            } else {
                if (this.extraPresentation == null) {
                    try {
                        this.extraPresentation = this.extraPresentationDescriptor.createPresentation();
                        this.extraPresentation.createPresentation((Composite)this.getExtraPresentationControl(), this);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error creating presentation", (Throwable)e);
                    }
                }
                if (maximize) {
                    stackLayout.topControl = this.getExtraPresentationControl();
                    this.getExtraPresentationControl().setFocus();
                } else {
                    stackLayout.topControl = null;
                }
            }
            boolean sideBarChanged = false;
            if (this.getExtraPresentationState() == SQLEditorPresentation.ActivationType.HIDDEN) {
                Control[] controlArray = this.presentationSwitchFolder.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control vb = controlArray[n2];
                    if (vb.getData() instanceof SQLPresentationPanelDescriptor) {
                        vb.dispose();
                        sideBarChanged = true;
                    }
                    ++n2;
                }
                controlArray = this.resultTabs.getItems();
                n = controlArray.length;
                n2 = 0;
                while (n2 < n) {
                    Control tabItem = controlArray[n2];
                    if (tabItem.getData() instanceof SQLEditorPresentationPanel) {
                        tabItem.dispose();
                    }
                    ++n2;
                }
                this.extraPresentationCurrentPanel = null;
            } else {
                UIUtils.createEmptyLabel((Composite)this.presentationSwitchFolder, (int)1, (int)1).setLayoutData((Object)new GridData(1040));
                for (SQLPresentationPanelDescriptor panelDescriptor : this.extraPresentationDescriptor.getPanels()) {
                    this.removeToggleLayoutButton();
                    sideBarChanged = true;
                    PresentationPanelToggleAction toggleAction = new PresentationPanelToggleAction(panelDescriptor);
                    VerticalButton panelButton = new VerticalButton(this.presentationSwitchFolder, 131072);
                    panelButton.setLayoutData((Object)new GridData(8));
                    panelButton.setAction((IAction)toggleAction, true);
                    panelButton.setData((Object)panelDescriptor);
                    if (panelDescriptor.isAutoActivate()) {
                        toggleAction.run();
                    }
                    this.createToggleLayoutButton();
                }
            }
            boolean isExtra = this.getExtraPresentationState() == SQLEditorPresentation.ActivationType.MAXIMIZED;
            this.switchPresentationSQLButton.setChecked(!isExtra);
            this.switchPresentationExtraButton.setChecked(isExtra);
            this.presentationSwitchFolder.redraw();
            if (sideBarChanged) {
                this.sideToolBar.getParent().layout(true, true);
            }
            this.presentationStack.layout(true, true);
        }
        finally {
            this.resultsSash.setRedraw(true);
        }
    }

    private void createToggleLayoutButton() {
        VerticalButton.create((VerticalFolder)this.presentationSwitchFolder, (int)131104, (IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.toggleLayout", (boolean)false);
    }

    private void removeToggleLayoutButton() {
        VerticalButton[] verticalButtonArray = this.presentationSwitchFolder.getItems();
        int n = verticalButtonArray.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalButton vButton = verticalButtonArray[n2];
            if (vButton.getCommandId() != null && vButton.getCommandId().equals("org.jkiss.dbeaver.ui.editors.sql.toggleLayout")) {
                vButton.dispose();
            }
            ++n2;
        }
    }

    private Control getExtraPresentationControl() {
        return this.presentationStack.getChildren()[0];
    }

    public void toggleResultPanel(boolean switchFocus, boolean createQueryProcessor) {
        UIUtils.syncExec(() -> {
            if (this.resultsSash.getMaximizedControl() == null) {
                this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
                this.switchFocus(false);
            } else {
                if (this.resultTabs.getItemCount() == 0 && createQueryProcessor) {
                    this.createQueryProcessor(true, true);
                }
                this.resultsSash.setMaximizedControl(null);
                if (switchFocus) {
                    this.switchFocus(true);
                }
            }
        });
    }

    public void toggleEditorMaximize() {
        if (this.resultsSash.getMaximizedControl() == null) {
            this.resultsSash.setMaximizedControl((Control)this.resultTabs);
            this.switchFocus(true);
        } else {
            this.resultsSash.setMaximizedControl(null);
            this.switchFocus(false);
        }
    }

    private void switchFocus(boolean results) {
        if (results) {
            ResultSetViewer activeRS = this.getActiveResultSetViewer();
            if (activeRS != null && activeRS.getActivePresentation() != null) {
                activeRS.getActivePresentation().getControl().setFocus();
            } else {
                CTabItem activeTab = this.resultTabs.getSelection();
                if (activeTab != null && activeTab.getControl() != null) {
                    activeTab.getControl().setFocus();
                }
            }
        } else {
            this.getEditorControlWrapper().setFocus();
        }
    }

    public void toggleActivePanel() {
        if (this.resultsSash.getMaximizedControl() == null) {
            if (UIUtils.hasFocus((Control)this.resultTabs)) {
                this.switchFocus(false);
            } else {
                this.switchFocus(true);
            }
        }
    }

    private void updateResultSetOrientation() {
        try {
            this.resultSetOrientation = ResultSetOrientation.valueOf(DBWorkbench.getPlatform().getPreferenceStore().getString("SQLEditor.resultSet.orientation"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resultSetOrientation = ResultSetOrientation.HORIZONTAL;
        }
        if (this.resultsSash != null) {
            this.resultsSash.setOrientation(this.resultSetOrientation.getSashOrientation());
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.updateResultSetOrientation();
        this.globalScriptContext = new SQLScriptContext(null, (DBPContextProvider)this, EditorUtils.getLocalFileFromInput((Object)this.getEditorInput()), (Writer)new OutputLogWriter(), (SQLParametersProvider)new SQLEditorParametersProvider(this.getSite()));
        this.globalScriptContext.addListener(new DBCScriptContextListener(){

            public void variableChanged(DBCScriptContextListener.ContextAction action, DBCScriptContext.VariableInfo variable) {
                this.saveContextVariables();
            }

            public void parameterChanged(DBCScriptContextListener.ContextAction action, String name, Object value) {
                this.saveContextVariables();
            }

            private void saveContextVariables() {
                new AbstractJob("Save variables"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        DBPDataSourceContainer ds = SQLEditor.this.getDataSourceContainer();
                        if (ds != null) {
                            SQLEditor.this.globalScriptContext.saveVariables(ds.getDriver(), null);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule(200L);
            }
        });
    }

    @Override
    protected void doSetInput(IEditorInput editorInput) {
        try {
            IFile file;
            if (editorInput instanceof IFileEditorInput && !(file = ((IFileEditorInput)editorInput).getFile()).exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error checking SQL file", (Throwable)e);
        }
        try {
            super.doSetInput(editorInput);
        }
        catch (Throwable e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)out, true));
            editorInput = new StringEditorInput("Error", (CharSequence)CommonUtils.truncateString((String)out.toString(), (int)10000), true, GeneralUtils.UTF8_ENCODING);
            this.doSetInput(editorInput);
            log.error((Object)"Error loading input SQL file", e);
        }
        this.syntaxLoaded = false;
        Runnable inputinitializer = () -> {
            DBPDataSourceContainer newDataSource;
            DBPDataSourceContainer oldDataSource = this.getDataSourceContainer();
            if (oldDataSource != (newDataSource = EditorUtils.getInputDataSource((IEditorInput)this.getEditorInput()))) {
                this.dataSourceContainer = null;
                this.updateDataSourceContainer();
            } else {
                this.reloadSyntaxRules();
            }
        };
        if (this.isNonPersistentEditor()) {
            inputinitializer.run();
        } else {
            UIExecutionQueue.queueExec((Runnable)inputinitializer);
        }
        this.setPartName(this.getEditorName());
        if (this.isNonPersistentEditor()) {
            this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONSOLE));
        }
        this.editorImage = this.getTitleImage();
    }

    public String getTitleToolTip() {
        String scriptPath;
        if (!DBWorkbench.getPlatform().getApplication().isStandalone()) {
            return this.getTitle();
        }
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        if (dataSourceContainer == null) {
            return super.getTitleToolTip();
        }
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            scriptPath = ((IFileEditorInput)editorInput).getFile().getFullPath().toString();
        } else if (editorInput instanceof IPathEditorInput) {
            scriptPath = ((IPathEditorInput)editorInput).getPath().toString();
        } else if (editorInput instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)editorInput).getURI();
            scriptPath = "file".equals(uri.getScheme()) ? new File(uri).getAbsolutePath() : uri.toString();
        } else if (editorInput instanceof INonPersistentEditorInput) {
            scriptPath = "SQL Console";
        } else {
            scriptPath = editorInput.getName();
            if (CommonUtils.isEmpty((String)scriptPath)) {
                scriptPath = "<not a file>";
            }
        }
        StringBuilder tip = new StringBuilder();
        tip.append("Script: ").append(scriptPath).append(" \nConnection: ").append(dataSourceContainer.getName()).append(" \nType: ").append(dataSourceContainer.getDriver().getFullName()).append(" \nURL: ").append(dataSourceContainer.getConnectionConfiguration().getUrl());
        Map<String, Object> vars = this.getScriptVariables(null, scriptPath);
        if (vars.get(VAR_ACTIVE_DATABASE) != null) {
            tip.append(" \nDatabase: ").append(vars.get(VAR_ACTIVE_DATABASE));
        }
        if (vars.get(VAR_ACTIVE_SCHEMA) != null) {
            tip.append(" \nSchema: ").append(vars.get(VAR_ACTIVE_SCHEMA));
        }
        return tip.toString();
    }

    private String getEditorName() {
        File localFile;
        IFile file = EditorUtils.getFileFromInput((IEditorInput)this.getEditorInput());
        String scriptName = file != null ? file.getFullPath().removeFileExtension().lastSegment() : ((localFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput())) != null ? localFile.getName() : this.getEditorInput().getName());
        Map<String, Object> vars = this.getScriptVariables(file, scriptName);
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        String pattern = preferenceStore.getString("script.title.pattern");
        return GeneralUtils.replaceVariables((String)pattern, (IVariableResolver)new GeneralUtils.MapResolver(vars));
    }

    @NotNull
    private Map<String, Object> getScriptVariables(IFile file, String scriptName) {
        DBCExecutionContextDefaults contextDefaults;
        DBPDataSourceContainer dataSourceContainer = this.getDataSourceContainer();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put(VAR_CONNECTION_NAME, dataSourceContainer == null ? "none" : dataSourceContainer.getName());
        vars.put(VAR_FILE_NAME, scriptName);
        vars.put(VAR_FILE_EXT, file == null ? "" : file.getFullPath().getFileExtension());
        vars.put(VAR_DRIVER_NAME, dataSourceContainer == null ? "?" : dataSourceContainer.getDriver().getFullName());
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null && (contextDefaults = executionContext.getContextDefaults()) != null) {
            vars.put(VAR_ACTIVE_DATABASE, contextDefaults.getDefaultCatalog());
            vars.put(VAR_ACTIVE_SCHEMA, contextDefaults.getDefaultSchema());
        }
        return vars;
    }

    public void setFocus() {
        super.setFocus();
    }

    public void loadQueryPlan() {
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        ExplainPlanViewer planView = this.getPlanView(null, planner);
        if (planView != null && !planView.loadQueryPlan(planner, planView)) {
            this.closeActiveTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explainQueryPlan() {
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryPlanExplain();
            }
        }
        SQLScriptElement scriptElement = this.extractActiveQuery();
        if (scriptElement == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
            return;
        }
        if (!(scriptElement instanceof SQLQuery)) {
            this.setStatus("Can't explain plan for command", DBPMessageType.ERROR);
            return;
        }
        this.explainQueryPlan((SQLQuery)scriptElement);
    }

    private void explainQueryPlan(SQLQuery sqlQuery) {
        this.showResultsPanel(false);
        DBCQueryPlanner planner = (DBCQueryPlanner)GeneralUtils.adapt((Object)this.getDataSource(), DBCQueryPlanner.class);
        DBCPlanStyle planStyle = planner.getPlanStyle();
        if (planStyle == DBCPlanStyle.QUERY) {
            this.explainPlanFromQuery(planner, sqlQuery);
        } else if (planStyle == DBCPlanStyle.OUTPUT) {
            this.explainPlanFromQuery(planner, sqlQuery);
            this.showOutputPanel();
        } else {
            ExplainPlanViewer planView = this.getPlanView(sqlQuery, planner);
            if (planView != null) {
                planView.explainQueryPlan(sqlQuery, planner);
            }
        }
    }

    private void showResultsPanel(boolean createQueryProcessor) {
        if (this.resultsSash.getMaximizedControl() != null) {
            this.toggleResultPanel(false, createQueryProcessor);
        }
        UIUtils.syncExec(() -> {
            if (this.resultsSash.isDownHidden()) {
                this.resultsSash.showDown();
            }
        });
    }

    private ExplainPlanViewer getPlanView(SQLQuery sqlQuery, DBCQueryPlanner planner) {
        int n;
        if (planner == null) {
            DBWorkbench.getPlatformUI().showError("Execution plan", "Execution plan explain isn't supported by current datasource");
            return null;
        }
        if (sqlQuery != null && !this.transformQueryWithParameters(sqlQuery)) {
            return null;
        }
        ExplainPlanViewer planView = null;
        if (sqlQuery != null) {
            CTabItem[] cTabItemArray = this.resultTabs.getItems();
            n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExplainPlanViewer pv;
                CTabItem item = cTabItemArray[n2];
                if (item.getData() instanceof ExplainPlanViewer && (pv = (ExplainPlanViewer)((Object)item.getData())).getQuery() != null && pv.getQuery().equals((Object)sqlQuery)) {
                    this.resultTabs.setSelection(item);
                    planView = pv;
                    break;
                }
                ++n2;
            }
        }
        if (planView == null) {
            int maxPlanNumber = 0;
            CTabItem[] cTabItemArray = this.resultTabs.getItems();
            int n3 = cTabItemArray.length;
            n = 0;
            while (n < n3) {
                CTabItem item = cTabItemArray[n];
                if (item.getData() instanceof ExplainPlanViewer) {
                    maxPlanNumber = Math.max(maxPlanNumber, ((ExplainPlanViewer)((Object)item.getData())).getPlanNumber());
                }
                ++n;
            }
            planView = new ExplainPlanViewer((IWorkbenchPart)this, this, (Composite)this.resultTabs, ++maxPlanNumber);
            CTabItem item = new CTabItem(this.resultTabs, 64);
            item.setControl(planView.getControl());
            item.setText(String.valueOf(SQLEditorMessages.editors_sql_error_execution_plan_title) + " - " + maxPlanNumber);
            if (sqlQuery != null) {
                item.setToolTipText(sqlQuery.getText());
            }
            item.setImage(IMG_EXPLAIN_PLAN);
            item.setData((Object)planView);
            item.addDisposeListener(this.resultTabDisposeListener);
            UIUtils.disposeControlOnItemDispose((CTabItem)item);
            this.resultTabs.setSelection(item);
        }
        return planView;
    }

    private void explainPlanFromQuery(DBCQueryPlanner planner, SQLQuery sqlQuery) {
        String[] planQueryString = new String[1];
        DBRRunnableWithProgress queryObtainTask = monitor -> {
            DBCQueryPlannerConfiguration configuration = ExplainPlanViewer.makeExplainPlanConfiguration(monitor, planner);
            if (configuration == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Prepare plan query");){
                    DBCPlan plan = planner.planQueryExecution(session, sqlQuery.getText(), configuration);
                    stringArray[0] = plan.getPlanQueryString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        };
        if (RuntimeUtils.runTask((DBRRunnableWithProgress)queryObtainTask, (String)"Retrieve plan query", (long)5000L) && !CommonUtils.isEmpty((String)planQueryString[0])) {
            SQLQuery planQuery = new SQLQuery(this.getDataSource(), planQueryString[0]);
            this.processQueries(Collections.singletonList(planQuery), false, true, false, true, null, null);
        }
    }

    public void processSQL(boolean newTab, boolean script) {
        this.processSQL(newTab, script, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSQL(boolean newTab, boolean script, SQLQueryTransformer transformer, @Nullable SQLQueryListener queryListener) {
        List<SQLScriptElement> elements;
        IDocument document = this.getDocument();
        if (document == null) {
            this.setStatus(SQLEditorMessages.editors_sql_status_cant_obtain_document, DBPMessageType.ERROR);
            return false;
        }
        List<SQLEditorListener> list = this.listeners;
        synchronized (list) {
            for (SQLEditorListener listener : this.listeners) {
                listener.beforeQueryExecute(script, newTab);
            }
        }
        if (script) {
            ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
            elements = selection.getLength() > 1 ? this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true) : this.extractScriptQueries(0, document.getLength(), true, false, true);
        } else {
            SQLScriptElement sqlQuery = this.extractActiveQuery();
            if (sqlQuery == null) {
                ResultSetViewer activeViewer = this.getActiveResultSetViewer();
                if (activeViewer != null) {
                    activeViewer.setStatus(SQLEditorMessages.editors_sql_status_empty_query_string, DBPMessageType.ERROR);
                }
                return false;
            }
            elements = Collections.singletonList(sqlQuery);
        }
        try {
            DBPDataSource dataSource;
            if (transformer != null && (dataSource = this.getDataSource()) != null) {
                ArrayList<SQLScriptElement> xQueries = new ArrayList<SQLScriptElement>(elements.size());
                for (SQLScriptElement element : elements) {
                    if (element instanceof SQLQuery) {
                        SQLQuery query = transformer.transformQuery(dataSource, this.getSyntaxManager(), (SQLQuery)element);
                        if (!CommonUtils.isEmpty((Collection)query.getParameters())) {
                            query.setParameters(this.parseQueryParameters(query));
                        }
                        xQueries.add((SQLScriptElement)query);
                        continue;
                    }
                    xQueries.add(element);
                }
                elements = xQueries;
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Bad query", "Can't execute query", (Throwable)e);
            return false;
        }
        if (!CommonUtils.isEmpty(elements)) {
            return this.processQueries(elements, script, newTab, false, true, queryListener, null);
        }
        return false;
    }

    public void exportDataFromQuery(@Nullable SQLScriptContext sqlScriptContext) {
        List<Object> elements;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (selection.getLength() > 1) {
            elements = this.extractScriptQueries(selection.getOffset(), selection.getLength(), true, false, true);
        } else {
            elements = new ArrayList<SQLScriptElement>();
            elements.add(this.extractActiveQuery());
        }
        if (!elements.isEmpty()) {
            this.processQueries(elements, false, false, true, true, null, sqlScriptContext);
        } else {
            DBWorkbench.getPlatformUI().showError("Extract data", "Choose one or more queries to export from");
        }
    }

    private boolean processQueries(@NotNull List<SQLScriptElement> queries, boolean forceScript, boolean newTab, boolean export, boolean checkSession, @Nullable SQLQueryListener queryListener, @Nullable SQLScriptContext context) {
        boolean isSingleQuery;
        if (queries.isEmpty()) {
            return false;
        }
        DBPDataSourceContainer container = this.getDataSourceContainer();
        if (checkSession) {
            try {
                boolean finalNewTab = newTab;
                DBRProgressListener connectListener = status -> {
                    if (!status.isOK() || container == null || !container.isConnected()) {
                        DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, null, status);
                        return;
                    }
                    this.updateExecutionContext(() -> UIUtils.syncExec(() -> {
                        boolean bl4 = this.processQueries(queries, forceScript, finalNewTab, export, false, queryListener, context);
                    }));
                };
                if (!this.checkSession(connectListener)) {
                    return false;
                }
            }
            catch (DBException ex) {
                ResultSetViewer viewer = this.getActiveResultSetViewer();
                if (viewer != null) {
                    viewer.setStatus(ex.getMessage(), DBPMessageType.ERROR);
                }
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_obtain_session, ex.getMessage());
                return false;
            }
        }
        if (this.dataSourceContainer == null) {
            return false;
        }
        if (!this.dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EXECUTE_SCRIPTS)) {
            DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, "Query execution was restricted by connection configuration");
            return false;
        }
        SQLScriptContext scriptContext = context;
        if (scriptContext == null) {
            scriptContext = this.createScriptContext();
        }
        boolean bl = isSingleQuery = !forceScript && queries.size() == 1;
        if (isSingleQuery && queries.get(0) instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)queries.get(0);
            if (query.isDeleteUpdateDangerous()) {
                String targetName = "multiple tables";
                if (query.getSingleSource() != null) {
                    targetName = query.getSingleSource().getEntityName();
                }
                if (ConfirmationDialog.showConfirmDialogEx((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages"), (Shell)this.getSite().getShell(), (String)"dangerous_sql", (int)5, (int)4, (Object[])new Object[]{query.getType().name(), targetName}) != 0) {
                    return false;
                }
            }
        } else if (newTab && queries.size() > 1 && ConfirmationDialog.showConfirmDialogEx((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages"), (Shell)this.getSite().getShell(), (String)"mass_parallel_sql", (int)5, (int)4, (Object[])new Object[]{queries.size()}) != 0) {
            return false;
        }
        if (this.resultsSash.getMaximizedControl() != null) {
            this.resultsSash.setMaximizedControl(null);
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnExecute") && this.isDirty()) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.clearOutputBeforeExecute")) {
            this.outputViewer.clearOutput();
        }
        if (!export) {
            CTabItem selectedTab;
            CTabItem tabItem;
            if (!newTab && !isSingleQuery) {
                int tabsClosed = this.closeExtraResultTabs(null, true, false);
                if (tabsClosed == 1) {
                    return false;
                }
                if (tabsClosed == 3) {
                    newTab = true;
                }
            }
            if (newTab || this.queryProcessors.isEmpty() || this.curQueryProcessor.hasPinnedTabs() || this.curQueryProcessor.getRunningJobs() > 0) {
                boolean foundSuitableTab = false;
                if (!newTab && isSingleQuery) {
                    for (QueryProcessor processor : this.queryProcessors) {
                        if (processor.hasPinnedTabs() || processor.getRunningJobs() != 0) continue;
                        foundSuitableTab = true;
                        this.curQueryProcessor = processor;
                        break;
                    }
                }
                if (!foundSuitableTab) {
                    this.createQueryProcessor(true, false);
                }
            }
            if (!newTab && isSingleQuery && this.curQueryProcessor.getResultContainers().size() > 1) {
                this.closeExtraResultTabs(this.curQueryProcessor, false, true);
            }
            if ((tabItem = this.curQueryProcessor.getFirstResults().getTabItem()) != null && ((selectedTab = this.resultTabs.getSelection()) == null || selectedTab.getData() != this.outputViewer.getControl())) {
                this.resultTabs.setSelection(tabItem);
            }
        }
        if (this.curQueryProcessor == null) {
            this.createQueryProcessor(true, true);
        }
        return this.curQueryProcessor.processQueries(scriptContext, queries, forceScript, false, export, !export && this.getActivePreferenceStore().getBoolean("SQLEditor.resultSet.closeOnError"), queryListener);
    }

    @NotNull
    private SQLScriptContext createScriptContext() {
        File localFile = EditorUtils.getLocalFileFromInput((Object)this.getEditorInput());
        return new SQLScriptContext(this.globalScriptContext, (DBPContextProvider)this, localFile, (Writer)new OutputLogWriter(), (SQLParametersProvider)new SQLEditorParametersProvider(this.getSite()));
    }

    private void setStatus(String status, DBPMessageType messageType) {
        ResultSetViewer resultsView = this.getActiveResultSetViewer();
        if (resultsView != null) {
            resultsView.setStatus(status, messageType);
        }
    }

    private int closeExtraResultTabs(@Nullable QueryProcessor queryProcessor, boolean confirmClose, boolean keepFirstTab) {
        ArrayList<CTabItem> tabsToClose = new ArrayList<CTabItem>();
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() instanceof QueryResultsContainer && item.getShowClose()) {
                QueryResultsContainer resultsProvider = (QueryResultsContainer)item.getData();
                if (!(queryProcessor != null && queryProcessor != resultsProvider.queryProcessor || queryProcessor != null && queryProcessor.resultContainers.size() < 2 && keepFirstTab)) {
                    tabsToClose.add(item);
                }
            } else if (item.getData() instanceof ExplainPlanViewer) {
                tabsToClose.add(item);
            }
            ++n2;
        }
        if (tabsToClose.size() > 1 || tabsToClose.size() == 1 && keepFirstTab) {
            int confirmResult = 2;
            if (confirmClose && ((confirmResult = ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages"), (Shell)this.getSite().getShell(), (String)"close_result_tabs", (int)6, (Object[])new Object[]{tabsToClose.size()})) == 1 || confirmResult < 0)) {
                return 1;
            }
            if (confirmResult == 2) {
                int i = 0;
                while (i < tabsToClose.size()) {
                    if (i != 0 || !keepFirstTab) {
                        ((CTabItem)tabsToClose.get(i)).dispose();
                    }
                    ++i;
                }
            }
            return confirmResult;
        }
        return 9;
    }

    public boolean transformQueryWithParameters(SQLQuery query) {
        return this.createScriptContext().fillQueryParameters(query, false);
    }

    private boolean checkSession(DBRProgressListener onFinish) throws DBException {
        DBPDataSourceContainer ds = this.getDataSourceContainer();
        if (ds == null) {
            throw new DBException("No active connection");
        }
        if (!ds.isConnected()) {
            boolean doConnect = ds.getPreferenceStore().getBoolean("database.editor.connect.on.execute");
            if (doConnect) {
                return this.checkConnected(true, onFinish);
            }
            throw new DBException("Disconnected from database");
        }
        DBPDataSource dataSource = ds.getDataSource();
        if (dataSource != null && SQLEditorUtils.isOpenSeparateConnection(ds) && this.executionContext == null) {
            this.initSeparateConnection(dataSource, () -> onFinish.onTaskFinished(Status.OK_STATUS));
            return this.executionContext != null;
        }
        return true;
    }

    private void fireDataSourceChange() {
        this.updateExecutionContext(null);
        UIUtils.syncExec(this::onDataSourceChange);
    }

    private void onDataSourceChange() {
        DBPDataSourceContainer dataSourceContainer;
        ResultSetViewer rsv;
        DBCExecutionContext executionContext;
        if (this.resultsSash == null || this.resultsSash.isDisposed()) {
            this.reloadSyntaxRules();
            return;
        }
        DatabaseEditorUtils.setPartBackground((IEditorPart)this, (Composite)this.resultTabs);
        if (this.getSourceViewerConfiguration() instanceof SQLEditorSourceViewerConfiguration) {
            ((SQLEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).onDataSourceChange();
        }
        if ((executionContext = this.getExecutionContext()) != null) {
            EditorUtils.setInputDataSource((IEditorInput)this.getEditorInput(), (DatabaseEditorContext)new SQLNavigatorContext(executionContext));
        }
        this.refreshActions();
        if (this.syntaxLoaded && this.lastExecutionContext == executionContext) {
            return;
        }
        if (this.curResultsContainer != null && (rsv = this.curResultsContainer.getResultSetController()) != null) {
            if (executionContext == null) {
                rsv.setStatus(ModelMessages.error_not_connected_to_database);
            } else {
                rsv.setStatus(String.valueOf(SQLEditorMessages.editors_sql_staus_connected_to) + executionContext.getDataSource().getContainer().getName() + "'");
            }
        }
        if (this.lastExecutionContext == null || executionContext == null || this.lastExecutionContext.getDataSource() != executionContext.getDataSource()) {
            SQLEditorPropertyTester.firePropertyChange("canExecute");
            SQLEditorPropertyTester.firePropertyChange("canExplain");
            this.reloadSyntaxRules();
        }
        if ((dataSourceContainer = this.getDataSourceContainer()) == null) {
            this.resultsSash.setMaximizedControl((Control)this.sqlEditorPanel);
        } else if (this.curQueryProcessor != null && this.curQueryProcessor.getFirstResults().hasData()) {
            this.resultsSash.setMaximizedControl(null);
        }
        this.lastExecutionContext = executionContext;
        this.syntaxLoaded = true;
        this.loadActivePreferenceSettings();
        if (dataSourceContainer != null) {
            this.globalScriptContext.loadVariables(dataSourceContainer.getDriver(), null);
        } else {
            this.globalScriptContext.clearVariables();
        }
        this.setPartName(this.getEditorName());
    }

    public void beforeConnect() {
    }

    public void beforeDisconnect() {
        this.closeAllJobs();
    }

    @Override
    public void dispose() {
        if (this.extraPresentation != null) {
            this.extraPresentation.dispose();
            this.extraPresentation = null;
        }
        this.releaseContainer();
        this.closeAllJobs();
        IEditorInput editorInput = this.getEditorInput();
        IFile sqlFile = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        this.logViewer = null;
        this.outputViewer = null;
        this.queryProcessors.clear();
        this.curResultsContainer = null;
        this.curQueryProcessor = null;
        super.dispose();
        if (sqlFile != null && !PlatformUI.getWorkbench().isClosing()) {
            this.deleteFileIfEmpty(sqlFile);
        }
    }

    private void deleteFileIfEmpty(IFile sqlFile) {
        if (sqlFile == null || !sqlFile.exists()) {
            return;
        }
        SQLPreferenceConstants.EmptyScriptCloseBehavior emptyScriptCloseBehavior = SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(this.getActivePreferenceStore().getString("script.delete.empty"));
        if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.NOTHING) {
            return;
        }
        File osFile = sqlFile.getLocation().toFile();
        if (!osFile.exists() || osFile.length() != 0L) {
            return;
        }
        try {
            Object[] fileHistory;
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (emptyScriptCloseBehavior == SQLPreferenceConstants.EmptyScriptCloseBehavior.DELETE_NEW && !ArrayUtils.isEmpty((Object[])(fileHistory = sqlFile.getHistory((IProgressMonitor)monitor)))) {
                Object[] objectArray = fileHistory;
                int n = fileHistory.length;
                int n2 = 0;
                while (n2 < n) {
                    Object historyItem = objectArray[n2];
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (InputStream contents = historyItem.getContents();){
                        int cValue = contents.read();
                        if (cValue != -1) {
                            return;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ++n2;
                }
            }
            log.debug((Object)("Delete empty SQL script '" + sqlFile.getFullPath().toOSString() + "'"));
            sqlFile.delete(true, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            log.error((Object)"Can't delete empty script file", (Throwable)e);
        }
    }

    private void closeAllJobs() {
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.closeJob();
        }
    }

    private int getTotalQueryRunning() {
        int jobsRunning = 0;
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            jobsRunning += queryProcessor.curJobRunning.get();
        }
        return jobsRunning;
    }

    public void handleDataSourceEvent(DBPEvent event) {
        boolean objectEvent;
        boolean dsEvent = event.getObject() == this.getDataSourceContainer();
        boolean bl = objectEvent = event.getObject().getDataSource() == this.getDataSource();
        if (dsEvent || objectEvent) {
            UIUtils.asyncExec(() -> {
                switch (event.getAction()) {
                    case OBJECT_REMOVE: {
                        if (!dsEvent) break;
                        this.setDataSourceContainer(null);
                        break;
                    }
                    case OBJECT_UPDATE: 
                    case OBJECT_SELECT: {
                        if (!objectEvent) break;
                        this.setPartName(this.getEditorName());
                        this.firePropertyChange(1);
                        break;
                    }
                }
                this.updateExecutionContext(null);
                this.onDataSourceChange();
            });
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (!EditorUtils.isInAutoSaveJob()) {
            monitor.beginTask("Save data changes...", 1);
            try {
                monitor.subTask("Save '" + this.getPartName() + "' changes...");
                SaveJob saveJob = new SaveJob();
                saveJob.schedule();
                UIUtils.waitJobCompletion((AbstractJob)saveJob);
                if (!saveJob.success.booleanValue()) {
                    monitor.setCanceled(true);
                    return;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (this.extraPresentation instanceof ISaveablePart) {
            ((ISaveablePart)this.extraPresentation).doSave(monitor);
        }
        super.doSave(monitor);
        this.updateDataSourceContainer();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.saveToExternalFile();
    }

    private synchronized void doScriptAutoSave() {
        if (this.scriptAutoSavejob == null) {
            this.scriptAutoSavejob = new ScriptAutoSaveJob();
        } else {
            this.scriptAutoSavejob.cancel();
        }
        this.scriptAutoSavejob.schedule(1000L);
    }

    public int promptToSaveOnClose() {
        UIServiceConnections serviceConnections;
        int jobsRunning = this.getTotalQueryRunning();
        if (jobsRunning > 0) {
            log.warn((Object)("There are " + jobsRunning + " SQL job(s) still running in the editor"));
            if (ConfirmationDialog.showConfirmDialog((ResourceBundle)ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages"), null, (String)"close_running_query", (int)3, (Object[])new Object[]{jobsRunning}) != 2) {
                return 2;
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return rsv.promptToSaveOnClose();
            }
        }
        for (QueryProcessor queryProcessor : this.queryProcessors) {
            queryProcessor.cancelJob();
            queryProcessor.curJobRunning.set(0);
        }
        if (this.executionContext != null && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null && !serviceConnections.checkAndCloseActiveTransaction(new DBCExecutionContext[]{this.executionContext})) {
            return 2;
        }
        if (this.isNonPersistentEditor()) {
            return 1;
        }
        this.updateDirtyFlag();
        if (this.getActivePreferenceStore().getBoolean("SQLEditor.autoSaveOnClose")) {
            return 0;
        }
        if (super.isDirty() || this.extraPresentation instanceof ISaveablePart && ((ISaveablePart)this.extraPresentation).isDirty()) {
            return 3;
        }
        return 0;
    }

    protected void afterSaveToFile(File saveFile) {
        try {
            IFileStore fileStore = EFS.getStore((URI)saveFile.toURI());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            EditorUtils.setInputDataSource((IEditorInput)input, (DatabaseEditorContext)new SQLNavigatorContext(this.getDataSourceContainer(), this.getExecutionContext()));
            this.setInput((IEditorInput)input);
        }
        catch (CoreException e) {
            DBWorkbench.getPlatformUI().showError("File save", "Can't open SQL editor from external file", (Throwable)e);
        }
    }

    @Nullable
    private ResultSetViewer getActiveResultSetViewer() {
        if (this.curResultsContainer != null) {
            return this.curResultsContainer.getResultSetController();
        }
        return null;
    }

    private void showScriptPositionRuler(boolean show) {
        IColumnSupport columnSupport = this.getAdapter(IColumnSupport.class);
        if (columnSupport != null) {
            RulerColumnDescriptor positionColumn = RulerColumnRegistry.getDefault().getColumnDescriptor("org.jkiss.dbeaver.ui.editors.columns.script.position");
            columnSupport.setColumnVisible(positionColumn, show);
        }
    }

    private void showStatementInEditor(SQLQuery query, boolean select) {
        UIUtils.runUIJob((String)"Select SQL query in editor", monitor -> {
            if (this.isDisposed()) {
                return;
            }
            if (select) {
                this.selectAndReveal(query.getOffset(), query.getLength());
                this.setStatus(query.getText(), DBPMessageType.INFORMATION);
            } else {
                this.getSourceViewer().revealRange(query.getOffset(), query.getLength());
            }
        });
    }

    @Override
    public void reloadSyntaxRules() {
        super.reloadSyntaxRules();
        if (this.outputViewer != null) {
            this.outputViewer.refreshStyles();
        }
    }

    private QueryProcessor createQueryProcessor(boolean setSelection, boolean makeDefault) {
        CTabItem tabItem;
        QueryProcessor queryProcessor;
        this.curQueryProcessor = queryProcessor = new QueryProcessor(makeDefault);
        this.curResultsContainer = queryProcessor.getFirstResults();
        if (setSelection && (tabItem = this.curResultsContainer.getTabItem()) != null) {
            this.resultTabs.setSelection(tabItem);
        }
        return queryProcessor;
    }

    @Override
    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        switch (event.getProperty()) {
            case "sql.parameter.prefix": 
            case "sql.variables.enabled": 
            case "script.sql.ignoreNativeDelimiter": 
            case "sql.command.prefix": 
            case "sql.parameter.anonymous.enabled": 
            case "sql.parameter.enabled": 
            case "script.sql.delimiter.blank": 
            case "script.sql.delimiter": 
            case "sql.parameter.mark": {
                this.reloadSyntaxRules();
                return;
            }
            case "SQLEditor.resultSet.orientation": {
                this.updateResultSetOrientation();
                return;
            }
            case "database.editor.separate.connection": {
                DBPDataSource dataSource = this.curDataSource;
                this.releaseExecutionContext();
                this.curDataSource = dataSource;
                if (dataSource != null && SQLEditorUtils.isOpenSeparateConnection(dataSource.getContainer())) {
                    this.initSeparateConnection(dataSource, null);
                }
                return;
            }
            case "script.title.pattern": {
                this.setPartName(this.getEditorName());
                return;
            }
        }
        super.preferenceChange(event);
    }

    private int getMaxResultsTabIndex() {
        int maxIndex = 0;
        CTabItem[] cTabItemArray = this.resultTabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tab = cTabItemArray[n2];
            if (tab.getData() instanceof QueryResultsContainer) {
                maxIndex = Math.max(maxIndex, ((QueryResultsContainer)tab.getData()).getResultSetIndex());
            }
            ++n2;
        }
        return maxIndex;
    }

    private String getResultsTabName(int resultSetNumber, int queryIndex, String name) {
        String tabName = name;
        if (CommonUtils.isEmpty((String)tabName)) {
            tabName = SQLEditorMessages.editors_sql_data_grid;
        }
        tabName = String.valueOf(tabName) + " " + (queryIndex + 1);
        if (resultSetNumber > 0) {
            tabName = String.valueOf(tabName) + " (" + (resultSetNumber + 1) + ")";
        }
        return tabName;
    }

    public void updateDirtyFlag() {
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueryServerOutput(@Nullable DBCExecutionResult result) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            DBPDataSource dataSource = executionContext.getDataSource();
            DBCServerOutputReader outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
            if (outputReader == null && result != null) {
                outputReader = new DefaultServerOutputReader();
            }
            if (outputReader != null && outputReader.isServerOutputEnabled()) {
                List<ServerOutputInfo> list = this.serverOutputs;
                synchronized (list) {
                    this.serverOutputs.add(new ServerOutputInfo(outputReader, executionContext, result));
                }
            }
        }
    }

    private void runPostExecuteActions(@Nullable SQLQueryResult result) {
        DBCExecutionContextDefaults contextDefaults;
        this.showResultsPanel(true);
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null && (result == null || !result.hasError() && this.getActivePreferenceStore().getBoolean("SQLEditor.refreshDefaultsAfterExecute")) && (contextDefaults = executionContext.getContextDefaults()) != null) {
            new AbstractJob("Refresh default object"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    monitor.beginTask("Refresh default objects", 1);
                    try {
                        DBUtils.refreshContextDefaultsAndReflect((DBRProgressMonitor)monitor, (DBCExecutionContextDefaults)contextDefaults);
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void updateOutputViewerIcon(boolean alert) {
        Image image = alert ? IMG_OUTPUT_ALERT : IMG_OUTPUT;
        CTabItem outputItem = UIUtils.getTabItem((CTabFolder)this.resultTabs, (Object)this.outputViewer.getControl());
        if (outputItem != null && outputItem != this.resultTabs.getSelection()) {
            outputItem.setImage(image);
        }
    }

    private class CloseContextJob
    extends AbstractJob {
        private final DBCExecutionContext context;

        CloseContextJob(DBCExecutionContext context) {
            super("Close context " + context.getContextName());
            this.context = context;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Close SQLEditor isolated connection", 1);
            try {
                UIServiceConnections serviceConnections;
                if (QMUtils.isTransactionActive((DBCExecutionContext)this.context) && (serviceConnections = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class)) != null) {
                    serviceConnections.closeActiveTransaction(monitor, this.context, false);
                }
                monitor.subTask("Close context " + this.context.getContextName());
                this.context.close();
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private class DynamicSelectionProvider
    extends CompositeSelectionProvider {
        private boolean lastFocusInEditor = true;

        private DynamicSelectionProvider() {
        }

        public ISelectionProvider getProvider() {
            boolean focusInEditor;
            ISelectionProvider selectionProvider;
            if (SQLEditor.this.extraPresentation != null && SQLEditor.this.getExtraPresentationState() == SQLEditorPresentation.ActivationType.VISIBLE && SQLEditor.this.getExtraPresentationControl().isFocusControl() && (selectionProvider = SQLEditor.this.extraPresentation.getSelectionProvider()) != null) {
                return selectionProvider;
            }
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean bl = focusInEditor = textViewer != null && textViewer.getTextWidget().isFocusControl();
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                return rsv;
            }
            if (textViewer != null) {
                return textViewer.getSelectionProvider();
            }
            return null;
        }
    }

    private class FindReplaceTarget
    extends DynamicFindReplaceTarget {
        private boolean lastFocusInEditor = true;

        private FindReplaceTarget() {
        }

        public IFindReplaceTarget getTarget() {
            ResultSetViewer rsv = SQLEditor.this.getActiveResultSetViewer();
            TextViewer textViewer = SQLEditor.this.getTextViewer();
            boolean focusInEditor = textViewer != null && textViewer.getTextWidget() != null && textViewer.getTextWidget().isFocusControl();
            CTabItem activeResultsTab = SQLEditor.this.getActiveResultsTab();
            if (activeResultsTab != null && activeResultsTab.getData() instanceof StyledText) {
                StyledText styledText = (StyledText)activeResultsTab.getData();
                if (!focusInEditor) {
                    return new StyledTextFindReplaceTarget(styledText);
                }
            }
            if (!focusInEditor) {
                focusInEditor = rsv != null && rsv.getActivePresentation().getControl().isFocusControl() ? false : this.lastFocusInEditor;
            }
            this.lastFocusInEditor = focusInEditor;
            if (!focusInEditor && rsv != null) {
                IFindReplaceTarget nested = (IFindReplaceTarget)rsv.getAdapter(IFindReplaceTarget.class);
                if (nested != null) {
                    return nested;
                }
            } else if (textViewer != null) {
                return textViewer.getFindReplaceTarget();
            }
            return null;
        }
    }

    private class OpenContextJob
    extends AbstractJob {
        private final DBSInstance instance;
        private final Runnable onSuccess;
        private Throwable error;

        OpenContextJob(DBSInstance instance, Runnable onSuccess) {
            super("Open connection to " + instance.getDataSource().getContainer().getName());
            this.instance = instance;
            this.onSuccess = onSuccess;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            block8: {
                monitor.beginTask("Open SQLEditor isolated connection", 1);
                try {
                    try {
                        String[] contextDefaultNames;
                        String title = "SQLEditor <" + SQLEditor.this.getEditorInput().getName() + ">";
                        monitor.subTask("Open context " + title);
                        DBCExecutionContext newContext = this.instance.openIsolatedContext(monitor, title, this.instance.getDefaultContext(monitor, false));
                        String[] stringArray = contextDefaultNames = SQLEditor.this.isRestoreActiveSchemaFromScript() ? EditorUtils.getInputContextDefaults((DBPDataSourceContainer)this.instance.getDataSource().getContainer(), (IEditorInput)SQLEditor.this.getEditorInput()) : null;
                        if (!(contextDefaultNames == null || contextDefaultNames.length <= 1 || CommonUtils.isEmpty((String)contextDefaultNames[0]) && CommonUtils.isEmpty((String)contextDefaultNames[1]))) {
                            try {
                                DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)newContext.getDataSource(), (DBCExecutionContext)newContext, (String)contextDefaultNames[0], null, (String)contextDefaultNames[1]);
                            }
                            catch (DBException e) {
                                DBWorkbench.getPlatformUI().showError("New connection default", "Error setting default catalog/schema for new connection", (Throwable)e);
                            }
                        }
                        SQLEditor.this.executionContext = newContext;
                        new AbstractJob("Notify context change"){

                            protected IStatus run(DBRProgressMonitor monitor) {
                                DBUtils.fireObjectSelect((DBSObject)OpenContextJob.this.instance, (boolean)true);
                                return Status.OK_STATUS;
                            }
                        }.schedule(200L);
                    }
                    catch (DBException e) {
                        this.error = e;
                        monitor.done();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            this.updateContext();
            return Status.OK_STATUS;
        }

        private void updateContext() {
            if (this.error != null) {
                SQLEditor.this.releaseExecutionContext();
                DBWorkbench.getPlatformUI().showError("Open context", "Can't open editor connection", this.error);
            } else {
                if (this.onSuccess != null) {
                    this.onSuccess.run();
                }
                SQLEditor.this.fireDataSourceChange();
            }
        }
    }

    private class OutputAutoShowToggleAction
    extends Action {
        OutputAutoShowToggleAction() {
            super(SQLEditorMessages.pref_page_sql_editor_label_auto_open_output_view, 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SHOW_ALL_DETAILS));
            this.setChecked(SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow"));
        }

        public void run() {
            SQLEditor.this.getActivePreferenceStore().setValue("SQLEditor.outputPanel.autoShow", this.isChecked());
            try {
                SQLEditor.this.getActivePreferenceStore().save();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private class OutputLogWriter
    extends Writer {
        private OutputLogWriter() {
        }

        @Override
        public void write(@NotNull char[] cbuf, int off, int len) {
            UIUtils.syncExec(() -> {
                if (!SQLEditor.this.outputViewer.isDisposed()) {
                    SQLEditor.this.outputViewer.getOutputWriter().write(cbuf, off, len);
                    SQLEditor.this.outputViewer.scrollToEnd();
                    if (!SQLEditor.this.outputViewer.isVisible()) {
                        SQLEditor.this.updateOutputViewerIcon(true);
                    }
                }
            });
        }

        @Override
        public void flush() throws IOException {
            SQLEditor.this.outputViewer.getOutputWriter().flush();
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class PresentationPanelToggleAction
    extends Action {
        private SQLPresentationPanelDescriptor panel;
        private CTabItem tabItem;

        public PresentationPanelToggleAction(SQLPresentationPanelDescriptor panel) {
            super(panel.getLabel(), 2);
            this.setId(SQLEditor.PANEL_ITEM_PREFIX + panel.getId());
            if (panel.getIcon() != null) {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)panel.getIcon()));
            }
            if (panel.getDescription() != null) {
                this.setToolTipText(panel.getDescription());
            }
            this.panel = panel;
        }

        public void run() {
            CTabItem tabItem;
            int n;
            int n2;
            CTabItem[] cTabItemArray;
            if (SQLEditor.this.resultsSash.getMaximizedControl() != null) {
                SQLEditor.this.resultsSash.setMaximizedControl(null);
            }
            this.setChecked(!this.isChecked());
            SQLEditorPresentationPanel panelInstance = (SQLEditorPresentationPanel)SQLEditor.this.extraPresentationPanels.get((Object)this.panel);
            if (panelInstance != null && !this.isChecked()) {
                cTabItemArray = SQLEditor.this.resultTabs.getItems();
                n2 = cTabItemArray.length;
                n = 0;
                while (n < n2) {
                    tabItem = cTabItemArray[n];
                    if (tabItem.getData() == panelInstance) {
                        tabItem.dispose();
                        return;
                    }
                    ++n;
                }
            }
            if (panelInstance == null) {
                Control panelControl;
                try {
                    panelInstance = this.panel.createPanel();
                    panelControl = panelInstance.createPanel((Composite)SQLEditor.this.resultTabs, SQLEditor.this, SQLEditor.this.extraPresentation);
                }
                catch (DBException e2) {
                    DBWorkbench.getPlatformUI().showError("Panel opening error", "Can't create panel " + this.panel.getLabel(), (Throwable)e2);
                    return;
                }
                SQLEditor.this.extraPresentationPanels.put(this.panel, panelInstance);
                this.tabItem = new CTabItem(SQLEditor.this.resultTabs, 64);
                this.tabItem.setControl(panelControl);
                this.tabItem.setText(this.panel.getLabel());
                this.tabItem.setToolTipText(this.panel.getDescription());
                this.tabItem.setImage(DBeaverIcons.getImage((DBPImage)this.panel.getIcon()));
                this.tabItem.setData((Object)panelInstance);
                this.tabItem.addDisposeListener(e -> {
                    this.setChecked(false);
                    panelControl.dispose();
                    SQLEditor.this.extraPresentationPanels.remove((Object)this.panel);
                    SQLEditor.this.extraPresentationCurrentPanel = null;
                    SQLEditor.this.resultTabDisposeListener.widgetDisposed(e);
                });
                SQLEditor.this.extraPresentationCurrentPanel = panelInstance;
                SQLEditor.this.resultTabs.setSelection(this.tabItem);
            } else {
                cTabItemArray = SQLEditor.this.resultTabs.getItems();
                n2 = cTabItemArray.length;
                n = 0;
                while (n < n2) {
                    tabItem = cTabItemArray[n];
                    if (tabItem.getData() == panelInstance) {
                        SQLEditor.this.resultTabs.setSelection(tabItem);
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    public class QueryProcessor
    implements SQLResultsConsumer,
    ISmartTransactionManager {
        private volatile SQLQueryJob curJob;
        private AtomicInteger curJobRunning = new AtomicInteger(0);
        private final List<QueryResultsContainer> resultContainers = new ArrayList<QueryResultsContainer>();
        private volatile DBDDataReceiver curDataReceiver = null;

        QueryProcessor(boolean makeDefault) {
            if (makeDefault) {
                SQLEditor.this.queryProcessors.add(0, this);
            } else {
                SQLEditor.this.queryProcessors.add(this);
            }
            this.createResultsProvider(0, makeDefault);
        }

        int getRunningJobs() {
            return this.curJobRunning.get();
        }

        private QueryResultsContainer createResultsProvider(int resultSetNumber, boolean makeDefault) {
            QueryResultsContainer resultsProvider = new QueryResultsContainer(this, resultSetNumber, SQLEditor.this.getMaxResultsTabIndex() + 1, makeDefault);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        private QueryResultsContainer createResultsProvider(DBSDataContainer dataContainer) {
            QueryResultsContainer resultsProvider = new QueryResultsContainer(this, this.resultContainers.size(), SQLEditor.this.getMaxResultsTabIndex(), dataContainer);
            this.resultContainers.add(resultsProvider);
            return resultsProvider;
        }

        public boolean hasPinnedTabs() {
            for (QueryResultsContainer container : this.resultContainers) {
                if (!container.isPinned()) continue;
                return true;
            }
            return false;
        }

        @NotNull
        QueryResultsContainer getFirstResults() {
            return this.resultContainers.get(0);
        }

        @Nullable
        QueryResultsContainer getResults(SQLQuery query) {
            for (QueryResultsContainer provider : this.resultContainers) {
                if (provider.query != query) continue;
                return provider;
            }
            return null;
        }

        List<QueryResultsContainer> getResultContainers() {
            return this.resultContainers;
        }

        private void closeJob() {
            SQLQueryJob job = this.curJob;
            if (job != null) {
                if (job.getState() == 4) {
                    job.cancel();
                }
                this.curJob = null;
                if (job.isJobOpen()) {
                    RuntimeUtils.runTask(monitor -> job.closeJob(), (String)"Close SQL job", (long)2000L, (boolean)true);
                }
            }
        }

        public void cancelJob() {
            for (QueryResultsContainer rc : this.resultContainers) {
                rc.viewer.cancelJobs();
            }
            SQLQueryJob job = this.curJob;
            if (job != null && job.getState() == 4) {
                job.cancel();
            }
        }

        boolean processQueries(SQLScriptContext scriptContext, List<SQLScriptElement> queries, boolean forceScript, boolean fetchResults, boolean export, boolean closeTabOnError, SQLQueryListener queryListener) {
            if (queries.isEmpty()) {
                return false;
            }
            if (this.curJobRunning.get() > 0) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, SQLEditorMessages.editors_sql_error_cant_execute_query_message);
                return false;
            }
            DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
            if (executionContext == null) {
                DBWorkbench.getPlatformUI().showError(SQLEditorMessages.editors_sql_error_cant_execute_query_title, ModelMessages.error_not_connected_to_database);
                return false;
            }
            boolean isSingleQuery = !forceScript && queries.size() == 1;
            SQLEditor.this.showScriptPositionRuler(true);
            QueryResultsContainer resultsContainer = this.getFirstResults();
            SQLEditorQueryListener listener = new SQLEditorQueryListener(this, closeTabOnError);
            if (queryListener != null) {
                listener.setExtListener(queryListener);
            }
            if (export) {
                ArrayList<DatabaseTransferProducer> producers = new ArrayList<DatabaseTransferProducer>();
                int i = 0;
                while (i < queries.size()) {
                    SQLScriptElement element = queries.get(i);
                    if (element instanceof SQLControlCommand) {
                        try {
                            scriptContext.executeControlCommand((SQLControlCommand)element);
                        }
                        catch (DBException e) {
                            DBWorkbench.getPlatformUI().showError("Command error", "Error processing control command", (Throwable)e);
                        }
                    } else {
                        SQLQuery query = (SQLQuery)element;
                        scriptContext.fillQueryParameters(query, false);
                        SQLQueryDataContainer dataContainer = new SQLQueryDataContainer((DBPContextProvider)SQLEditor.this, query, scriptContext, log);
                        producers.add(new DatabaseTransferProducer((DBSDataContainer)dataContainer, null));
                    }
                    ++i;
                }
                DataTransferWizard.openWizard((IWorkbenchWindow)SQLEditor.this.getSite().getWorkbenchWindow(), producers, null, (IStructuredSelection)new StructuredSelection((Object)this));
            } else {
                SQLQueryJob job = new SQLQueryJob(SQLEditor.this.getSite(), isSingleQuery ? SQLEditorMessages.editors_sql_job_execute_query : SQLEditorMessages.editors_sql_job_execute_script, executionContext, resultsContainer, queries, scriptContext, this, listener);
                if (isSingleQuery) {
                    resultsContainer.query = queries.get(0);
                    this.closeJob();
                    this.curJob = job;
                    ResultSetViewer rsv = resultsContainer.getResultSetController();
                    if (rsv != null) {
                        rsv.resetDataFilter(false);
                        rsv.resetHistory();
                        rsv.refresh();
                    }
                } else {
                    if (fetchResults) {
                        job.setFetchResultSets(true);
                    }
                    job.schedule();
                    this.curJob = job;
                }
            }
            return true;
        }

        public boolean isDirty() {
            for (QueryResultsContainer resultsProvider : this.resultContainers) {
                ResultSetViewer rsv = resultsProvider.getResultSetController();
                if (rsv == null || !rsv.isDirty()) continue;
                return true;
            }
            return false;
        }

        void removeResults(QueryResultsContainer resultsContainer) {
            this.resultContainers.remove(resultsContainer);
            if (this.resultContainers.isEmpty()) {
                SQLEditor.this.queryProcessors.remove(this);
                if (SQLEditor.this.curQueryProcessor == this) {
                    if (SQLEditor.this.queryProcessors.isEmpty()) {
                        SQLEditor.this.curQueryProcessor = null;
                        SQLEditor.this.curResultsContainer = null;
                    } else {
                        SQLEditor.this.curQueryProcessor = (QueryProcessor)SQLEditor.this.queryProcessors.get(0);
                        SQLEditor.this.curResultsContainer = SQLEditor.this.curQueryProcessor.getFirstResults();
                    }
                }
            }
        }

        @Override
        @Nullable
        public DBDDataReceiver getDataReceiver(SQLQuery statement, int resultSetNumber) {
            ResultSetViewer rsv;
            boolean isStatsResult;
            if (this.curDataReceiver != null) {
                return this.curDataReceiver;
            }
            boolean bl = isStatsResult = statement != null && statement.getData() == SQLQueryJob.STATS_RESULTS;
            if (resultSetNumber >= this.resultContainers.size() && !SQLEditor.this.isDisposed()) {
                UIUtils.syncExec(() -> {
                    QueryResultsContainer queryResultsContainer = this.createResultsProvider(resultSetNumber, false);
                });
            }
            if (resultSetNumber >= this.resultContainers.size()) {
                return null;
            }
            QueryResultsContainer resultsProvider = this.resultContainers.get(resultSetNumber);
            if (statement != null && !SQLEditor.this.resultTabs.isDisposed()) {
                resultsProvider.query = (SQLScriptElement)statement;
                resultsProvider.lastGoodQuery = (SQLScriptElement)statement;
                String tabName = null;
                String queryText = CommonUtils.truncateString((String)statement.getText(), (int)1000);
                DBPDataSourceContainer dataSourceContainer = SQLEditor.this.getDataSourceContainer();
                String toolTip = "Connection: " + (dataSourceContainer == null ? "N/A" : dataSourceContainer.getName()) + GeneralUtils.getDefaultLineSeparator() + "Time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + GeneralUtils.getDefaultLineSeparator() + "Query: " + (CommonUtils.isEmpty((String)queryText) ? "N/A" : queryText);
                if (isStatsResult) {
                    tabName = SQLEditorMessages.editors_sql_statistics;
                    int queryIndex = SQLEditor.this.queryProcessors.indexOf(this);
                    tabName = String.valueOf(tabName) + " " + (queryIndex + 1);
                }
                String finalTabName = tabName;
                UIUtils.asyncExec(() -> resultsProvider.updateResultsName(finalTabName, toolTip));
            }
            return (rsv = resultsProvider.getResultSetController()) == null ? null : rsv.getDataReceiver();
        }

        public boolean isSmartAutoCommit() {
            return SQLEditor.this.isSmartAutoCommit();
        }

        public void setSmartAutoCommit(boolean smartAutoCommit) {
            SQLEditor.this.setSmartAutoCommit(smartAutoCommit);
        }
    }

    public class QueryResultsContainer
    implements DBSDataContainer,
    IResultSetContainer,
    IResultSetValueReflector,
    IResultSetListener,
    IResultSetContainerExt,
    SQLQueryContainer,
    ISmartTransactionManager,
    IQueryExecuteController {
        private final QueryProcessor queryProcessor;
        private final ResultSetViewer viewer;
        private int resultSetNumber;
        private final int resultSetIndex;
        private SQLScriptElement query = null;
        private SQLScriptElement lastGoodQuery = null;
        private DBSDataContainer dataContainer;
        private CTabItem resultsTab;
        private String tabName;

        private QueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean makeDefault) {
            this.queryProcessor = queryProcessor;
            this.resultSetNumber = resultSetNumber;
            this.resultSetIndex = resultSetIndex;
            boolean detachedViewer = false;
            SQLResultsView sqlView = null;
            if (detachedViewer) {
                try {
                    sqlView = (SQLResultsView)SQLEditor.this.getSite().getPage().showView("org.jkiss.dbeaver.core.sqlResults", null, 3);
                }
                catch (Throwable e2) {
                    DBWorkbench.getPlatformUI().showError("Detached results", "Can't open results view", e2);
                }
            }
            if (sqlView != null) {
                sqlView.setContainer(this);
                this.viewer = sqlView.getViewer();
            } else {
                this.viewer = new ResultSetViewer((Composite)SQLEditor.this.resultTabs, SQLEditor.this.getSite(), (IResultSetContainer)this);
                this.viewer.addListener((IResultSetListener)this);
                int tabCount = SQLEditor.this.resultTabs.getItemCount();
                int tabIndex = 0;
                if (!makeDefault) {
                    int i = tabCount;
                    while (i > 0) {
                        if (SQLEditor.this.resultTabs.getItem(i - 1).getData() instanceof QueryResultsContainer) {
                            tabIndex = i;
                            break;
                        }
                        --i;
                    }
                }
                this.resultsTab = new CTabItem(SQLEditor.this.resultTabs, 0, tabIndex);
                this.resultsTab.setImage(IMG_DATA_GRID);
                this.resultsTab.setData((Object)this);
                this.resultsTab.setShowClose(true);
                this.resultsTab.setText(SQLEditor.this.getResultsTabName(resultSetNumber, this.getQueryIndex(), null));
                CSSUtils.setCSSClass((Widget)this.resultsTab, (String)"coloredByConnectionType");
                this.resultsTab.setControl((Control)this.viewer.getControl());
                this.resultsTab.addDisposeListener(SQLEditor.this.resultTabDisposeListener);
                UIUtils.disposeControlOnItemDispose((CTabItem)this.resultsTab);
            }
            this.viewer.getControl().addDisposeListener(e -> {
                this.queryProcessor.removeResults(this);
                if (this == SQLEditor.this.curResultsContainer) {
                    SQLEditor.this.curResultsContainer = null;
                }
            });
        }

        QueryResultsContainer(QueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, DBSDataContainer dataContainer) {
            this(queryProcessor, resultSetNumber, resultSetIndex, false);
            this.dataContainer = dataContainer;
            this.updateResultsName(sQLEditor.getResultsTabName(resultSetNumber, 0, dataContainer.getName()), null);
        }

        private CTabItem getTabItem() {
            return this.resultsTab;
        }

        public int getResultSetIndex() {
            return this.resultSetIndex;
        }

        public int getQueryIndex() {
            return SQLEditor.this.queryProcessors.indexOf(this.queryProcessor);
        }

        void updateResultsName(String resultSetName, String toolTip) {
            CTabItem tabItem;
            if (SQLEditor.this.resultTabs == null || SQLEditor.this.resultTabs.isDisposed()) {
                return;
            }
            if (CommonUtils.isEmpty((String)resultSetName)) {
                resultSetName = this.tabName;
            }
            if ((tabItem = this.getTabItem()) != null && !tabItem.isDisposed()) {
                if (!CommonUtils.isEmpty((String)resultSetName)) {
                    tabItem.setText(resultSetName);
                }
                if (toolTip != null) {
                    tabItem.setToolTipText(toolTip);
                }
            }
        }

        boolean isPinned() {
            CTabItem tabItem = this.getTabItem();
            return tabItem != null && !tabItem.isDisposed() && !tabItem.getShowClose();
        }

        void setPinned(boolean pinned) {
            CTabItem tabItem = this.getTabItem();
            if (tabItem != null) {
                tabItem.setShowClose(!pinned);
                tabItem.setImage(pinned ? IMG_DATA_GRID_LOCKED : IMG_DATA_GRID);
            }
        }

        @NotNull
        public DBPProject getProject() {
            return SQLEditor.this.getProject();
        }

        public DBCExecutionContext getExecutionContext() {
            return SQLEditor.this.getExecutionContext();
        }

        @Nullable
        public ResultSetViewer getResultSetController() {
            return this.viewer;
        }

        boolean hasData() {
            return this.viewer != null && this.viewer.hasData();
        }

        @Nullable
        public DBSDataContainer getDataContainer() {
            return this;
        }

        public boolean isReadyToRun() {
            return this.queryProcessor.curJob == null || this.queryProcessor.curJobRunning.get() <= 0;
        }

        public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
            UIUtils.syncExec(() -> {
                QueryResultsContainer resultsProvider = this.queryProcessor.createResultsProvider(dataContainer);
                CTabItem tabItem = resultsProvider.getTabItem();
                if (tabItem != null) {
                    tabItem.getParent().setSelection(tabItem);
                }
                SQLEditor.this.setActiveResultsContainer(resultsProvider);
                resultsProvider.viewer.refreshWithFilter(newFilter);
            });
        }

        public IResultSetDecorator createResultSetDecorator() {
            return new QueryResultsDecorator(){

                public String getEmptyDataDescription() {
                    String execQuery = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.statement", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                    String execScript = ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.editors.sql.run.script", (IServiceLocator)SQLEditor.this.getSite(), (boolean)true);
                    return NLS.bind((String)ResultSetMessages.sql_editor_resultset_filter_panel_control_execute_to_see_reslut, (Object)execQuery, (Object)execScript);
                }
            };
        }

        public int getSupportedFeatures() {
            if (this.dataContainer != null) {
                return this.dataContainer.getSupportedFeatures();
            }
            int features = 0;
            features |= 1;
            if (this.getQueryResultCounts() <= 1) {
                features |= 4;
            }
            return features;
        }

        @NotNull
        public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
            SQLQuery query;
            if (this.dataContainer != null) {
                return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags, fetchSize);
            }
            SQLQueryJob job = this.queryProcessor.curJob;
            if (job == null) {
                throw new DBCException("No active query - can't read data");
            }
            if (this.query instanceof SQLQuery && (query = (SQLQuery)this.query).getResultsMaxRows() >= 0) {
                firstRow = query.getResultsOffset();
                maxRows = query.getResultsMaxRows();
            }
            try {
                if (dataReceiver != this.viewer.getDataReceiver()) {
                    this.queryProcessor.curDataReceiver = dataReceiver;
                } else {
                    this.queryProcessor.curDataReceiver = null;
                }
                int resultCounts = this.getQueryResultCounts();
                if (resultCounts <= 1 && this.resultSetNumber > 0) {
                    job.setFetchResultSetNumber(this.resultSetNumber);
                } else {
                    job.setFetchResultSetNumber(-1);
                }
                job.setResultSetLimit(firstRow, maxRows);
                job.setDataFilter(dataFilter);
                job.setFetchSize(fetchSize);
                job.setFetchFlags(flags);
                job.extractData(session, this.query, resultCounts > 1 ? 0 : this.resultSetNumber);
                this.lastGoodQuery = job.getLastGoodQuery();
                DBCStatistics dBCStatistics = job.getStatistics();
                return dBCStatistics;
            }
            finally {
                this.queryProcessor.curDataReceiver = null;
            }
        }

        private int getQueryResultCounts() {
            int resultCounts = 0;
            for (QueryResultsContainer qrc : this.queryProcessor.resultContainers) {
                if (qrc.query != this.query) continue;
                ++resultCounts;
            }
            return resultCounts;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
            if (this.dataContainer != null) {
                return this.dataContainer.countData(source, session, dataFilter, 0L);
            }
            DBPDataSource dataSource = this.getDataSource();
            if (dataSource == null) {
                throw new DBCException("Query transform is not supported by datasource");
            }
            if (!(this.query instanceof SQLQuery)) {
                throw new DBCException("Can't count rows for control command");
            }
            try {
                SQLQuery countQuery = new SQLQueryTransformerCount().transformQuery(dataSource, SQLEditor.this.getSyntaxManager(), (SQLQuery)this.query);
                if (!CommonUtils.isEmpty((Collection)countQuery.getParameters())) {
                    countQuery.setParameters(SQLEditor.this.parseQueryParameters(countQuery));
                }
                Throwable throwable = null;
                Object var9_10 = null;
                try (DBCStatement dbStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.QUERY, (SQLQuery)countQuery, (long)0L, (long)0L);){
                    if (!dbStatement.executeStatement()) throw new DBCException("Row count query didn't return any value");
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try {
                        Object countValue;
                        block26: {
                            long l;
                            DBCResultSet rs = dbStatement.openResultSet();
                            try {
                                Object singleValue;
                                if (!rs.nextRow()) throw new DBCException("Row count result is empty");
                                List resultAttrs = rs.getMeta().getAttributes();
                                countValue = null;
                                if (resultAttrs.size() == 1) {
                                    countValue = rs.getAttributeValue(0);
                                } else {
                                    int i = 0;
                                    while (i < resultAttrs.size()) {
                                        DBCAttributeMetaData ma = (DBCAttributeMetaData)resultAttrs.get(i);
                                        if (ma.getName().toLowerCase(Locale.ENGLISH).contains("count")) {
                                            countValue = rs.getAttributeValue(i);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                if (countValue instanceof Map && ((Map)countValue).size() == 1 && (singleValue = ((Map)countValue).values().iterator().next()) instanceof Number) {
                                    countValue = singleValue;
                                }
                                if (!(countValue instanceof Number)) break block26;
                                l = ((Number)countValue).longValue();
                                if (rs == null) return l;
                            }
                            catch (Throwable throwable3) {
                                if (rs == null) throw throwable3;
                                rs.close();
                                throw throwable3;
                            }
                            rs.close();
                            return l;
                        }
                        throw new DBCException("Unexpected row count value: " + countValue);
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (DBException e) {
                throw new DBCException("Error executing row count", (Throwable)e);
            }
        }

        @Nullable
        public String getDescription() {
            if (this.dataContainer != null) {
                return this.dataContainer.getDescription();
            }
            return SQLEditorMessages.editors_sql_description;
        }

        @Nullable
        public DBSObject getParentObject() {
            return this.getDataSource();
        }

        @Nullable
        public DBPDataSource getDataSource() {
            return SQLEditor.this.getDataSource();
        }

        public boolean isPersisted() {
            return this.dataContainer == null || this.dataContainer.isPersisted();
        }

        @NotNull
        public String getName() {
            String name;
            if (this.dataContainer != null) {
                return this.dataContainer.getName();
            }
            String string = this.lastGoodQuery != null ? this.lastGoodQuery.getOriginalText() : (name = this.query == null ? null : this.query.getOriginalText());
            if (name == null) {
                name = "SQL";
            }
            return name;
        }

        @Nullable
        public DBPDataSourceContainer getDataSourceContainer() {
            return SQLEditor.this.getDataSourceContainer();
        }

        public String toString() {
            if (this.dataContainer != null) {
                return this.dataContainer.toString();
            }
            return this.query == null ? "SQL Query / " + SQLEditor.this.getEditorInput().getName() : this.query.getOriginalText();
        }

        public void handleResultSetLoad() {
        }

        public void handleResultSetChange() {
            SQLEditor.this.updateDirtyFlag();
        }

        public void handleResultSetSelectionChange(SelectionChangedEvent event) {
        }

        public SQLScriptElement getQuery() {
            return this.query;
        }

        public Map<String, Object> getQueryParameters() {
            return SQLEditor.this.globalScriptContext.getAllParameters();
        }

        public boolean isSmartAutoCommit() {
            return SQLEditor.this.isSmartAutoCommit();
        }

        public void setSmartAutoCommit(boolean smartAutoCommit) {
            SQLEditor.this.setSmartAutoCommit(smartAutoCommit);
        }

        public void setTabName(String tabName) {
            this.tabName = tabName;
            this.resultsTab.setText(tabName);
        }

        public void insertCurrentCellValue(DBDAttributeBinding attributeBinding, Object cellValue, String stringValue) {
            StyledText textWidget;
            StyledText styledText = textWidget = SQLEditor.this.getTextViewer() == null ? null : SQLEditor.this.getTextViewer().getTextWidget();
            if (textWidget != null) {
                String sqlValue = this.getDataSource() != null ? SQLUtils.convertValueToSQL((DBPDataSource)this.getDataSource(), (DBSTypedObject)attributeBinding, (Object)cellValue) : stringValue;
                textWidget.insert(sqlValue);
                textWidget.setCaretOffset(textWidget.getCaretOffset() + sqlValue.length());
                textWidget.setFocus();
            }
        }

        public void forceDataReadCancel(Throwable error) {
            for (QueryProcessor processor : SQLEditor.this.queryProcessors) {
                SQLQueryJob job = processor.curJob;
                if (job == null) continue;
                SQLQueryResult currentQueryResult = job.getCurrentQueryResult();
                if (currentQueryResult == null) {
                    currentQueryResult = new SQLQueryResult(new SQLQuery(null, ""));
                }
                currentQueryResult.setError(error);
                job.notifyQueryExecutionEnd(currentQueryResult);
            }
        }

        public void handleExecuteResult(DBCExecutionResult result) {
            SQLEditor.this.dumpQueryServerOutput(result);
        }
    }

    public static enum ResultSetOrientation {
        HORIZONTAL(512, SQLEditorMessages.sql_editor_result_set_orientation_horizontal, SQLEditorMessages.sql_editor_result_set_orientation_horizontal_tip, true),
        VERTICAL(256, SQLEditorMessages.sql_editor_result_set_orientation_vertical, SQLEditorMessages.sql_editor_result_set_orientation_vertical_tip, true),
        DETACHED(512, SQLEditorMessages.sql_editor_result_set_orientation_detached, SQLEditorMessages.sql_editor_result_set_orientation_detached_tip, false);

        private final int sashOrientation;
        private final String label;
        private final String description;
        private final boolean supported;

        private ResultSetOrientation(int sashOrientation, String label, String description, boolean supported) {
            this.sashOrientation = sashOrientation;
            this.label = label;
            this.description = description;
            this.supported = supported;
        }

        public int getSashOrientation() {
            return this.sashOrientation;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }

    public static class ResultSetOrientationMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (!(activeEditor instanceof SQLEditorBase)) {
                return new IContributionItem[0];
            }
            final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            String curPresentation = preferenceStore.getString("SQLEditor.resultSet.orientation");
            ResultSetOrientation[] orientations = ResultSetOrientation.values();
            ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>(orientations.length);
            ResultSetOrientation[] resultSetOrientationArray = orientations;
            int n = orientations.length;
            int n2 = 0;
            while (n2 < n) {
                final ResultSetOrientation orientation = resultSetOrientationArray[n2];
                Action action = new Action(orientation.getLabel(), 8){

                    public void run() {
                        preferenceStore.setValue("SQLEditor.resultSet.orientation", orientation.name());
                        PrefUtils.savePreferenceStore((DBPPreferenceStore)preferenceStore);
                    }
                };
                action.setDescription(orientation.getDescription());
                if (!orientation.isSupported()) {
                    action.setEnabled(false);
                }
                if (orientation.name().equals(curPresentation)) {
                    action.setChecked(true);
                }
                items.add(new ActionContributionItem((IAction)action));
                ++n2;
            }
            return items.toArray(new IContributionItem[0]);
        }
    }

    private class SQLEditorQueryListener
    implements SQLQueryListener {
        private final QueryProcessor queryProcessor;
        private boolean scriptMode;
        private long lastUIUpdateTime;
        private final ITextSelection originalSelection;
        private int topOffset;
        private int visibleLength;
        private boolean closeTabOnError;
        private SQLQueryListener extListener;

        private SQLEditorQueryListener(QueryProcessor queryProcessor, boolean closeTabOnError) {
            this.originalSelection = (ITextSelection)SQLEditor.this.getSelectionProvider().getSelection();
            this.queryProcessor = queryProcessor;
            this.closeTabOnError = closeTabOnError;
        }

        public SQLQueryListener getExtListener() {
            return this.extListener;
        }

        public void setExtListener(SQLQueryListener extListener) {
            this.extListener = extListener;
        }

        public void onStartScript() {
            try {
                this.lastUIUpdateTime = -1L;
                this.scriptMode = true;
                UIUtils.asyncExec(() -> {
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.maxEditorOnScriptExecute")) {
                        SQLEditor.this.resultsSash.setMaximizedControl((Control)SQLEditor.this.sqlEditorPanel);
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartScript();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStartQuery(DBCSession session, SQLQuery query) {
            try {
                boolean isInExecute;
                boolean bl = isInExecute = SQLEditor.this.getTotalQueryRunning() > 0;
                if (!isInExecute) {
                    UIUtils.asyncExec(() -> {
                        SQLEditor.this.setTitleImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT_EXECUTE));
                        SQLEditor.this.updateDirtyFlag();
                    });
                }
                this.queryProcessor.curJobRunning.incrementAndGet();
                List list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.add(query);
                }
                if (this.lastUIUpdateTime < 0L || System.currentTimeMillis() - this.lastUIUpdateTime > 100L) {
                    UIUtils.asyncExec(() -> {
                        TextViewer textViewer = SQLEditor.this.getTextViewer();
                        if (textViewer != null) {
                            this.topOffset = textViewer.getTopIndexStartOffset();
                            this.visibleLength = textViewer.getBottomIndexEndOffset() - this.topOffset;
                        }
                    });
                    if (this.scriptMode) {
                        SQLEditor.this.showStatementInEditor(query, false);
                    }
                    this.lastUIUpdateTime = System.currentTimeMillis();
                }
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onStartQuery(session, query);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
            try {
                List list = SQLEditor.this.runningQueries;
                synchronized (list) {
                    SQLEditor.this.runningQueries.remove(result.getStatement());
                }
                this.queryProcessor.curJobRunning.decrementAndGet();
                if (SQLEditor.this.getTotalQueryRunning() <= 0) {
                    UIUtils.asyncExec(() -> {
                        if (SQLEditor.this.isDisposed()) {
                            return;
                        }
                        SQLEditor.this.setTitleImage(SQLEditor.this.editorImage);
                        SQLEditor.this.updateDirtyFlag();
                    });
                }
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                UIUtils.runUIJob((String)"Process SQL query result", monitor -> {
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    this.processQueryResult(monitor, result, statistics);
                    SQLEditor.this.updateDirtyFlag();
                    SQLEditor.this.refreshActions();
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndQuery(session, result, statistics);
                }
            }
        }

        private void processQueryResult(DBRProgressMonitor monitor, SQLQueryResult result, DBCStatistics statistics) {
            CTabItem tabItem;
            SQLEditor.this.dumpQueryServerOutput((DBCExecutionResult)result);
            if (!this.scriptMode) {
                SQLEditor.this.runPostExecuteActions(result);
            }
            SQLQuery query = result.getStatement();
            Throwable error = result.getError();
            ISelectionProvider selectionProvider = SQLEditor.this.getSelectionProvider();
            if (selectionProvider == null) {
                return;
            }
            if (error != null) {
                SQLEditor.this.setStatus(GeneralUtils.getFirstMessage((Throwable)error), DBPMessageType.ERROR);
                if (!SQLEditor.this.scrollCursorToError(monitor, query, error)) {
                    int errorQueryOffset = query.getOffset();
                    int errorQueryLength = query.getLength();
                    if (errorQueryOffset >= 0 && errorQueryLength > 0) {
                        if (this.scriptMode) {
                            selectionProvider.setSelection((ISelection)new TextSelection(errorQueryOffset, errorQueryLength));
                        } else {
                            selectionProvider.setSelection((ISelection)this.originalSelection);
                        }
                    }
                }
            } else if (!this.scriptMode && SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.resetCursorOnExecute")) {
                selectionProvider.setSelection((ISelection)this.originalSelection);
            }
            for (QueryResultsContainer cr : this.queryProcessor.resultContainers) {
                cr.viewer.updateFiltersText(false);
            }
            if (!result.hasError() && result.hasResultSet() && !this.queryProcessor.resultContainers.isEmpty()) {
                SQLEditor.this.resultTabs.setSelection(((QueryResultsContainer)this.queryProcessor.resultContainers.get(0)).resultsTab);
            }
            if (this.scriptMode || this.queryProcessor.getResultContainers().size() > 0) {
                int queryIndex = SQLEditor.this.queryProcessors.indexOf(this.queryProcessor);
                int resultsIndex = 0;
                for (QueryResultsContainer results : this.queryProcessor.resultContainers) {
                    if (results.query != query) continue;
                    if (resultsIndex < result.getExecuteResults().size()) {
                        ResultSetViewer resultSetViewer;
                        SQLQueryResult.ExecuteResult executeResult = result.getExecuteResults(resultsIndex, true);
                        String resultSetName = results.tabName;
                        if (CommonUtils.isEmpty((String)resultSetName)) {
                            resultSetName = SQLEditor.this.getResultsTabName(results.resultSetNumber, queryIndex, executeResult.getResultSetName());
                            results.updateResultsName(resultSetName, null);
                        }
                        if ((resultSetViewer = results.getResultSetController()) != null) {
                            resultSetViewer.getModel().setStatistics(statistics);
                        }
                    }
                    ++resultsIndex;
                }
            }
            if (this.closeTabOnError && error != null && (tabItem = this.queryProcessor.getFirstResults().getTabItem()) != null && tabItem.getShowClose()) {
                tabItem.dispose();
            }
            if (SQLEditor.this.dataSourceContainer != null && !this.scriptMode && SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.beepOnQueryEnd")) {
                Display.getCurrent().beep();
            }
            if (result.getQueryTime() > DBWorkbench.getPlatformUI().getLongOperationTimeout() * 1000L) {
                DBWorkbench.getPlatformUI().notifyAgent("Query completed [" + SQLEditor.this.getEditorInput().getName() + "]" + GeneralUtils.getDefaultLineSeparator() + CommonUtils.truncateString((String)query.getText(), (int)200), !result.hasError() ? 1 : 4);
            }
        }

        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            try {
                if (SQLEditor.this.isDisposed()) {
                    return;
                }
                SQLEditor.this.runPostExecuteActions(null);
                UIUtils.asyncExec(() -> {
                    QueryResultsContainer results;
                    ResultSetViewer viewer;
                    if (SQLEditor.this.isDisposed()) {
                        return;
                    }
                    SQLEditor.this.resultsSash.setMaximizedControl(null);
                    if (!hasErrors) {
                        SQLEditor.this.getSelectionProvider().setSelection((ISelection)this.originalSelection);
                    }
                    if ((viewer = (results = this.queryProcessor.getFirstResults()).getResultSetController()) != null) {
                        viewer.getModel().setStatistics(statistics);
                        viewer.updateStatusMessage();
                    }
                });
            }
            finally {
                if (this.extListener != null) {
                    this.extListener.onEndScript(statistics, hasErrors);
                }
            }
        }
    }

    private class SaveJob
    extends AbstractJob {
        private transient Boolean success;

        SaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' data changes...");
            this.success = null;
            this.setUser(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Save query processors", SQLEditor.this.queryProcessors.size());
            try {
                for (QueryProcessor queryProcessor : SQLEditor.this.queryProcessors) {
                    for (QueryResultsContainer resultsProvider : queryProcessor.getResultContainers()) {
                        ResultSetViewer rsv = resultsProvider.getResultSetController();
                        if (rsv == null || !rsv.isDirty()) continue;
                        rsv.doSave(monitor);
                    }
                    monitor.worked(1);
                }
                this.success = true;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable e) {
                this.success = false;
                log.error((Object)e);
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (this.success == null) {
                    this.success = true;
                }
                monitor.done();
            }
        }
    }

    private class ScriptAutoSaveJob
    extends AbstractJob {
        ScriptAutoSaveJob() {
            super("Save '" + SQLEditor.this.getPartName() + "' script");
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (EditorUtils.isInAutoSaveJob()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Auto-save SQL script", 1);
            try {
                try {
                    UIUtils.asyncExec(() -> SQLEditor.this.doTextEditorSave(monitor));
                }
                catch (Throwable e) {
                    log.debug((Object)e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    private static class ServerOutputInfo {
        private final DBCServerOutputReader outputReader;
        private final DBCExecutionContext executionContext;
        private final DBCExecutionResult result;

        ServerOutputInfo(DBCServerOutputReader outputReader, DBCExecutionContext executionContext, DBCExecutionResult result) {
            this.outputReader = outputReader;
            this.executionContext = executionContext;
            this.result = result;
        }
    }

    private class ServerOutputReader
    extends AbstractJob {
        ServerOutputReader() {
            super("Dump server output");
            this.setSystem(true);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (!DBWorkbench.getPlatform().isShuttingDown() && SQLEditor.this.resultsSash != null && !SQLEditor.this.resultsSash.isDisposed()) {
                this.dumpOutput(monitor);
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dumpOutput(DBRProgressMonitor monitor) {
            ArrayList outputs;
            if (SQLEditor.this.outputViewer == null) {
                return;
            }
            List list = SQLEditor.this.serverOutputs;
            synchronized (list) {
                outputs = new ArrayList(SQLEditor.this.serverOutputs);
                SQLEditor.this.serverOutputs.clear();
            }
            PrintWriter outputWriter = SQLEditor.this.outputViewer.getOutputWriter();
            if (!outputs.isEmpty()) {
                for (ServerOutputInfo info : outputs) {
                    if (monitor.isCanceled()) break;
                    try {
                        info.outputReader.readServerOutput(monitor, info.executionContext, info.result, null, outputWriter);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
            }
            if (!monitor.isCanceled()) {
                DBCServerOutputReader outputReader = null;
                DBCExecutionContext executionContext = SQLEditor.this.getExecutionContext();
                if (executionContext != null) {
                    DBPDataSource dataSource = executionContext.getDataSource();
                    outputReader = (DBCServerOutputReader)DBUtils.getAdapter(DBCServerOutputReader.class, (Object)dataSource);
                }
                if (outputReader != null && outputReader.isAsyncOutputReadSupported()) {
                    for (QueryProcessor qp : SQLEditor.this.queryProcessors) {
                        DBCStatement statement;
                        SQLQueryJob queryJob = qp.curJob;
                        if (queryJob == null || (statement = queryJob.getCurrentStatement()) == null) continue;
                        try {
                            outputReader.readServerOutput(monitor, executionContext, null, statement, outputWriter);
                        }
                        catch (DBCException e) {
                            log.error((Object)e);
                        }
                    }
                }
            }
            outputWriter.flush();
            if (!SQLEditor.this.outputViewer.isHasNewOutput()) {
                return;
            }
            SQLEditor.this.outputViewer.resetNewOutput();
            UIUtils.asyncExec(() -> {
                SQLEditor.this.outputViewer.scrollToEnd();
                if (SQLEditor.this.getActivePreferenceStore().getBoolean("SQLEditor.outputPanel.autoShow") && !SQLEditor.this.getViewToolItem("org.jkiss.dbeaver.ui.editors.sql.show.output").isChecked()) {
                    SQLEditor.this.showOutputPanel();
                }
            });
        }
    }
}

