/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2dl.AbsoluteBendpoint;
import org.eclipse.draw2dl.Bendpoint;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.ConnectionLocator;
import org.eclipse.draw2dl.Ellipse;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.PolygonDecoration;
import org.eclipse.draw2dl.PolylineConnection;
import org.eclipse.draw2dl.RelativeBendpoint;
import org.eclipse.draw2dl.RotatableDecoration;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.editpolicies.ConnectionEndpointEditPolicy;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.erd.ui.part.PropertyAwareConnectionPart;
import org.jkiss.dbeaver.erd.ui.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.AssociationEditPolicy;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AssociationPart
extends PropertyAwareConnectionPart {
    private Integer oldLineWidth;

    public ERDAssociation getAssociation() {
        return (ERDAssociation)this.getModel();
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (this.isEditEnabled()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AssociationEditPolicy());
        }
        this.getDiagramPart().getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
    }

    protected IFigure createFigure() {
        ERDAssociation association;
        PolylineConnection conn = new PolylineConnection();
        conn.setForegroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"));
        boolean showComments = this.getDiagramPart().getDiagram().hasAttributeStyle(ERDViewStyle.COMMENTS);
        if (showComments && (association = this.getAssociation()) != null && association.getObject() != null && !CommonUtils.isEmpty((String)((DBSEntityAssociation)association.getObject()).getDescription())) {
            ConnectionLocator descLabelLocator = new ConnectionLocator((Connection)conn, 4);
            Label descLabel = new Label(((DBSEntityAssociation)association.getObject()).getDescription());
            descLabel.setForegroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
            conn.add((IFigure)descLabel, (Object)descLabelLocator);
        }
        this.setConnectionStyles(conn);
        this.setConnectionRouting(conn);
        this.setConnectionToolTip(conn);
        return conn;
    }

    protected void setConnectionRouting(PolylineConnection conn) {
        ERDAssociation association = this.getAssociation();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        conn.setConnectionRouter(cLayer.getConnectionRouter());
        if (!CommonUtils.isEmpty((Collection)association.getInitBends())) {
            ArrayList<AbsoluteBendpoint> connBends = new ArrayList<AbsoluteBendpoint>();
            for (int[] bend : association.getInitBends()) {
                connBends.add(new AbsoluteBendpoint(bend[0], bend[1]));
            }
            conn.setRoutingConstraint(connBends);
        } else if (association.getTargetEntity() != null && association.getTargetEntity() == association.getSourceEntity()) {
            EditPart entityPart = this.getSource();
            if (entityPart == null) {
                entityPart = this.getTarget();
            }
            if (entityPart instanceof GraphicalEditPart) {
                IFigure entityFigure = ((GraphicalEditPart)entityPart).getFigure();
                Dimension figureSize = entityFigure.getMinimumSize();
                int entityWidth = figureSize.width;
                int entityHeight = figureSize.height;
                ArrayList<RelativeBendpoint> bends = new ArrayList<RelativeBendpoint>();
                RelativeBendpoint bp1 = new RelativeBendpoint((Connection)conn);
                bp1.setRelativeDimensions(new Dimension(entityWidth, entityHeight / 2), new Dimension(entityWidth / 2, entityHeight / 2));
                bends.add(bp1);
                RelativeBendpoint bp2 = new RelativeBendpoint((Connection)conn);
                bp2.setRelativeDimensions(new Dimension(-entityWidth, entityHeight / 2), new Dimension(entityWidth, entityHeight));
                bends.add(bp2);
                conn.setRoutingConstraint(bends);
            }
        }
    }

    protected void setConnectionStyles(PolylineConnection conn) {
        ERDAssociation association = this.getAssociation();
        boolean identifying = ERDUtils.isIdentifyingAssociation((ERDAssociation)association);
        DBSEntityConstraintType constraintType = ((DBSEntityAssociation)association.getObject()).getConstraintType();
        if (constraintType == DBSEntityConstraintType.INHERITANCE) {
            PolygonDecoration srcDec = new PolygonDecoration();
            srcDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            srcDec.setFill(true);
            srcDec.setBackgroundColor(this.getParent().getViewer().getControl().getBackground());
            srcDec.setScale(10.0, 6.0);
            conn.setTargetDecoration((RotatableDecoration)srcDec);
        } else if (constraintType.isAssociation()) {
            CircleDecoration sourceDecor = new CircleDecoration();
            sourceDecor.setRadius(3);
            sourceDecor.setFill(true);
            sourceDecor.setBackgroundColor(this.getParent().getViewer().getControl().getForeground());
            conn.setSourceDecoration((RotatableDecoration)sourceDecor);
            if (!identifying) {
                RhombusDecoration targetDecor = new RhombusDecoration();
                targetDecor.setBackgroundColor(this.getParent().getViewer().getControl().getBackground());
                conn.setTargetDecoration((RotatableDecoration)targetDecor);
            }
        }
        conn.setLineWidth(2);
        if (!identifying || constraintType.isLogical()) {
            float[] fArray;
            conn.setLineStyle(6);
            if (constraintType.isLogical()) {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = 4.0f;
            } else {
                float[] fArray3 = new float[1];
                fArray = fArray3;
                fArray3[0] = 5.0f;
            }
            conn.setLineDash(fArray);
        }
    }

    protected void setConnectionToolTip(PolylineConnection conn) {
        Label toolTip = new Label(String.valueOf(((DBSEntityAssociation)this.getAssociation().getObject()).getName()) + " [" + ((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName() + "]");
        toolTip.setIcon(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        conn.setToolTip((IFigure)toolTip);
    }

    public void setSelected(int value) {
        if (this.getSelected() == value) {
            return;
        }
        super.setSelected(value);
        if (this.oldLineWidth == null) {
            this.oldLineWidth = ((PolylineConnection)this.getFigure()).getLineWidth();
        }
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(this.oldLineWidth + 1);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(this.oldLineWidth.intValue());
        }
        if (this.getSource() == null || this.getTarget() == null) {
            return;
        }
        this.markAssociatedAttributes(value);
    }

    public void markAssociatedAttributes(int value) {
        if (this.getSource() instanceof EntityPart) {
            for (AttributePart attrPart : this.getEntityAttributes((EntityPart)this.getSource(), this.getAssociation().getSourceAttributes())) {
                attrPart.setSelected(value);
            }
        }
        if (this.getTarget() instanceof EntityPart) {
            for (AttributePart attrPart : this.getEntityAttributes((EntityPart)this.getTarget(), this.getAssociation().getTargetAttributes())) {
                attrPart.setSelected(value);
            }
        }
    }

    private List<AttributePart> getEntityAttributes(EntityPart source, List<ERDEntityAttribute> columns) {
        ArrayList<AttributePart> result = new ArrayList<AttributePart>();
        for (AttributePart attrPart : source.getChildren()) {
            if (!columns.contains(attrPart.getAttribute())) continue;
            result.add(attrPart);
        }
        return result;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagramPart().getDiagram(), (ERDObject)this.getAssociation());
        }
    }

    public void addBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        bendpoints.add(bendpointIndex, (Bendpoint)bendpoint);
        this.updateBendpoints(bendpoints);
    }

    public void removeBendpoint(int bendpointIndex) {
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.remove(bendpointIndex);
            this.updateBendpoints(bendpoints);
        }
    }

    public void moveBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.set(bendpointIndex, (Bendpoint)bendpoint);
            this.updateBendpoints(bendpoints);
        }
    }

    public List<Bendpoint> getBendpoints() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            return (List)constraint;
        }
        return Collections.emptyList();
    }

    private List<Bendpoint> getBendpointsCopy() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            List curList = (List)constraint;
            return new ArrayList<Bendpoint>(curList);
        }
        return new ArrayList<Bendpoint>();
    }

    private void updateBendpoints(List<Bendpoint> bendpoints) {
        this.getConnectionFigure().setRoutingConstraint(bendpoints);
    }

    public String toString() {
        return String.valueOf(((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName()) + " " + ((DBSEntityAssociation)this.getAssociation().getObject()).getName();
    }

    public static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private int radius = 5;
        private Point location = new Point();

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void setLocation(Point p) {
            this.location = p;
            Rectangle bounds = new Rectangle(this.location.x - this.radius, this.location.y - this.radius, this.radius * 2, this.radius * 2);
            this.setBounds(bounds);
        }

        public void setReferencePoint(Point p) {
            double d = Math.sqrt(Math.pow(this.location.x - p.x, 2.0) + Math.pow(this.location.y - p.y, 2.0));
            if (d < (double)this.radius) {
                return;
            }
            double k = (d - (double)this.radius) / d;
            double longx = Math.abs(p.x - this.location.x);
            double longy = Math.abs(p.y - this.location.y);
            double shortx = k * longx;
            double shorty = k * longy;
            int rx = this.location.x < p.x ? p.x - (int)shortx : p.x + (int)shortx;
            int ry = this.location.y > p.y ? p.y + (int)shorty : p.y - (int)shorty;
            this.setBounds(new Rectangle(rx - this.radius, ry - this.radius, (int)((double)this.radius * 2.5), (int)((double)this.radius * 2.5)));
        }
    }

    public static class RhombusDecoration
    extends PolygonDecoration {
        private static PointList GEOMETRY = new PointList();

        static {
            GEOMETRY.addPoint(0, 0);
            GEOMETRY.addPoint(-1, 1);
            GEOMETRY.addPoint(-2, 0);
            GEOMETRY.addPoint(-1, -1);
        }

        public RhombusDecoration() {
            this.setTemplate(GEOMETRY);
            this.setFill(true);
            this.setScale(5.0, 5.0);
        }
    }
}

