/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentXML;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;

public class OracleContentXML
extends JDBCContentXML {
    OracleContentXML(DBCExecutionContext executionContext, SQLXML xml) {
        super(executionContext, xml);
    }

    protected OracleContentXML createNewContent() {
        return new OracleContentXML(this.executionContext, null);
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        block13: {
            try {
                if (this.storage != null) {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream streamReader = this.storage.getContentStream();){
                        Object xmlObject = this.createXmlObject(session, streamReader);
                        preparedStatement.setObject(paramIndex, xmlObject);
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                preparedStatement.setNull(paramIndex, 2009, columnType.getTypeName());
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
            catch (IOException e) {
                throw new DBCException("IO error while reading XML", (Throwable)e);
            }
        }
    }

    private Object createXmlObject(JDBCSession session, InputStream stream) throws DBCException {
        try {
            return BeanUtils.invokeStaticMethod((Class)DBUtils.getDriverClass((DBPDataSource)this.executionContext.getDataSource(), (String)"oracle.xdb.XMLType"), (String)"createXML", (Class[])new Class[]{Connection.class, InputStream.class}, (Object[])new Object[]{session.getOriginal(), stream});
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        catch (Throwable e) {
            throw new DBCException("Internal error when creating XMLType", e, this.executionContext);
        }
    }
}

