/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDObject;
import org.jkiss.dbeaver.erd.ui.ERDUIUtils;
import org.jkiss.dbeaver.erd.ui.command.AttributeCheckCommand;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.part.PropertyAwarePart;
import org.jkiss.dbeaver.erd.ui.policy.AttributeConnectionEditPolicy;
import org.jkiss.dbeaver.erd.ui.policy.AttributeDragAndDropEditPolicy;

public class AttributePart
extends PropertyAwarePart {
    public static final String PROP_CHECKED = "CHECKED";

    public boolean isSelectable() {
        return true;
    }

    public ERDEntityAttribute getAttribute() {
        return (ERDEntityAttribute)this.getModel();
    }

    public ERDEntity getEntity() {
        return (ERDEntity)this.getParent().getModel();
    }

    public String getAttributeLabel() {
        return ERDUIUtils.getFullAttributeLabel(this.getDiagram(), this.getAttribute(), false);
    }

    protected AttributeItemFigure createFigure() {
        return new AttributeItemFigure(this);
    }

    public AttributeItemFigure getFigure() {
        return (AttributeItemFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        if (this.isLayoutEnabled() && this.getEditPolicy("ContainerEditPolicy") == null && this.isColumnDragAndDropSupported()) {
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new AttributeConnectionEditPolicy(this));
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new AttributeDragAndDropEditPolicy(this));
        }
        this.getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagram(), (ERDObject)this.getAttribute());
        } else {
            this.getDiagram().getModelAdapter().performPartRequest((EditPart)this, request);
        }
    }

    public AttributeCheckCommand createAttributeCheckCommand(boolean newChecked) {
        return new AttributeCheckCommand<AttributePart>(this, newChecked);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EditableLabel columnLabel = this.getFigure().getLabel();
        columnLabel.setSelected(value != 0);
        columnLabel.repaint();
    }

    public void handleNameChange() {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(0);
        figure.revalidate();
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        AttributeItemFigure figure = this.getFigure();
        figure.updateLabels();
        this.setSelected(2);
        figure.revalidate();
    }

    protected void refreshVisuals() {
        this.getFigure().updateLabels();
    }

    public DragTracker getDragTracker(Request request) {
        DragEditPartsTracker dragTracker = new DragEditPartsTracker((EditPart)this);
        dragTracker.setDefaultCursor(SharedCursors.CURSOR_TREE_MOVE);
        return dragTracker;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    protected void registerVisuals() {
        super.registerVisuals();
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.put(this.getFigure().getCheckBox(), this);
        visualPartMap.put(this.getFigure().getLabel(), this);
    }

    protected void unregisterVisuals() {
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.remove((Object)this.getFigure().getLabel());
        visualPartMap.remove((Object)this.getFigure().getCheckBox());
        super.unregisterVisuals();
    }

    public String toString() {
        return String.valueOf(ERDUIMessages.column_.trim()) + " " + this.getAttribute().getLabelText();
    }
}

