/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data.type;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.data.type.PostgreTypeHandler;
import org.jkiss.utils.CommonUtils;

public class PostgreNumericTypeHandler
extends PostgreTypeHandler {
    public static final PostgreNumericTypeHandler INSTANCE = new PostgreNumericTypeHandler();
    private static final int NUMERIC_MASK_PRECISION = -65536;
    private static final int NUMERIC_MASK_SCALE = 65535;

    private PostgreNumericTypeHandler() {
    }

    @Override
    public int getTypeModifiers(@NotNull PostgreDataType type, @NotNull String typeName, @NotNull String[] typmod) throws DBException {
        switch (typmod.length) {
            case 0: {
                return -1;
            }
            case 1: {
                return PostgreNumericTypeHandler.getNumberModifiers(CommonUtils.toInt((Object)typmod[0]), 0);
            }
            case 2: {
                return PostgreNumericTypeHandler.getNumberModifiers(CommonUtils.toInt((Object)typmod[0]), CommonUtils.toInt((Object)typmod[1]));
            }
        }
        return super.getTypeModifiers(type, typeName, typmod);
    }

    @Override
    @NotNull
    public String getTypeModifiersString(@NotNull PostgreDataType type, int typmod) {
        StringBuilder sb = new StringBuilder();
        if (typmod > 0) {
            Integer precision = this.getTypePrecision(type, typmod);
            Integer scale = this.getTypeScale(type, typmod);
            if (precision != null && precision > 0) {
                sb.append('(').append(precision);
                if (scale != null && scale > 0) {
                    sb.append(", ").append(scale);
                }
                sb.append(')');
            }
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public Integer getTypePrecision(@NotNull PostgreDataType type, int typmod) {
        if (typmod < 0) {
            return null;
        }
        return (typmod & 0xFFFF0000) >> 16;
    }

    @Override
    @Nullable
    public Integer getTypeScale(@NotNull PostgreDataType type, int typmod) {
        if (typmod < 0) {
            return null;
        }
        return (typmod & 0xFFFF) - 4;
    }

    private static int getNumberModifiers(int precision, int scale) throws DBException {
        if (precision < 1 || precision > 1000) {
            throw new DBException("Numeric precision " + precision + " must be between 1 and 1000");
        }
        if (scale < 0 || scale > precision) {
            throw new DBException("Numeric scale " + scale + " must be between 0 and " + precision);
        }
        return precision << 16 | scale + 4;
    }
}

