/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExecutionContext;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class PostgreStructureAssistant
extends JDBCStructureAssistant<PostgreExecutionContext> {
    private final PostgreDataSource dataSource;

    public PostgreStructureAssistant(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_CONSTRAINT, RelationalObjectType.TYPE_PROCEDURE, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_DATA_TYPE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE, RelationalObjectType.TYPE_PROCEDURE};
    }

    protected void findObjectsByMask(@NotNull PostgreExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws DBException, SQLException {
        PostgreDatabase database;
        DBSObject parentObject = params.getParentObject();
        PostgreSchema ownerSchema = parentObject instanceof PostgreSchema ? (PostgreSchema)parentObject : null;
        PostgreDataSource dataSource = (PostgreDataSource)session.getDataSource();
        PostgreDatabase postgreDatabase = database = parentObject instanceof PostgreObject ? ((PostgreObject)parentObject).getDatabase() : executionContext.getDefaultCatalog();
        if (database == null) {
            database = dataSource.getDefaultInstance();
        }
        ArrayList<PostgreSchema> nsList = new ArrayList<PostgreSchema>();
        if (ownerSchema != null) {
            nsList.add(0, ownerSchema);
        } else if (!params.isGlobalSearch()) {
            for (String sn : executionContext.getSearchPath()) {
                PostgreSchema schema = database.getSchema(session.getProgressMonitor(), PostgreUtils.getRealSchemaName(database, sn));
                if (schema == null) continue;
                nsList.add(schema);
            }
            PostgreSchema pgCatalog = database.getCatalogSchema(session.getProgressMonitor());
            if (pgCatalog != null) {
                nsList.add(pgCatalog);
            }
        } else {
            DBSObjectFilter schemaFilter = dataSource.getContainer().getObjectFilter(PostgreSchema.class, (DBSObject)database, true);
            if (schemaFilter != null && schemaFilter.isEnabled()) {
                for (PostgreSchema schema : database.getSchemas(session.getProgressMonitor())) {
                    if (!schemaFilter.matches(schema.getName())) continue;
                    nsList.add(schema);
                }
            }
        }
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, database, nsList, params, references);
        } else if (objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            this.findConstraintsByMask(session, database, nsList, params, references);
        } else if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, database, nsList, params, references);
        } else if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, database, nsList, params, references);
        }
    }

    private void findTablesByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable List<PostgreSchema> schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = PostgreStructureAssistant.buildFindQuery("pc.oid,pc.relname,pc.relnamespace,pc.relkind", "pg_catalog.pg_class pc", "pc.relkind in('r','v','m')", params.isSearchInComments(), "pc.relname", params.isCaseSensitive(), "obj_description(pc.oid, 'pg_class')", schema, "pc.relnamespace", "pc.relname", params.getMaxResults() - objects.size());
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schema);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                    PostgreClass.RelKind tableType = PostgreClass.RelKind.valueOf(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind"));
                    final PostgreSchema tableSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (tableSchema == null) {
                        log.debug((Object)("Can't resolve table '" + tableName + "' - owner schema " + schemaId + " not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(tableName, tableSchema, null, tableType == PostgreClass.RelKind.r ? PostgreTable.class : (tableType == PostgreClass.RelKind.v ? PostgreView.class : PostgreMaterializedView.class), RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = tableSchema.getTable(monitor, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in schema '" + tableSchema.getName() + "'");
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable List<PostgreSchema> schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = PostgreStructureAssistant.buildFindQuery("pp.oid, pp.*", "pg_catalog.pg_proc pp", "pp.proname NOT LIKE '\\_%'", params.isSearchInComments(), "pp.proname", params.isCaseSensitive(), "obj_description(pp.oid, 'pg_proc')", schema, "pp.pronamespace", "pp.proname", params.getMaxResults() - objects.size());
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schema);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"pronamespace");
                    final String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proname");
                    final long procId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final PostgreSchema procSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (procSchema == null) {
                        log.debug((Object)("Procedure's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    PostgreProcedure proc = new PostgreProcedure(monitor, procSchema, (ResultSet)dbResult);
                    objects.add((DBSObjectReference)new AbstractObjectReference(procName, procSchema, null, PostgreProcedure.class, RelationalObjectType.TYPE_PROCEDURE, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)procSchema)) + "." + proc.getOverloadedName()){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreProcedure procedure = procSchema.getProcedure(monitor, procId);
                            if (procedure == null) {
                                throw new DBException("Procedure '" + procName + "' not found in schema '" + procSchema.getName() + "'");
                            }
                            return procedure;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable List<PostgreSchema> schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = PostgreStructureAssistant.buildFindQuery("pc.oid, pc.conname, pc.connamespace", "pg_catalog.pg_constraint pc", null, params.isSearchInComments(), "pc.conname", params.isCaseSensitive(), "obj_description(pc.oid, 'pg_constraint')", schema, "pc.connamespace", "pc.conname", params.getMaxResults() - objects.size());
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schema);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"connamespace");
                    final long constrId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
                    final String constrName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"conname");
                    final PostgreSchema constrSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Constraint's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(constrName, constrSchema, null, PostgreTableConstraintBase.class, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableConstraintBase constraint = (PostgreTableConstraintBase)PostgreUtils.getObjectById(monitor, constrSchema.getConstraintCache(), constrSchema, constrId);
                            if (constraint == null) {
                                throw new DBException("Constraint '" + constrName + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return constraint;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable List<PostgreSchema> schema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> objects) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = PostgreStructureAssistant.buildFindQuery("x.attname,x.attrelid,x.atttypid,c.relnamespace", "pg_catalog.pg_attribute x, pg_catalog.pg_class c", "c.oid=x.attrelid", params.isSearchInComments(), "x.attname", params.isCaseSensitive(), "col_description(c.oid, x.attnum)", schema, "c.relnamespace", "x.attname", params.getMaxResults() - objects.size());
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
            PostgreStructureAssistant.fillParams(dbStat, params, schema);
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                    final long tableId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"attrelid");
                    final String attributeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"attname");
                    final PostgreSchema constrSchema = database.getSchema(session.getProgressMonitor(), schemaId);
                    if (constrSchema == null) {
                        log.debug((Object)("Attribute's schema '" + schemaId + "' not found"));
                        continue;
                    }
                    objects.add((DBSObjectReference)new AbstractObjectReference(attributeName, constrSchema, null, PostgreTableBase.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            PostgreTableBase table = (PostgreTableBase)PostgreUtils.getObjectById(monitor, constrSchema.getTableCache(), constrSchema, tableId);
                            if (table == null) {
                                throw new DBException("Table '" + tableId + "' not found in schema '" + constrSchema.getName() + "'");
                            }
                            return table.getAttribute(monitor, attributeName);
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static String buildFindQuery(@NotNull String select, @NotNull String from, @Nullable String where, boolean searchInComments, @NotNull String name, boolean caseSensitive, @NotNull String descriptionClause, @Nullable List<PostgreSchema> schema, @NotNull String namespace, @NotNull String orderBy, int maxResults) {
        StringBuilder sql = new StringBuilder("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ");
        if (where != null) {
            sql.append(where).append(" AND ");
        }
        if (searchInComments) {
            sql.append("(");
        }
        String likeClause = caseSensitive ? " LIKE ?" : " ILIKE ?";
        sql.append(name).append(likeClause).append(" ");
        if (searchInComments) {
            sql.append("OR ").append(descriptionClause).append(likeClause).append(") ");
        }
        if (!CommonUtils.isEmpty(schema)) {
            sql.append("AND ").append(namespace).append(" IN (").append(SQLUtils.generateParamList((int)schema.size())).append(") ");
        }
        sql.append("ORDER BY ").append(orderBy).append(" LIMIT ").append(maxResults);
        return sql.toString();
    }

    private static void fillParams(@NotNull JDBCPreparedStatement statement, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @Nullable List<PostgreSchema> schema) throws SQLException {
        statement.setString(1, params.getMask());
        int arrayParamIdx = 2;
        if (params.isSearchInComments()) {
            statement.setString(2, params.getMask());
            ++arrayParamIdx;
        }
        if (!CommonUtils.isEmpty(schema)) {
            PostgreUtils.setArrayParameter(statement, arrayParamIdx, schema);
        }
    }
}

