/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;

public class MySQLPartition
extends JDBCTableObject<MySQLTable>
implements DBSTablePartition {
    private static final String CAT_STATS = "Statistics";
    private MySQLPartition parent;
    private List<MySQLPartition> subPartitions;
    private int position;
    private String method;
    private String expression;
    private String description;
    private long tableRows;
    private long avgRowLength;
    private long dataLength;
    private long maxDataLength;
    private long indexLength;
    private long dataFree;
    private Date createTime;
    private Date updateTime;
    private Date checkTime;
    private long checksum;
    private String comment;
    private String nodegroup;

    protected MySQLPartition(MySQLTable mySQLTable, MySQLPartition parent, String name, ResultSet dbResult) {
        super((JDBCTable)mySQLTable, name, true);
        this.parent = parent;
        if (parent != null) {
            parent.addSubPartitions(this);
        }
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)(parent == null ? "PARTITION_ORDINAL_POSITION" : "SUBPARTITION_ORDINAL_POSITION"));
        this.method = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(parent == null ? "PARTITION_METHOD" : "SUBPARTITION_METHOD"));
        this.expression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(parent == null ? "PARTITION_EXPRESSION" : "SUBPARTITION_EXPRESSION"));
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_DESCRIPTION");
        this.tableRows = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TABLE_ROWS");
        this.avgRowLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"AVG_ROW_LENGTH");
        this.dataLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"DATA_LENGTH");
        this.maxDataLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_DATA_LENGTH");
        this.indexLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INDEX_LENGTH");
        this.dataFree = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"DATA_FREE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.updateTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"UPDATE_TIME");
        this.checkTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CHECK_TIME");
        this.checksum = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CHECKSUM");
        this.comment = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_COMMENT");
        this.nodegroup = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NODEGROUP");
    }

    protected MySQLPartition(JDBCTableObject<MySQLTable> source) {
        super(source);
    }

    protected MySQLPartition(DBRProgressMonitor monitor, MySQLTable table, MySQLPartition source) {
        super((JDBCTable)table, source.getName(), false);
        this.position = source.position;
        this.method = source.method;
        this.expression = source.expression;
        this.description = source.description;
        this.comment = source.comment;
        this.nodegroup = source.nodegroup;
    }

    private void addSubPartitions(MySQLPartition partition) {
        if (this.subPartitions == null) {
            this.subPartitions = new ArrayList<MySQLPartition>();
        }
        this.subPartitions.add(partition);
    }

    public MySQLPartition getParent() {
        return this.parent;
    }

    public List<MySQLPartition> getSubPartitions() {
        return this.subPartitions;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)((MySQLTable)this.getTable()).getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, order=2)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=3)
    public String getMethod() {
        return this.method;
    }

    @Property(viewable=true, order=4)
    public String getExpression() {
        return this.expression;
    }

    @Property(viewable=true, order=5)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=16)
    public String getComment() {
        return this.comment;
    }

    @Property(viewable=true, order=17)
    public String getNodegroup() {
        return this.nodegroup;
    }

    @Property(category="Statistics", viewable=true, order=6)
    public long getTableRows() {
        return this.tableRows;
    }

    @Property(category="Statistics", viewable=true, order=7)
    public long getAvgRowLength() {
        return this.avgRowLength;
    }

    @Property(category="Statistics", viewable=true, order=8)
    public long getDataLength() {
        return this.dataLength;
    }

    @Property(category="Statistics", viewable=true, order=9)
    public long getMaxDataLength() {
        return this.maxDataLength;
    }

    @Property(category="Statistics", viewable=true, order=10)
    public long getIndexLength() {
        return this.indexLength;
    }

    @Property(category="Statistics", viewable=true, order=11)
    public long getDataFree() {
        return this.dataFree;
    }

    @Property(category="Statistics", viewable=false, order=12)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(category="Statistics", viewable=false, order=13)
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Property(category="Statistics", viewable=false, order=14)
    public Date getCheckTime() {
        return this.checkTime;
    }

    @Property(category="Statistics", viewable=true, order=15)
    public long getChecksum() {
        return this.checksum;
    }
}

