/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ToolTipHelper
extends PopUpHelper {
    private Timer timer;
    private IFigure currentTipSource;
    private int hideDelay = 5000;

    public ToolTipHelper(Control c) {
        super(c, 16388);
        this.getShell().setBackground(ColorConstants.tooltipBackground);
        this.getShell().setForeground(ColorConstants.tooltipForeground);
    }

    private Point computeWindowLocation(IFigure tip, int eventX, int eventY) {
        Rectangle clientArea = this.control.getDisplay().getClientArea();
        Point preferredLocation = new Point(eventX, eventY + 26);
        Dimension tipSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
        if (preferredLocation.y + tipSize.height > clientArea.height) {
            preferredLocation.y = eventY - tipSize.height;
        }
        if (preferredLocation.x + tipSize.width > clientArea.width) {
            preferredLocation.x -= preferredLocation.x + tipSize.width - clientArea.width;
        }
        return preferredLocation;
    }

    public void setHideDelay(int hideDelay) {
        this.hideDelay = hideDelay;
    }

    public void displayToolTipNear(IFigure hoverSource, IFigure tip, int eventX, int eventY) {
        if (tip != null && hoverSource != this.currentTipSource) {
            this.getLightweightSystem().setContents(tip);
            Point displayPoint = this.computeWindowLocation(tip, eventX, eventY);
            Dimension shellSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
            this.setShellBounds(displayPoint.x, displayPoint.y, shellSize.width, shellSize.height);
            this.show();
            this.currentTipSource = hoverSource;
            this.timer = new Timer(true);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    Display.getDefault().asyncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$0(this.this$1).hide();
                        }
                    });
                }

                static /* synthetic */ ToolTipHelper access$0(1 var0) {
                    return var0.ToolTipHelper.this;
                }
            }, this.hideDelay);
        }
    }

    public void dispose() {
        if (this.isShowing()) {
            this.hide();
        }
        this.getShell().dispose();
    }

    protected void hide() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.hide();
    }

    protected void hookShellListeners() {
        this.getShell().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ToolTipHelper.this.hide();
                ToolTipHelper.this.currentTipSource = null;
            }
        });
    }

    public void updateToolTip(IFigure figureUnderMouse, IFigure tip, int eventX, int eventY) {
        if (figureUnderMouse == null && this.isShowing()) {
            this.hide();
        }
        if (this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.hide();
            this.displayToolTipNear(figureUnderMouse, tip, eventX, eventY);
        } else if (!this.isShowing() && figureUnderMouse != this.currentTipSource) {
            this.currentTipSource = null;
        }
    }
}

