/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import org.jkiss.dbeaver.model.DBPDataKind;

public enum FireBirdFieldType {
    SMALLINT(7, 5, DBPDataKind.NUMERIC, "SMALLINT"),
    INTEGER(8, 4, DBPDataKind.NUMERIC, "INTEGER"),
    FLOAT(10, 6, DBPDataKind.NUMERIC, "FLOAT"),
    DATE(12, 91, DBPDataKind.DATETIME, "DATE"),
    TIME(13, 92, DBPDataKind.DATETIME, "TIME"),
    CHAR(14, 1, DBPDataKind.STRING, "CHAR"),
    BIGINT(16, -5, DBPDataKind.NUMERIC, "BIGINT"),
    BOOLEAN(23, 16, DBPDataKind.BOOLEAN, "BOOLEAN"),
    DOUBLE_PRECISION(27, 8, DBPDataKind.NUMERIC, "DOUBLE PRECISION"),
    TIMESTAMP(35, 93, DBPDataKind.DATETIME, "TIMESTAMP"),
    VARCHAR(37, 12, DBPDataKind.STRING, "VARCHAR"),
    BLOB(261, 2004, DBPDataKind.CONTENT, "BLOB");

    private final int typeID;
    private final int valueType;
    private final DBPDataKind dataKind;
    private final String name;

    private FireBirdFieldType(int typeID, int valueType, DBPDataKind dataKind, String name) {
        this.typeID = typeID;
        this.valueType = valueType;
        this.dataKind = dataKind;
        this.name = name;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public int getValueType() {
        return this.valueType;
    }

    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    public String getName() {
        return this.name;
    }

    public static FireBirdFieldType getById(int id) {
        FireBirdFieldType[] fireBirdFieldTypeArray = FireBirdFieldType.values();
        int n = fireBirdFieldTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FireBirdFieldType ft = fireBirdFieldTypeArray[n2];
            if (ft.getTypeID() == id) {
                return ft;
            }
            ++n2;
        }
        return null;
    }
}

