/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexString;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;

public class DB2SQLDialect
extends JDBCSQLDialect {
    private static final Log log = Log.getLog(DB2SQLDialect.class);
    public static final String[] EXEC_KEYWORDS = new String[]{"call"};
    private static final String[][] DB2_BEGIN_END_BLOCK = new String[0][];
    private static final boolean LOAD_ROUTINES_FROM_SYSCAT = false;

    public DB2SQLDialect() {
        super("DB2 LUW", "db2_luw");
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addSQLKeywords(Arrays.asList(DB2Constants.ADVANCED_KEYWORDS));
        this.addFunctions(Arrays.asList(DB2Constants.ROUTINES));
        this.turnFunctionIntoKeyword("TRUNCATE");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    protected void loadFunctions(JDBCSession session, JDBCDatabaseMetaData metaData, Set<String> allFunctions) throws DBException, SQLException {
        if (allFunctions.isEmpty()) {
            super.loadFunctions(session, metaData, allFunctions);
        }
    }

    @Nullable
    public String getDualTableName() {
        return "SYSIBM.SYSDUMMY1";
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexString.INSTANCE;
    }

    public String[][] getBlockBoundStrings() {
        return DB2_BEGIN_END_BLOCK;
    }

    public String getScriptDelimiterRedefiner() {
        return "DELIMITER";
    }
}

