/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeFilter;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class ResultSetDataContainer
implements DBSDataContainer,
DBPContextProvider,
IAdaptable,
DBDAttributeFilter {
    private static final Log log = Log.getLog(ResultSetDataContainer.class);
    private final IResultSetController controller;
    private final DBSDataContainer dataContainer;
    private final ResultSetModel model;
    private ResultSetDataContainerOptions options;
    private boolean filterAttributes;

    public ResultSetDataContainer(IResultSetController controller, ResultSetDataContainerOptions options) {
        this.controller = controller;
        this.dataContainer = controller.getDataContainer();
        this.model = controller.getModel();
        this.options = options;
    }

    public String getDescription() {
        return this.dataContainer.getDescription();
    }

    public DBSObject getParentObject() {
        return this.dataContainer.getParentObject();
    }

    public DBPDataSource getDataSource() {
        return this.dataContainer.getDataSource();
    }

    public int getSupportedFeatures() {
        return 1;
    }

    public ResultSetDataContainerOptions getOptions() {
        return this.options;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBCStatistics readData(DBCExecutionSource source, DBCSession session, DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        this.filterAttributes = this.proceedSelectedColumnsOnly(flags);
        if (!this.filterAttributes && !this.proceedSelectedRowsOnly(flags)) {
            return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags, fetchSize);
        }
        long startTime = System.currentTimeMillis();
        DBCStatistics statistics = new DBCStatistics();
        statistics.setExecuteTime(System.currentTimeMillis() - startTime);
        ModelResultSet resultSet = new ModelResultSet(session, flags);
        long resultCount = 0L;
        try {
            dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
            while (!session.getProgressMonitor().isCanceled() && resultSet.nextRow()) {
                if (!this.proceedSelectedRowsOnly(flags) || this.options.getSelectedRows().contains(resultCount)) {
                    dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                }
                ++resultCount;
            }
        }
        finally {
            try {
                dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
            }
            catch (DBCException e) {
                log.error((Object)"Error while finishing result set fetch", (Throwable)e);
            }
            resultSet.close();
            dataReceiver.close();
        }
        statistics.setFetchTime(System.currentTimeMillis() - startTime);
        statistics.setRowsFetched(resultCount);
        return statistics;
    }

    private boolean proceedSelectedColumnsOnly(long flags) {
        return (flags & 8L) != 0L && !CommonUtils.isEmpty(this.options.getSelectedColumns());
    }

    private boolean proceedSelectedRowsOnly(long flags) {
        return (flags & 4L) != 0L && !CommonUtils.isEmpty(this.options.getSelectedRows());
    }

    public long countData(DBCExecutionSource source, DBCSession session, DBDDataFilter dataFilter, long flags) throws DBCException {
        if (this.proceedSelectedRowsOnly(flags)) {
            return this.options.getSelectedRows().size();
        }
        if (this.proceedSelectedColumnsOnly(flags)) {
            return this.model.getRowCount();
        }
        return this.dataContainer.countData(source, session, dataFilter, flags);
    }

    public String getName() {
        return this.dataContainer.getName();
    }

    public boolean isPersisted() {
        return this.dataContainer.isPersisted();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.dataContainer)) {
            return adapter.cast(this.dataContainer);
        }
        return null;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.controller.getExecutionContext();
    }

    public DBDAttributeBinding[] filterAttributeBindings(DBDAttributeBinding[] attributes) {
        DBDDataFilter dataFilter = this.model.getDataFilter();
        ArrayList<DBDAttributeBinding> filtered = new ArrayList<DBDAttributeBinding>();
        DBDAttributeBinding[] dBDAttributeBindingArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            DBDAttributeConstraint ac = dataFilter.getConstraint(attr);
            if (!(ac != null && !ac.isVisible() || this.filterAttributes && !this.options.getSelectedColumns().contains(attr.getName()))) {
                filtered.add(attr);
            }
            ++n2;
        }
        filtered.sort((o1, o2) -> {
            DBDAttributeConstraint c1 = dataFilter.getConstraint((DBSAttributeBase)o1, true);
            DBDAttributeConstraint c2 = dataFilter.getConstraint((DBSAttributeBase)o2, true);
            return c1 == null || c2 == null ? 0 : c1.getVisualPosition() - c2.getVisualPosition();
        });
        return filtered.toArray(new DBDAttributeBinding[0]);
    }

    private class ModelResultSet
    implements DBCResultSet {
        private final DBCSession session;
        private final long flags;
        private ResultSetRow curRow;

        ModelResultSet(DBCSession session, long flags) {
            this.session = session;
            this.flags = flags;
        }

        public DBCSession getSession() {
            return this.session;
        }

        public DBCStatement getSourceStatement() {
            return null;
        }

        public Object getAttributeValue(int index) throws DBCException {
            return ResultSetDataContainer.this.model.getCellValue(ResultSetDataContainer.this.model.getVisibleAttribute(index), this.curRow);
        }

        public Object getAttributeValue(String name) throws DBCException {
            DBDAttributeBinding attr = (DBDAttributeBinding)DBUtils.findObject(ResultSetDataContainer.this.model.getVisibleAttributes(), (String)name);
            if (attr == null) {
                throw new DBCException("Attribute '" + name + "' not found");
            }
            return ResultSetDataContainer.this.model.getCellValue(attr, this.curRow);
        }

        public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
            return null;
        }

        public DBDValueMeta getRowMeta() throws DBCException {
            return null;
        }

        public boolean nextRow() throws DBCException {
            if (this.curRow == null) {
                if (ResultSetDataContainer.this.model.getRowCount() == 0) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(0);
            } else {
                if (this.curRow.getVisualNumber() >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(this.curRow.getVisualNumber() + 1);
            }
            return true;
        }

        public boolean moveTo(int position) throws DBCException {
            if (position >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                return false;
            }
            this.curRow = ResultSetDataContainer.this.model.getRow(position);
            return true;
        }

        @NotNull
        public DBCResultSetMetaData getMeta() throws DBCException {
            List<DBDAttributeBinding> attributes = ResultSetDataContainer.this.model.getVisibleAttributes();
            ArrayList<DBCAttributeMetaData> meta = new ArrayList<DBCAttributeMetaData>(attributes.size());
            for (DBDAttributeBinding attribute : attributes) {
                DBCAttributeMetaData metaAttribute = attribute.getMetaAttribute();
                if (metaAttribute == null) continue;
                meta.add(metaAttribute);
            }
            return new CustomResultSetMeta(meta);
        }

        public String getResultSetName() throws DBCException {
            return "ClientResults";
        }

        public Object getFeature(String name) {
            if ("local".equals(name)) {
                return true;
            }
            return null;
        }

        public void close() {
        }

        private class CustomResultSetMeta
        extends LocalResultSetMeta {
            public CustomResultSetMeta(List<DBCAttributeMetaData> meta) {
                super(meta);
            }
        }
    }
}

