/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.hana.model.HANADataSource;
import org.jkiss.dbeaver.ext.hana.model.HANAObjectType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class HANAStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private HANADataSource dataSource;

    public HANAStructureAssistant(HANADataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.PROCEDURE, HANAObjectType.SYNONYM, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN};
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.PROCEDURE, HANAObjectType.SYNONYM};
    }

    protected void findObjectsByMask(JDBCExecutionContext executionContext, JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> result) throws DBException, SQLException {
        GenericSchema parentSchema;
        GenericSchema genericSchema = parentSchema = parentObject instanceof GenericSchema ? (GenericSchema)parentObject : null;
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW) {
            this.findViewsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW_COLUMN) {
            this.findViewColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
        }
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext executionContext, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        ArrayList<DBSObjectReference> result = new ArrayList<DBSObjectReference>();
        List<DBSObjectType> objectTypesList = Arrays.asList(objectTypes);
        StringBuilder objectTypeClause = new StringBuilder(100);
        GenericSchema parentSchema = parentObject instanceof GenericSchema ? (GenericSchema)parentObject : (globalSearch || !(executionContext instanceof GenericExecutionContext) ? null : ((GenericExecutionContext)executionContext).getDefaultSchema());
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by mask");){
                if (objectTypesList.contains((Object)HANAObjectType.TABLE) || objectTypesList.contains((Object)HANAObjectType.VIEW) || objectTypesList.contains((Object)HANAObjectType.PROCEDURE) || objectTypesList.contains((Object)HANAObjectType.SYNONYM)) {
                    DBSObjectType[] dBSObjectTypeArray = objectTypes;
                    int n = objectTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBSObjectType objectType = dBSObjectTypeArray[n2];
                        if (objectTypeClause.length() > 0) {
                            objectTypeClause.append(",");
                        }
                        objectTypeClause.append("'").append(objectType.getTypeName()).append("'");
                        ++n2;
                    }
                    if (objectTypeClause.length() == 0) {
                        objectTypeClause.append("'TABLE', 'VIEW', 'SYNONYM', 'PROCEDURE'");
                    }
                    this.searchNotColumnObjects(session, parentSchema, objectNameMask, caseSensitive, maxResults, result, objectTypeClause.toString());
                }
                if (objectTypesList.contains(RelationalObjectType.TYPE_TABLE_COLUMN)) {
                    this.findTableColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
                }
                if (objectTypesList.contains(RelationalObjectType.TYPE_VIEW_COLUMN)) {
                    this.findViewColumnsByMask(session, parentSchema, objectNameMask, caseSensitive, maxResults, result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
        return result;
    }

    private void searchNotColumnObjects(final JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result, String objectTypeClause) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, OBJECT_NAME, OBJECT_TYPE FROM SYS.OBJECTS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " OBJECT_NAME LIKE ?" : " UPPER(OBJECT_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " AND OBJECT_TYPE IN (" + objectTypeClause + ")";
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, OBJECT_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var11_12 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var14_17 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    final String objectTypeName = dbResult.getString(3);
                    final HANAObjectType objectType = HANAObjectType.valueOf(objectTypeName);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) {
                        log.debug((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, null, objectType.getTypeClass(), objectType){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            DBSObject object = objectType.findObject(session.getProgressMonitor(), (GenericObjectContainer)schema, objectName);
                            if (object == null) {
                                throw new DBException(String.valueOf(objectTypeName) + " '" + objectName + "' not found in schema '" + schema.getName() + "'");
                            }
                            return object;
                        }

                        @NotNull
                        public String getFullyQualifiedName(DBPEvaluationContext context) {
                            if (objectType == HANAObjectType.SYNONYM && "PUBLIC".equals(schemaName)) {
                                return DBUtils.getQuotedIdentifier((DBPDataSource)HANAStructureAssistant.this.dataSource, (String)objectName);
                            }
                            return super.getFullyQualifiedName(context);
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTablesByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COMMENTS FROM SYS.TABLES WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " TABLE_NAME LIKE ?" : " UPPER(TABLE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, TABLE_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTable.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findViewsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COMMENTS FROM SYS.VIEWS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " VIEW_NAME LIKE ?" : " UPPER(VIEW_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, VIEW_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTable.class, RelationalObjectType.TYPE_VIEW){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, PROCEDURE_NAME FROM SYS.PROCEDURES WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " PROCEDURE_NAME LIKE ?" : " UPPER(PROCEDURE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, PROCEDURE_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = null;
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericProcedure object = ((GenericObjectContainer)this.getContainer()).getProcedure(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableColumnsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COLUMN_NAME, COMMENTS FROM SYS.TABLE_COLUMNS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, TABLE_NAME, COLUMN_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findViewColumnsByMask(JDBCSession session, GenericSchema parentSchema, String objectNameMask, boolean caseSensitive, int maxResults, List<DBSObjectReference> result) throws SQLException, DBException {
        String stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COLUMN_NAME, COMMENTS FROM SYS.VIEW_COLUMNS WHERE";
        stmt = String.valueOf(stmt) + (caseSensitive ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = String.valueOf(stmt) + " AND SCHEMA_NAME = ?";
        }
        stmt = String.valueOf(stmt) + " ORDER BY SCHEMA_NAME, VIEW_NAME, COLUMN_NAME LIMIT " + maxResults;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement(stmt);){
            dbStat.setString(1, caseSensitive ? objectNameMask : objectNameMask.toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                int numResults = maxResults;
                while (dbResult.next() && numResults-- > 0) {
                    GenericSchema schema;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference(objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

