/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.internal.workbench.swt.IEventLoopAdvisor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.ActivityPersistanceHelper;
import org.eclipse.ui.internal.EarlyStartupRunnable;
import org.eclipse.ui.internal.EditorHistory;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.ExtensionEventHandler;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.JFaceUtil;
import org.eclipse.ui.internal.LocalWorkingSetManager;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.SelectionConversionService;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.UILockListener;
import org.eclipse.ui.internal.UISynchronizer;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchConfigurer;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchIntroManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.activities.ws.WorkbenchActivitySupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.CommandImageService;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.WorkbenchCommandSupport;
import org.eclipse.ui.internal.contexts.ActiveContextSourceProvider;
import org.eclipse.ui.internal.contexts.ContextService;
import org.eclipse.ui.internal.contexts.WorkbenchContextSupport;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.help.WorkbenchHelpSystem;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.keys.show.ShowKeysListener;
import org.eclipse.ui.internal.menus.FocusControlSourceProvider;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.model.ContributionService;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.services.EvaluationService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.MenuSourceProvider;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.ServiceLocatorCreator;
import org.eclipse.ui.internal.services.SourceProviderService;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.splash.EclipseSplashHandler;
import org.eclipse.ui.internal.splash.SplashHandlerFactory;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.internal.testing.WorkbenchTestable;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.IContributionService;
import org.eclipse.ui.operations.IWorkbenchOperationSupport;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.testing.ContributionInfo;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.event.Event;
import org.osgi.util.tracker.ServiceTracker;

public final class Workbench
extends EventManager
implements IWorkbench,
org.eclipse.e4.ui.workbench.IWorkbench {
    public static final String WORKBENCH_AUTO_SAVE_JOB = "Workbench Auto-Save Job";
    private static final String WORKBENCH_AUTO_SAVE_BACKGROUND_JOB = "Workbench Auto-Save Background Job";
    public static final String MEMENTO_KEY = "memento";
    public static final String EDITOR_TAG = "Editor";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    public static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String CMD_DATA = "-data";
    private static final String CMD_VMARGS = "-vmargs";
    public static final String EARLY_STARTUP_FAMILY = "earlyStartup";
    public static final String DEFAULT_WORKBENCH_STATE_FILENAME = "workbench.xml";
    private static Workbench instance;
    private static WorkbenchTestable testableObject;
    private static boolean createSplash;
    private static AbstractSplashHandler splash;
    private Display display;
    private boolean workbenchAutoSave = true;
    private EditorHistory editorHistory;
    private boolean runEventLoop = true;
    private boolean isStarting = true;
    private boolean isClosing = false;
    private boolean windowsClosed = false;
    private int returnCode = 2;
    private WorkbenchAdvisor advisor;
    private WorkbenchConfigurer workbenchConfigurer;
    private ExtensionEventHandler extensionEventHandler;
    private int largeUpdates = 0;
    private final ServiceLocator serviceLocator;
    private ListenerList<IWorkbenchListener> workbenchListeners = new ListenerList(1);
    private ServiceRegistration workbenchService;
    private MApplication application;
    private IEclipseContext e4Context;
    private IEventBroker eventBroker;
    private IExtensionRegistry registry;
    boolean initializationDone = false;
    private WorkbenchWindow windowBeingCreated = null;
    private Listener backForwardListener;
    private Job autoSaveJob;
    private String id;
    private ServiceRegistration<?> e4WorkbenchService;
    private boolean applicationModelChanged = false;
    private IWorkbenchWindow windowWhileInit;
    private static ServiceTracker instanceAppContext;
    private ArrayList<MCommand> commandsToRemove = new ArrayList();
    private ArrayList<MCategory> categoriesToRemove = new ArrayList();
    private Map<String, MBindingContext> bindingContexts = new HashMap<String, MBindingContext>();
    private WorkbenchActivitySupport workbenchActivitySupport;
    private WorkbenchCommandSupport workbenchCommandSupport;
    private WorkbenchContextSupport workbenchContextSupport;
    private BindingManager bindingManager;
    private CommandManager commandManager;
    private ContextManager contextManager;
    private final IBindingManagerListener bindingManagerListener = bindingManagerEvent -> {
        if (bindingManagerEvent.isActiveBindingsChanged()) {
            this.updateActiveWorkbenchWindowMenuManager(true);
        }
    };
    private ActivityPersistanceHelper activityHelper;
    private WorkbenchIntroManager introManager;
    private IntroDescriptor introDescriptor;
    private IExtensionTracker tracker;
    private IRegistryChangeListener startupRegistryListener = event -> {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.ui", "startup");
        if (deltas.length == 0) {
            return;
        }
        String disabledPlugins = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        IExtensionDelta[] iExtensionDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            IExtension extension = delta.getExtension();
            if (delta.getKind() != 2 && !disabledPlugins.contains(extension.getContributor().getName())) {
                SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(extension));
            }
            ++n2;
        }
    };
    private MenuSourceProvider menuSourceProvider;

    static {
        createSplash = true;
    }

    private Workbench(Display display, final WorkbenchAdvisor advisor, MApplication app, IEclipseContext appContext) {
        this.advisor = Objects.requireNonNull(advisor);
        this.display = Objects.requireNonNull(display);
        this.application = app;
        this.e4Context = appContext;
        this.id = this.createId();
        if (instance != null && instance.isRunning()) {
            throw new IllegalStateException(WorkbenchMessages.Workbench_CreatingWorkbenchTwice);
        }
        instance = this;
        StartupThreading.setDisplay(display);
        this.eventBroker = (IEventBroker)this.e4Context.get(IEventBroker.class);
        this.registry = (IExtensionRegistry)this.e4Context.get(IExtensionRegistry.class);
        appContext.set(Workbench.class, (Object)this);
        appContext.set(IWorkbench.class, (Object)this);
        appContext.set(IEventLoopAdvisor.class, (Object)new IEventLoopAdvisor(){

            public void eventLoopIdle(Display display) {
                advisor.eventLoopIdle(display);
            }

            public void eventLoopException(Throwable exception) {
                advisor.eventLoopException(exception);
            }
        });
        this.extensionEventHandler = new ExtensionEventHandler(this);
        this.registry.addRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        ServiceLocatorCreator slc = new ServiceLocatorCreator();
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(null, null, () -> {
            Display display1 = this.getDisplay();
            if (display1 != null && !display1.isDisposed()) {
                MessageDialog.openInformation(null, (String)WorkbenchMessages.Workbench_NeedsClose_Title, (String)WorkbenchMessages.Workbench_NeedsClose_Message);
                this.close(1, true);
            }
        }, appContext);
        this.serviceLocator.registerService(IServiceLocatorCreator.class, slc);
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.services.IWorkbench", this, null, null, null, null, 0));
    }

    public static Workbench getInstance() {
        return instance;
    }

    public static int createAndRunWorkbench(Display display, WorkbenchAdvisor advisor) {
        int[] returnCode = new int[1];
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            boolean showProgress = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_PROGRESS_ON_STARTUP");
            String nlExtensions = Platform.getNLExtensions();
            if (nlExtensions.length() > 0) {
                ULocale.setDefault((ULocale.Category)ULocale.Category.FORMAT, (ULocale)new ULocale(String.valueOf(ULocale.getDefault((ULocale.Category)ULocale.Category.FORMAT).getBaseName()) + nlExtensions));
            }
            System.setProperty("applicationXMI", "org.eclipse.ui.workbench/LegacyIDE.e4xmi");
            Object obj = Workbench.getApplication(Platform.getCommandLineArgs());
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            if (!store.isDefault("LAYOUT_DIRECTION")) {
                int orientation = store.getInt("LAYOUT_DIRECTION");
                Window.setDefaultOrientation((int)orientation);
            }
            if (obj instanceof E4Application) {
                E4Application e4app = (E4Application)obj;
                E4Workbench e4Workbench = e4app.createE4Workbench(Workbench.getApplicationContext(), display);
                MApplication appModel = e4Workbench.getApplication();
                IEclipseContext context = e4Workbench.getContext();
                final Workbench workbench = new Workbench(display, advisor, appModel, context);
                Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
                ((Dictionary)properties).put("service.ranking", 0x7FFFFFFE);
                final ServiceRegistration[] registration = new ServiceRegistration[1];
                StartupMonitor startupMonitor = new StartupMonitor(){

                    public void applicationRunning() {
                        registration[0].unregister();
                        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                        int n = iWorkbenchWindowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                            IWorkbenchPage page = window.getActivePage();
                            if (page != null) {
                                ((WorkbenchPage)page).fireInitialPartVisibilityEvents();
                            }
                            ++n2;
                        }
                    }

                    public void update() {
                    }
                };
                registration[0] = FrameworkUtil.getBundle(WorkbenchPlugin.class).getBundleContext().registerService(StartupMonitor.class.getName(), (Object)startupMonitor, properties);
                StartupProgressBundleListener bundleListener = null;
                createSplash = WorkbenchPlugin.isSplashHandleSpecified();
                if (createSplash) {
                    Shell splashShell;
                    workbench.createSplashWrapper();
                    AbstractSplashHandler handler = Workbench.getSplash();
                    if (handler != null && (splashShell = handler.getSplash()) != null && !splashShell.isDisposed()) {
                        splashShell.setVisible(true);
                        splashShell.forceActive();
                    }
                    Workbench.spinEventQueueToUpdateSplash(display);
                    if (handler != null && showProgress) {
                        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)handler.getBundleProgressMonitor());
                        bundleListener = new StartupProgressBundleListener((IProgressMonitor)progressMonitor, display);
                        WorkbenchPlugin.getDefault().addBundleListener((BundleListener)bundleListener);
                    }
                }
                Workbench.setSearchContribution(appModel, true);
                nArray[0] = workbench.runUI();
                if (returnCode[0] == 0) {
                    if (bundleListener != null) {
                        WorkbenchPlugin.getDefault().removeBundleListener((BundleListener)bundleListener);
                    }
                    e4Workbench.createAndRunUI((MApplicationElement)e4Workbench.getApplication());
                }
                if (returnCode[0] != 2) {
                    Workbench.setSearchContribution(appModel, false);
                    e4app.saveModel();
                }
                if (e4Workbench.isRestart()) {
                    nArray[0] = 1;
                } else {
                    e4Workbench.close();
                    nArray[0] = workbench.returnCode;
                }
            }
        });
        return returnCode[0];
    }

    private static void setSearchContribution(MApplication app, boolean enabled) {
        for (MTrimContribution contribution : app.getTrimContributions()) {
            if (!"org.eclipse.ui.ide.application.trimcontribution.QuickAccess".contains(contribution.getElementId())) continue;
            contribution.setToBeRendered(enabled);
        }
    }

    static IApplicationContext getApplicationContext() {
        if (instanceAppContext == null) {
            instanceAppContext = new ServiceTracker(WorkbenchPlugin.getDefault().getBundleContext(), IApplicationContext.class.getName(), null);
            instanceAppContext.open();
        }
        return (IApplicationContext)instanceAppContext.getService();
    }

    static Object getApplication(String[] args) {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", "org.eclipse.e4.ui.workbench.swt.E4Application");
        Assert.isNotNull((Object)extension);
        try {
            Object runnable;
            IConfigurationElement[] runs;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
                return runnable;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Display createDisplay() {
        Display newDisplay;
        String applicationName = WorkbenchPlugin.getDefault().getAppName();
        if (applicationName != null) {
            Display.setAppName((String)applicationName);
        }
        if ((newDisplay = Display.getCurrent()) == null) {
            if (Policy.DEBUG_SWT_GRAPHICS || Policy.DEBUG_SWT_DEBUG) {
                DeviceData data = new DeviceData();
                if (Policy.DEBUG_SWT_GRAPHICS) {
                    data.tracking = true;
                }
                if (Policy.DEBUG_SWT_DEBUG) {
                    data.debug = true;
                }
                newDisplay = new Display(data);
            } else {
                newDisplay = new Display();
            }
        }
        newDisplay.setWarnings(false);
        Thread.currentThread().setPriority(Math.min(10, 6));
        Workbench.initializeImages();
        return newDisplay;
    }

    private void createSplashWrapper() {
        SafeRunnable run = new SafeRunnable(){
            Image background = null;

            public void run() throws Exception {
                String splashLoc = System.getProperty("org.eclipse.equinox.launcher.splash.location");
                this.background = Workbench.loadSplashScreenImage(Workbench.this.display, splashLoc);
                Workbench.getSplash();
                if (splash == null) {
                    createSplash = false;
                    return;
                }
                Shell splashShell = splash.getSplash();
                if (splashShell == null) {
                    splashShell = WorkbenchPlugin.getSplashShell(Workbench.this.display);
                    if (splashShell == null) {
                        return;
                    }
                    if (this.background != null) {
                        splashShell.setBackgroundImage(this.background);
                    }
                }
                Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
                ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
                BundleContext context = WorkbenchPlugin.getDefault().getBundleContext();
                final ServiceRegistration[] registration = new ServiceRegistration[1];
                StartupMonitor startupMonitor = new StartupMonitor(){

                    public void applicationRunning() {
                        if (background != null) {
                            background.dispose();
                        }
                        registration[0].unregister();
                        if (splash != null) {
                            splash.dispose();
                        }
                        WorkbenchPlugin.unsetSplashShell((this).Workbench.this.display);
                    }

                    public void update() {
                    }
                };
                registration[0] = context.registerService(StartupMonitor.class.getName(), (Object)startupMonitor, properties);
                splash.init(splashShell);
            }

            public void handleException(Throwable e) {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Could not instantiate splash", e));
                createSplash = false;
                splash = null;
                if (this.background != null) {
                    this.background.dispose();
                }
            }
        };
        SafeRunner.run((ISafeRunnable)run);
    }

    private static void spinEventQueueToUpdateSplash(Display display) {
        if (!display.isDisposed() && display.getThread() == Thread.currentThread()) {
            int safetyCounter = 0;
            while (display.readAndDispatch() && safetyCounter++ < 100) {
            }
        }
    }

    private static Image loadSplashScreenImage(Display display, String splashLoc) {
        Image background = null;
        if (splashLoc != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(splashLoc));){
                    background = new Image((Device)display, (InputStream)input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | SWTException e) {
                StatusManager.getManager().handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, e));
            }
        }
        return background;
    }

    private static AbstractSplashHandler getSplash() {
        if (!createSplash) {
            return null;
        }
        if (splash == null) {
            IProduct product = Platform.getProduct();
            if (product != null) {
                splash = SplashHandlerFactory.findSplashHandlerFor(product);
            }
            if (splash == null) {
                splash = new EclipseSplashHandler();
            }
        }
        return splash;
    }

    public static WorkbenchTestable getWorkbenchTestable() {
        if (testableObject == null) {
            testableObject = new WorkbenchTestable();
        }
        return testableObject;
    }

    @Override
    public void addWorkbenchListener(IWorkbenchListener listener) {
        this.workbenchListeners.add((Object)listener);
    }

    @Override
    public void removeWorkbenchListener(IWorkbenchListener listener) {
        this.workbenchListeners.remove((Object)listener);
    }

    boolean firePreShutdown(final boolean forced) {
        for (final IWorkbenchListener l : this.workbenchListeners) {
            final boolean[] result = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    result[0] = l.preShutdown(Workbench.this, forced);
                }
            });
            if (result[0]) continue;
            return false;
        }
        return true;
    }

    void firePostShutdown() {
        for (final IWorkbenchListener l : this.workbenchListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.postShutdown(Workbench.this);
                }
            });
        }
    }

    @Override
    public void addWindowListener(IWindowListener l) {
        this.addListenerObject(l);
    }

    @Override
    public void removeWindowListener(IWindowListener l) {
        this.removeListenerObject(l);
    }

    protected void fireWindowOpened(final IWorkbenchWindow window) {
        Object[] list;
        Object[] objectArray = list = this.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IWindowListener l = (IWindowListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowOpened(window);
                }
            });
            ++n2;
        }
    }

    protected void fireWindowClosed(final IWorkbenchWindow window) {
        Object[] list;
        Object[] objectArray = list = this.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IWindowListener l = (IWindowListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowClosed(window);
                }
            });
            ++n2;
        }
    }

    protected void fireWindowActivated(final IWorkbenchWindow window) {
        Object[] list;
        Object[] objectArray = list = this.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IWindowListener l = (IWindowListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowActivated(window);
                }
            });
            ++n2;
        }
    }

    protected void fireWindowDeactivated(final IWorkbenchWindow window) {
        Object[] list;
        Object[] objectArray = list = this.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IWindowListener l = (IWindowListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.windowDeactivated(window);
                }
            });
            ++n2;
        }
    }

    private boolean busyClose(final boolean force) {
        boolean closeEditors;
        this.isClosing = this.advisor.preShutdown();
        if (!force && !this.isClosing) {
            return false;
        }
        this.isClosing = this.firePreShutdown(force);
        if (!force && !this.isClosing) {
            return false;
        }
        this.isClosing = this.saveAllParts(!force, true);
        if (!force && !this.isClosing) {
            return false;
        }
        if (this.autoSaveJob != null) {
            this.autoSaveJob.cancel();
            this.autoSaveJob = null;
        }
        boolean bl = closeEditors = !force && PrefUtil.getAPIPreferenceStore().getBoolean("CLOSE_EDITORS_ON_EXIT");
        if (closeEditors) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    IWorkbenchWindow[] windows;
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows = Workbench.this.getWorkbenchWindows();
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage[] pages;
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            Workbench.this.isClosing = Workbench.this.isClosing && page.closeAllEditors(false);
                            ++n4;
                        }
                        ++n2;
                    }
                }
            });
            if (!force && !this.isClosing) {
                return false;
            }
        }
        this.persist(true);
        if (!force && !this.isClosing) {
            return false;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(WorkbenchMessages.ErrorClosing){

            public void run() {
                if (Workbench.this.isClosing || force) {
                    E4Util.unsupported("Need to close since no windowManager");
                    MWindow selectedWindow = (MWindow)Workbench.this.application.getSelectedElement();
                    WorkbenchWindow selected = null;
                    IWorkbenchWindow[] iWorkbenchWindowArray = Workbench.this.getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        WorkbenchWindow ww = (WorkbenchWindow)window;
                        if (ww.getModel() == selectedWindow) {
                            selected = ww;
                        } else {
                            ((WorkbenchWindow)window).close(false);
                        }
                        ++n2;
                    }
                    if (selected != null) {
                        selected.close(false);
                    }
                    Workbench.this.windowsClosed = true;
                }
            }
        });
        if (!force && !this.isClosing) {
            return false;
        }
        UIEvents.publishEvent((String)"org/eclipse/e4/ui/LifeCycle/appShutdownStarted", (MUIElement)this.application);
        this.shutdown();
        IPresentationEngine engine = (IPresentationEngine)this.application.getContext().get(IPresentationEngine.class);
        engine.stop();
        this.runEventLoop = false;
        return true;
    }

    private void persist(final boolean shutdown) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = Workbench.this.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        List<EditorReference> editorReferences = ((WorkbenchPage)page).getInternalEditorReferences();
                        ArrayList<EditorReference> referencesToClose = new ArrayList<EditorReference>();
                        for (EditorReference reference : editorReferences) {
                            IEditorPart editor = reference.getEditor(false);
                            if (editor == null || reference.persist() || !shutdown) continue;
                            referencesToClose.add(reference);
                        }
                        if (shutdown) {
                            for (EditorReference reference : referencesToClose) {
                                ((WorkbenchPage)page).closeEditor(reference);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        if (this.getWorkbenchConfigurer().getSaveAndRestore()) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    Workbench.this.persistWorkbenchState();
                }

                public void handleException(Throwable e) {
                    String message = e.getMessage() == null ? WorkbenchMessages.ErrorClosingNoArg : NLS.bind((String)WorkbenchMessages.ErrorClosingOneArg, (Object)e.getMessage());
                    if (!MessageDialog.openQuestion(null, (String)WorkbenchMessages.Error, (String)message)) {
                        Workbench.this.isClosing = false;
                    }
                }
            });
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = Workbench.this.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference[] references;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IViewReference[] iViewReferenceArray = references = page.getViewReferences();
                        int n5 = references.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IViewReference reference = iViewReferenceArray[n6];
                            if (reference.getView(false) != null) {
                                ((ViewReference)reference).persist();
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        if (!shutdown) {
            this.persistWorkbenchModel();
        }
    }

    private boolean detectWorkbenchCorruption(MApplication application) {
        if (application.getChildren().isEmpty()) {
            WorkbenchPlugin.log("When auto-saving the workbench model, there were no top-level windows.  Skipped saving the model.", new Exception());
            return true;
        }
        return false;
    }

    private void persistWorkbenchModel() {
        if (Job.getJobManager().find((Object)WORKBENCH_AUTO_SAVE_JOB).length > 0) {
            return;
        }
        final MApplication appCopy = (MApplication)EcoreUtil.copy((EObject)((EObject)this.application));
        if (this.detectWorkbenchCorruption(appCopy)) {
            return;
        }
        final IModelResourceHandler handler = (IModelResourceHandler)this.e4Context.get(IModelResourceHandler.class);
        Job cleanAndSaveJob = new Job(WORKBENCH_AUTO_SAVE_BACKGROUND_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                Resource res = handler.createResourceWithApp(appCopy);
                Workbench.cleanUpCopy(appCopy);
                try {
                    try {
                        if (!Workbench.this.detectWorkbenchCorruption((MApplication)res.getContents().get(0))) {
                            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                            options.put("E4_FILTER_PERSISTED_STATE", Boolean.TRUE);
                            res.save(options);
                        }
                    }
                    catch (IOException iOException) {
                        res.unload();
                        res.getResourceSet().getResources().remove((Object)res);
                    }
                }
                finally {
                    res.unload();
                    res.getResourceSet().getResources().remove((Object)res);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return Workbench.WORKBENCH_AUTO_SAVE_JOB.equals(family);
            }
        };
        cleanAndSaveJob.setPriority(20);
        cleanAndSaveJob.setSystem(true);
        cleanAndSaveJob.schedule();
    }

    private static void cleanUpCopy(MApplication appCopy) {
        Workbench.setSearchContribution(appCopy, false);
    }

    @Override
    public boolean saveAllEditors(boolean confirm) {
        return this.saveAllEditors(confirm, false);
    }

    private boolean saveAllEditors(boolean confirm, boolean closing) {
        IWorkbenchWindow[] windows = this.getWorkbenchWindows();
        if (windows.length == 0) {
            return true;
        }
        HashSet dirtyParts = new HashSet();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            WorkbenchPage page = (WorkbenchPage)window.getActivePage();
            if (page != null) {
                Collections.addAll(dirtyParts, page.getDirtyWorkbenchParts());
            }
            ++n2;
        }
        IWorkbenchWindow activeWindow = this.getActiveWorkbenchWindow();
        if (activeWindow == null) {
            activeWindow = windows[0];
        }
        return WorkbenchPage.saveAll(new ArrayList<IWorkbenchPart>(dirtyParts), confirm, closing, true, activeWindow, activeWindow);
    }

    private boolean saveAllParts(boolean confirm, boolean closing) {
        Collection<MPart> parts;
        EPartService partService = (EPartService)this.e4Context.get(EPartService.class);
        if (partService != null && (parts = this.getDirtyMParts()) != null && parts.size() > 0) {
            ISaveHandler saveHandler;
            IEclipseContext context;
            EModelService modelService;
            MPart selected = null;
            Iterator<MPart> iterator = parts.iterator();
            if (iterator.hasNext()) {
                MPart part;
                selected = part = iterator.next();
            }
            if ((modelService = (EModelService)this.e4Context.get(EModelService.class)) != null && (context = modelService.getContainingContext((MUIElement)selected)) != null && (saveHandler = (ISaveHandler)context.get(ISaveHandler.class)) != null && saveHandler instanceof WorkbenchWindow.WWinPartServiceSaveHandler) {
                try {
                    return ((WorkbenchWindow.WWinPartServiceSaveHandler)saveHandler).saveParts(parts, confirm, true, true);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        return this.saveAllEditors(confirm, closing);
    }

    private Collection<MPart> getDirtyMParts() {
        HashSet<MPart> dirtyParts = new HashSet<MPart>();
        for (MWindow window : this.application.getChildren()) {
            EPartService partService;
            IWorkbenchWindow wwindow;
            IEclipseContext context = window.getContext();
            if (context == null || (wwindow = (IWorkbenchWindow)context.get(IWorkbenchWindow.class)) == null || (partService = (EPartService)context.get(EPartService.class)) == null) continue;
            Collection parts = null;
            try {
                parts = partService.getDirtyParts();
                dirtyParts.addAll(parts);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return dirtyParts;
    }

    @Override
    public boolean close() {
        return this.close(0, false);
    }

    boolean close(int returnCode, boolean force) {
        this.returnCode = returnCode;
        boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, () -> {
            boolean bl2 = this.busyClose(force);
        });
        return ret[0];
    }

    @Override
    public IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() == null || !this.initializationDone) {
            return null;
        }
        if (this.windowsClosed) {
            return null;
        }
        if (this.e4Context.get(IPresentationEngine.class) == null) {
            return null;
        }
        if (this.windowWhileInit != null) {
            return this.windowWhileInit;
        }
        MWindow activeWindow = (MWindow)this.application.getSelectedElement();
        if (!(activeWindow != null && activeWindow.getWidget() != null || this.application.getChildren().isEmpty())) {
            activeWindow = (MWindow)this.application.getChildren().get(0);
        }
        if (activeWindow == null || activeWindow.getWidget() == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = (IWorkbenchWindow)activeWindow.getContext().get(IWorkbenchWindow.class);
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow;
        }
        return this.createWorkbenchWindow(this.getDefaultPageInput(), this.getPerspectiveRegistry().findPerspectiveWithId(this.getPerspectiveRegistry().getDefaultPerspective()), activeWindow, false);
    }

    IWorkbenchWindow createWorkbenchWindow(IAdaptable input, IPerspectiveDescriptor descriptor, MWindow window, boolean newWindow) {
        WorkbenchWindow result;
        IEclipseContext windowContext = window.getContext();
        if (windowContext == null) {
            windowContext = E4Workbench.initializeContext((IEclipseContext)this.e4Context, (MContext)window);
        }
        if ((result = (WorkbenchWindow)windowContext.get(IWorkbenchWindow.class)) == null) {
            if (this.windowBeingCreated != null) {
                return this.windowBeingCreated;
            }
            try {
                this.windowBeingCreated = result = new WorkbenchWindow(input, descriptor);
                this.windowWhileInit = this.getActiveWorkbenchWindow();
                if (newWindow) {
                    Point size = result.getWindowConfigurer().getInitialSize();
                    window.setWidth(size.x);
                    window.setHeight(size.y);
                    this.application.getChildren().add(window);
                    this.application.setSelectedElement((MUIElement)window);
                }
                ContextInjectionFactory.inject((Object)result, (IEclipseContext)windowContext);
                windowContext.set(IWorkbenchWindow.class, (Object)result);
            }
            finally {
                this.windowBeingCreated = null;
                this.windowWhileInit = null;
            }
            if (this.application.getSelectedElement() == window) {
                this.application.getContext().set("activeWorkbenchWindow", (Object)result);
                this.application.getContext().set("activeWorkbenchWindowShell", (Object)result.getShell());
            }
            this.fireWindowOpened(result);
            result.fireWindowOpened();
        }
        return result;
    }

    public EditorHistory getEditorHistory() {
        if (this.editorHistory == null) {
            this.editorHistory = new EditorHistory();
        }
        return this.editorHistory;
    }

    @Override
    public IEditorRegistry getEditorRegistry() {
        return WorkbenchPlugin.getDefault().getEditorRegistry();
    }

    @Override
    public IWorkbenchOperationSupport getOperationSupport() {
        return WorkbenchPlugin.getDefault().getOperationSupport();
    }

    @Override
    public IPerspectiveRegistry getPerspectiveRegistry() {
        return WorkbenchPlugin.getDefault().getPerspectiveRegistry();
    }

    @Override
    public PreferenceManager getPreferenceManager() {
        return WorkbenchPlugin.getDefault().getPreferenceManager();
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public ISharedImages getSharedImages() {
        return WorkbenchPlugin.getDefault().getSharedImages();
    }

    @Override
    public int getWorkbenchWindowCount() {
        return this.getWorkbenchWindows().length;
    }

    @Override
    public IWorkbenchWindow[] getWorkbenchWindows() {
        ArrayList<IWorkbenchWindow> windows = new ArrayList<IWorkbenchWindow>();
        for (MWindow window : this.application.getChildren()) {
            IWorkbenchWindow wwindow;
            IEclipseContext context = window.getContext();
            if (context == null || (wwindow = (IWorkbenchWindow)context.get(IWorkbenchWindow.class)) == null) continue;
            windows.add(wwindow);
        }
        return windows.toArray(new IWorkbenchWindow[windows.size()]);
    }

    @Override
    public IWorkingSetManager getWorkingSetManager() {
        return WorkbenchPlugin.getDefault().getWorkingSetManager();
    }

    @Override
    public ILocalWorkingSetManager createLocalWorkingSetManager() {
        return new LocalWorkingSetManager(WorkbenchPlugin.getDefault().getBundleContext());
    }

    private boolean init() {
        IProduct product;
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.DEBUG = true;
            ModalContext.setDebugMode((boolean)true);
        }
        JFaceUtil.initializeJFacePreferences();
        this.e4Context.set("org.eclipse.core.runtime.Platform", Platform.class);
        final EvaluationService evaluationService = new EvaluationService(this.e4Context);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.serviceLocator.registerService(IEvaluationService.class, evaluationService);
            }
        });
        this.initializeLazyServices();
        this.activityHelper = ActivityPersistanceHelper.getInstance();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchImages.getImageRegistry();
            }
        });
        this.initializeE4Services();
        IIntroRegistry introRegistry = WorkbenchPlugin.getDefault().getIntroRegistry();
        if (introRegistry.getIntroCount() > 0 && (product = Platform.getProduct()) != null) {
            this.introDescriptor = (IntroDescriptor)introRegistry.getIntroForProduct(product.getId());
        }
        this.initializeDefaultServices();
        this.initializeFonts();
        this.initializeApplicationColors();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.advisor.internalBasicInitialize(Workbench.this.getWorkbenchConfigurer());
            }
        });
        boolean useColorIcons = PrefUtil.getInternalPreferenceStore().getBoolean("COLOR_ICONS");
        ActionContributionItem.setUseColorIconsInToolbars((boolean)useColorIcons);
        this.initializeSingleClickOption();
        this.initializeGlobalization();
        this.initializeNLExtensions();
        this.initializeWorkbenchImages();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                new ShowKeysListener(Workbench.this, PrefUtil.getInternalPreferenceStore());
            }
        });
        try {
            UIStats.start(4, "Workbench");
            final boolean[] bail = new boolean[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    Workbench.this.advisor.preStartup();
                    Workbench.this.initializationDone = true;
                    if (Workbench.this.isClosing() || !Workbench.this.advisor.openWindows()) {
                        bail[0] = true;
                    }
                    Workbench.this.restoreWorkbenchState();
                }
            });
            if (bail[0]) {
                return false;
            }
        }
        finally {
            UIStats.end(4, this, "Workbench");
        }
        return true;
    }

    private void initializeWorkbenchImages() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                WorkbenchImages.getDescriptors();
            }
        });
    }

    private void initializeCommandResolver() {
        ExternalActionManager.getInstance().setCallback((ExternalActionManager.ICallback)new ExternalActionManager.CommandCallback(this.bindingManager, this.commandManager, commandId -> this.workbenchActivitySupport.getActivityManager().getIdentifier(commandId).isEnabled(), action -> !(action instanceof CommandAction)));
    }

    private void initializeApplicationColors() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ColorDefinition[] colorDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getColors();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getCurrentTheme(), colorDefinitions, PrefUtil.getInternalPreferenceStore());
            }
        });
    }

    void initializeSingleClickOption() {
        int singleClickMethod;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        boolean selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        boolean openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        int n = singleClickMethod = openOnSingleClick ? 1 : 0;
        if (openOnSingleClick) {
            if (selectOnHover) {
                singleClickMethod |= 2;
            }
            if (openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
    }

    private void initializeGlobalization() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!store.isDefault("BIDI_SUPPORT")) {
            BidiUtils.setBidiSupport((boolean)store.getBoolean("BIDI_SUPPORT"));
        }
        if (!store.isDefault("TEXT_DIRECTION")) {
            BidiUtils.setTextDirection((String)store.getString("TEXT_DIRECTION"));
        }
    }

    private void initializeNLExtensions() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        if (!store.isDefault("NL_EXTENSIONS")) {
            String nlExtensions = store.getString("NL_EXTENSIONS");
            ULocale.setDefault((ULocale.Category)ULocale.Category.FORMAT, (ULocale)new ULocale(String.valueOf(ULocale.getDefault((ULocale.Category)ULocale.Category.FORMAT).getBaseName()) + nlExtensions));
        }
    }

    private void initializeFonts() {
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                FontDefinition[] fontDefinitions = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
                ThemeElementHelper.populateRegistry(Workbench.this.getThemeManager().getCurrentTheme(), fontDefinitions, PrefUtil.getInternalPreferenceStore());
                IPropertyChangeListener themeToPreferencesFontSynchronizer = event -> {
                    if (event.getNewValue() instanceof FontData[]) {
                        FontData[] fontData = (FontData[])event.getNewValue();
                        PrefUtil.getInternalPreferenceStore().setValue(event.getProperty(), PreferenceConverter.getStoredRepresentation((FontData[])fontData));
                    }
                };
                Workbench.this.getThemeManager().getCurrentTheme().getFontRegistry().addListener(themeToPreferencesFontSynchronizer);
                Workbench.this.getThemeManager().addPropertyChangeListener(event -> {
                    if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                        Object newValue;
                        Object oldValue = event.getOldValue();
                        if (oldValue != null && oldValue instanceof ITheme) {
                            ((ITheme)oldValue).removePropertyChangeListener(themeToPreferencesFontSynchronizer);
                        }
                        if ((newValue = event.getNewValue()) != null && newValue instanceof ITheme) {
                            ((ITheme)newValue).addPropertyChangeListener(themeToPreferencesFontSynchronizer);
                        }
                    }
                });
            }
        });
    }

    private static void initializeImages() {
        ImageDescriptor[] windowImages = WorkbenchPlugin.getDefault().getWindowImages();
        if (windowImages == null) {
            return;
        }
        Image[] images = new Image[windowImages.length];
        int i = 0;
        while (i < windowImages.length) {
            images[i] = windowImages[i].createImage();
            ++i;
        }
        Window.setDefaultImages((Image[])images);
    }

    private void uninitializeImages() {
        WorkbenchImages.dispose();
        Image[] images = Window.getDefaultImages();
        Window.setDefaultImage(null);
        Image[] imageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            image.dispose();
            ++n2;
        }
    }

    @Override
    public boolean isClosing() {
        return this.isClosing;
    }

    private void initializeE4Services() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", event -> {
            if (this.application == event.getProperty("ChangedElement") && UIEvents.isREMOVE((Event)event)) {
                for (Object removed : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                    IWorkbenchWindow wwindow;
                    MWindow window = (MWindow)removed;
                    IEclipseContext windowContext = window.getContext();
                    if (windowContext == null || (wwindow = (IWorkbenchWindow)windowContext.get(IWorkbenchWindow.class)) == null) continue;
                    this.fireWindowClosed(wwindow);
                }
            }
        });
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", event -> {
            IWorkbenchWindow wwindow;
            MWindow window;
            if (this.application == event.getProperty("ChangedElement") && "SET".equals(event.getProperty("EventType")) && (window = (MWindow)event.getProperty("NewValue")) != null && (wwindow = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class)) != null) {
                this.e4Context.set("activeWorkbenchWindow", (Object)wwindow);
                this.e4Context.set("activeWorkbenchWindowShell", (Object)wwindow.getShell());
            }
        });
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", event -> {
            Object element;
            if (Boolean.TRUE.equals(event.getProperty("NewValue")) && (element = event.getProperty("ChangedElement")) instanceof MPart) {
                MPart part = (MPart)element;
                this.createReference(part);
            }
        });
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", event -> {
            MPart part;
            IEclipseContext context;
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPart && (context = (part = (MPart)element).getContext()) != null) {
                this.setReference(part, context);
            }
        });
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", event -> {
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MApplication)) {
                return;
            }
            MApplication app = (MApplication)element;
            if (UIEvents.isREMOVE((Event)event) && app.getChildren().isEmpty()) {
                Object oldValue = event.getProperty("OldValue");
                WorkbenchPlugin.log("The final top level window " + oldValue + " was just removed", new Exception());
            }
        });
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/*", event -> {
            this.applicationModelChanged = true;
        });
        boolean found = false;
        List currentDescriptors = this.application.getDescriptors();
        for (MPartDescriptor desc : currentDescriptors) {
            if (!desc.getElementId().equals("org.eclipse.e4.ui.compatibility.editor")) continue;
            desc.getTags().add("removeOnHide");
            found = true;
            break;
        }
        if (!found) {
            EModelService modelService = (EModelService)this.e4Context.get(EModelService.class);
            MPartDescriptor descriptor = (MPartDescriptor)modelService.createModelElement(MPartDescriptor.class);
            descriptor.getTags().add(EDITOR_TAG);
            descriptor.getTags().add("removeOnHide");
            descriptor.setCloseable(true);
            descriptor.setAllowMultiple(true);
            descriptor.setElementId("org.eclipse.e4.ui.compatibility.editor");
            descriptor.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor");
            descriptor.setCategory("org.eclipse.e4.primaryDataStack");
            this.application.getDescriptors().add(descriptor);
        }
    }

    private WorkbenchPage getWorkbenchPage(MPart part) {
        IEclipseContext context = this.getWindowContext(part);
        WorkbenchPage page = (WorkbenchPage)context.get(IWorkbenchPage.class);
        if (page == null) {
            MWindow window = (MWindow)context.get(MWindow.class);
            Workbench workbench = (Workbench)PlatformUI.getWorkbench();
            workbench.openWorkbenchWindow(this.getDefaultPageInput(), this.getPerspectiveRegistry().findPerspectiveWithId(this.getDefaultPerspectiveId()), window, false);
            page = (WorkbenchPage)context.get(IWorkbenchPage.class);
        }
        return page;
    }

    private void setReference(MPart part, IEclipseContext context) {
        String uri = part.getContributionURI();
        if ("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor".equals(uri)) {
            WorkbenchPage page = this.getWorkbenchPage(part);
            EditorReference ref = page.getEditorReference(part);
            if (ref == null) {
                EditorReference originalRef;
                MPart clonedFrom = (MPart)part.getTransientData().get("Cloned From");
                if (clonedFrom != null && clonedFrom.getContext() != null && (originalRef = page.getEditorReference(clonedFrom)) != null) {
                    IEditorInput partInput = null;
                    String editorId = originalRef.getDescriptor().getId();
                    try {
                        partInput = originalRef.getEditorInput();
                    }
                    catch (PartInitException partInitException) {
                        System.out.println("Ooops !!!");
                    }
                    ref = page.createEditorReferenceForPart(part, partInput, editorId, null);
                }
                if (ref == null) {
                    ref = this.createEditorReference(part, page);
                }
            }
            context.set(EditorReference.class, (Object)ref);
        } else {
            WorkbenchPage page = this.getWorkbenchPage(part);
            ViewReference ref = page.getViewReference(part);
            if (ref == null) {
                ref = this.createViewReference(part, page);
            }
            context.set(ViewReference.class, (Object)ref);
        }
    }

    private ViewReference createViewReference(MPart part, WorkbenchPage page) {
        WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
        String partId = part.getElementId();
        int colonIndex = partId.indexOf(58);
        String descId = colonIndex == -1 ? partId : partId.substring(0, colonIndex);
        IViewDescriptor desc = window.getWorkbench().getViewRegistry().find(descId);
        ViewReference ref = new ViewReference(window.getModel().getContext(), page, part, (ViewDescriptor)desc);
        page.addViewReference(ref);
        return ref;
    }

    private EditorReference createEditorReference(MPart part, WorkbenchPage page) {
        WorkbenchWindow window = (WorkbenchWindow)page.getWorkbenchWindow();
        EditorReference ref = new EditorReference(window.getModel().getContext(), page, part, null, null, null);
        page.addEditorReference(ref);
        return ref;
    }

    private void createReference(MPart part) {
        WorkbenchPage page;
        EditorReference ref;
        String uri = part.getContributionURI();
        if ("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(uri)) {
            WorkbenchPage page2 = this.getWorkbenchPage(part);
            ViewReference ref2 = page2.getViewReference(part);
            if (ref2 == null) {
                this.createViewReference(part, page2);
            }
        } else if ("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor".equals(uri) && (ref = (page = this.getWorkbenchPage(part)).getEditorReference(part)) == null) {
            this.createEditorReference(part, page);
        }
    }

    private IEclipseContext getWindowContext(MPart part) {
        MElementContainer parent = (MElementContainer)((EObject)part).eContainer();
        while (!(parent instanceof MWindow)) {
            parent = (MElementContainer)((EObject)parent).eContainer();
        }
        return ((MWindow)parent).getContext();
    }

    private void initializeLazyServices() {
        this.e4Context.set(IExtensionTracker.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (Workbench.this.tracker == null) {
                    Workbench.this.tracker = new UIExtensionTracker(Workbench.this.getDisplay());
                }
                return Workbench.this.tracker;
            }
        });
        this.e4Context.set(IWorkbenchActivitySupport.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (Workbench.this.workbenchActivitySupport == null) {
                    Workbench.this.workbenchActivitySupport = new WorkbenchActivitySupport();
                }
                return Workbench.this.workbenchActivitySupport;
            }
        });
        this.e4Context.set(IProgressService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ProgressManager.getInstance();
            }
        });
        WorkbenchPlugin.getDefault().initializeContext(this.e4Context);
    }

    private CommandService initializeCommandService(IEclipseContext appContext) {
        CommandService service = new CommandService(this.commandManager, appContext);
        appContext.set(ICommandService.class, (Object)service);
        appContext.set(IUpdateService.class, (Object)service);
        service.readRegistry();
        return service;
    }

    public MBindingContext getBindingContext(String id) {
        MBindingContext result = this.bindingContexts.get(id);
        if (result == null) {
            result = this.searchContexts(id, this.application.getRootContext());
            if (result == null) {
                result = MCommandsFactory.INSTANCE.createBindingContext();
                result.setElementId(id);
                result.setName("Auto::" + id);
                this.application.getRootContext().add(result);
            }
            if (result != null) {
                this.bindingContexts.put(id, result);
            }
        }
        return result;
    }

    private MBindingContext searchContexts(String id, List<MBindingContext> rootContext) {
        for (MBindingContext context : rootContext) {
            if (context.getElementId().equals(id)) {
                return context;
            }
            MBindingContext result = this.searchContexts(id, context.getChildren());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void defineBindingTable(String id) {
        List bindingTables = this.application.getBindingTables();
        if (this.contains(bindingTables, id)) {
            return;
        }
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            WorkbenchPlugin.log("Defining a binding table: " + id);
        }
        MBindingTable bt = CommandsFactoryImpl.eINSTANCE.createBindingTable();
        bt.setBindingContext(this.getBindingContext(id));
        bindingTables.add(bt);
    }

    private boolean contains(List<MBindingTable> bindingTables, String id) {
        for (MBindingTable bt : bindingTables) {
            if (!id.equals(bt.getBindingContext().getElementId())) continue;
            return true;
        }
        return false;
    }

    private void initializeDefaultServices() {
        IContextService cxs;
        ContributionService contributionService = new ContributionService(this.getAdvisor());
        this.serviceLocator.registerService(IContributionService.class, contributionService);
        final IEvaluationService evaluationService = this.serviceLocator.getService(IEvaluationService.class);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.serviceLocator.registerService(ISaveablesLifecycleListener.class, new SaveablesList());
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Command.DEBUG_COMMAND_EXECUTION = Policy.DEBUG_COMMANDS;
                Workbench.this.commandManager = (CommandManager)Workbench.this.e4Context.get(CommandManager.class);
            }
        });
        final CommandService[] commandService = new CommandService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                commandService[0] = Workbench.this.initializeCommandService(Workbench.this.e4Context);
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ContextManager.DEBUG = Policy.DEBUG_CONTEXTS;
                Workbench.this.contextManager = (ContextManager)Workbench.this.e4Context.get(ContextManager.class);
            }
        });
        final IContextService contextService = cxs = (IContextService)ContextInjectionFactory.make(ContextService.class, (IEclipseContext)this.e4Context);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.contextManager.addContextManagerListener(contextManagerEvent -> {
                    String id;
                    if (contextManagerEvent.isContextChanged() && (id = contextManagerEvent.getContextId()) != null) {
                        Workbench.this.defineBindingTable(id);
                    }
                });
                EContextService ecs = (EContextService)Workbench.this.e4Context.get(EContextService.class);
                ecs.activateContext("org.eclipse.ui.contexts.dialogAndWindow");
            }
        });
        this.serviceLocator.registerService(IContextService.class, contextService);
        final IBindingService[] bindingService = new BindingService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                BindingManager.DEBUG = Policy.DEBUG_KEY_BINDINGS;
                Workbench.this.bindingManager = (BindingManager)Workbench.this.e4Context.get(BindingManager.class);
                bindingService[0] = (IBindingService)ContextInjectionFactory.make(BindingService.class, (IEclipseContext)Workbench.this.e4Context);
            }
        });
        this.serviceLocator.registerService(IBindingService.class, bindingService[0]);
        CommandImageManager commandImageManager = new CommandImageManager();
        CommandImageService commandImageService = new CommandImageService(commandImageManager, commandService[0]);
        commandImageService.readRegistry();
        this.serviceLocator.registerService(ICommandImageService.class, commandImageService);
        final WorkbenchMenuService menuService = new WorkbenchMenuService(this.serviceLocator, this.e4Context);
        this.serviceLocator.registerService(IMenuService.class, menuService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                menuService.readRegistry();
            }
        });
        final SourceProviderService sourceProviderService = new SourceProviderService(this.serviceLocator);
        this.serviceLocator.registerService(ISourceProviderService.class, sourceProviderService);
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                ISourceProvider[] sourceproviders;
                sourceProviderService.readRegistry();
                ISourceProvider[] iSourceProviderArray = sourceproviders = sourceProviderService.getSourceProviders();
                int n = sourceproviders.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceProvider sp = iSourceProviderArray[n2];
                    evaluationService.addSourceProvider(sp);
                    if (!(sp instanceof ActiveContextSourceProvider)) {
                        contextService.addSourceProvider(sp);
                    }
                    ++n2;
                }
            }
        });
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                FocusControlSourceProvider focusControl = (FocusControlSourceProvider)sourceProviderService.getSourceProvider("activeFocusControlId");
                Workbench.this.serviceLocator.registerService(IFocusService.class, focusControl);
                Workbench.this.menuSourceProvider = (MenuSourceProvider)sourceProviderService.getSourceProvider("activeMenu");
            }
        });
        final IHandlerService[] handlerService = new IHandlerService[1];
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                handlerService[0] = new LegacyHandlerService(Workbench.this.e4Context);
                Workbench.this.e4Context.set(IHandlerService.class, (Object)handlerService[0]);
                handlerService[0].readRegistry();
            }
        });
        this.workbenchContextSupport = new WorkbenchContextSupport(this, this.contextManager);
        this.workbenchCommandSupport = new WorkbenchCommandSupport(this.bindingManager, this.commandManager, this.contextManager, handlerService[0]);
        this.initializeCommandResolver();
        this.bindingManager.addBindingManagerListener(this.bindingManagerListener);
        this.serviceLocator.registerService(ISelectionConversionService.class, new SelectionConversionService());
        this.backForwardListener = this.createBackForwardListener();
        StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

            @Override
            public void runWithException() {
                Workbench.this.getDisplay().addFilter(3, Workbench.this.backForwardListener);
            }
        });
    }

    private Listener createBackForwardListener() {
        return event -> {
            String commandId;
            switch (event.button) {
                case 4: 
                case 8: {
                    commandId = "org.eclipse.ui.navigate.backwardHistory";
                    break;
                }
                case 5: 
                case 9: {
                    commandId = "org.eclipse.ui.navigate.forwardHistory";
                    break;
                }
                default: {
                    return;
                }
            }
            IHandlerService handlerService = this.getService(IHandlerService.class);
            try {
                handlerService.executeCommand(commandId, event);
                event.doit = false;
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException throwable) {
            }
            catch (ExecutionException ex) {
                StatusUtil.handleStatus(ex, 3);
            }
        };
    }

    @Override
    public boolean isStarting() {
        return this.isStarting && this.isRunning();
    }

    void openFirstTimeWindow() {
        boolean showProgress = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_PROGRESS_ON_STARTUP");
        if (!showProgress) {
            this.doOpenFirstTimeWindow();
        } else {
            this.runStartupWithProgress(this::doOpenFirstTimeWindow);
        }
    }

    private void doOpenFirstTimeWindow() {
        try {
            final IAdaptable[] input = new IAdaptable[1];
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    input[0] = Workbench.this.getDefaultPageInput();
                }
            });
            this.openWorkbenchWindow(this.getDefaultPerspectiveId(), input[0]);
        }
        catch (WorkbenchException e) {
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                @Override
                public void runWithException() throws Throwable {
                    ErrorDialog.openError(null, (String)WorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            });
        }
    }

    private void runStartupWithProgress(Runnable runnable) {
        AbstractSplashHandler handler = Workbench.getSplash();
        IProgressMonitor progressMonitor = null;
        if (handler != null) {
            progressMonitor = handler.getBundleProgressMonitor();
        }
        if (progressMonitor == null) {
            runnable.run();
        } else {
            StartupProgressBundleListener bundleListener = new StartupProgressBundleListener(progressMonitor, this.display);
            WorkbenchPlugin.getDefault().addBundleListener((BundleListener)bundleListener);
            try {
                runnable.run();
            }
            finally {
                WorkbenchPlugin.getDefault().removeBundleListener((BundleListener)bundleListener);
            }
        }
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(IAdaptable input) throws WorkbenchException {
        return this.openWorkbenchWindow(this.getDefaultPerspectiveId(), input);
    }

    @Override
    public IWorkbenchWindow openWorkbenchWindow(String perspectiveId, IAdaptable input) throws WorkbenchException {
        IPerspectiveDescriptor descriptor = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        try {
            MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
            return this.openWorkbenchWindow(input, descriptor, (MWindow)window, true);
        }
        catch (InjectionException e) {
            throw new WorkbenchException(e.getMessage(), e);
        }
    }

    public WorkbenchWindow openWorkbenchWindow(IAdaptable input, IPerspectiveDescriptor descriptor, MWindow window, boolean newWindow) {
        return (WorkbenchWindow)this.createWorkbenchWindow(input, descriptor, window, newWindow);
    }

    @Override
    public boolean restart() {
        return this.close(1, false);
    }

    @Override
    public boolean restart(boolean useCurrrentWorkspace) {
        URL instanceUrl;
        if (useCurrrentWorkspace && (instanceUrl = Platform.getInstanceLocation().getURL()) != null) {
            try {
                URI uri = instanceUrl.toURI();
                String command_line = Workbench.buildCommandLine(uri.toString());
                if (command_line != null) {
                    System.setProperty(PROP_EXIT_CODE, IApplication.EXIT_RELAUNCH.toString());
                    System.setProperty("eclipse.exitdata", command_line);
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return this.close(1, false);
    }

    private static String buildCommandLine(String workspace) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            if (!Platform.inDevelopmentMode()) {
                WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.Workbench_missingPropertyMessage, (Object)PROP_VM));
            }
            return null;
        }
        StringBuilder result = new StringBuilder(512);
        result.append(property);
        result.append('\n');
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        if ((property = System.getProperty(PROP_COMMANDS)) == null) {
            result.append(CMD_DATA);
            result.append('\n');
            result.append(workspace);
            result.append('\n');
        } else {
            int cmd_data_pos = property.lastIndexOf(CMD_DATA);
            if (cmd_data_pos != -1) {
                result.append(property.substring(0, cmd_data_pos += CMD_DATA.length() + 1));
                result.append(workspace);
                int nextArg = property.indexOf("\n-", cmd_data_pos - 1);
                if (nextArg != -1) {
                    result.append(property.substring(nextArg));
                }
            } else {
                result.append(CMD_DATA);
                result.append('\n');
                result.append(workspace);
                result.append('\n');
                result.append(property);
            }
        }
        if (vmargs != null) {
            if (result.charAt(result.length() - 1) != '\n') {
                result.append('\n');
            }
            result.append(CMD_VMARGS);
            result.append('\n');
            result.append(vmargs);
        }
        return result.toString();
    }

    public static Object setRestartArguments(String workspacePath) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError(null, (String)WorkbenchMessages.Workbench_problemsRestartErrorTitle, (String)NLS.bind((String)WorkbenchMessages.Workbench_problemsRestartErrorMessage, (Object)PROP_VM));
            return IApplication.EXIT_OK;
        }
        String command_line = Workbench.buildCommandLine(workspacePath);
        if (command_line == null) {
            return IApplication.EXIT_OK;
        }
        System.setProperty(PROP_EXIT_CODE, IApplication.EXIT_RELAUNCH.toString());
        System.setProperty("eclipse.exitdata", command_line);
        return IApplication.EXIT_RELAUNCH;
    }

    public ContributionInfo[] getEarlyActivatedPlugins() {
        IExtensionPoint point = this.registry.getExtensionPoint("org.eclipse.ui", "startup");
        IExtension[] extensions = point.getExtensions();
        ArrayList<String> pluginIds = new ArrayList<String>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String id = extension.getContributor().getName();
            if (!pluginIds.contains(id)) {
                pluginIds.add(id);
            }
            ++n2;
        }
        ContributionInfo[] result = new ContributionInfo[pluginIds.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new ContributionInfo((String)pluginIds.get(i), ContributionInfoMessages.ContributionInfo_EarlyStartupPlugin, null);
            ++i;
        }
        return result;
    }

    public String[] getDisabledEarlyActivatedPlugins() {
        String pref = PrefUtil.getInternalPreferenceStore().getString("PLUGINS_NOT_ACTIVATED_ON_STARTUP");
        return pref.split(";");
    }

    private void startPlugins() {
        Job job = new Job("Executing the early startup extensions"){

            protected IStatus run(IProgressMonitor monitor) {
                IExtensionPoint point = Workbench.this.registry.getExtensionPoint("org.eclipse.ui", "startup");
                IExtension[] extensions = point.getExtensions();
                if (extensions.length == 0) {
                    return Status.OK_STATUS;
                }
                HashSet<String> disabledPlugins = new HashSet<String>(Arrays.asList(Workbench.this.getDisabledEarlyActivatedPlugins()));
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WorkbenchMessages.Workbench_startingPlugins, (int)extensions.length);
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    if (subMonitor.isCanceled() || !Workbench.this.isRunning()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!disabledPlugins.contains(extension.getContributor().getName())) {
                        subMonitor.setTaskName(extension.getContributor().getName());
                        SafeRunner.run((ISafeRunnable)new EarlyStartupRunnable(extension));
                    }
                    subMonitor.worked(1);
                    ++n2;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return Workbench.EARLY_STARTUP_FAMILY.equals(family);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void setEnableAutoSave(boolean b) {
        this.workbenchAutoSave = b;
    }

    private int runUI() {
        UISynchronizer synchronizer;
        String[] commandLineArgs;
        UIStats.start(5, "Workbench");
        boolean avoidDeadlock = true;
        String[] stringArray = commandLineArgs = Platform.getCommandLineArgs();
        int n = commandLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String commandLineArg = stringArray[n2];
            if (commandLineArg.equalsIgnoreCase("-allowDeadlock")) {
                avoidDeadlock = false;
            }
            ++n2;
        }
        if (avoidDeadlock) {
            UILockListener uiLockListener = new UILockListener(this.display);
            Job.getJobManager().setLockListener((LockListener)uiLockListener);
            synchronizer = new UISynchronizer(this.display, uiLockListener);
            this.display.setSynchronizer((Synchronizer)synchronizer);
            UISynchronizer.startupThread.set(Boolean.TRUE);
        } else {
            synchronizer = null;
        }
        ModalContext.setAllowReadAndDispatch((boolean)false);
        if (WorkbenchPlugin.getDefault().isDebugging()) {
            this.display.asyncExec(() -> {
                if (this.isStarting()) {
                    WorkbenchPlugin.log(StatusUtil.newStatus(2, "Event loop should not be run while the Workbench is starting.", (Throwable)new RuntimeException()));
                }
            });
        }
        Listener closeListener = event -> {
            boolean bl = event.doit = this.close();
        };
        ExceptionHandler handler = ExceptionHandler.getInstance();
        try {
            this.display.addListener(21, closeListener);
            Window.setExceptionHandler((Window.IExceptionHandler)handler);
            boolean[] initOK = new boolean[]{this.init()};
            if (initOK[0] && this.runEventLoop) {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("id", this.getId());
                this.workbenchService = WorkbenchPlugin.getDefault().getBundleContext().registerService(IWorkbench.class.getName(), (Object)this, properties);
                this.e4WorkbenchService = WorkbenchPlugin.getDefault().getBundleContext().registerService(org.eclipse.e4.ui.workbench.IWorkbench.class.getName(), (Object)this, properties);
                Runnable earlyStartup = () -> {
                    this.advisor.postStartup();
                    this.startPlugins();
                    this.addStartupRegistryListener();
                };
                this.e4Context.set("runEarlyStartup", (Object)earlyStartup);
                int millisecondInterval = this.getAutoSaveJobTime();
                if (millisecondInterval > 0 && this.workbenchAutoSave) {
                    this.autoSaveJob = new WorkbenchJob(WORKBENCH_AUTO_SAVE_JOB){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            int nextDelay = Workbench.this.getAutoSaveJobTime();
                            try {
                                if (Workbench.this.applicationModelChanged) {
                                    Workbench.this.persist(false);
                                    Workbench.this.applicationModelChanged = false;
                                }
                                monitor.done();
                            }
                            finally {
                                if (nextDelay > 0 && Workbench.this.workbenchAutoSave) {
                                    this.schedule(nextDelay);
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    this.autoSaveJob.setSystem(true);
                    this.autoSaveJob.schedule((long)millisecondInterval);
                }
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIStats.end(5, this, "Workbench");
                        UIStats.startupComplete();
                    }
                });
                Workbench.getWorkbenchTestable().init(this.display, this);
                ModalContext.setAllowReadAndDispatch((boolean)true);
                this.isStarting = false;
                if (synchronizer != null) {
                    synchronizer.started();
                }
            }
            this.returnCode = 0;
            if (!initOK[0]) {
                this.returnCode = 2;
            }
        }
        catch (Exception e) {
            if (!this.display.isDisposed()) {
                handler.handleException(e);
            }
            String msg = "Exception in Workbench.runUI after display was disposed";
            WorkbenchPlugin.log(msg, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 1, msg, (Throwable)e));
        }
        return this.returnCode;
    }

    private int getAutoSaveJobTime() {
        int minuteSaveInterval = this.getPreferenceStore().getInt("WORKBENCH_SAVE_INTERVAL");
        return minuteSaveInterval * 60 * 1000;
    }

    @Override
    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow window) throws WorkbenchException {
        return this.showPerspective(perspectiveId, window, this.advisor.getDefaultPageInput());
    }

    private boolean activate(String perspectiveId, IWorkbenchPage page, IAdaptable input) {
        if (page != null) {
            IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getOpenPerspectives();
            int n = iPerspectiveDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPerspectiveDescriptor openedPerspective = iPerspectiveDescriptorArray[n2];
                if (openedPerspective.getId().equals(perspectiveId) && page.getInput() == input) {
                    WorkbenchWindow wwindow = (WorkbenchWindow)page.getWorkbenchWindow();
                    MWindow model = wwindow.getModel();
                    this.application.setSelectedElement((MUIElement)model);
                    page.setPerspective(openedPerspective);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public IWorkbenchPage showPerspective(String perspectiveId, IWorkbenchWindow targetWindow, IAdaptable input) throws WorkbenchException {
        Assert.isNotNull((Object)perspectiveId);
        Object[] ret = new Object[1];
        BusyIndicator.showWhile(null, () -> {
            try {
                objectArray[0] = this.busyShowPerspective(perspectiveId, targetWindow, input);
            }
            catch (WorkbenchException e) {
                objectArray[0] = e;
            }
        });
        if (ret[0] instanceof IWorkbenchPage) {
            return (IWorkbenchPage)ret[0];
        }
        if (ret[0] instanceof WorkbenchException) {
            throw (WorkbenchException)((Object)ret[0]);
        }
        throw new WorkbenchException(WorkbenchMessages.WorkbenchPage_AbnormalWorkbenchCondition);
    }

    private IWorkbenchPage busyShowPerspective(String perspectiveId, IWorkbenchWindow targetWindow, IAdaptable input) throws WorkbenchException {
        IWorkbenchPage page;
        Assert.isNotNull((Object)perspectiveId);
        IPerspectiveDescriptor targetPerspective = this.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (targetPerspective == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
        }
        if (targetWindow != null && this.activate(perspectiveId, page = targetWindow.getActivePage(), input)) {
            return page;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = this.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page2 = window.getActivePage();
            if (this.activate(perspectiveId, page2, input)) {
                return page2;
            }
            ++n2;
        }
        if (targetWindow != null) {
            page = targetWindow.getActivePage();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int mode = store.getInt("OPEN_PERSPECTIVE_MODE");
            if (2 != mode) {
                targetWindow.getShell().open();
                if (page == null) {
                    page = targetWindow.openPage(perspectiveId, input);
                } else {
                    page.setPerspective(targetPerspective);
                }
                return page;
            }
        }
        return this.openWorkbenchWindow(perspectiveId, input).getActivePage();
    }

    private void shutdown() {
        StatusManager statusManager = StatusManager.getManager();
        try {
            this.advisor.postShutdown();
        }
        catch (Exception ex) {
            statusManager.handle(StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, "Exceptions during shutdown", (Throwable)ex));
        }
        this.firePostShutdown();
        this.workbenchListeners.clear();
        this.cancelEarlyStartup();
        if (this.workbenchService != null) {
            this.workbenchService.unregister();
        }
        this.workbenchService = null;
        if (this.e4WorkbenchService != null) {
            this.e4WorkbenchService.unregister();
        }
        this.e4WorkbenchService = null;
        this.registry.removeRegistryChangeListener((IRegistryChangeListener)this.extensionEventHandler);
        this.registry.removeRegistryChangeListener(this.startupRegistryListener);
        this.serviceLocator.dispose();
        this.application.getCommands().removeAll(this.commandsToRemove);
        this.application.getCategories().removeAll(this.categoriesToRemove);
        this.getDisplay().removeFilter(3, this.backForwardListener);
        this.backForwardListener = null;
        this.workbenchActivitySupport.dispose();
        WorkbenchHelpSystem.disposeIfNecessary();
        this.activityHelper.shutdown();
        this.uninitializeImages();
        if (WorkbenchPlugin.getDefault() != null) {
            WorkbenchPlugin.getDefault().reset();
        }
        WorkbenchThemeManager.getInstance().dispose();
        PropertyPageContributorManager.getManager().dispose();
        ObjectActionContributorManager.getManager().dispose();
        if (this.tracker != null) {
            this.tracker.close();
        }
        statusManager.unregister();
    }

    private void cancelEarlyStartup() {
        Job.getJobManager().cancel((Object)EARLY_STARTUP_FAMILY);
    }

    @Override
    public IDecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }

    WorkbenchConfigurer getWorkbenchConfigurer() {
        if (this.workbenchConfigurer == null) {
            this.workbenchConfigurer = new WorkbenchConfigurer();
        }
        return this.workbenchConfigurer;
    }

    WorkbenchAdvisor getAdvisor() {
        return this.advisor;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    public String getDefaultPerspectiveId() {
        return this.getAdvisor().getInitialWindowPerspectiveId();
    }

    public IAdaptable getDefaultPageInput() {
        return this.getAdvisor().getDefaultPageInput();
    }

    public String getMainPreferencePageId() {
        return this.getAdvisor().getMainPreferencePageId();
    }

    @Override
    public IElementFactory getElementFactory(String factoryId) {
        Assert.isNotNull((Object)factoryId);
        return WorkbenchPlugin.getDefault().getElementFactory(factoryId);
    }

    @Override
    public IProgressService getProgressService() {
        return (IProgressService)this.e4Context.get(IProgressService.class);
    }

    @Override
    public IWorkbenchActivitySupport getActivitySupport() {
        return (IWorkbenchActivitySupport)this.e4Context.get(IWorkbenchActivitySupport.class);
    }

    @Override
    public IWorkbenchCommandSupport getCommandSupport() {
        return this.workbenchCommandSupport;
    }

    @Override
    public IWorkbenchContextSupport getContextSupport() {
        return this.workbenchContextSupport;
    }

    private void updateActiveWorkbenchWindowMenuManager(boolean textOnly) {
        IWorkbenchWindow workbenchWindow = this.getActiveWorkbenchWindow();
        if (workbenchWindow instanceof WorkbenchWindow) {
            WorkbenchWindow activeWorkbenchWindow = (WorkbenchWindow)workbenchWindow;
            if (activeWorkbenchWindow.isClosing()) {
                return;
            }
            MenuManager menuManager = activeWorkbenchWindow.getMenuManager();
            if (textOnly) {
                menuManager.update("text");
            } else {
                menuManager.update(true);
            }
        }
    }

    @Override
    public IIntroManager getIntroManager() {
        return this.getWorkbenchIntroManager();
    }

    WorkbenchIntroManager getWorkbenchIntroManager() {
        if (this.introManager == null) {
            this.introManager = new WorkbenchIntroManager(this);
        }
        return this.introManager;
    }

    public IntroDescriptor getIntroDescriptor() {
        return this.introDescriptor;
    }

    public void setIntroDescriptor(IntroDescriptor descriptor) {
        if (this.getIntroManager().getIntro() != null) {
            this.getIntroManager().closeIntro(this.getIntroManager().getIntro());
        }
        this.introDescriptor = descriptor;
    }

    @Override
    public IThemeManager getThemeManager() {
        return WorkbenchThemeManager.getInstance();
    }

    public boolean isRunning() {
        return this.runEventLoop;
    }

    public void largeUpdateStart() {
        if (this.largeUpdates++ == 0) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = this.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateStart();
                }
                ++n2;
            }
        }
    }

    public void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = this.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                if (window instanceof WorkbenchWindow) {
                    ((WorkbenchWindow)window).largeUpdateEnd();
                }
                ++n2;
            }
        }
    }

    @Override
    public IExtensionTracker getExtensionTracker() {
        return (IExtensionTracker)this.e4Context.get(IExtensionTracker.class);
    }

    private void addStartupRegistryListener() {
        this.registry.addRegistryChangeListener(this.startupRegistryListener);
    }

    @Override
    public IWorkbenchHelpSystem getHelpSystem() {
        return WorkbenchHelpSystem.getInstance();
    }

    @Override
    public IWorkbenchBrowserSupport getBrowserSupport() {
        return WorkbenchBrowserSupport.getInstance();
    }

    @Override
    public IViewRegistry getViewRegistry() {
        return WorkbenchPlugin.getDefault().getViewRegistry();
    }

    @Override
    public IWizardRegistry getNewWizardRegistry() {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry();
    }

    @Override
    public IWizardRegistry getImportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getImportWizardRegistry();
    }

    @Override
    public IWizardRegistry getExportWizardRegistry() {
        return WorkbenchPlugin.getDefault().getExportWizardRegistry();
    }

    public <T> T getAdapter(Class<T> key) {
        return key.cast(this.serviceLocator.getService(key));
    }

    @Override
    public <T> T getService(Class<T> key) {
        return this.serviceLocator.getService(key);
    }

    @Override
    public boolean hasService(Class<?> key) {
        return this.serviceLocator.hasService(key);
    }

    public void registerService(Class api, Object service) {
        this.serviceLocator.registerService(api, service);
    }

    public void addShowingMenus(Set menuIds, ISelection localSelection, ISelection localEditorInput) {
        this.menuSourceProvider.addShowingMenus(menuIds, localSelection, localEditorInput);
        Map currentState = this.menuSourceProvider.getCurrentState();
        String[] stringArray = this.menuSourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.e4Context.set(key, currentState.get(key));
            ++n2;
        }
    }

    public void removeShowingMenus(Set menuIds, ISelection localSelection, ISelection localEditorInput) {
        this.menuSourceProvider.removeShowingMenus(menuIds, localSelection, localEditorInput);
        String[] stringArray = this.menuSourceProvider.getProvidedSourceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.e4Context.remove(key);
            ++n2;
        }
    }

    @Override
    public boolean saveAll(IShellProvider shellProvider, IRunnableContext runnableContext, ISaveableFilter filter, boolean confirm) {
        SaveablesList saveablesList = (SaveablesList)this.getService(ISaveablesLifecycleListener.class);
        Saveable[] saveables = saveablesList.getOpenModels();
        List<Saveable> toSave = this.getFilteredSaveables(filter, saveables);
        if (toSave.isEmpty()) {
            return true;
        }
        if (!confirm) {
            return !saveablesList.saveModels(toSave, shellProvider, runnableContext);
        }
        return !saveablesList.promptForSaving(toSave, shellProvider, runnableContext, true, false);
    }

    private List<Saveable> getFilteredSaveables(ISaveableFilter filter, Saveable[] saveables) {
        ArrayList<Saveable> toSave = new ArrayList<Saveable>();
        if (filter == null) {
            Saveable[] saveableArray = saveables;
            int n = saveables.length;
            int n2 = 0;
            while (n2 < n) {
                Saveable saveable = saveableArray[n2];
                if (saveable.isDirty()) {
                    toSave.add(saveable);
                }
                ++n2;
            }
        } else {
            SaveablesList saveablesList = (SaveablesList)this.getService(ISaveablesLifecycleListener.class);
            Saveable[] saveableArray = saveables;
            int n = saveables.length;
            int n3 = 0;
            while (n3 < n) {
                IWorkbenchPart[] parts;
                Saveable saveable = saveableArray[n3];
                if (saveable.isDirty() && this.matchesFilter(filter, saveable, parts = saveablesList.getPartsForSaveable(saveable))) {
                    toSave.add(saveable);
                }
                ++n3;
            }
        }
        return toSave;
    }

    private boolean matchesFilter(ISaveableFilter filter, Saveable saveable, IWorkbenchPart[] parts) {
        return filter == null || filter.select(saveable, parts);
    }

    @Override
    public IShellProvider getModalDialogShellProvider() {
        return ProgressManagerUtil::getDefaultParent;
    }

    public IEclipseContext getContext() {
        return this.e4Context;
    }

    public MApplication getApplication() {
        return this.application;
    }

    private void persistWorkbenchState() {
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("workbench");
            IStatus status = this.saveWorkbenchState(memento);
            if (status.getSeverity() == 0) {
                StringWriter writer = new StringWriter();
                memento.save(writer);
                this.application.getPersistedState().put(MEMENTO_KEY, writer.toString());
            } else {
                WorkbenchPlugin.log((IStatus)new Status(status.getSeverity(), "org.eclipse.ui", WorkbenchMessages.Workbench_problemsSavingMsg));
            }
        }
        catch (IOException e) {
            WorkbenchPlugin.log((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSavingMsg, (Throwable)e));
        }
    }

    private IStatus saveWorkbenchState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsSaving);
        result.add(this.getEditorHistory().saveState(memento.createChild("mruList")));
        return result;
    }

    private void restoreWorkbenchState() {
        try {
            XMLMemento memento;
            IStatus status;
            String persistedState = (String)this.application.getPersistedState().get(MEMENTO_KEY);
            if (persistedState != null && (status = this.readWorkbenchState(memento = XMLMemento.createReadRoot(new StringReader(persistedState)))).getSeverity() != 0) {
                WorkbenchPlugin.log((IStatus)new Status(status.getSeverity(), "org.eclipse.ui", WorkbenchMessages.Workbench_problemsRestoring));
            }
        }
        catch (Exception e) {
            WorkbenchPlugin.log((IStatus)new Status(4, "org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsRestoring, (Throwable)e));
        }
    }

    private IStatus readWorkbenchState(IMemento memento) {
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.Workbench_problemsRestoring, null);
        try {
            UIStats.start(4, "MRUList");
            IMemento mruMemento = memento.getChild("mruList");
            if (mruMemento != null) {
                result.add(this.getEditorHistory().restoreState(mruMemento));
            }
        }
        finally {
            UIStats.end(4, this, "MRUList");
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    protected String createId() {
        return UUID.randomUUID().toString();
    }

    private static final class StartupProgressBundleListener
    implements SynchronousBundleListener {
        private final SubMonitor subMonitor;
        private Display displayForStartupListener;

        StartupProgressBundleListener(IProgressMonitor progressMonitor, Display display) {
            this.displayForStartupListener = display;
            this.subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
            this.subMonitor.setTaskName(NLS.bind((String)WorkbenchMessages.Startup_Loading, (Object)Platform.getProduct().getName()));
        }

        public void bundleChanged(BundleEvent event) {
            int eventType = event.getType();
            if (eventType == 2) {
                this.subMonitor.setWorkRemaining(5).worked(1);
                Workbench.spinEventQueueToUpdateSplash(this.displayForStartupListener);
            }
        }
    }
}

