/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.Arrays;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.ArrayUtils;

class MySQLDialect
extends JDBCSQLDialect {
    public static final String[] MYSQL_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"USE", "SHOW", "CREATE", "ALTER", "DROP", "EXPLAIN", "DESCRIBE", "DESC"});
    private static final String[] ADVANCED_KEYWORDS = new String[]{"AUTO_INCREMENT", "DATABASES", "COLUMNS", "ALGORITHM", "REPAIR"};
    public static final String[][] MYSQL_QUOTE_STRINGS = new String[][]{{"`", "`"}, {"\"", "\""}};
    private static final String[] MYSQL_EXTRA_FUNCTIONS = new String[]{"ADDDATE", "ADDTIME", "ANY_VALUE", "CAST", "COALESCE", "COLLATION", "COMPRESS", "DATE_ADD", "DATE_SUB", "DATEDIFF", "EXTRACT", "FIRST_VALUE", "FORMAT", "FOUND_ROWS", "FROM_BASE64", "GET_FORMAT", "GROUP_CONCAT", "HOUR", "DAY", "IFNULL", "ISNULL", "LAG", "LAST_VALUE", "LEAD", "LEAST", "LENGTH", "MAKEDATE", "MAKETIME", "MINUTE", "MONTH", "NULLIF", "RANDOM_BYTES", "REGEXP_LIKE", "REGEXP_INSTR", "REGEXP_REPLACE", "REGEXP_SUBSTR", "SESSION_USER", "SPACE", "SUBSTR", "SUBTIME", "TIMEDIFF", "TO_BASE64", "TO_SECONDS", "UUID", "UUID_TO_BIN", "WEEKOFYEAR", "YEAR"};
    private static String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private int lowerCaseTableNames;

    public MySQLDialect() {
        super("MySQL", "mysql");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        this.lowerCaseTableNames = ((MySQLDataSource)dataSource).getLowerCaseTableNames();
        this.setSupportsUnquotedMixedCase(this.lowerCaseTableNames != 2);
        Collections.addAll(this.tableQueryWords, "EXPLAIN", "DESCRIBE", "DESC");
        this.addFunctions(Arrays.asList("SLEEP"));
        String[] stringArray = ADVANCED_KEYWORDS;
        int n = ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        this.removeSQLKeyword("SOURCE");
        this.addDataTypes(Arrays.asList("GEOMETRY", "POINT"));
        this.addFunctions(Arrays.asList(MYSQL_EXTRA_FUNCTIONS));
    }

    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return MYSQL_QUOTE_STRINGS;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    public char getStringEscapeCharacter() {
        return '\\';
    }

    @Nullable
    public String getScriptDelimiterRedefiner() {
        return "DELIMITER";
    }

    public String[][] getBlockBoundStrings() {
        return null;
    }

    public boolean useCaseInsensitiveNameLookup() {
        return this.lowerCaseTableNames != 0;
    }

    @NotNull
    public String escapeString(String string) {
        return string.replace("'", "''").replace("\\^[_%?]", "\\\\");
    }

    @NotNull
    public String unEscapeString(String string) {
        return string.replace("''", "'").replace("\\\\", "\\");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    public String[] getSingleLineComments() {
        return new String[]{"-- ", "#"};
    }

    public String getTestSQL() {
        return "SELECT 1";
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return MYSQL_NON_TRANSACTIONAL_KEYWORDS;
    }

    public boolean isAmbiguousCountBroken() {
        return true;
    }

    protected boolean useBracketsForExec() {
        return true;
    }

    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (attribute.getTypeName().equalsIgnoreCase("json")) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }
}

