/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.OverlayImageDescriptor;
import org.jkiss.dbeaver.ui.OverlayImageDescriptorLegacy;

public class DBeaverIcons {
    private static final Log log;
    private static final boolean useLegacyOverlay;
    private static Map<String, IconDescriptor> imageMap;
    private static Map<String, IconDescriptor> compositeMap;
    private static Image viewMenuImage;
    private static ImageDescriptor viewMenuImageDescriptor;

    static {
        boolean hasCachedImageDataProvider;
        log = Log.getLog(DBeaverIcons.class);
        try {
            Class.forName("org.eclipse.jface.resource.CompositeImageDescriptor$CachedImageDataProvider");
            hasCachedImageDataProvider = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            hasCachedImageDataProvider = false;
        }
        useLegacyOverlay = !hasCachedImageDataProvider;
        imageMap = new HashMap<String, IconDescriptor>();
        compositeMap = new HashMap<String, IconDescriptor>();
    }

    @NotNull
    public static Image getImage(@NotNull DBPImage image) {
        if (image == null) {
            return null;
        }
        if (image instanceof DBIconBinary) {
            return ((DBIconBinary)image).getImage();
        }
        IconDescriptor icon = DBeaverIcons.getIconByLocation(image.getLocation());
        if (icon == null) {
            throw new IllegalArgumentException("Image '" + image.getLocation() + "' not found");
        }
        if (image instanceof DBIconComposite) {
            return DBeaverIcons.getCompositeIcon((IconDescriptor)icon, (DBIconComposite)((DBIconComposite)image)).image;
        }
        return icon.image;
    }

    @NotNull
    public static ImageDescriptor getImageDescriptor(@NotNull DBPImage image) {
        if (image == null) {
            return null;
        }
        if (image instanceof DBIconBinary) {
            return ((DBIconBinary)image).getImageDescriptor();
        }
        IconDescriptor icon = DBeaverIcons.getIconByLocation(image.getLocation());
        if (icon == null) {
            throw new IllegalArgumentException("Image '" + image.getLocation() + "' not found");
        }
        if (image instanceof DBIconComposite) {
            return DBeaverIcons.getCompositeIcon((IconDescriptor)icon, (DBIconComposite)((DBIconComposite)image)).imageDescriptor;
        }
        return icon.imageDescriptor;
    }

    private static IconDescriptor getCompositeIcon(IconDescriptor mainIcon, DBIconComposite image) {
        if (!image.hasOverlays()) {
            return mainIcon;
        }
        String compositeId = String.valueOf(mainIcon.id) + "^" + (image.getTopLeft() == null ? "" : image.getTopLeft().getLocation()) + "^" + (image.getTopRight() == null ? "" : image.getTopRight().getLocation()) + "^" + (image.getBottomLeft() == null ? "" : image.getBottomLeft().getLocation()) + "^" + (image.getBottomRight() == null ? "" : image.getBottomRight().getLocation());
        IconDescriptor icon = compositeMap.get(compositeId);
        if (icon == null) {
            Image resultImage;
            if (useLegacyOverlay) {
                OverlayImageDescriptorLegacy ovrImage = new OverlayImageDescriptorLegacy(mainIcon.image.getImageData());
                if (image.getTopLeft() != null) {
                    ovrImage.setTopLeft(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getTopLeft())});
                }
                if (image.getTopRight() != null) {
                    ovrImage.setTopRight(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getTopRight())});
                }
                if (image.getBottomLeft() != null) {
                    ovrImage.setBottomLeft(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getBottomLeft())});
                }
                if (image.getBottomRight() != null) {
                    ovrImage.setBottomRight(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getBottomRight())});
                }
                resultImage = ovrImage.createImage();
            } else {
                OverlayImageDescriptor ovrImage = new OverlayImageDescriptor(mainIcon.imageDescriptor);
                if (image.getTopLeft() != null) {
                    ovrImage.setTopLeft(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getTopLeft())});
                }
                if (image.getTopRight() != null) {
                    ovrImage.setTopRight(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getTopRight())});
                }
                if (image.getBottomLeft() != null) {
                    ovrImage.setBottomLeft(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getBottomLeft())});
                }
                if (image.getBottomRight() != null) {
                    ovrImage.setBottomRight(new ImageDescriptor[]{DBeaverIcons.getImageDescriptor(image.getBottomRight())});
                }
                resultImage = ovrImage.createImage();
            }
            icon = new IconDescriptor(compositeId, resultImage);
            compositeMap.put(compositeId, icon);
        }
        return icon;
    }

    private static IconDescriptor getIconByLocation(String location) {
        IconDescriptor icon = imageMap.get(location);
        if (icon == null) {
            block4: {
                try {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(location));
                    icon = new IconDescriptor(location, imageDescriptor);
                    if (icon.image != null) break block4;
                    log.warn((Object)("Bad image: " + location));
                    return null;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    return null;
                }
            }
            imageMap.put(location, icon);
        }
        return icon;
    }

    public static synchronized Image getViewMenuImage() {
        if (viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 3, 15, 3, 11, 7, 10, 7};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return viewMenuImage;
    }

    public static synchronized ImageDescriptor getViewMenuImageDescriptor() {
        if (viewMenuImageDescriptor == null) {
            viewMenuImageDescriptor = ImageDescriptor.createFromImage((Image)DBeaverIcons.getViewMenuImage());
        }
        return viewMenuImageDescriptor;
    }

    private static class IconDescriptor {
        String id;
        Image image;
        ImageDescriptor imageDescriptor;

        IconDescriptor(String id, ImageDescriptor imageDescriptor) {
            this.id = id;
            this.image = imageDescriptor.createImage(false);
            this.imageDescriptor = imageDescriptor;
        }

        IconDescriptor(String id, Image image) {
            this.id = id;
            this.image = image;
            this.imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        }
    }
}

