/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class MySQLForeignKeyManager
extends SQLForeignKeyManager<MySQLTableForeignKey, MySQLTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTableForeignKey> getObjectsCache(MySQLTableForeignKey object) {
        return ((MySQLTable)object.getParentObject()).getForeignKeyCache();
    }

    protected MySQLTableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        MySQLTable table = (MySQLTable)container;
        try {
            if ("MyISAM".equalsIgnoreCase(table.getAdditionalInfo(monitor).getEngine().getName())) {
                DBWorkbench.getPlatformUI().showError("Create foreign key", "Foreign keys are not supported by MyISAM engine.\nYou could change table's engine to INNODB or some other relational engine");
                return null;
            }
        }
        catch (DBCException e) {
            log.error((Object)e);
            return null;
        }
        MySQLTableForeignKey foreignKey = new MySQLTableForeignKey(table, "", null, null, DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.NO_ACTION, false);
        foreignKey.setName(this.getNewConstraintName(monitor, (JDBCTableConstraint)foreignKey));
        return foreignKey;
    }

    protected String getDropForeignKeyPattern(MySQLTableForeignKey foreignKey) {
        return "ALTER TABLE %TABLE% DROP FOREIGN KEY %CONSTRAINT%";
    }
}

