/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTriggerManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLServerTableTriggerManager
extends SQLTriggerManager<SQLServerTableTrigger, SQLServerTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableTrigger> getObjectsCache(SQLServerTableTrigger object) {
        return object.getSchema().getTriggerCache();
    }

    protected SQLServerTableTrigger createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        SQLServerTable table = (SQLServerTable)container;
        String newTriggerName = "NewTrigger";
        SQLServerTableTrigger newTrigger = new SQLServerTableTrigger(table, newTriggerName);
        newTrigger.setBody("CREATE OR ALTER TRIGGER " + newTriggerName + " ON " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "\n" + "AFTER INSERT\n" + "AS\n" + ";\n");
        return newTrigger;
    }

    protected void createOrReplaceTriggerQuery(List<DBEPersistAction> actions, SQLServerTableTrigger trigger, boolean create) {
        SQLServerDatabase defaultDatabase = trigger.getDataSource().getDefaultObject();
        if (defaultDatabase != trigger.getTable().getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE " + DBUtils.getQuotedIdentifier((DBSObject)trigger.getTable().getDatabase()), false));
        }
        if (create) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getBody(), true));
        } else {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter trigger", SQLServerUtils.changeCreateToAlterDDL(trigger.getDataSource().getSQLDialect(), trigger.getBody()), true));
        }
        if (defaultDatabase != trigger.getTable().getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)defaultDatabase), false));
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        SQLServerTableTrigger trigger = (SQLServerTableTrigger)command.getObject();
        SQLServerDatabase defaultDatabase = trigger.getDataSource().getDefaultObject();
        if (defaultDatabase != trigger.getTable().getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database", "USE " + DBUtils.getQuotedIdentifier((DBSObject)trigger.getTable().getDatabase()), false));
        }
        super.addObjectDeleteActions(actions, command, options);
        if (defaultDatabase != trigger.getTable().getDatabase()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set current database ", "USE " + DBUtils.getQuotedIdentifier((DBSObject)defaultDatabase), false));
        }
    }
}

