/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.nio.ByteBuffer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.impl.BytesContentStorage;
import org.jkiss.dbeaver.model.impl.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ContentInlineEditor
extends BaseValueEditor<Text> {
    private static final int MAX_STRING_LENGTH = 1048575;
    private static final Log log = Log.getLog(ContentInlineEditor.class);
    private final boolean isText;

    public ContentInlineEditor(IValueController controller) {
        super(controller);
        this.isText = ContentUtils.isTextContent((DBDContent)((DBDContent)controller.getValue()));
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        if (value instanceof DBDContentCached) {
            String stringValue;
            DBDContentCached newValue = (DBDContentCached)value;
            Object cachedValue = newValue.getCachedValue();
            if (cachedValue == null) {
                stringValue = "";
            } else if (cachedValue instanceof byte[]) {
                byte[] bytes = (byte[])cachedValue;
                stringValue = DBValueFormatting.getBinaryPresentation((DBPDataSource)this.valueController.getExecutionContext().getDataSource()).toString(bytes, 0, bytes.length);
            } else if (cachedValue instanceof ByteBuffer) {
                byte[] bytes = ((ByteBuffer)cachedValue).array();
                stringValue = DBValueFormatting.getBinaryPresentation((DBPDataSource)this.valueController.getExecutionContext().getDataSource()).toString(bytes, 0, bytes.length);
            } else {
                stringValue = cachedValue.toString();
            }
            ((Text)this.control).setText(stringValue);
            ((Text)this.control).selectAll();
        }
    }

    @Override
    protected Text createControl(Composite editPlaceholder) {
        Text editor = new Text(editPlaceholder, 2048);
        editor.setEditable(!this.valueController.isReadOnly());
        editor.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        long maxLength = this.valueController.getValueType().getMaxLength();
        maxLength = maxLength <= 0L ? 1048575L : Math.min(maxLength, 1048575L);
        editor.setTextLimit((int)maxLength);
        return editor;
    }

    @Override
    public Object extractEditorValue() {
        String newValue = ((Text)this.control).getText();
        DBDContent content = (DBDContent)this.valueController.getValue();
        assert (content != null);
        try {
            if (this.isText) {
                content.updateContents((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContentStorage)new StringContentStorage(newValue));
            } else {
                content.updateContents((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContentStorage)new BytesContentStorage(newValue.getBytes(GeneralUtils.getDefaultFileEncoding()), GeneralUtils.getDefaultFileEncoding()));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return content;
    }
}

