/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class GenericFilterValueEdit {
    private static final Log log = Log.getLog(GenericFilterValueEdit.class);
    TableViewer tableViewer;
    String filterPattern;
    private KeyLoadJob loadJob;
    IValueEditor editor;
    Text textControl;
    @NotNull
    final ResultSetViewer viewer;
    @NotNull
    final DBDAttributeBinding attr;
    @NotNull
    final ResultSetRow[] rows;
    @NotNull
    final DBCLogicalOperator operator;
    private boolean isCheckedTable;
    private static final int MAX_MULTI_VALUES = 1000;
    private static final String MULTI_KEY_LABEL = "...";

    GenericFilterValueEdit(@NotNull ResultSetViewer viewer, @NotNull DBDAttributeBinding attr, @NotNull ResultSetRow[] rows, @NotNull DBCLogicalOperator operator) {
        this.viewer = viewer;
        this.attr = attr;
        this.rows = rows;
        this.operator = operator;
    }

    void setupTable(Composite composite, int style, boolean visibleLines, boolean visibleHeader, Object layoutData) {
        this.tableViewer = new TableViewer(composite, style);
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(visibleLines);
        table.setHeaderVisible(visibleHeader);
        table.setLayoutData(layoutData);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        boolean bl = this.isCheckedTable = (style & 0x20) == 32;
        if (this.isCheckedTable) {
            Composite buttonsPanel = UIUtils.createComposite((Composite)composite, (int)2);
            UIUtils.createPushButton((Composite)buttonsPanel, (String)"Select All", null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] tableItemArray = table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(true);
                        ++n2;
                    }
                }
            });
            UIUtils.createPushButton((Composite)buttonsPanel, (String)"Select None", null, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] tableItemArray = table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(false);
                        ++n2;
                    }
                }
            });
        }
    }

    void addContextMenu(Action[] actions) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            UIUtils.fillDefaultTableContextMenu((IContributionManager)manager, (Table)this.tableViewer.getTable());
            manager.add((IContributionItem)new Separator());
            Action[] actionArray2 = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action act = actionArray2[n2];
                manager.add((IAction)act);
                ++n2;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menuMgr.createContextMenu((Control)this.tableViewer.getTable()));
        this.tableViewer.getTable().addDisposeListener(e -> menuMgr.dispose());
    }

    Collection<DBDLabelValuePair> getMultiValues() {
        return (Collection)this.tableViewer.getInput();
    }

    Text addFilterTextbox(Composite composite) {
        Text valueFilterText = new Text(composite, 2048);
        valueFilterText.setLayoutData((Object)new GridData(768));
        valueFilterText.addModifyListener(e -> {
            this.filterPattern = valueFilterText.getText();
            if (this.filterPattern.isEmpty()) {
                this.filterPattern = null;
            }
            this.loadValues(null);
        });
        return valueFilterText;
    }

    void loadValues(Runnable onFinish) {
        if (this.loadJob != null) {
            this.loadJob.schedule(200L);
            return;
        }
        DBSEntityReferrer enumerableConstraint = ReferenceValueEditor.getEnumerableConstraint(this.attr);
        if (enumerableConstraint != null) {
            this.loadConstraintEnum(enumerableConstraint, onFinish);
        } else if (this.attr.getEntityAttribute() instanceof DBSAttributeEnumerable) {
            this.loadAttributeEnum((DBSAttributeEnumerable)this.attr.getEntityAttribute(), onFinish);
        } else {
            this.loadMultiValueList(Collections.emptyList(), this.isCheckedTable);
        }
    }

    private void loadConstraintEnum(final DBSEntityReferrer refConstraint, Runnable onFinish) {
        this.loadJob = new KeyLoadJob(this, "Load constraint '" + refConstraint.getName() + "' values", onFinish){

            @Override
            List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor monitor) throws DBException {
                DBSEntityAttribute tableColumn = attr.getEntityAttribute();
                if (tableColumn == null) {
                    return null;
                }
                DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)refConstraint, (DBSEntityAttribute)tableColumn);
                if (fkColumn == null) {
                    return null;
                }
                if (!(refConstraint instanceof DBSEntityAssociation)) {
                    return null;
                }
                DBSEntityAssociation association = (DBSEntityAssociation)refConstraint;
                DBSEntityAttribute refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                if (refColumn == null) {
                    return null;
                }
                DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
                DBSEntityConstraint refConstraint2 = association.getReferencedConstraint();
                DBSDictionary enumConstraint = (DBSDictionary)refConstraint2.getParentObject();
                if (fkAttribute != null && enumConstraint != null) {
                    return enumConstraint.getDictionaryEnumeration(monitor, refColumn, (Object)filterPattern, null, true, true, 1000);
                }
                return null;
            }
        };
        this.loadJob.schedule();
    }

    private void loadAttributeEnum(final DBSAttributeEnumerable attributeEnumerable, Runnable onFinish) {
        if (this.tableViewer.getTable().getColumns().length > 1) {
            this.tableViewer.getTable().getColumn(1).setText("Count");
        }
        this.loadJob = new KeyLoadJob(this, "Load '" + this.attr.getName() + "' values", onFinish){
            private List<DBDLabelValuePair> result;

            @Override
            List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor monitor) throws DBException {
                DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)attributeEnumerable.getDataSource(), param -> {
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)attributeEnumerable, (String)"Read value enumeration");){
                            this.result = attributeEnumerable.getValueEnumeration(session, (Object)filterPattern, 1000);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                return this.result;
            }
        };
        this.loadJob.schedule();
    }

    private void loadMultiValueList(@NotNull Collection<DBDLabelValuePair> values, boolean mergeResultsWithData) {
        Widget item;
        ViewerColumnController vcc;
        Object itemString;
        String itemString2;
        if (this.tableViewer == null || this.tableViewer.getControl() == null || this.tableViewer.getControl().isDisposed()) {
            return;
        }
        Pattern pattern = null;
        if (!CommonUtils.isEmpty((String)this.filterPattern) && this.attr.getDataKind() == DBPDataKind.STRING) {
            pattern = Pattern.compile(SQLUtils.makeLikePattern((String)("%" + this.filterPattern + "%")), 2);
        }
        boolean hasNulls = false;
        HashMap<Object, DBDLabelValuePair> rowData = new HashMap<Object, DBDLabelValuePair>();
        for (DBDLabelValuePair pair : values) {
            DBDLabelValuePair oldLabel = (DBDLabelValuePair)rowData.get(pair.getValue());
            if (oldLabel != null) {
                String multiLabel = String.valueOf(oldLabel.getLabel()) + "," + pair.getLabel();
                if (multiLabel.length() > 200) {
                    multiLabel = String.valueOf(multiLabel.substring(0, 200)) + MULTI_KEY_LABEL;
                }
                rowData.put(pair.getValue(), new DBDLabelValuePair(multiLabel, pair.getValue()));
                continue;
            }
            rowData.put(pair.getValue(), pair);
        }
        if (mergeResultsWithData) {
            for (ResultSetRow row : this.viewer.getModel().getAllRows()) {
                Object cellValue = this.viewer.getModel().getCellValue(this.attr, row);
                if (DBUtils.isNullValue((Object)cellValue)) {
                    hasNulls = true;
                    continue;
                }
                if (this.keyPresents(rowData, cellValue)) continue;
                itemString2 = this.attr.getValueHandler().getValueDisplayString((DBSTypedObject)this.attr, cellValue, DBDDisplayFormat.UI);
                rowData.put(cellValue, new DBDLabelValuePair(itemString2, cellValue));
            }
        }
        ArrayList sortedList = new ArrayList(rowData.values());
        if (pattern != null) {
            Iterator iter = sortedList.iterator();
            while (iter.hasNext()) {
                DBDLabelValuePair valuePair = (DBDLabelValuePair)iter.next();
                itemString2 = this.attr.getValueHandler().getValueDisplayString((DBSTypedObject)this.attr, valuePair.getValue(), DBDDisplayFormat.UI);
                if (pattern.matcher(itemString2).matches() || valuePair.getLabel() != null && pattern.matcher(valuePair.getLabel()).matches()) continue;
                iter.remove();
            }
        } else if (this.filterPattern != null && this.attr.getDataKind() == DBPDataKind.NUMERIC) {
            double minValue = CommonUtils.toDouble((Object)this.filterPattern);
            Iterator<Object> iter = sortedList.iterator();
            while (iter.hasNext()) {
                DBDLabelValuePair valuePair = (DBDLabelValuePair)iter.next();
                itemString = this.attr.getValueHandler().getValueDisplayString((DBSTypedObject)this.attr, valuePair.getValue(), DBDDisplayFormat.EDIT);
                double itemValue = CommonUtils.toDouble((Object)itemString);
                if (!(itemValue < minValue)) continue;
                iter.remove();
            }
        }
        try {
            Collections.sort(sortedList);
        }
        catch (Exception e) {
            log.error((Object)"Error sorting value collection", (Throwable)e);
        }
        if (hasNulls) {
            boolean nullPresents = false;
            for (DBDLabelValuePair val : rowData.values()) {
                if (!DBUtils.isNullValue((Object)val.getValue())) continue;
                nullPresents = true;
                break;
            }
            if (!nullPresents) {
                sortedList.add(0, new DBDLabelValuePair(DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)DBDDisplayFormat.UI), null));
            }
        }
        HashSet<Object> checkedValues = new HashSet<Object>();
        itemString = this.rows;
        int valuePair = this.rows.length;
        int iter = 0;
        while (iter < valuePair) {
            ResultSetRow row = itemString[iter];
            Object value = this.viewer.getModel().getCellValue(this.attr, row);
            checkedValues.add(value);
            ++iter;
        }
        DBDAttributeConstraint constraint = this.viewer.getModel().getDataFilter().getConstraint(this.attr);
        if (constraint != null && constraint.getOperator() == DBCLogicalOperator.IN && constraint.getValue() instanceof Object[]) {
            Collections.addAll(checkedValues, (Object[])constraint.getValue());
        }
        this.tableViewer.setInput(sortedList);
        DBDLabelValuePair firstVisibleItem = null;
        if (this.isCheckedTable) {
            for (DBDLabelValuePair row : sortedList) {
                Object cellValue = row.getValue();
                if (!checkedValues.contains(cellValue)) continue;
                TableItem t = (TableItem)this.tableViewer.testFindItem((Object)row);
                t.setChecked(true);
                if (firstVisibleItem != null) continue;
                firstVisibleItem = row;
            }
        }
        if ((vcc = ViewerColumnController.getFromControl((Control)this.tableViewer.getTable())) != null) {
            vcc.repackColumns();
        }
        if (firstVisibleItem != null && (item = this.tableViewer.testFindItem(firstVisibleItem)) != null) {
            this.tableViewer.getTable().setSelection((TableItem)item);
            this.tableViewer.getTable().showItem((TableItem)item);
        }
    }

    private boolean keyPresents(Map<Object, DBDLabelValuePair> rowData, Object cellValue) {
        if (cellValue instanceof Number) {
            for (Object key : rowData.keySet()) {
                if (!(key instanceof Number) || CommonUtils.compareNumbers((Number)((Number)key), (Number)((Number)cellValue)) != 0) continue;
                return true;
            }
        }
        return rowData.containsKey(cellValue);
    }

    private abstract class KeyLoadJob
    extends AbstractJob {
        private final Runnable onFinish;

        KeyLoadJob(String name, Runnable onFinish) {
            super(name);
            this.onFinish = onFinish;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            DBCExecutionContext executionContext = GenericFilterValueEdit.this.viewer.getExecutionContext();
            if (executionContext == null) {
                return Status.OK_STATUS;
            }
            try {
                List<DBDLabelValuePair> valueEnumeration = this.readEnumeration(monitor);
                if (valueEnumeration == null) {
                    return Status.OK_STATUS;
                }
                this.populateValues(valueEnumeration);
                if (this.onFinish != null) {
                    this.onFinish.run();
                }
            }
            catch (Throwable e) {
                this.populateValues(Collections.emptyList());
                return GeneralUtils.makeExceptionStatus((Throwable)e);
            }
            return Status.OK_STATUS;
        }

        @Nullable
        abstract List<DBDLabelValuePair> readEnumeration(DBRProgressMonitor var1) throws DBException;

        boolean mergeResultsWithData() {
            return CommonUtils.isEmpty((String)GenericFilterValueEdit.this.filterPattern);
        }

        void populateValues(@NotNull Collection<DBDLabelValuePair> values) {
            UIUtils.asyncExec(() -> GenericFilterValueEdit.this.loadMultiValueList(values, this.mergeResultsWithData()));
        }
    }
}

