/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.commands.Command;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildSetMenu;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.actions.QuickMenuAction;
import org.eclipse.ui.internal.ide.actions.RetargetActionWithDefault;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public final class WorkbenchActionBuilder
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction workbookEditorsAction;
    private ActionFactory.IWorkbenchAction quickAccessAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private ActionFactory.IWorkbenchAction newWizardAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    private ActionFactory.IWorkbenchAction buildAllAction;
    private ActionFactory.IWorkbenchAction cleanAction;
    private ActionFactory.IWorkbenchAction toggleAutoBuildAction;
    private MenuManager buildWorkingSetMenu;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private QuickMenuAction showInQuickMenu;
    private QuickMenuAction newQuickMenu;
    private ActionFactory.IWorkbenchAction introAction;
    private ActionFactory.IWorkbenchAction buildProjectAction;
    private CommandContributionItem minimizeItem;
    private CommandContributionItem zoomItem;
    private CommandContributionItem fullscreenItem;
    private CommandContributionItem arrangeWindowsItem;
    private NewWizardMenu newWizardMenu;
    private StatusLineContributionItem statusLineItem;
    private Preferences.IPropertyChangeListener prefListener;
    private IPropertyChangeListener propPrefListener;
    private IPageListener pageListener;
    private IPartListener partListener;
    private IResourceChangeListener resourceListener;
    private boolean isDisposed = false;

    public WorkbenchActionBuilder(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
                BuildAction buildHandler = new BuildAction((IShellProvider)page.getWorkbenchWindow(), 10);
                ((RetargetActionWithDefault)WorkbenchActionBuilder.this.buildProjectAction).setDefaultHandler((IAction)buildHandler);
            }
        };
        this.getWindow().addPageListener(this.pageListener);
        this.partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (!(part instanceof IEditorPart)) {
                    return;
                }
                ICommandService commandService = (ICommandService)WorkbenchActionBuilder.this.window.getService(ICommandService.class);
                commandService.refreshElements("org.eclipse.ui.window.pinEditor", null);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }
        };
        this.getWindow().getPartService().addPartListener(this.partListener);
        this.prefListener = event -> {
            if (event.getProperty().equals("description.autobuilding")) {
                this.updateBuildActions(false);
            }
        };
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.prefListener);
        this.propPrefListener = event -> {
            if (event.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && this.window.getShell() != null && !this.window.getShell().isDisposed()) {
                this.window.getShell().getDisplay().asyncExec(() -> {
                    if (this.window.getShell() != null && !this.window.getShell().isDisposed()) {
                        this.updatePinActionToolbar();
                    }
                });
            }
        };
        WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propPrefListener);
        this.resourceListener = event -> {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean changed;
                IResourceDelta projectDelta = iResourceDeltaArray[n2];
                int kind = projectDelta.getKind();
                boolean bl = changed = (projectDelta.getFlags() & 0x84000) != 0;
                if (kind != 4 || changed) {
                    this.updateBuildActions(false);
                    return;
                }
                ++n2;
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    public void fillActionBars(int flags) {
        super.fillActionBars(flags);
        this.updateBuildActions(true);
        if ((flags & 1) == 0) {
            this.hookListeners();
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        IActionBarConfigurer2 actionBarConfigurer = (IActionBarConfigurer2)this.getActionBarConfigurer();
        coolBar.add((IContributionItem)new GroupMarker("group.file"));
        IToolBarManager fileToolBar = actionBarConfigurer.createToolBarManager();
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IAction)this.newWizardDropDownAction);
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IAction)this.saveAllAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add(this.getPrintItem());
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("build.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("build.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("group.edit"));
        IToolBarManager editToolBar = actionBarConfigurer.createToolBarManager();
        editToolBar.add((IContributionItem)new Separator("edit.group"));
        editToolBar.add((IAction)this.undoAction);
        editToolBar.add((IAction)this.redoAction);
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(editToolBar, "org.eclipse.ui.workbench.edit"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new GroupMarker("group.nav"));
        IToolBarManager navToolBar = actionBarConfigurer.createToolBarManager();
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IContributionItem)new GroupMarker("group.application"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        navToolBar.add((IContributionItem)new Separator("pin.group"));
        navToolBar.add(this.getPinEditorItem());
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(navToolBar, "org.eclipse.ui.workbench.navigate"));
        coolBar.add((IContributionItem)new GroupMarker("group.editor"));
        coolBar.add((IContributionItem)new GroupMarker("group.help"));
        IToolBarManager helpToolBar = actionBarConfigurer.createToolBarManager();
        helpToolBar.add((IContributionItem)new Separator("group.help"));
        helpToolBar.add((IContributionItem)new GroupMarker("group.application"));
        coolBar.add((IContributionItem)actionBarConfigurer.createToolBarContributionItem(helpToolBar, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createNavigateMenu());
        menuBar.add((IContributionItem)this.createProjectMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        String newText = IDEWorkbenchMessages.Workbench_new;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId);
        newMenu.setActionDefinitionId("org.eclipse.ui.file.newQuickMenu");
        newMenu.add((IContributionItem)new Separator(newId));
        this.newWizardMenu = new NewWizardMenu(this.getWindow());
        newMenu.add((IContributionItem)this.newWizardMenu);
        newMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)newMenu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        MenuManager recent = new MenuManager(WorkbenchMessages.OpenRecentDocuments_text);
        recent.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        recent.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)recent);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        menu.add((IAction)this.saveAllAction);
        menu.add(this.getRevertItem());
        menu.add((IContributionItem)new Separator());
        menu.add(this.getMoveItem());
        menu.add(this.getRenameItem());
        menu.add(this.getRefreshItem());
        menu.add((IContributionItem)new GroupMarker("save.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getPrintItem());
        menu.add((IContributionItem)new GroupMarker("print.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.importResourcesAction);
        menu.add((IAction)this.exportResourcesAction);
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getPropertiesItem());
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.openWorkspaceAction);
        ActionContributionItem quitItem = new ActionContributionItem((IAction)this.quitAction);
        quitItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)quitItem);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getCutItem());
        menu.add(this.getCopyItem());
        menu.add(this.getPasteItem());
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getDeleteItem());
        menu.add(this.getSelectAllItem());
        menu.add((IContributionItem)new Separator());
        menu.add(this.getFindItem());
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getBookmarkItem());
        menu.add(this.getTaskItem());
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_navigate, "navigate");
        menu.add((IContributionItem)new GroupMarker("navStart"));
        menu.add((IAction)this.goIntoAction);
        MenuManager goToSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_goTo, "goTo");
        menu.add((IContributionItem)goToSubMenu);
        goToSubMenu.add((IAction)this.backAction);
        goToSubMenu.add((IAction)this.forwardAction);
        goToSubMenu.add((IAction)this.upAction);
        goToSubMenu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("open.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator("show.ext"));
        MenuManager showInSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_showIn, "showIn");
        showInSubMenu.setActionDefinitionId(this.showInQuickMenu.getActionDefinitionId());
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getWindow()));
        menu.add((IContributionItem)showInSubMenu);
        i = 2;
        while (i < 5) {
            menu.add((IContributionItem)new Separator("show.ext" + i));
            ++i;
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.nextAction);
        menu.add((IAction)this.previousAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new GroupMarker("navEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.backwardHistoryAction);
        menu.add((IAction)this.forwardHistoryAction);
        return menu;
    }

    private MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_project, "project");
        menu.add((IContributionItem)new Separator("projStart"));
        menu.add(this.getOpenProjectItem());
        menu.add(this.getCloseProjectItem());
        menu.add((IContributionItem)new GroupMarker("open.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.buildAllAction);
        menu.add((IAction)this.buildProjectAction);
        this.addWorkingSetBuildActions(menu);
        menu.add((IAction)this.cleanAction);
        menu.add((IAction)this.toggleAutoBuildAction);
        menu.add((IContributionItem)new GroupMarker("build.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("projEnd"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.projectPropertyDialogAction);
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_window, "window");
        this.addMacWindowMenuItems(menu);
        menu.add((IAction)this.newWindowAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)this.addShowView());
        menu.add((IContributionItem)this.addPerspectiveActions());
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        Separator sep = new Separator("additions");
        sep.setVisible(!Util.isMac());
        menu.add((IContributionItem)sep);
        if (Util.isCocoa()) {
            menu.add((IContributionItem)this.arrangeWindowsItem);
        }
        ActionContributionItem openPreferencesItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        openPreferencesItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)openPreferencesItem);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private void addMacWindowMenuItems(MenuManager windowMenu) {
        if (!Util.isCocoa()) {
            return;
        }
        windowMenu.add((IContributionItem)this.minimizeItem);
        windowMenu.add((IContributionItem)this.zoomItem);
        windowMenu.add((IContributionItem)this.fullscreenItem);
        windowMenu.add((IContributionItem)new Separator());
    }

    private MenuManager addShowView() {
        MenuManager showViewMenuMgr = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        return showViewMenuMgr;
    }

    private MenuManager addPerspectiveActions() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_perspective, "perspective");
        menu.add((IContributionItem)new GroupMarker("perspectiveStart"));
        String openText = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager changePerspMenuMgr = new MenuManager(openText, WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_NEW_PAGE"), "openPerspective");
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add(this.getSavePerspectiveItem());
        menu.add(this.getResetPerspectiveItem());
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
        return menu;
    }

    private void addWorkingSetBuildActions(MenuManager menu) {
        this.buildWorkingSetMenu = new MenuManager(IDEWorkbenchMessages.Workbench_buildSet);
        BuildSetMenu workingSetBuilds = new BuildSetMenu(this.window, this.getActionBarConfigurer());
        this.buildWorkingSetMenu.add((IContributionItem)workingSetBuilds);
        menu.add((IContributionItem)this.buildWorkingSetMenu);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.Workbench_shortcuts, "shortcuts");
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IAction)this.quickAccessAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IAction)this.switchToEditorAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_help, "help");
        this.addSeparatorOrGroupMarker(menu, "group.intro");
        if (this.introAction != null) {
            menu.add((IAction)this.introAction);
        } else if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.main");
        menu.add((IAction)this.helpContentsAction);
        menu.add((IAction)this.helpSearchAction);
        menu.add((IAction)this.dynamicHelpAction);
        this.addSeparatorOrGroupMarker(menu, "group.assist");
        if (this.tipsAndTricksAction != null) {
            menu.add((IAction)this.tipsAndTricksAction);
        }
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.tutorials");
        this.addSeparatorOrGroupMarker(menu, "group.tools");
        this.addSeparatorOrGroupMarker(menu, "group.updates");
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        this.addSeparatorOrGroupMarker(menu, "additions");
        menu.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
        aboutItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)aboutItem);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addSeparatorOrGroupMarker(MenuManager menu, String groupId) {
        String prefId = "useSeparator." + menu.getId() + "." + groupId;
        boolean addExtraSeparators = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(prefId);
        if (addExtraSeparators) {
            menu.add((IContributionItem)new Separator(groupId));
        } else {
            menu.add((IContributionItem)new GroupMarker(groupId));
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.getActionBarConfigurer().getStatusLineManager().remove((IContributionItem)this.statusLineItem);
        if (this.pageListener != null) {
            this.window.removePageListener(this.pageListener);
            this.pageListener = null;
        }
        if (this.partListener != null) {
            this.window.getPartService().removePartListener(this.partListener);
            this.partListener = null;
        }
        if (this.prefListener != null) {
            ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        if (this.propPrefListener != null) {
            WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propPrefListener);
            this.propPrefListener = null;
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resourceListener = null;
        }
        this.showInQuickMenu.dispose();
        this.newQuickMenu.dispose();
        this.closeAction = null;
        this.closeAllAction = null;
        this.closeAllSavedAction = null;
        this.closeOthersAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.newWindowAction = null;
        this.helpContentsAction = null;
        this.helpSearchAction = null;
        this.dynamicHelpAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.saveAsAction = null;
        this.hideShowEditorAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.lockToolBarAction = null;
        this.closeAllPerspsAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.activateEditorAction = null;
        this.switchToEditorAction = null;
        this.quickAccessAction.dispose();
        this.quickAccessAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.quitAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.openWorkspaceAction = null;
        this.projectPropertyDialogAction = null;
        this.newWizardAction = null;
        this.newWizardDropDownAction = null;
        this.importResourcesAction = null;
        this.exportResourcesAction = null;
        this.buildAllAction = null;
        this.cleanAction = null;
        this.toggleAutoBuildAction = null;
        this.buildWorkingSetMenu = null;
        this.quickStartAction = null;
        this.tipsAndTricksAction = null;
        this.showInQuickMenu = null;
        this.newQuickMenu = null;
        this.buildProjectAction = null;
        if (this.newWizardMenu != null) {
            this.newWizardMenu.dispose();
            this.newWizardMenu = null;
        }
        this.statusLineItem = null;
        this.prefListener = null;
        this.propPrefListener = null;
        this.introAction = null;
        this.minimizeItem = null;
        this.zoomItem = null;
        this.fullscreenItem = null;
        this.arrangeWindowsItem = null;
        super.dispose();
    }

    void updateModeLine(String text) {
        this.statusLineItem.setText(text);
    }

    public boolean isApplicationMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        statusLine.add((IContributionItem)this.statusLineItem);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.newWizardAction = ActionFactory.NEW.create(window);
        this.register((IAction)this.newWizardAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(window);
        this.register((IAction)this.newWizardDropDownAction);
        this.importResourcesAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportResourcesAction);
        this.buildAllAction = IDEActionFactory.BUILD.create(window);
        this.register((IAction)this.buildAllAction);
        this.cleanAction = IDEActionFactory.BUILD_CLEAN.create(window);
        this.register((IAction)this.cleanAction);
        this.toggleAutoBuildAction = IDEActionFactory.BUILD_AUTOMATICALLY.create(window);
        this.register((IAction)this.toggleAutoBuildAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText(IDEWorkbenchMessages.Workbench_openNewWindow);
        this.register((IAction)this.newWindowAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(window);
        this.register((IAction)this.closeOthersAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(window);
        this.register((IAction)this.closeAllSavedAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.makeFeatureDependentActions(window);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register((IAction)this.activateEditorAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register((IAction)this.switchToEditorAction);
        this.workbookEditorsAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register((IAction)this.workbookEditorsAction);
        this.quickAccessAction = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(window);
        this.register((IAction)this.hideShowEditorAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(window);
        this.register((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(window);
        this.register((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(window);
        this.register((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(window);
        this.register((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_NEXT_NAV"));
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_PREVIOUS_NAV"));
        this.register((IAction)this.previousAction);
        this.buildProjectAction = IDEActionFactory.BUILD_PROJECT.create(window);
        this.register((IAction)this.buildProjectAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register((IAction)this.openWorkspaceAction);
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(window);
        this.register((IAction)this.projectPropertyDialogAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        String showInQuickMenuId = "org.eclipse.ui.navigate.showInQuickMenu";
        this.showInQuickMenu = new QuickMenuAction(showInQuickMenuId){

            @Override
            protected void fillMenu(IMenuManager menu) {
                menu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(window));
            }
        };
        this.register((IAction)this.showInQuickMenu);
        this.newQuickMenu = new QuickMenuAction("org.eclipse.ui.file.newQuickMenu"){

            @Override
            protected void fillMenu(IMenuManager menu) {
                menu.add((IContributionItem)new NewWizardMenu(window));
            }
        };
        this.register((IAction)this.newQuickMenu);
        if (Util.isCocoa()) {
            CommandContributionItemParameter minimizeParam = new CommandContributionItemParameter((IServiceLocator)window, null, "org.eclipse.ui.cocoa.minimizeWindow", 8);
            this.minimizeItem = new CommandContributionItem(minimizeParam);
            CommandContributionItemParameter zoomParam = new CommandContributionItemParameter((IServiceLocator)window, null, "org.eclipse.ui.cocoa.zoomWindow", 8);
            this.zoomItem = new CommandContributionItem(zoomParam);
            CommandContributionItemParameter fullscreenParam = new CommandContributionItemParameter((IServiceLocator)window, null, "org.eclipse.ui.cocoa.fullscreenWindow", 8);
            this.fullscreenItem = new CommandContributionItem(fullscreenParam);
            CommandContributionItemParameter arrangeWindowsParam = new CommandContributionItemParameter((IServiceLocator)window, null, "org.eclipse.ui.cocoa.arrangeWindowsInFront", 8);
            this.arrangeWindowsItem = new CommandContributionItem(arrangeWindowsParam);
        }
    }

    private void makeFeatureDependentActions(IWorkbenchWindow window) {
        AboutInfo[] infos = null;
        IPreferenceStore prefs = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String stateKey = "platformState";
        String prevState = prefs.getString(stateKey);
        String currentState = String.valueOf(Platform.getStateStamp());
        boolean sameState = currentState.equals(prevState);
        if (!sameState) {
            prefs.putValue(stateKey, currentState);
        }
        String quickStartKey = IDEActionFactory.QUICK_START.getId();
        String showQuickStart = prefs.getString(quickStartKey);
        if (sameState && "true".equals(showQuickStart)) {
            this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
            this.register((IAction)this.quickStartAction);
        } else if (!sameState || !"false".equals(showQuickStart)) {
            infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            boolean found = this.hasWelcomePage(infos);
            prefs.setValue(quickStartKey, String.valueOf(found));
            if (found) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
                this.register((IAction)this.quickStartAction);
            }
        }
        String tipsAndTricksKey = IDEActionFactory.TIPS_AND_TRICKS.getId();
        String showTipsAndTricks = prefs.getString(tipsAndTricksKey);
        if (sameState && "true".equals(showTipsAndTricks)) {
            this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
            this.register((IAction)this.tipsAndTricksAction);
        } else if (!sameState || !"false".equals(showTipsAndTricks)) {
            if (infos == null) {
                infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            }
            boolean found = this.hasTipsAndTricks(infos);
            prefs.setValue(tipsAndTricksKey, String.valueOf(found));
            if (found) {
                this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
                this.register((IAction)this.tipsAndTricksAction);
            }
        }
    }

    private boolean hasWelcomePage(AboutInfo[] infos) {
        AboutInfo[] aboutInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutInfo info = aboutInfoArray[n2];
            if (info.getWelcomePageURL() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasTipsAndTricks(AboutInfo[] infos) {
        AboutInfo[] aboutInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutInfo info = aboutInfoArray[n2];
            if (info.getTipsAndTricksHref() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void updateBuildActions(boolean immediately) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                boolean found;
                if (WorkbenchActionBuilder.this.isDisposed) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                boolean enabled = BuildUtilities.isEnabled(projects, 10);
                this.updateCommandEnablement(WorkbenchActionBuilder.this.buildAllAction.getActionDefinitionId());
                WorkbenchActionBuilder.this.buildProjectAction.setEnabled(enabled);
                WorkbenchActionBuilder.this.toggleAutoBuildAction.setChecked(workspace.isAutoBuilding());
                WorkbenchActionBuilder.this.cleanAction.setEnabled(BuildUtilities.isEnabled(projects, 15));
                ICoolBarManager coolBarManager = WorkbenchActionBuilder.this.getActionBarConfigurer().getCoolBarManager();
                IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.file");
                if (!(cbItem instanceof IToolBarContributionItem)) {
                    IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
                    return;
                }
                IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
                IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
                if (toolBarManager == null) {
                    IDEWorkbenchPlugin.log("File toolbar is missing");
                    return;
                }
                boolean bl = found = toolBarManager.find(WorkbenchActionBuilder.this.buildAllAction.getId()) != null;
                if (enabled && !found) {
                    toolBarManager.appendToGroup("build.group", (IAction)WorkbenchActionBuilder.this.buildAllAction);
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                } else if (WorkbenchActionBuilder.this.buildAllAction != null && found && !enabled) {
                    toolBarManager.remove(WorkbenchActionBuilder.this.buildAllAction.getId());
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                }
            }

            private void updateCommandEnablement(String commandId) {
                IHandlerService handlerService = (IHandlerService)WorkbenchActionBuilder.this.window.getService(IHandlerService.class);
                ICommandService commandService = (ICommandService)WorkbenchActionBuilder.this.window.getService(ICommandService.class);
                if (handlerService != null && commandService != null) {
                    Command buildAllCmd = commandService.getCommand(commandId);
                    buildAllCmd.setEnabled((Object)handlerService.getCurrentState());
                }
            }
        };
        if (immediately) {
            update.run();
        } else {
            Shell shell = this.window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(update);
            }
        }
    }

    void updatePinActionToolbar() {
        ICoolBarManager coolBarManager = this.getActionBarConfigurer().getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.navigate");
        if (!(cbItem instanceof IToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("Navigation toolbar contribution item is missing");
            return;
        }
        IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log("Navigate toolbar is missing");
            return;
        }
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean reuseEditors = store.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        IContributionItem pinItem = toolBarManager.find("org.eclipse.ui.window.pinEditor");
        if (pinItem != null) {
            pinItem.setVisible(reuseEditors);
        }
        toolBarManager.markDirty();
        toolBarManager.update(false);
        toolBarItem.update("size");
        this.window.getShell().getDisplay().asyncExec(() -> {
            if (this.window.getShell() != null && !this.window.getShell().isDisposed()) {
                ICommandService commandService = (ICommandService)this.window.getService(ICommandService.class);
                commandService.refreshElements("org.eclipse.ui.window.pinEditor", null);
            }
        });
    }

    private IContributionItem getPinEditorItem() {
        return ContributionItemFactory.PIN_EDITOR.create(this.window);
    }

    private IContributionItem getCutItem() {
        return this.getItem(ActionFactory.CUT.getId(), ActionFactory.CUT.getCommandId(), "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED", WorkbenchMessages.Workbench_cut, WorkbenchMessages.Workbench_cutToolTip);
    }

    private IContributionItem getCopyItem() {
        return this.getItem(ActionFactory.COPY.getId(), ActionFactory.COPY.getCommandId(), "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED", WorkbenchMessages.Workbench_copy, WorkbenchMessages.Workbench_copyToolTip);
    }

    private IContributionItem getResetPerspectiveItem() {
        return this.getItem(ActionFactory.RESET_PERSPECTIVE.getId(), ActionFactory.RESET_PERSPECTIVE.getCommandId(), null, null, WorkbenchMessages.ResetPerspective_text, WorkbenchMessages.ResetPerspective_toolTip);
    }

    private IContributionItem getSavePerspectiveItem() {
        return this.getItem(ActionFactory.SAVE_PERSPECTIVE.getId(), ActionFactory.SAVE_PERSPECTIVE.getCommandId(), null, null, WorkbenchMessages.SavePerspective_text, WorkbenchMessages.SavePerspective_toolTip);
    }

    private IContributionItem getPasteItem() {
        return this.getItem(ActionFactory.PASTE.getId(), ActionFactory.PASTE.getCommandId(), "IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED", WorkbenchMessages.Workbench_paste, WorkbenchMessages.Workbench_pasteToolTip);
    }

    private IContributionItem getPrintItem() {
        return this.getItem(ActionFactory.PRINT.getId(), ActionFactory.PRINT.getCommandId(), "IMG_ETOOL_PRINT_EDIT", "IMG_ETOOL_PRINT_EDIT_DISABLED", WorkbenchMessages.Workbench_print, WorkbenchMessages.Workbench_printToolTip);
    }

    private IContributionItem getSelectAllItem() {
        return this.getItem(ActionFactory.SELECT_ALL.getId(), ActionFactory.SELECT_ALL.getCommandId(), null, null, WorkbenchMessages.Workbench_selectAll, WorkbenchMessages.Workbench_selectAllToolTip);
    }

    private IContributionItem getFindItem() {
        return this.getItem(ActionFactory.FIND.getId(), ActionFactory.FIND.getCommandId(), null, null, WorkbenchMessages.Workbench_findReplace, WorkbenchMessages.Workbench_findReplaceToolTip);
    }

    private IContributionItem getBookmarkItem() {
        return this.getItem(IDEActionFactory.BOOKMARK.getId(), IDEActionFactory.BOOKMARK.getCommandId(), null, null, IDEWorkbenchMessages.Workbench_addBookmark, IDEWorkbenchMessages.Workbench_addBookmarkToolTip);
    }

    private IContributionItem getTaskItem() {
        return this.getItem(IDEActionFactory.ADD_TASK.getId(), IDEActionFactory.ADD_TASK.getCommandId(), null, null, IDEWorkbenchMessages.Workbench_addTask, IDEWorkbenchMessages.Workbench_addTaskToolTip);
    }

    private IContributionItem getDeleteItem() {
        return this.getItem(ActionFactory.DELETE.getId(), ActionFactory.DELETE.getCommandId(), "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED", WorkbenchMessages.Workbench_delete, WorkbenchMessages.Workbench_deleteToolTip);
    }

    private IContributionItem getRevertItem() {
        return this.getItem(ActionFactory.REVERT.getId(), ActionFactory.REVERT.getCommandId(), null, null, WorkbenchMessages.Workbench_revert, WorkbenchMessages.Workbench_revertToolTip);
    }

    private IContributionItem getRefreshItem() {
        return this.getItem(ActionFactory.REFRESH.getId(), ActionFactory.REFRESH.getCommandId(), null, null, WorkbenchMessages.Workbench_refresh, WorkbenchMessages.Workbench_refreshToolTip);
    }

    private IContributionItem getPropertiesItem() {
        return this.getItem(ActionFactory.PROPERTIES.getId(), ActionFactory.PROPERTIES.getCommandId(), null, null, WorkbenchMessages.Workbench_properties, WorkbenchMessages.Workbench_propertiesToolTip);
    }

    private IContributionItem getMoveItem() {
        return this.getItem(ActionFactory.MOVE.getId(), ActionFactory.MOVE.getCommandId(), null, null, WorkbenchMessages.Workbench_move, WorkbenchMessages.Workbench_moveToolTip);
    }

    private IContributionItem getRenameItem() {
        return this.getItem(ActionFactory.RENAME.getId(), ActionFactory.RENAME.getCommandId(), null, null, WorkbenchMessages.Workbench_rename, WorkbenchMessages.Workbench_renameToolTip);
    }

    private IContributionItem getOpenProjectItem() {
        return this.getItem(IDEActionFactory.OPEN_PROJECT.getId(), IDEActionFactory.OPEN_PROJECT.getCommandId(), null, null, IDEWorkbenchMessages.OpenResourceAction_text, IDEWorkbenchMessages.OpenResourceAction_toolTip);
    }

    private IContributionItem getCloseProjectItem() {
        return this.getItem(IDEActionFactory.CLOSE_PROJECT.getId(), IDEActionFactory.CLOSE_PROJECT.getCommandId(), null, null, IDEWorkbenchMessages.CloseResourceAction_text, IDEWorkbenchMessages.CloseResourceAction_text);
    }

    private IContributionItem getItem(String actionId, String commandId, String image, String disabledImage, String label, String tooltip) {
        ISharedImages sharedImages = this.getWindow().getWorkbench().getSharedImages();
        IActionCommandMappingService acms = (IActionCommandMappingService)this.getWindow().getService(IActionCommandMappingService.class);
        acms.map(actionId, commandId);
        CommandContributionItemParameter commandParm = new CommandContributionItemParameter((IServiceLocator)this.getWindow(), actionId, commandId, null, sharedImages.getImageDescriptor(image), sharedImages.getImageDescriptor(disabledImage), null, label, null, tooltip, 8, null, false);
        return new CommandContributionItem(commandParm);
    }
}

