/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBeaverSplashHandler
extends BasicSplashHandler {
    public static final int TOTAL_LOADING_TASKS = 20;
    private static DBeaverSplashHandler instance;
    private Font normalFont;
    private Font boldFont;

    public static IProgressMonitor getActiveMonitor() {
        if (instance == null) {
            return null;
        }
        try {
            return instance.getBundleProgressMonitor();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public DBeaverSplashHandler() {
        instance = this;
    }

    public void init(Shell splash) {
        super.init(splash);
        try {
            this.initVisualization();
            this.getBundleProgressMonitor().beginTask("Loading", 20);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void initVisualization() {
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        String versionCoordString = null;
        String versionInfoSizeString = null;
        String versionInfoColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
            versionCoordString = product.getProperty("versionInfoCoord");
            versionInfoSizeString = product.getProperty("versionInfoSize");
            versionInfoColorString = product.getProperty("versionInfoColor");
        }
        this.setProgressRect(StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(275, 300, 280, 10)));
        this.setMessageRect(StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(275, 275, 280, 25)));
        Point versionCoord = StringConverter.asPoint((String)versionCoordString, (Point)new Point(485, 215));
        int versionInfoSize = StringConverter.asInt((String)versionInfoSizeString, (int)22);
        RGB versionInfoRGB = StringConverter.asRGB((String)versionInfoColorString, (RGB)new RGB(255, 255, 255));
        int foregroundColorInteger = 13817855;
        try {
            if (foregroundColorString != null) {
                foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
            }
        }
        catch (Exception exception) {}
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        this.normalFont = this.getContent().getFont();
        FontData[] fontData = this.normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | 1);
        fontData[0].setHeight(versionInfoSize);
        this.boldFont = new Font(this.normalFont.getDevice(), fontData[0]);
        Color versionColor = new Color((Device)this.getContent().getDisplay(), versionInfoRGB);
        this.getContent().addPaintListener(e -> {
            String productVersion = "";
            if (product != null) {
                productVersion = GeneralUtils.getPlainVersion();
            }
            if (this.boldFont != null) {
                e.gc.setFont(this.boldFont);
            }
            e.gc.setForeground(versionColor);
            e.gc.drawText(productVersion, point.x, point.y, true);
            e.gc.setFont(this.normalFont);
        });
    }

    public void dispose() {
        super.dispose();
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
        instance = null;
    }

    public static void showMessage(String message) {
        if (message == null || message.isEmpty() || message.startsWith(">")) {
            return;
        }
        try {
            IProgressMonitor activeMonitor = DBeaverSplashHandler.getActiveMonitor();
            if (activeMonitor != null) {
                activeMonitor.setTaskName(message);
                activeMonitor.worked(1);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }
}

