/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.LocalNativeClientLocation;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializer;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

@Deprecated
public class DriverDescriptorSerializerLegacy
extends DriverDescriptorSerializer {
    private static final Log log = Log.getLog(DriverDescriptorSerializerLegacy.class);
    private DriverDescriptor driver;

    DriverDescriptorSerializerLegacy(DriverDescriptor driver) {
        this.driver = driver;
    }

    public void serialize(XMLBuilder xml, boolean export) throws IOException {
        Map<String, String> pathSubstitutions = this.getPathSubstitutions();
        Throwable throwable = null;
        Object var5_6 = null;
        try (XMLBuilder.Element e0 = xml.startElement("driver");){
            XMLBuilder.Element e1;
            Object var10_22;
            Throwable throwable2;
            if (export) {
                xml.addAttribute("provider", this.driver.getProviderDescriptor().getId());
            }
            xml.addAttribute("id", this.driver.getId());
            if (this.driver.isDisabled()) {
                xml.addAttribute("disabled", true);
            }
            if (!CommonUtils.isEmpty((String)this.driver.getCategory())) {
                xml.addAttribute("category", this.driver.getCategory());
            }
            xml.addAttribute("categories", String.join((CharSequence)",", this.driver.getCategories()));
            xml.addAttribute("custom", this.driver.isCustom());
            xml.addAttribute("embedded", this.driver.isEmbedded());
            xml.addAttribute("name", this.driver.getName());
            xml.addAttribute("class", this.driver.getDriverClassName());
            if (!CommonUtils.isEmpty((String)this.driver.getSampleURL())) {
                xml.addAttribute("url", this.driver.getSampleURL());
            }
            if (this.driver.getDefaultPort() != null) {
                xml.addAttribute("port", this.driver.getDefaultPort());
            }
            xml.addAttribute("description", CommonUtils.notEmpty((String)this.driver.getDescription()));
            if (this.driver.isCustomDriverLoader()) {
                xml.addAttribute("customDriverLoader", this.driver.isCustomDriverLoader());
            }
            for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
                if (export && !dBPDriverLibrary.isDisabled()) continue;
                throwable2 = null;
                var10_22 = null;
                try {
                    e1 = xml.startElement("library");
                    try {
                        List<DriverDescriptor.DriverFileInfo> files;
                        xml.addAttribute("type", dBPDriverLibrary.getType().name());
                        xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, dBPDriverLibrary.getPath()));
                        xml.addAttribute("custom", dBPDriverLibrary.isCustom());
                        if (dBPDriverLibrary.isDisabled()) {
                            xml.addAttribute("disabled", true);
                        }
                        if (!CommonUtils.isEmpty((String)dBPDriverLibrary.getPreferredVersion())) {
                            xml.addAttribute("version", dBPDriverLibrary.getPreferredVersion());
                        }
                        if ((files = this.driver.getResolvedFiles().get(dBPDriverLibrary)) == null) continue;
                        for (DriverDescriptor.DriverFileInfo file : files) {
                            Throwable throwable3 = null;
                            Object var16_33 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("file");){
                                if (file.getFile() == null) {
                                    log.warn((Object)("File missing in " + file.getId()));
                                    continue;
                                }
                                xml.addAttribute("id", file.getId());
                                if (!CommonUtils.isEmpty((String)file.getVersion())) {
                                    xml.addAttribute("version", file.getVersion());
                                }
                                xml.addAttribute("path", DriverDescriptorSerializerLegacy.substitutePathVariables(pathSubstitutions, file.getFile().getAbsolutePath()));
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            for (DBPNativeClientLocation dBPNativeClientLocation : this.driver.getNativeClientHomes()) {
                throwable2 = null;
                var10_22 = null;
                try {
                    e1 = xml.startElement("clientHome");
                    try {
                        xml.addAttribute("id", dBPNativeClientLocation.getName());
                        if (dBPNativeClientLocation.getPath() == null) continue;
                        xml.addAttribute("path", dBPNativeClientLocation.getPath().getAbsolutePath());
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable2 == null) {
                        throwable2 = throwable6;
                    } else if (throwable2 != throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                    throw throwable2;
                }
            }
            for (Map.Entry entry : this.driver.getCustomParameters().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)this.driver.getDefaultParameters().get(entry.getKey()))) continue;
                throwable2 = null;
                var10_22 = null;
                try {
                    e1 = xml.startElement("parameter");
                    try {
                        xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            for (Map.Entry entry : this.driver.getCustomConnectionProperties().entrySet()) {
                if (CommonUtils.equalObjects(entry.getValue(), (Object)this.driver.getDefaultConnectionProperties().get(entry.getKey()))) continue;
                throwable2 = null;
                var10_22 = null;
                try {
                    e1 = xml.startElement("property");
                    try {
                        xml.addAttribute("name", CommonUtils.toString(entry.getKey()));
                        xml.addAttribute("value", CommonUtils.toString(entry.getValue()));
                    }
                    finally {
                        if (e1 != null) {
                            e1.close();
                        }
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable2 == null) {
                        throwable2 = throwable8;
                    } else if (throwable2 != throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
            } else if (throwable != throwable9) {
                throwable.addSuppressed(throwable9);
            }
            throw throwable;
        }
    }

    public static class DriversParser
    implements SAXListener {
        DataSourceProviderDescriptor curProvider;
        DriverDescriptor curDriver;
        DBPDriverLibrary curLibrary;
        private static final String PATH_VERSION_OBSOLETE_RELEASE = ":release";

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) {
            switch (localName) {
                case "provider": {
                    this.curProvider = null;
                    this.curDriver = null;
                    String idAttr = atts.getValue("id");
                    if (CommonUtils.isEmpty((String)idAttr)) {
                        log.warn((Object)"No id for driver provider");
                        return;
                    }
                    this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(idAttr);
                    if (this.curProvider != null) break;
                    log.warn((Object)("Datasource provider '" + idAttr + "' not found. Bad provider description."));
                    break;
                }
                case "driver": {
                    this.curDriver = null;
                    if (this.curProvider == null) {
                        String providerId = atts.getValue("provider");
                        if (!CommonUtils.isEmpty((String)providerId)) {
                            this.curProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
                            if (this.curProvider == null) {
                                log.warn((Object)("Datasource provider '" + providerId + "' not found. Bad driver description."));
                            }
                        }
                        if (this.curProvider == null) {
                            log.warn((Object)"Driver outside of datasource provider");
                            return;
                        }
                    }
                    String idAttr = atts.getValue("id");
                    this.curDriver = this.curProvider.getDriver(idAttr);
                    if (this.curDriver == null) {
                        this.curDriver = new DriverDescriptor(this.curProvider, idAttr);
                        this.curProvider.addDriver(this.curDriver);
                    }
                    if (this.curProvider.isDriversManagable()) {
                        String category = atts.getValue("category");
                        if (!CommonUtils.isEmpty((String)category)) {
                            this.curDriver.setCategory(category);
                        }
                        if (this.curDriver.isCustom()) {
                            this.curDriver.setName(atts.getValue("name"));
                        }
                        this.curDriver.setDescription(atts.getValue("description"));
                        this.curDriver.setDriverClassName(atts.getValue("class"));
                        this.curDriver.setSampleURL(atts.getValue("url"));
                        this.curDriver.setDriverDefaultPort(atts.getValue("port"));
                        this.curDriver.setEmbedded(CommonUtils.getBoolean((String)atts.getValue("embedded"), (boolean)false));
                        this.curDriver.setAllowsEmptyPassword(CommonUtils.getBoolean((String)atts.getValue("allowsEmptyPassword"), (boolean)false));
                    }
                    if (atts.getValue("customDriverLoader") != null) {
                        this.curDriver.setCustomDriverLoader(CommonUtils.getBoolean((String)atts.getValue("customDriverLoader"), (boolean)false));
                    }
                    if (atts.getValue("useURL") != null) {
                        this.curDriver.setUseURL(CommonUtils.getBoolean((String)atts.getValue("useURL"), (boolean)true));
                    }
                    this.curDriver.setModified(true);
                    String disabledAttr = atts.getValue("disabled");
                    if (!CommonUtils.getBoolean((String)disabledAttr)) break;
                    this.curDriver.setDisabled(true);
                    break;
                }
                case "library": {
                    DBPDriverLibrary.FileType type;
                    if (this.curDriver == null) {
                        log.warn((Object)"Library outside of driver");
                        return;
                    }
                    String typeStr = atts.getValue("type");
                    if (CommonUtils.isEmpty((String)typeStr)) {
                        type = DBPDriverLibrary.FileType.jar;
                    } else {
                        try {
                            type = DBPDriverLibrary.FileType.valueOf((String)typeStr);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn((Object)e);
                            type = DBPDriverLibrary.FileType.jar;
                        }
                    }
                    String path = DriversParser.normalizeLibraryPath(atts.getValue("path"));
                    if (!CommonUtils.isEmpty((String)path)) {
                        path = DriverDescriptorSerializerLegacy.replacePathVariables(path);
                    }
                    boolean custom = CommonUtils.getBoolean((String)atts.getValue("custom"), (boolean)true);
                    String version = atts.getValue("version");
                    DBPDriverLibrary lib = this.curDriver.getDriverLibrary(path);
                    if (!custom && lib == null) {
                        return;
                    }
                    String disabledAttr = atts.getValue("disabled");
                    if (lib != null && CommonUtils.getBoolean((String)disabledAttr)) {
                        lib.setDisabled(true);
                    } else if (lib == null) {
                        lib = DriverLibraryAbstract.createFromPath(this.curDriver, type, path, version);
                        this.curDriver.addDriverLibrary(lib);
                    } else if (!CommonUtils.isEmpty((String)version)) {
                        lib.setPreferredVersion(version);
                    }
                    this.curLibrary = lib;
                    break;
                }
                case "file": {
                    String path;
                    if (this.curDriver == null || this.curLibrary == null || (path = atts.getValue("path")) == null) break;
                    if (CommonUtils.isEmpty((String)(path = DriverDescriptorSerializerLegacy.replacePathVariables(path)))) {
                        log.warn((Object)"Empty path for library file");
                        break;
                    }
                    DriverDescriptor.DriverFileInfo info = new DriverDescriptor.DriverFileInfo(atts.getValue(CommonUtils.notEmpty((String)"id")), atts.getValue(CommonUtils.notEmpty((String)"version")), new File(path));
                    this.curDriver.addLibraryFile(this.curLibrary, info);
                    break;
                }
                case "clientHome": {
                    if (this.curDriver == null) break;
                    this.curDriver.addNativeClientLocation((DBPNativeClientLocation)new LocalNativeClientLocation(atts.getValue("id"), atts.getValue("path")));
                    break;
                }
                case "parameter": {
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName) || CommonUtils.isEmpty((String)paramValue)) break;
                    this.curDriver.setDriverParameter(paramName, paramValue, false);
                    break;
                }
                case "property": {
                    if (this.curDriver == null) break;
                    String paramName = atts.getValue("name");
                    String paramValue = atts.getValue("value");
                    if (CommonUtils.isEmpty((String)paramName) || CommonUtils.isEmpty((String)paramValue)) break;
                    this.curDriver.setConnectionProperty(paramName, paramValue);
                }
            }
        }

        private static String normalizeLibraryPath(String value) {
            if (value.startsWith("maven:/") && value.endsWith(PATH_VERSION_OBSOLETE_RELEASE)) {
                value = String.valueOf(value.substring(0, value.length() - PATH_VERSION_OBSOLETE_RELEASE.length())) + ":" + "RELEASE";
            }
            return value;
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "library": {
                    this.curLibrary = null;
                }
            }
        }
    }
}

