/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExtension;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreExtensionManager
extends SQLObjectEditor<PostgreExtension, PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<PostgreDatabase, PostgreExtension> getObjectsCache(PostgreExtension object) {
        return object.getDatabase().extensionCache;
    }

    protected PostgreExtension createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new PostgreExtension((PostgreDatabase)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreExtension extension = (PostgreExtension)command.getObject();
        StringBuilder script = new StringBuilder("CREATE EXTENSION " + DBUtils.getQuotedIdentifier((DBSObject)extension));
        script.append(" SCHEMA ").append(extension.getSchema());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create extension", script.toString()));
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop extension", "DROP EXTENSION " + ((PostgreExtension)command.getObject()).getName() + " CASCADE"));
    }

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(PostgreExtension object) {
        return true;
    }

    public boolean canEditObject(PostgreExtension object) {
        return false;
    }
}

