/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeBindingMeta
extends DBDAttributeBinding {
    @NotNull
    private DBSDataContainer dataContainer;
    @NotNull
    private final DBCAttributeMetaData metaAttribute;
    @Nullable
    private DBSEntityAttribute entityAttribute;
    @Nullable
    private DBDRowIdentifier rowIdentifier;
    @Nullable
    private List<DBSEntityReferrer> referrers;
    @Nullable
    private DBDPseudoAttribute pseudoAttribute;
    private boolean showLabel;

    public DBDAttributeBindingMeta(@NotNull DBSDataContainer dataContainer, @NotNull DBCSession session, @NotNull DBCAttributeMetaData metaAttribute) {
        super(DBUtils.findValueHandler(session, (DBSTypedObject)metaAttribute));
        this.dataContainer = dataContainer;
        this.metaAttribute = metaAttribute;
        DBPDataSource dataSource = dataContainer.getDataSource();
        this.showLabel = dataSource == null || !dataSource.getContainer().getPreferenceStore().getBoolean("resultset.column.label.ignore");
    }

    @Override
    public DBPDataSource getDataSource() {
        return this.dataContainer.getDataSource();
    }

    @Override
    @Nullable
    public DBDAttributeBinding getParentObject() {
        return null;
    }

    @Override
    public int getOrdinalPosition() {
        return this.metaAttribute.getOrdinalPosition();
    }

    @Override
    public boolean isRequired() {
        return this.getAttribute().isRequired();
    }

    @Override
    public boolean isAutoGenerated() {
        return this.getAttribute().isAutoGenerated();
    }

    @Override
    public boolean isPseudoAttribute() {
        return this.pseudoAttribute != null;
    }

    @Override
    @NotNull
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public String getTypeName() {
        return this.getAttribute().getTypeName();
    }

    @Override
    public String getFullTypeName() {
        return this.getAttribute().getFullTypeName();
    }

    @Override
    public int getTypeID() {
        return this.getAttribute().getTypeID();
    }

    @Override
    public DBPDataKind getDataKind() {
        return this.getAttribute().getDataKind();
    }

    @Override
    public Integer getScale() {
        return this.getAttribute().getScale();
    }

    @Override
    public Integer getPrecision() {
        return this.getAttribute().getPrecision();
    }

    @Override
    public long getMaxLength() {
        return this.getAttribute().getMaxLength();
    }

    @Override
    @NotNull
    public String getLabel() {
        if (!this.showLabel) {
            return this.getName();
        }
        return this.metaAttribute.getLabel();
    }

    @Override
    @NotNull
    public String getName() {
        return this.metaAttribute.getName();
    }

    @Override
    @NotNull
    public DBCAttributeMetaData getMetaAttribute() {
        return this.metaAttribute;
    }

    @Override
    @Nullable
    public DBSEntityAttribute getEntityAttribute() {
        return this.entityAttribute;
    }

    @Override
    @Nullable
    public DBDRowIdentifier getRowIdentifier() {
        return this.rowIdentifier;
    }

    @Override
    @Nullable
    public List<DBSEntityReferrer> getReferrers() {
        return this.referrers;
    }

    @Override
    @Nullable
    public Object extractNestedValue(@NotNull Object ownerValue) throws DBCException {
        throw new DBCException("Meta binding doesn't support nested values");
    }

    public boolean setEntityAttribute(@Nullable DBSEntityAttribute entityAttribute, boolean updateHandler) {
        this.entityAttribute = entityAttribute;
        if (updateHandler && entityAttribute != null && !DBDAttributeBindingMeta.haveEqualsTypes(this.metaAttribute, entityAttribute)) {
            DBDValueHandler newValueHandler = DBUtils.findValueHandler(this.getDataSource(), (DBSTypedObject)entityAttribute);
            if (newValueHandler != this.getDataSource().getContainer().getDefaultValueHandler()) {
                this.valueHandler = newValueHandler;
            }
            return true;
        }
        return false;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public static boolean haveEqualsTypes(DBSTypedObject object1, DBSTypedObject object2) {
        return object1.getTypeID() == object2.getTypeID() && object1.getDataKind() == object2.getDataKind() && object1.getTypeName().equalsIgnoreCase(object2.getTypeName());
    }

    public void setRowIdentifier(@Nullable DBDRowIdentifier rowIdentifier) {
        this.rowIdentifier = rowIdentifier;
    }

    @Override
    public void lateBinding(@NotNull DBCSession session, List<Object[]> rows) throws DBException {
        DBSEntityAttribute entityAttribute = this.getEntityAttribute();
        if (entityAttribute != null) {
            this.referrers = DBUtils.getAttributeReferrers(session.getProgressMonitor(), entityAttribute, true);
        }
        super.lateBinding(session, rows);
    }

    @Nullable
    public DBDPseudoAttribute getPseudoAttribute() {
        return this.pseudoAttribute;
    }

    public void setPseudoAttribute(@Nullable DBDPseudoAttribute pseudoAttribute) {
        this.pseudoAttribute = pseudoAttribute;
    }

    @Override
    public String toString() {
        return this.metaAttribute.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBDAttributeBindingMeta) {
            DBCAttributeMetaData cmpMeta = ((DBDAttributeBindingMeta)obj).metaAttribute;
            return CommonUtils.equalObjects((Object)this.metaAttribute.getName(), (Object)cmpMeta.getName()) && CommonUtils.equalObjects((Object)this.metaAttribute.getLabel(), (Object)cmpMeta.getLabel()) && CommonUtils.equalObjects((Object)this.metaAttribute.getEntityName(), (Object)cmpMeta.getEntityName()) && this.metaAttribute.getOrdinalPosition() == cmpMeta.getOrdinalPosition() && this.metaAttribute.getTypeID() == cmpMeta.getTypeID() && CommonUtils.equalObjects((Object)this.metaAttribute.getTypeName(), (Object)cmpMeta.getTypeName());
        }
        return false;
    }

    public int hashCode() {
        return CommonUtils.notEmpty((String)this.metaAttribute.getName()).hashCode() + CommonUtils.notEmpty((String)this.metaAttribute.getLabel()).hashCode() + CommonUtils.notEmpty((String)this.metaAttribute.getEntityName()).hashCode() + this.metaAttribute.getOrdinalPosition() + this.metaAttribute.getTypeID() + CommonUtils.notEmpty((String)this.metaAttribute.getTypeName()).hashCode();
    }
}

