/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.views;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.db2.Activator;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.views.DB2ConnectionTracePage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class DB2ConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Text usernameText;
    private Text passwordText;
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/db2_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DB2ConnectionPage.this.site.updateButtons();
            }
        };
        Group addrGroup = UIUtils.createControlGroup((Composite)control, (String)DB2Messages.db2_connection_page_tab_database, (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_port);
        gd = new GridData(128);
        portLabel.setLayoutData((Object)gd);
        this.portText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 40;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        Label dbLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_database);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        addrGroup = UIUtils.createControlGroup((Composite)control, (String)DB2Messages.db2_connection_page_tab_security, (int)2, (int)0, (int)0);
        gd = new GridData(768);
        addrGroup.setLayoutData((Object)gd);
        Label usernameLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_user_name);
        usernameLabel.setLayoutData((Object)new GridData(128));
        this.usernameText = new Text((Composite)addrGroup, 2048);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        Label passwordLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)DB2Messages.dialog_connection_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        Composite passPH = UIUtils.createPlaceholder((Composite)addrGroup, (int)2, (int)5);
        passPH.setLayoutData((Object)new GridData(768));
        this.passwordText = new Text(passPH, 0x400800);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createSavePasswordButton(passPH);
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    public boolean isComplete() {
        return this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            this.dbText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages(boolean extrasOnly) {
        return new IDialogPage[]{new DB2ConnectionTracePage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

