/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.model.ClassMetadata;
import com.sleepycat.client.persist.model.EntityMetadata;
import com.sleepycat.client.persist.model.EntityModel;
import java.util.Set;

class StoredModel
extends EntityModel {
    private volatile PersistCatalog catalog;
    private volatile Set<String> knownClasses;

    StoredModel(PersistCatalog persistCatalog) {
        this.catalog = persistCatalog;
    }

    @Override
    protected void setCatalog(PersistCatalog persistCatalog) {
        super.setCatalog(persistCatalog);
        this.catalog = persistCatalog;
        this.knownClasses = persistCatalog.getModelClasses();
    }

    @Override
    public ClassMetadata getClassMetadata(String string) {
        ClassMetadata classMetadata = null;
        Format format = this.catalog.getFormat(string);
        if (format != null && format.isCurrentVersion()) {
            classMetadata = format.getClassMetadata();
        }
        return classMetadata;
    }

    @Override
    public EntityMetadata getEntityMetadata(String string) {
        EntityMetadata entityMetadata = null;
        Format format = this.catalog.getFormat(string);
        if (format != null && format.isCurrentVersion()) {
            entityMetadata = format.getEntityMetadata();
        }
        return entityMetadata;
    }

    @Override
    public Set<String> getKnownClasses() {
        return this.knownClasses;
    }
}

