/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.impl.Accessor;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.ComplexFormat;
import com.sleepycat.client.persist.impl.Enhanced;
import com.sleepycat.client.persist.impl.EntityInput;
import com.sleepycat.client.persist.impl.EntityOutput;
import com.sleepycat.client.persist.impl.FieldInfo;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.RefreshException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnhancedAccessor
implements Accessor {
    private static final Map<String, Enhanced> classRegistry = Collections.synchronizedMap(new HashMap());
    public static final boolean EXPECT_ENHANCED = "true".equals(System.getProperty("expectEnhanced"));
    private Enhanced prototype;
    private Format priKeyFormat;
    private Format[] compositeKeyFormats;
    private Class type;

    public static void registerClass(String string, Enhanced enhanced) {
        classRegistry.put(string, enhanced);
    }

    static boolean isEnhanced(Class clazz) {
        boolean bl = classRegistry.containsKey(clazz.getName());
        if (!bl && EXPECT_ENHANCED) {
            throw new IllegalStateException("Test was run with expectEnhanced=true but class " + clazz.getName() + " is not enhanced");
        }
        return bl;
    }

    private EnhancedAccessor(Class clazz) {
        this.type = clazz;
        this.prototype = classRegistry.get(clazz.getName());
        assert (this.prototype != null || Modifier.isAbstract(clazz.getModifiers()));
    }

    EnhancedAccessor(Catalog catalog, Class clazz, ComplexFormat complexFormat) {
        this(clazz);
        for (ComplexFormat complexFormat2 = complexFormat; complexFormat2 != null; complexFormat2 = complexFormat2.getComplexSuper()) {
            FieldInfo fieldInfo = complexFormat2.getPriKeyFieldInfo();
            if (fieldInfo == null) continue;
            this.priKeyFormat = catalog.getFormat(fieldInfo.getClassName());
            break;
        }
    }

    EnhancedAccessor(Catalog catalog, Class clazz, List<FieldInfo> list) {
        this(clazz);
        int n = list.size();
        this.compositeKeyFormats = new Format[n];
        for (int i = 0; i < n; ++i) {
            this.compositeKeyFormats[i] = catalog.getFormat(list.get(i).getClassName());
        }
    }

    @Override
    public Object newInstance() {
        if (this.prototype == null) {
            throw DbCompat.unexpectedState();
        }
        return this.prototype.bdbNewInstance();
    }

    @Override
    public Object newArray(int n) {
        if (this.prototype == null) {
            return Array.newInstance(this.type, n);
        }
        return this.prototype.bdbNewArray(n);
    }

    @Override
    public boolean isPriKeyFieldNullOrZero(Object object) {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + object.getClass().getName());
        }
        return ((Enhanced)object).bdbIsPriKeyFieldNullOrZero();
    }

    @Override
    public void writePriKeyField(Object object, EntityOutput entityOutput) throws RefreshException {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + object.getClass().getName());
        }
        ((Enhanced)object).bdbWritePriKeyField(entityOutput, this.priKeyFormat);
    }

    @Override
    public void readPriKeyField(Object object, EntityInput entityInput) throws RefreshException {
        if (this.priKeyFormat == null) {
            throw DbCompat.unexpectedState("No primary key: " + object.getClass().getName());
        }
        ((Enhanced)object).bdbReadPriKeyField(entityInput, this.priKeyFormat);
    }

    @Override
    public void writeSecKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        ((Enhanced)object).bdbWriteSecKeyFields(entityOutput);
    }

    @Override
    public void readSecKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) throws RefreshException {
        ((Enhanced)object).bdbReadSecKeyFields(entityInput, n, n2, n3);
    }

    @Override
    public void writeNonKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        ((Enhanced)object).bdbWriteNonKeyFields(entityOutput);
    }

    @Override
    public void readNonKeyFields(Object object, EntityInput entityInput, int n, int n2, int n3) throws RefreshException {
        ((Enhanced)object).bdbReadNonKeyFields(entityInput, n, n2, n3);
    }

    @Override
    public void writeCompositeKeyFields(Object object, EntityOutput entityOutput) throws RefreshException {
        ((Enhanced)object).bdbWriteCompositeKeyFields(entityOutput, this.compositeKeyFormats);
    }

    @Override
    public void readCompositeKeyFields(Object object, EntityInput entityInput) throws RefreshException {
        ((Enhanced)object).bdbReadCompositeKeyFields(entityInput, this.compositeKeyFormats);
    }

    @Override
    public Object getField(Object object, int n, int n2, boolean bl) {
        return ((Enhanced)object).bdbGetField(object, n, n2, bl);
    }

    @Override
    public void setField(Object object, int n, int n2, boolean bl, Object object2) {
        ((Enhanced)object).bdbSetField(object, n, n2, bl, object2);
    }

    @Override
    public void setPriField(Object object, Object object2) {
        ((Enhanced)object).bdbSetPriField(object, object2);
    }
}

